/*
 * Decompiled with CFR 0.152.
 */
package org.jbpm.designer.web.server;

import java.net.URL;
import java.nio.file.Files;
import java.nio.file.Paths;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Comparator;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import javax.servlet.ServletConfig;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.eclipse.bpmn2.Definitions;
import org.jbpm.designer.helper.TestHttpServletRequest;
import org.jbpm.designer.helper.TestHttpServletResponse;
import org.jbpm.designer.helper.TestServletConfig;
import org.jbpm.designer.helper.TestServletContext;
import org.jbpm.designer.repository.Asset;
import org.jbpm.designer.repository.AssetBuilderFactory;
import org.jbpm.designer.repository.Filter;
import org.jbpm.designer.repository.Repository;
import org.jbpm.designer.repository.RepositoryBaseTest;
import org.jbpm.designer.repository.filters.FilterByExtension;
import org.jbpm.designer.repository.impl.AssetBuilder;
import org.jbpm.designer.repository.vfs.VFSRepository;
import org.jbpm.designer.taskforms.BPMNFormBuilderManager;
import org.jbpm.designer.web.profile.IDiagramProfile;
import org.jbpm.designer.web.server.TaskFormsServlet;
import org.junit.After;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;
import org.junit.runner.RunWith;
import org.kie.workbench.common.forms.bpmn.BPMNFormBuilderService;
import org.mockito.InjectMocks;
import org.mockito.Matchers;
import org.mockito.Mock;
import org.mockito.Mockito;
import org.mockito.invocation.InvocationOnMock;
import org.mockito.runners.MockitoJUnitRunner;
import org.mockito.stubbing.Answer;
import org.uberfire.backend.vfs.Path;
import org.uberfire.backend.vfs.PathFactory;
import org.uberfire.backend.vfs.VFSService;

@RunWith(value=MockitoJUnitRunner.class)
public class TaskFormsServletTest
extends RepositoryBaseTest {
    @Mock
    private VFSService vfsServices;
    @Mock
    private BPMNFormBuilderService<Definitions> formBuilderService;
    @Mock
    private BPMNFormBuilderManager builderManager;
    @InjectMocks
    TaskFormsServlet taskFormsServlet;

    @Override
    @Before
    public void setup() {
        super.setup();
        Mockito.when((Object)this.vfsServices.get((String)Matchers.any())).thenAnswer((Answer)new Answer<Path>(){

            public Path answer(InvocationOnMock invocation) throws Throwable {
                Object[] args = invocation.getArguments();
                return PathFactory.newPath((String)((String)args[0]), (String)((String)args[0]));
            }
        });
        Mockito.when((Object)this.builderManager.getFormBuilders()).thenReturn(Arrays.asList(this.formBuilderService));
        Mockito.when((Object)this.builderManager.getBuilderByFormType(Mockito.anyString())).thenReturn(this.formBuilderService);
    }

    @Override
    @After
    public void teardown() {
        super.teardown();
    }

    @Test
    public void testTaskFormServlet() throws Exception {
        Mockito.when((Object)this.formBuilderService.buildFormContent((Path)Matchers.any(), Matchers.any(), (String)Matchers.any())).thenReturn((Object)"dummyform");
        VFSRepository repository = new VFSRepository(this.producer.getIoService());
        repository.setDescriptor(this.descriptor);
        this.profile.setRepository((Repository)repository);
        AssetBuilder builder = AssetBuilderFactory.getAssetBuilder((Asset.AssetType)Asset.AssetType.Text);
        builder.content((Object)"bpmn2 content").type("bpmn2").name("hello").location("/defaultPackage");
        String uniqueId = repository.createAsset(builder.getAsset());
        HashMap<String, String> params = new HashMap<String, String>();
        params.put("uuid", uniqueId);
        params.put("json", this.readFile("BPMN2-DefaultProcess.json"));
        params.put("profile", "jbpm");
        params.put("ppdata", null);
        this.taskFormsServlet.setProfile((IDiagramProfile)this.profile);
        this.taskFormsServlet.init((ServletConfig)new TestServletConfig(new TestServletContext((Repository)repository, "org/jbpm/designer/public")));
        this.taskFormsServlet.doPost((HttpServletRequest)new TestHttpServletRequest(params), (HttpServletResponse)new TestHttpServletResponse());
        Collection forms = repository.listAssets("/defaultPackage", (Filter)new FilterByExtension("ftl"));
        Assert.assertNotNull((Object)forms);
        Assert.assertEquals((long)1L, (long)forms.size());
        Assert.assertEquals((Object)"hello-taskform", (Object)((Asset)forms.iterator().next()).getName());
        Assert.assertEquals((Object)"/defaultPackage", (Object)((Asset)forms.iterator().next()).getAssetLocation());
        Asset form = repository.loadAsset(((Asset)forms.iterator().next()).getUniqueId());
        Assert.assertNotNull((Object)form.getAssetContent());
    }

    @Test
    public void testTaskFormServletWithUserTask() throws Exception {
        Mockito.when((Object)this.formBuilderService.buildFormContent((Path)Matchers.any(), Matchers.any(), (String)Matchers.any())).thenReturn((Object)"dummyform");
        VFSRepository repository = new VFSRepository(this.producer.getIoService());
        repository.setDescriptor(this.descriptor);
        this.profile.setRepository((Repository)repository);
        AssetBuilder builder = AssetBuilderFactory.getAssetBuilder((Asset.AssetType)Asset.AssetType.Text);
        builder.content((Object)"bpmn2 content").type("bpmn2").name("userTask").location("/defaultPackage");
        String uniqueId = repository.createAsset(builder.getAsset());
        HashMap<String, String> params = new HashMap<String, String>();
        params.put("uuid", uniqueId);
        params.put("json", this.readFile("BPMN2-UserTask.json"));
        params.put("profile", "jbpm");
        params.put("ppdata", null);
        this.taskFormsServlet.setProfile((IDiagramProfile)this.profile);
        this.taskFormsServlet.init((ServletConfig)new TestServletConfig(new TestServletContext((Repository)repository, "org/jbpm/designer/public")));
        this.taskFormsServlet.doPost((HttpServletRequest)new TestHttpServletRequest(params), (HttpServletResponse)new TestHttpServletResponse());
        Collection forms = repository.listAssets("/defaultPackage", (Filter)new FilterByExtension("ftl"));
        Assert.assertNotNull((Object)forms);
        Assert.assertEquals((long)2L, (long)forms.size());
        List<Asset> arrForms = this.sortAssets(forms);
        Iterator<Asset> assets = arrForms.iterator();
        Asset asset1 = assets.next();
        Assert.assertEquals((Object)"evaluate-taskform", (Object)asset1.getName());
        Assert.assertEquals((Object)"/defaultPackage", (Object)asset1.getAssetLocation());
        Asset asset2 = assets.next();
        Assert.assertEquals((Object)"testprocess-taskform", (Object)asset2.getName());
        Assert.assertEquals((Object)"/defaultPackage", (Object)asset2.getAssetLocation());
        Asset form1 = repository.loadAsset(asset1.getUniqueId());
        Assert.assertNotNull((Object)form1.getAssetContent());
        Asset form2 = repository.loadAsset(asset2.getUniqueId());
        Assert.assertNotNull((Object)form2.getAssetContent());
    }

    private String readFile(String fileName) throws Exception {
        URL fileURL = TaskFormsServletTest.class.getResource(fileName);
        return new String(Files.readAllBytes(Paths.get(fileURL.toURI())));
    }

    private List<Asset> sortAssets(Collection<Asset> assets) {
        ArrayList<Asset> arrAssets = new ArrayList<Asset>(assets);
        arrAssets.sort(new Comparator<Asset>(){

            @Override
            public int compare(Asset a1, Asset a2) {
                if (a1.getName() == null) {
                    return -1;
                }
                if (a2.getName() == null) {
                    return 1;
                }
                return a1.getName().compareTo(a2.getName());
            }
        });
        return arrAssets;
    }
}

