/*
 * Decompiled with CFR 0.152.
 */
package org.jbpm.designer.bpmn2.validation;

import java.util.Arrays;
import java.util.List;
import java.util.Map;
import org.eclipse.bpmn2.Bpmn2Factory;
import org.eclipse.bpmn2.FlowNode;
import org.eclipse.bpmn2.SubProcess;
import org.eclipse.bpmn2.TextAnnotation;
import org.jbpm.designer.bpmn2.impl.Bpmn2JsonMarshallerTest;
import org.jbpm.designer.bpmn2.utils.Bpmn2Loader;
import org.jbpm.designer.bpmn2.validation.BPMN2SyntaxChecker;
import org.jbpm.designer.bpmn2.validation.SyntaxChecker;
import org.jbpm.designer.web.profile.IDiagramProfile;
import org.json.JSONObject;
import org.junit.Assert;
import org.junit.Test;

public class BPMN2SyntaxCheckerTest {
    private Bpmn2Loader loader = new Bpmn2Loader(BPMN2SyntaxCheckerTest.class);
    private Map<String, List<BPMN2SyntaxChecker.ValidationSyntaxError>> errors;

    @Test
    public void testUserTaskWithTaskName() throws Exception {
        this.loader.loadProcessFromXml("userTaskWithTaskName.bpmn2");
        String processJson = this.loader.getProcessJson();
        BPMN2SyntaxChecker syntaxChecker = new BPMN2SyntaxChecker(processJson, "", (IDiagramProfile)this.loader.getProfile());
        this.verifyNoErrors((SyntaxChecker)syntaxChecker);
    }

    @Test
    public void testUserTaskWithoutTaskName() throws Exception {
        JSONObject process = this.loader.loadProcessFromXml("userTaskWithoutTaskName.bpmn2");
        JSONObject userTask = Bpmn2Loader.getChildByName(process, "User Task");
        String processJson = this.loader.getProcessJson();
        BPMN2SyntaxChecker syntaxChecker = new BPMN2SyntaxChecker(processJson, "", (IDiagramProfile)this.loader.getProfile());
        this.verifyErrorsOfElement((SyntaxChecker)syntaxChecker, userTask, Arrays.asList("User Task has no task name."));
    }

    @Test
    public void testNoCalledElementCallActivity() throws Exception {
        JSONObject process = this.loader.loadProcessFromXml("noCalledElementCallActivity.bpmn2");
        JSONObject callActivity = Bpmn2Loader.getChildByName(process, "callActivity");
        String processJson = this.loader.getProcessJson();
        BPMN2SyntaxChecker syntaxChecker = new BPMN2SyntaxChecker(processJson, "", (IDiagramProfile)this.loader.getProfile());
        this.verifyErrorsOfElement((SyntaxChecker)syntaxChecker, callActivity, Arrays.asList("Reusable Subprocess has no called element specified."));
    }

    @Test
    public void testCallActivity() throws Exception {
        this.loader.loadProcessFromXml("callActivity.bpmn2");
        String processJson = this.loader.getProcessJson();
        BPMN2SyntaxChecker syntaxChecker = new BPMN2SyntaxChecker(processJson, "", (IDiagramProfile)this.loader.getProfile());
        this.verifyNoErrors((SyntaxChecker)syntaxChecker);
    }

    @Test
    public void testInclusiveGatewayWithDefaultSimulationPath() throws Exception {
        this.loader.loadProcessFromXml("inclusiveGatewayWithDefaultSimulationPath.bpmn2");
        String processJson = this.loader.getProcessJson();
        BPMN2SyntaxChecker syntaxChecker = new BPMN2SyntaxChecker(processJson, "", (IDiagramProfile)this.loader.getProfile());
        this.verifyNoErrors((SyntaxChecker)syntaxChecker);
    }

    @Test
    public void testInclusiveGatewayWithoutDefaultSimulationPath() throws Exception {
        JSONObject process = this.loader.loadProcessFromXml("inclusiveGatewayWithoutDefaultSimulationPath.bpmn2");
        JSONObject gateway = Bpmn2Loader.getChildByName(process, "inclusiveGateway");
        String processJson = this.loader.getProcessJson();
        BPMN2SyntaxChecker syntaxChecker = new BPMN2SyntaxChecker(processJson, "", (IDiagramProfile)this.loader.getProfile());
        this.verifyErrorsOfElement((SyntaxChecker)syntaxChecker, gateway, Arrays.asList("At least one outgoing connection should have probability equal to 100."));
    }

    @Test
    public void testInclusiveGatewayInvalidDefaultGate() throws Exception {
        JSONObject process = this.loader.loadProcessFromXml("inclusiveGatewayInvalidDefaultGate.bpmn2");
        JSONObject gateway = Bpmn2Loader.getChildByName(process, "inclusiveGateway");
        String processJson = this.loader.getProcessJson();
        BPMN2SyntaxChecker syntaxChecker = new BPMN2SyntaxChecker(processJson, "", (IDiagramProfile)this.loader.getProfile());
        this.verifyErrorsOfElement((SyntaxChecker)syntaxChecker, gateway, Arrays.asList("Default gate must be one of outgoing flows."));
    }

    @Test
    public void testEventGatewayProperProbabilities() throws Exception {
        this.loader.loadProcessFromXml("eventGatewayProperProbabilities.bpmn2");
        String processJson = this.loader.getProcessJson();
        BPMN2SyntaxChecker syntaxChecker = new BPMN2SyntaxChecker(processJson, "", (IDiagramProfile)this.loader.getProfile());
        this.verifyNoErrors((SyntaxChecker)syntaxChecker);
    }

    @Test
    public void testEventGatewayInproperProbabilities() throws Exception {
        JSONObject process = this.loader.loadProcessFromXml("eventGatewayInproperProbabilities.bpmn2");
        JSONObject gateway = Bpmn2Loader.getChildByName(process, "eventGateway");
        String processJson = this.loader.getProcessJson();
        BPMN2SyntaxChecker syntaxChecker = new BPMN2SyntaxChecker(processJson, "", (IDiagramProfile)this.loader.getProfile());
        this.verifyErrorsOfElement((SyntaxChecker)syntaxChecker, gateway, Arrays.asList("The sum of probability values of all outgoing Sequence Flows must be equal 100."));
    }

    @Test
    public void testExclusiveGatewayProperProbabilities() throws Exception {
        this.loader.loadProcessFromXml("exclusiveGatewayProperProbabilities.bpmn2");
        String processJson = this.loader.getProcessJson();
        BPMN2SyntaxChecker syntaxChecker = new BPMN2SyntaxChecker(processJson, "", (IDiagramProfile)this.loader.getProfile());
        this.verifyNoErrors((SyntaxChecker)syntaxChecker);
    }

    @Test
    public void testExclusiveGatewayInproperProbabilities() throws Exception {
        JSONObject process = this.loader.loadProcessFromXml("exclusiveGatewayInproperProbabilities.bpmn2");
        JSONObject gateway = Bpmn2Loader.getChildByName(process, "exclusiveGateway");
        String processJson = this.loader.getProcessJson();
        BPMN2SyntaxChecker syntaxChecker = new BPMN2SyntaxChecker(processJson, "", (IDiagramProfile)this.loader.getProfile());
        this.verifyErrorsOfElement((SyntaxChecker)syntaxChecker, gateway, Arrays.asList("The sum of probability values of all outgoing Sequence Flows must be equal 100."));
    }

    @Test
    public void testExclusiveGatewayInvalidDefaultGate() throws Exception {
        JSONObject process = this.loader.loadProcessFromXml("exclusiveGatewayInvalidDefaultGate.bpmn2");
        JSONObject gateway = Bpmn2Loader.getChildByName(process, "exclusiveGateway");
        String processJson = this.loader.getProcessJson();
        BPMN2SyntaxChecker syntaxChecker = new BPMN2SyntaxChecker(processJson, "", (IDiagramProfile)this.loader.getProfile());
        this.verifyErrorsOfElement((SyntaxChecker)syntaxChecker, gateway, Arrays.asList("Default gate must be one of outgoing flows."));
    }

    @Test
    public void testParallelGatewayProbabilities() throws Exception {
        this.loader.loadProcessFromXml("parallelGatewayProbabilities.bpmn2");
        String processJson = this.loader.getProcessJson();
        BPMN2SyntaxChecker syntaxChecker = new BPMN2SyntaxChecker(processJson, "", (IDiagramProfile)this.loader.getProfile());
        this.verifyNoErrors((SyntaxChecker)syntaxChecker);
    }

    @Test
    public void testScriptTaskNoScriptNoLanguage() throws Exception {
        JSONObject process = this.loader.loadProcessFromXml("scriptTaskNoScriptNoLanguage.bpmn2");
        JSONObject task = Bpmn2Loader.getChildByName(process, "scriptTask");
        String processJson = this.loader.getProcessJson();
        BPMN2SyntaxChecker syntaxChecker = new BPMN2SyntaxChecker(processJson, "", (IDiagramProfile)this.loader.getProfile());
        this.verifyErrorsOfElement((SyntaxChecker)syntaxChecker, task, Arrays.asList("Script Task has no script.", "Script Task has no script format."));
    }

    @Test
    public void testScriptTaskNoScript() throws Exception {
        JSONObject process = this.loader.loadProcessFromXml("scriptTaskNoScript.bpmn2");
        JSONObject task = Bpmn2Loader.getChildByName(process, "scriptTask");
        String processJson = this.loader.getProcessJson();
        BPMN2SyntaxChecker syntaxChecker = new BPMN2SyntaxChecker(processJson, "", (IDiagramProfile)this.loader.getProfile());
        this.verifyErrorsOfElement((SyntaxChecker)syntaxChecker, task, Arrays.asList("Script Task has no script."));
    }

    @Test
    public void testScriptTaskNoLanguage() throws Exception {
        JSONObject process = this.loader.loadProcessFromXml("scriptTaskNoLanguage.bpmn2");
        JSONObject task = Bpmn2Loader.getChildByName(process, "scriptTask");
        String processJson = this.loader.getProcessJson();
        BPMN2SyntaxChecker syntaxChecker = new BPMN2SyntaxChecker(processJson, "", (IDiagramProfile)this.loader.getProfile());
        this.verifyErrorsOfElement((SyntaxChecker)syntaxChecker, task, Arrays.asList("Script Task has no script format."));
    }

    @Test
    public void testScriptTask() throws Exception {
        this.loader.loadProcessFromXml("scriptTask.bpmn2");
        String processJson = this.loader.getProcessJson();
        BPMN2SyntaxChecker syntaxChecker = new BPMN2SyntaxChecker(processJson, "", (IDiagramProfile)this.loader.getProfile());
        this.verifyNoErrors((SyntaxChecker)syntaxChecker);
    }

    @Test
    public void testErrorBoundaryEvent() throws Exception {
        this.loader.loadProcessFromXml("errorBoundaryEvent.bpmn2");
        String processJson = this.loader.getProcessJson();
        BPMN2SyntaxChecker syntaxChecker = new BPMN2SyntaxChecker(processJson, "", (IDiagramProfile)this.loader.getProfile());
        this.verifyNoErrors((SyntaxChecker)syntaxChecker);
    }

    @Test
    public void testErrorBoundaryEventMissingDefinition() throws Exception {
        JSONObject process = this.loader.loadProcessFromXml("errorBoundaryEventMissingDefinition.bpmn2");
        JSONObject lane = Bpmn2Loader.getChildByName(process, "myLane");
        JSONObject error = Bpmn2Loader.getChildByName(lane, "MyError");
        String processJson = this.loader.getProcessJson();
        BPMN2SyntaxChecker syntaxChecker = new BPMN2SyntaxChecker(processJson, "", (IDiagramProfile)this.loader.getProfile());
        this.verifyErrorsOfElement((SyntaxChecker)syntaxChecker, error, Arrays.asList("Catch Event has no errorref."));
    }

    @Test
    public void testServiceTaskInterfaceAndOperation() throws Exception {
        JSONObject process = this.loader.loadProcessFromXml("serviceTaskInterfaceAndOperation.bpmn2", Bpmn2JsonMarshallerTest.class);
        JSONObject serviceTask = Bpmn2Loader.getChildByName(process, "Send PO");
        String processJson = this.loader.getProcessJson();
        BPMN2SyntaxChecker syntaxChecker = new BPMN2SyntaxChecker(processJson, "", (IDiagramProfile)this.loader.getProfile());
        syntaxChecker.checkSyntax();
        Assert.assertTrue((boolean)syntaxChecker.errorsFound());
        this.errors = syntaxChecker.getErrors();
        String serviceTaskId = serviceTask.getString("resourceId");
        Assert.assertFalse((boolean)this.errors.containsKey(serviceTaskId));
    }

    @Test
    public void testServiceTaskNoInterfaceNoOperation() throws Exception {
        JSONObject process = this.loader.loadProcessFromXml("serviceTaskNoInterfaceNoOperation.bpmn2", Bpmn2JsonMarshallerTest.class);
        JSONObject serviceTask = Bpmn2Loader.getChildByName(process, "Send PO");
        String processJson = this.loader.getProcessJson();
        BPMN2SyntaxChecker syntaxChecker = new BPMN2SyntaxChecker(processJson, "", (IDiagramProfile)this.loader.getProfile());
        this.verifyErrorsOfElement((SyntaxChecker)syntaxChecker, serviceTask, Arrays.asList("Service Task has no operation."));
    }

    @Test
    public void testEmptyBusinessRule() throws Exception {
        JSONObject process = this.loader.loadProcessFromXml("emptyBusinessRule.bpmn2");
        JSONObject ruleTask = Bpmn2Loader.getChildByName(process, "businessRuleTask");
        String processJson = this.loader.getProcessJson();
        BPMN2SyntaxChecker syntaxChecker = new BPMN2SyntaxChecker(processJson, "", (IDiagramProfile)this.loader.getProfile());
        this.verifyErrorsOfElement((SyntaxChecker)syntaxChecker, ruleTask, Arrays.asList("Business Rule Task has no ruleflow-group."));
    }

    @Test
    public void testBusinessRule() throws Exception {
        this.loader.loadProcessFromXml("businessRule.bpmn2");
        String processJson = this.loader.getProcessJson();
        BPMN2SyntaxChecker syntaxChecker = new BPMN2SyntaxChecker(processJson, "", (IDiagramProfile)this.loader.getProfile());
        this.verifyNoErrors((SyntaxChecker)syntaxChecker);
    }

    @Test
    public void testGenericTask() throws Exception {
        JSONObject process = this.loader.loadProcessFromXml("genericTask.bpmn2");
        String processJson = this.loader.getProcessJson();
        BPMN2SyntaxChecker syntaxChecker = new BPMN2SyntaxChecker(processJson, "", (IDiagramProfile)this.loader.getProfile());
        this.verifyErrorsOfElement((SyntaxChecker)syntaxChecker, process.getJSONObject("properties").getString("id"), Arrays.asList("Node 'generic task' [2] Task has no task type."));
    }

    @Test
    public void testIsCompensatingFlowNodeInSubprocessForTextAnnotation() throws Exception {
        BPMN2SyntaxChecker syntaxChecker = new BPMN2SyntaxChecker("", "", null);
        SubProcess subprocess = Bpmn2Factory.eINSTANCE.createSubProcess();
        TextAnnotation textAnnotation = Bpmn2Factory.eINSTANCE.createTextAnnotation();
        subprocess.getFlowElements().add(textAnnotation);
        Assert.assertTrue((boolean)syntaxChecker.isCompensatingFlowNodeInSubprocess((FlowNode)textAnnotation, subprocess));
    }

    @Test
    public void testReceiveTask() throws Exception {
        this.loader.loadProcessFromXml("receiveTask.bpmn2", Bpmn2JsonMarshallerTest.class);
        String processJson = this.loader.getProcessJson();
        BPMN2SyntaxChecker syntaxChecker = new BPMN2SyntaxChecker(processJson, "", (IDiagramProfile)this.loader.getProfile());
        this.verifyNoErrors((SyntaxChecker)syntaxChecker);
    }

    @Test
    public void testReceiveTaskMissingMessage() throws Exception {
        JSONObject process = this.loader.loadProcessFromXml("receiveTaskMissingMessage.bpmn2");
        JSONObject receiveTask = Bpmn2Loader.getChildByName(process, "receiveTask");
        String processJson = this.loader.getProcessJson();
        BPMN2SyntaxChecker syntaxChecker = new BPMN2SyntaxChecker(processJson, "", (IDiagramProfile)this.loader.getProfile());
        this.verifyErrorsOfElement((SyntaxChecker)syntaxChecker, receiveTask, Arrays.asList("Task has no message."));
    }

    @Test
    public void testSendTask() throws Exception {
        this.loader.loadProcessFromXml("sendTask.bpmn2", Bpmn2JsonMarshallerTest.class);
        String processJson = this.loader.getProcessJson();
        BPMN2SyntaxChecker syntaxChecker = new BPMN2SyntaxChecker(processJson, "", (IDiagramProfile)this.loader.getProfile());
        this.verifyNoErrors((SyntaxChecker)syntaxChecker);
    }

    @Test
    public void testSendTaskMissingMessage() throws Exception {
        JSONObject process = this.loader.loadProcessFromXml("sendTaskMissingMessage.bpmn2");
        JSONObject sendTask = Bpmn2Loader.getChildByName(process, "sendTask");
        String processJson = this.loader.getProcessJson();
        BPMN2SyntaxChecker syntaxChecker = new BPMN2SyntaxChecker(processJson, "", (IDiagramProfile)this.loader.getProfile());
        this.verifyErrorsOfElement((SyntaxChecker)syntaxChecker, sendTask, Arrays.asList("Task has no message."));
    }

    @Test
    public void testMultipleSubprocessStartEvents() throws Exception {
        JSONObject process = this.loader.loadProcessFromXml("multipleSubprocessStartEvents.bpmn2");
        JSONObject subProcess = Bpmn2Loader.getChildByName(process, "SubProcess");
        String processJson = this.loader.getProcessJson();
        BPMN2SyntaxChecker syntaxChecker = new BPMN2SyntaxChecker(processJson, "", (IDiagramProfile)this.loader.getProfile());
        this.verifyErrorsOfElement((SyntaxChecker)syntaxChecker, subProcess, Arrays.asList("Multiple start events not allowed."));
    }

    @Test
    public void testEmptyDMNBusinessRule() throws Exception {
        JSONObject process = this.loader.loadProcessFromXml("emptyDmnBusinessRule.bpmn2", BPMN2SyntaxCheckerTest.class);
        JSONObject ruleTask = Bpmn2Loader.getChildByName(process, "test");
        String processJson = this.loader.getProcessJson();
        BPMN2SyntaxChecker syntaxChecker = new BPMN2SyntaxChecker(processJson, "", (IDiagramProfile)this.loader.getProfile());
        this.verifyErrorsOfElement((SyntaxChecker)syntaxChecker, ruleTask, Arrays.asList("DMN Business Rule Task has no namespace set.", "DMN Business Rule Task has no model set."));
    }

    @Test
    public void testDMNBusinessRule() throws Exception {
        this.loader.loadProcessFromXml("dmnBusinessRule.bpmn2");
        String processJson = this.loader.getProcessJson();
        BPMN2SyntaxChecker syntaxChecker = new BPMN2SyntaxChecker(processJson, "", (IDiagramProfile)this.loader.getProfile());
        this.verifyNoErrors((SyntaxChecker)syntaxChecker);
    }

    @Test
    public void testEmptyPackageName() throws Exception {
        this.loader.loadProcessFromXml("emptyPackageName.bpmn2");
        String processJson = this.loader.getProcessJson();
        BPMN2SyntaxChecker syntaxChecker = new BPMN2SyntaxChecker(processJson, "", (IDiagramProfile)this.loader.getProfile());
        this.verifyNoErrors((SyntaxChecker)syntaxChecker);
    }

    @Test
    public void testInvalidPackageName() throws Exception {
        this.loader.loadProcessFromXml("invalidPackageName.bpmn2");
        String processJson = this.loader.getProcessJson();
        BPMN2SyntaxChecker syntaxChecker = new BPMN2SyntaxChecker(processJson, "", (IDiagramProfile)this.loader.getProfile());
        syntaxChecker.checkSyntax();
        Map errors = syntaxChecker.getErrors();
        Assert.assertEquals((long)1L, (long)errors.size());
        Assert.assertEquals((long)1L, (long)((List)errors.get("emptypackagename")).size());
        BPMN2SyntaxChecker.ValidationSyntaxError packageError = (BPMN2SyntaxChecker.ValidationSyntaxError)((List)errors.get("emptypackagename")).get(0);
        Assert.assertEquals((Object)"Package name contains invalid characters.", (Object)packageError.getError());
    }

    private void verifyNoErrors(SyntaxChecker syntaxChecker) throws Exception {
        syntaxChecker.checkSyntax();
        Assert.assertFalse((boolean)syntaxChecker.errorsFound());
        Assert.assertEquals((long)0L, (long)syntaxChecker.getErrors().size());
    }

    private void verifyErrorsOfElement(SyntaxChecker syntaxChecker, JSONObject element, List<String> elementErrors) throws Exception {
        this.verifyErrorsOfElement(syntaxChecker, element.getString("resourceId"), elementErrors);
    }

    private void verifyErrorsOfElement(SyntaxChecker syntaxChecker, String elementId, List<String> elementErrors) throws Exception {
        syntaxChecker.checkSyntax();
        Assert.assertTrue((boolean)syntaxChecker.errorsFound());
        this.errors = syntaxChecker.getErrors();
        Assert.assertEquals((long)elementErrors.size(), (long)this.errors.get(elementId).size());
        int i = 0;
        for (String error : elementErrors) {
            Assert.assertEquals((Object)error, (Object)this.errors.get(elementId).get(i).getError());
            ++i;
        }
    }
}

