/*
 * Decompiled with CFR 0.152.
 */
package org.jbpm.designer.bpmn2.utils;

import bpsim.impl.BpsimPackageImpl;
import java.net.URL;
import java.nio.file.Files;
import java.nio.file.Paths;
import java.util.ArrayList;
import java.util.List;
import org.eclipse.bpmn2.Definitions;
import org.jboss.drools.impl.DroolsPackageImpl;
import org.jbpm.designer.web.profile.IDiagramProfile;
import org.jbpm.designer.web.profile.impl.JbpmProfileImpl;
import org.json.JSONArray;
import org.json.JSONException;
import org.json.JSONObject;

public class Bpmn2Loader {
    private Class testClass;
    private String processJson;
    JbpmProfileImpl profile = new JbpmProfileImpl();
    IDiagramProfile.IDiagramUnmarshaller marshaller = this.profile.createUnmarshaller();

    public Bpmn2Loader(Class testClass) {
        this.testClass = testClass;
    }

    public Definitions loadProcessFromJson(String fileName, String zOrderEnabled, String bpsimDisplay) throws Exception {
        this.profile.setZOrder(zOrderEnabled);
        this.profile.setBpsimDisplay(bpsimDisplay);
        IDiagramProfile.IDiagramMarshaller unmarshaller = this.profile.createMarshaller();
        URL fileURL = this.testClass.getResource(fileName);
        String json = new String(Files.readAllBytes(Paths.get(fileURL.toURI())));
        return unmarshaller.getDefinitions(json, "Email,HelloWorkItemHandler,Log,Rest,WebService");
    }

    public Definitions loadProcessFromJson(String fileName) throws Exception {
        return this.loadProcessFromJson(fileName, "false", "true");
    }

    public JSONObject loadProcessFromXml(String fileName, Class nonDefaultTestClass) throws Exception {
        URL fileURL = nonDefaultTestClass.getResource(fileName);
        String definition = new String(Files.readAllBytes(Paths.get(fileURL.toURI())));
        DroolsPackageImpl.init();
        BpsimPackageImpl.init();
        this.processJson = this.marshaller.parseModel(definition, (IDiagramProfile)this.profile, "Email,HelloWorkItemHandler,Log,Rest,WebService");
        JSONObject process = new JSONObject(this.processJson);
        if ("BPMNDiagram".equals(process.getJSONObject("stencil").getString("id"))) {
            return process;
        }
        throw new IllegalArgumentException("File " + fileName + " is not a valid BPMN2 process JSON");
    }

    public JSONObject loadProcessFromXml(String fileName) throws Exception {
        return this.loadProcessFromXml(fileName, this.testClass);
    }

    public static JSONObject getChildByName(JSONObject parent, String name) throws JSONException {
        JSONArray children = parent.getJSONArray("childShapes");
        for (int i = 0; i < children.length(); ++i) {
            JSONObject child = children.getJSONObject(i);
            if (!name.equals(Bpmn2Loader.getPropertyValue(child, "name"))) continue;
            return child;
        }
        return null;
    }

    public static List<JSONObject> getChildByTypeName(JSONObject parent, String type) throws JSONException {
        ArrayList<JSONObject> result = new ArrayList<JSONObject>();
        JSONArray children = parent.getJSONArray("childShapes");
        for (int i = 0; i < children.length(); ++i) {
            JSONObject child = children.getJSONObject(i);
            if (!type.equals(Bpmn2Loader.getStencilValue(child, "id"))) continue;
            result.add(child);
        }
        return result;
    }

    public static String getDocumentationFor(JSONObject bpmnElement) throws JSONException {
        return Bpmn2Loader.getPropertyValue(bpmnElement, "documentation");
    }

    public static String getNameFor(JSONObject bpmnElement) throws JSONException {
        return Bpmn2Loader.getPropertyValue(bpmnElement, "name");
    }

    private static String getPropertyValue(JSONObject bpmnElement, String propertyName) throws JSONException {
        return bpmnElement.getJSONObject("properties").getString(propertyName);
    }

    public static String getResourceId(JSONObject bpmnElement) throws JSONException {
        return bpmnElement.getString("resourceId");
    }

    private static String getStencilValue(JSONObject bpmnElement, String propertyName) throws JSONException {
        return bpmnElement.getJSONObject("stencil").getString(propertyName);
    }

    public JbpmProfileImpl getProfile() {
        return this.profile;
    }

    public String getProcessJson() {
        return this.processJson;
    }
}

