/*
 * Decompiled with CFR 0.152.
 */
package org.jbpm.designer.web.preprocessing.impl;

import java.util.Arrays;
import java.util.Collection;
import java.util.HashMap;
import java.util.Map;
import javax.servlet.ServletContext;
import javax.servlet.http.HttpServletRequest;
import org.jbpm.designer.helper.TestHttpServletRequest;
import org.jbpm.designer.helper.TestIDiagramProfile;
import org.jbpm.designer.helper.TestServletContext;
import org.jbpm.designer.repository.Asset;
import org.jbpm.designer.repository.AssetBuilderFactory;
import org.jbpm.designer.repository.Repository;
import org.jbpm.designer.repository.RepositoryBaseTest;
import org.jbpm.designer.repository.VFSFileSystemProducer;
import org.jbpm.designer.repository.impl.AssetBuilder;
import org.jbpm.designer.web.preprocessing.impl.JbpmPreprocessingUnit;
import org.jbpm.designer.web.profile.IDiagramProfile;
import org.jbpm.process.workitem.WorkDefinitionImpl;
import org.junit.After;
import org.junit.AfterClass;
import org.junit.Assert;
import org.junit.Before;
import org.junit.BeforeClass;
import org.junit.Test;
import org.junit.runner.RunWith;
import org.mockito.InjectMocks;
import org.mockito.Spy;
import org.mockito.runners.MockitoJUnitRunner;
import org.stringtemplate.v4.ST;

@RunWith(value=MockitoJUnitRunner.class)
public class JbpmPreprocessingUnitVFSGitTest
extends RepositoryBaseTest {
    private static final String REPOSITORY_ROOT = "designer-playground";
    private static final String VFS_REPOSITORY_ROOT = "git://designer-playground";
    private static final String USERNAME = "guvnorngtestuser1";
    private static final String PASSWORD = "test1234";
    private static final String ORIGIN_URL = "https://github.com/mswiderski/designer-playground.git";
    private static final String FETCH_COMMAND = "?fetch";
    private static String gitLocalClone = System.getProperty("java.io.tmpdir") + "git-repo";
    private static Map<String, String> env = new HashMap<String, String>();
    private VFSFileSystemProducer producer = new VFSFileSystemProducer();
    @Spy
    @InjectMocks
    private JbpmPreprocessingUnit preprocessingUnitVFS = new JbpmPreprocessingUnit();

    @BeforeClass
    public static void prepare() {
        env.put("username", USERNAME);
        env.put("password", PASSWORD);
        env.put("origin", ORIGIN_URL);
        env.put("fetch.cmd", FETCH_COMMAND);
        System.setProperty("org.kie.nio.git.dir", gitLocalClone);
    }

    @AfterClass
    public static void cleanup() {
        System.clearProperty("org.kie.nio.git.dir");
    }

    @Override
    @Before
    public void setup() {
        super.setup();
    }

    @Override
    @After
    public void teardown() {
        super.teardown();
    }

    @Test
    public void testProprocess() {
        Repository repository = this.createRepository();
        repository.createDirectory("/myprocesses");
        repository.createDirectory("/global");
        AssetBuilder builder = AssetBuilderFactory.getAssetBuilder((Asset.AssetType)Asset.AssetType.Text);
        builder.content((Object)"bpmn2 content").type("bpmn2").name("process").location("/myprocesses");
        String uniqueId = repository.createAsset(builder.getAsset());
        this.preprocessingUnitVFS.init((ServletContext)new TestServletContext(), "/", null);
        HashMap<String, String> params = new HashMap<String, String>();
        params.put("uuid", uniqueId);
        this.preprocessingUnitVFS.preprocess((HttpServletRequest)new TestHttpServletRequest(params), null, (IDiagramProfile)new TestIDiagramProfile(repository), null, false, false, null, null);
        Collection globalAssets = repository.listAssets("/global");
        Assert.assertNotNull((Object)globalAssets);
        Assert.assertEquals((long)31L, (long)globalAssets.size());
        repository.assetExists("/global/customeditors.json");
        repository.assetExists("/global/themes.json");
        repository.assetExists("/global/defaultemailicon.gif");
        repository.assetExists("/global/defaultmilestoneicon.png");
        repository.assetExists("/global/defaultlogicon.gif");
        repository.assetExists("/global/defaultservicenodeicon.png");
        repository.assetExists("/global/patterns.json");
        repository.assetExists("/global/.gitignore");
        Collection defaultStuff = repository.listAssets("/myprocesses");
        Assert.assertNotNull((Object)defaultStuff);
        Assert.assertEquals((long)2L, (long)defaultStuff.size());
        repository.assetExists("/myprocesses/WorkDefinitions.wid");
        repository.assetExists("/myprocesses/process.bpmn2");
        repository.assetExists("/myprocesses/.gitignore");
    }

    @Test
    public void testWorkitemParameterValues() throws Exception {
        Repository repository = this.createRepository();
        repository.createDirectory("/myprocesses");
        repository.createDirectory("/global");
        AssetBuilder builder = AssetBuilderFactory.getAssetBuilder((Asset.AssetType)Asset.AssetType.Text);
        builder.content((Object)"import org.drools.core.process.core.datatype.impl.type.StringDataType;\nimport org.drools.core.process.core.datatype.impl.type.EnumDataType;\n[\n    [\n        \"name\" : \"TestServiceWithParamValues\",\n        \"description\" : \"TestServiceWithParamValues\",\n        \"parameters\" : [\n            \"param1\" : new StringDataType(),\n            \"param2\" : new StringDataType(),\n            \"param3\" : new StringDataType()\n        ],\n        \"parameterValues\" : [\n            \"param1\" : new EnumDataType(\"org.jbpm.designer.web.preprocessing.impl.CarsEnum\"),\n            \"param3\" : \"one,two,three\"\n        ],\n        \"results\" : [\n            \"result1\" : new StringDataType(),\n            \"result2\" : new StringDataType()\n        ],\n        \"displayName\" : \"TestServiceWithParamValues\",\n        \"icon\" : \"widicon.png\",\n        \"category\": \"MyTestServices\",\n\t    \"dependencies\" : [\n        ]\n    ]\n]\n").type("wid").name("processwid").location("/myprocesses");
        String uniqueWidID = repository.createAsset(builder.getAsset());
        AssetBuilder builder2 = AssetBuilderFactory.getAssetBuilder((Asset.AssetType)Asset.AssetType.Byte);
        builder2.content((Object)"".getBytes()).type("png").name("widicon").location("/myprocesses");
        String uniqueIconID = repository.createAsset(builder2.getAsset());
        JbpmPreprocessingUnit preprocessingUnitVFS = new JbpmPreprocessingUnit();
        preprocessingUnitVFS.init((ServletContext)new TestServletContext(), "/", null);
        Asset widAsset = repository.loadAsset(uniqueWidID);
        HashMap workDefinitions = new HashMap();
        preprocessingUnitVFS.evaluateWorkDefinitions(workDefinitions, widAsset, widAsset.getAssetLocation(), repository);
        Assert.assertNotNull(workDefinitions);
        Assert.assertEquals((long)1L, (long)workDefinitions.size());
        Assert.assertTrue((boolean)workDefinitions.containsKey("TestServiceWithParamValues"));
        Assert.assertNotNull((Object)((WorkDefinitionImpl)workDefinitions.get("TestServiceWithParamValues")).getParameterValues());
        Assert.assertEquals((long)2L, (long)((WorkDefinitionImpl)workDefinitions.get("TestServiceWithParamValues")).getParameterValues().size());
        Map paramValues = ((WorkDefinitionImpl)workDefinitions.get("TestServiceWithParamValues")).getParameterValues();
        Assert.assertTrue((boolean)paramValues.containsKey("param1"));
        Assert.assertTrue((boolean)paramValues.containsKey("param3"));
        Assert.assertEquals((Object)"TOYOTA,MAZDA,FORD,NISSAN,HONDA", paramValues.get("param1"));
        Assert.assertEquals((Object)"one,two,three", paramValues.get("param3"));
        HashMap customParams = new HashMap();
        for (Map.Entry widEntry : workDefinitions.entrySet()) {
            WorkDefinitionImpl widImpl = (WorkDefinitionImpl)widEntry.getValue();
            if (widImpl.getParameterValues() == null) continue;
            Map widImplParamValues = widImpl.getParameterValues();
            HashMap customParamsValueMap = new HashMap();
            for (Map.Entry widParamValueEntry : widImplParamValues.entrySet()) {
                if (widParamValueEntry.getValue() == null || !(widParamValueEntry.getValue() instanceof String)) continue;
                customParamsValueMap.put(widParamValueEntry.getKey(), Arrays.asList(((String)widParamValueEntry.getValue()).split(",\\s*")));
            }
            customParams.put(widEntry.getKey(), customParamsValueMap);
        }
        Assert.assertNotNull(customParams);
        Assert.assertEquals((long)1L, (long)customParams.size());
        Assert.assertTrue((boolean)customParams.containsKey("TestServiceWithParamValues"));
        Assert.assertEquals((long)2L, (long)((Map)customParams.get("TestServiceWithParamValues")).size());
        ST workItemTemplate = new ST("$workitemDefs:{k| $workitemDefs.(k).parameters:{k1| $if(customParams.(k).(k1))$ $k1.name$ $endif$ }$ }$", '$', '$');
        workItemTemplate.add("workitemDefs", workDefinitions);
        workItemTemplate.add("customParams", customParams);
        Assert.assertTrue((boolean)workItemTemplate.render().contains("param1"));
        Assert.assertTrue((boolean)workItemTemplate.render().contains("param3"));
        Assert.assertFalse((boolean)workItemTemplate.render().contains("param2"));
        ST workItemTemplate2 = new ST("$workitemDefs:{k| $workitemDefs.(k).parameters:{k1| $if(customParams.(k).(k1))$ $else$ $k1.name$ $endif$ }$ }$", '$', '$');
        workItemTemplate2.add("workitemDefs", workDefinitions);
        workItemTemplate2.add("customParams", customParams);
        Assert.assertFalse((boolean)workItemTemplate2.render().contains("param1"));
        Assert.assertFalse((boolean)workItemTemplate2.render().contains("param3"));
        Assert.assertTrue((boolean)workItemTemplate2.render().contains("param2"));
    }

    @Test
    public void testEmptyCustomEditor() throws Exception {
        Repository repository = this.createRepository();
        repository.createDirectory("/myprocesses");
        repository.createDirectory("/global");
        AssetBuilder builder = AssetBuilderFactory.getAssetBuilder((Asset.AssetType)Asset.AssetType.Text);
        builder.content((Object)"import org.drools.core.process.core.datatype.impl.type.StringDataType;\n\n[\n\n  [\n    \"name\" : \"Rewardsystem\",\n    \"description\" : \"Notifies the Reward System\",\n    \"displayName\" : \"Rewardsystem\",\n    \"defaultHandler\": \"mvel: com.rewardsystem.MyRewardsHandler()\",\n    \"category\" : \"Rewards\",\n    \"customEditor\" : \"\",\n    \"icon\" : \"widicon.png\",\n  ]\n\n]").type("wid").name("processwid").location("/myprocesses");
        String uniqueWidID = repository.createAsset(builder.getAsset());
        AssetBuilder builder2 = AssetBuilderFactory.getAssetBuilder((Asset.AssetType)Asset.AssetType.Byte);
        builder2.content((Object)"".getBytes()).type("png").name("widicon").location("/myprocesses");
        String uniqueIconID = repository.createAsset(builder2.getAsset());
        JbpmPreprocessingUnit preprocessingUnitVFS = new JbpmPreprocessingUnit();
        preprocessingUnitVFS.init((ServletContext)new TestServletContext(), "/", null);
        Asset widAsset = repository.loadAsset(uniqueWidID);
        HashMap workDefinitions = new HashMap();
        preprocessingUnitVFS.evaluateWorkDefinitions(workDefinitions, widAsset, widAsset.getAssetLocation(), repository);
        Assert.assertNotNull(workDefinitions);
        Assert.assertEquals((long)1L, (long)workDefinitions.size());
        Assert.assertTrue((boolean)workDefinitions.containsKey("Rewardsystem"));
        Assert.assertTrue((((WorkDefinitionImpl)workDefinitions.get("Rewardsystem")).getCustomEditor() == null ? 1 : 0) != 0);
        ST workItemTemplate = new ST("$workitemDefs:{k| $if(workitemDefs.(k).customEditor)$CEdefined$else$CEnotdefined$endif$ }$", '$', '$');
        workItemTemplate.add("workitemDefs", workDefinitions);
        Assert.assertFalse((boolean)workItemTemplate.render().contains("CEdefined"));
        Assert.assertTrue((boolean)workItemTemplate.render().contains("CEnotdefined"));
        ((WorkDefinitionImpl)workDefinitions.get("Rewardsystem")).setCustomEditor("myRewardsCustomEditor");
        ST workItemTemplate2 = new ST("$workitemDefs:{k| $if(workitemDefs.(k).customEditor)$CEdefined$else$CEnotdefined$endif$ }$", '$', '$');
        workItemTemplate2.add("workitemDefs", workDefinitions);
        Assert.assertTrue((boolean)workItemTemplate2.render().contains("CEdefined"));
        Assert.assertFalse((boolean)workItemTemplate2.render().contains("CEnotdefined"));
    }

    @Test
    public void testCaseProjectSetting() throws Exception {
        Repository repository = this.createRepository();
        repository.createDirectory("/myprocesses");
        repository.createDirectory("/global");
        AssetBuilder builder = AssetBuilderFactory.getAssetBuilder((Asset.AssetType)Asset.AssetType.Text);
        builder.content((Object)"import org.drools.core.process.core.datatype.impl.type.StringDataType;\n\n[\n\n  [\n    \"name\" : \"MyCustomWorkitem\",\n    \"description\" : \"\",\n    \"displayName\" : \"MyCustomWorkitem\",\n    \"defaultHandler\": \"mvel: com.rewardsystem.MyCustomHandler()\",\n    \"category\" : \"Custom\",\n    \"customEditor\" : \"\",\n    \"icon\" : \"widicon.png\",\n  ]\n\n]").type("wid").name("processwid").location("/myprocesses");
        String uniqueWidID = repository.createAsset(builder.getAsset());
        AssetBuilder builder2 = AssetBuilderFactory.getAssetBuilder((Asset.AssetType)Asset.AssetType.Byte);
        builder2.content((Object)"".getBytes()).type("png").name("widicon").location("/myprocesses");
        String uniqueIconID = repository.createAsset(builder2.getAsset());
        JbpmPreprocessingUnit preprocessingUnitVFS = new JbpmPreprocessingUnit();
        preprocessingUnitVFS.init((ServletContext)new TestServletContext(), "/", null);
        Asset widAsset = repository.loadAsset(uniqueWidID);
        HashMap workDefinitions = new HashMap();
        preprocessingUnitVFS.evaluateWorkDefinitions(workDefinitions, widAsset, widAsset.getAssetLocation(), repository);
        Assert.assertNotNull(workDefinitions);
        Assert.assertEquals((long)1L, (long)workDefinitions.size());
        Assert.assertTrue((boolean)workDefinitions.containsKey("MyCustomWorkitem"));
        ST workItemTemplate = new ST("$if(caseproject)$CaseProjectTrue$else$CaseProjectFalse$endif$", '$', '$');
        workItemTemplate.add("workitemDefs", workDefinitions);
        Assert.assertFalse((boolean)workItemTemplate.render().contains("CaseProjectTrue"));
        Assert.assertTrue((boolean)workItemTemplate.render().contains("CaseProjectFalse"));
    }
}

