/*
 * Decompiled with CFR 0.152.
 */
package org.jbpm.designer.web.server;

import java.net.URL;
import java.nio.file.Files;
import java.nio.file.Paths;
import java.util.HashMap;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.apache.commons.codec.binary.Base64;
import org.jbpm.designer.helper.TestHttpServletRequest;
import org.jbpm.designer.helper.TestHttpServletResponse;
import org.jbpm.designer.repository.UriUtils;
import org.jbpm.designer.web.profile.IDiagramProfile;
import org.jbpm.designer.web.profile.impl.JbpmProfileImpl;
import org.jbpm.designer.web.server.SimulationServlet;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;

public class SimulationServletTest {
    private JbpmProfileImpl profile;

    @Before
    public void setup() {
        this.profile = new JbpmProfileImpl();
        this.profile.setBpsimDisplay("true");
    }

    @Test
    public void testRunSimulationLocalizedNames() throws Exception {
        SimulationServlet simulationServlet = new SimulationServlet();
        simulationServlet.setProfile((IDiagramProfile)this.profile);
        String rawJson = this.readFile("BPSim_i18nNames.json");
        String encodedJson = Base64.encodeBase64String((byte[])UriUtils.encode((String)rawJson.toString()).getBytes("UTF-8"));
        HashMap<String, String> params = new HashMap<String, String>();
        params.put("json", encodedJson);
        params.put("action", "runsimulation");
        params.put("ppdata", "Email,Log,Rest,WebService");
        params.put("numinstances", "10");
        params.put("interval", "5");
        params.put("intervalUnit", "minutes");
        TestHttpServletResponse response = new TestHttpServletResponse();
        simulationServlet.doPost((HttpServletRequest)new TestHttpServletRequest(params), (HttpServletResponse)response);
        int responseStatus = response.getStatus();
        Assert.assertEquals((long)0L, (long)responseStatus);
        String encodedResponseText = new String(response.getContent());
        Assert.assertNotNull((Object)encodedResponseText);
        String responseText = UriUtils.decode((String)new String(Base64.decodeBase64((String)encodedResponseText), "UTF-8"));
        Assert.assertTrue((boolean)responseText.contains("BPSim\u49e6\u3057 \u8129"));
        Assert.assertTrue((boolean)responseText.contains("u1\u49e6\u3057 \u8129"));
        Assert.assertTrue((boolean)responseText.contains("u1\u0434\u044d\u043c\u043e\u043a\u0440\u0438\u0442\u0443\u043c"));
    }

    @Test
    public void testGetPathInfoLocalizedNames() throws Exception {
        SimulationServlet simulationServlet = new SimulationServlet();
        simulationServlet.setProfile((IDiagramProfile)this.profile);
        String rawJson = this.readFile("BPSim_i18nNames.json");
        String encodedJson = Base64.encodeBase64String((byte[])UriUtils.encode((String)rawJson.toString()).getBytes("UTF-8"));
        HashMap<String, String> params = new HashMap<String, String>();
        params.put("json", encodedJson);
        params.put("action", "getpathinfo");
        params.put("ppdata", "Email,Log,Rest,WebService");
        params.put("numinstances", "10");
        params.put("interval", "5");
        params.put("intervalUnit", "minutes");
        TestHttpServletResponse response = new TestHttpServletResponse();
        simulationServlet.doPost((HttpServletRequest)new TestHttpServletRequest(params), (HttpServletResponse)response);
        int responseStatus = response.getStatus();
        Assert.assertEquals((long)0L, (long)responseStatus);
        String responseText = new String(response.getContent());
        Assert.assertNotNull((Object)responseText);
        Assert.assertTrue((boolean)responseText.contains("Path"));
        Assert.assertTrue((boolean)responseText.contains("paths"));
    }

    @Test
    public void testLocalizedStartEndTime() throws Exception {
        SimulationServlet simulationServlet = new SimulationServlet();
        simulationServlet.setProfile((IDiagramProfile)this.profile);
        String rawJson = this.readFile("BPSim_i18nNames.json");
        String encodedJson = Base64.encodeBase64String((byte[])UriUtils.encode((String)rawJson.toString()).getBytes("UTF-8"));
        HashMap<String, String> params = new HashMap<String, String>();
        params.put("json", encodedJson);
        params.put("action", "runsimulation");
        params.put("language", "ru_RU");
        params.put("ppdata", "Email,Log,Rest,WebService");
        params.put("numinstances", "10");
        params.put("interval", "5");
        params.put("intervalUnit", "minutes");
        params.put("simteststarttime", "1464083491796");
        params.put("simtestendtime", "1465776165148");
        TestHttpServletResponse response = new TestHttpServletResponse();
        simulationServlet.doPost((HttpServletRequest)new TestHttpServletRequest(params), (HttpServletResponse)response);
        int responseStatus = response.getStatus();
        Assert.assertEquals((long)0L, (long)responseStatus);
        String encodedResponseText = new String(response.getContent());
        Assert.assertNotNull((Object)encodedResponseText);
        String responseText = UriUtils.decode((String)new String(Base64.decodeBase64((String)encodedResponseText), "UTF-8"));
        Assert.assertNotNull((Object)responseText);
        Assert.assertTrue((responseText.contains("\u043c\u0430\u0439") || responseText.contains("\u043c\u0430\u044f") ? 1 : 0) != 0);
        Assert.assertTrue((boolean)responseText.contains("\u0438\u044e\u043d"));
    }

    @Test
    public void testNotAbleToFindPathsInProcess() throws Exception {
        SimulationServlet simulationServlet = new SimulationServlet();
        simulationServlet.setProfile((IDiagramProfile)this.profile);
        String rawJson = this.readFile("BPSim_pathfindererror.json");
        String encodedJson = Base64.encodeBase64String((byte[])UriUtils.encode((String)rawJson.toString()).getBytes("UTF-8"));
        HashMap<String, String> params = new HashMap<String, String>();
        params.put("json", encodedJson);
        params.put("action", "getpathinfo");
        params.put("ppdata", "Email,Log,Rest,WebService");
        params.put("numinstances", "10");
        params.put("interval", "5");
        params.put("intervalUnit", "minutes");
        TestHttpServletResponse response = new TestHttpServletResponse();
        simulationServlet.doPost((HttpServletRequest)new TestHttpServletRequest(params), (HttpServletResponse)response);
        int responseStatus = response.getStatus();
        Assert.assertEquals((long)500L, (long)responseStatus);
    }

    private String readFile(String fileName) throws Exception {
        URL fileURL = SimulationServletTest.class.getResource(fileName);
        return new String(Files.readAllBytes(Paths.get(fileURL.toURI())));
    }
}

