/*
 * Decompiled with CFR 0.152.
 */
package org.jbpm.designer.web.server;

import bpsim.impl.BpsimFactoryImpl;
import java.io.IOException;
import java.io.UnsupportedEncodingException;
import java.util.List;
import java.util.function.BiConsumer;
import javax.inject.Inject;
import javax.servlet.ServletConfig;
import javax.servlet.ServletException;
import javax.servlet.annotation.WebServlet;
import javax.servlet.http.HttpServlet;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.apache.commons.codec.binary.Base64;
import org.eclipse.bpmn2.Definitions;
import org.jboss.drools.impl.DroolsFactoryImpl;
import org.jbpm.designer.bpmn2.impl.Bpmn2JsonUnmarshaller;
import org.jbpm.designer.repository.Asset;
import org.jbpm.designer.repository.AssetBuilderFactory;
import org.jbpm.designer.repository.Repository;
import org.jbpm.designer.repository.impl.AssetBuilder;
import org.jbpm.designer.taskforms.BPMNFormBuilderManager;
import org.jbpm.designer.taskforms.TaskFormInfo;
import org.jbpm.designer.taskforms.TaskFormTemplateManager;
import org.jbpm.designer.util.ConfigurationProvider;
import org.jbpm.designer.util.Utils;
import org.jbpm.designer.web.profile.IDiagramProfile;
import org.jbpm.designer.web.profile.IDiagramProfileService;
import org.json.JSONArray;
import org.json.JSONObject;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.uberfire.backend.vfs.Path;
import org.uberfire.backend.vfs.VFSService;

@WebServlet(displayName="Taskforms", name="TaskformsServlet", urlPatterns={"/taskforms"})
public class TaskFormsServlet
extends HttpServlet {
    private static final long serialVersionUID = 1L;
    private static final Logger _logger = LoggerFactory.getLogger(TaskFormsServlet.class);
    private static final String TASKFORMS_PATH = "taskforms";
    private static final String FORMMODELER_FILE_EXTENSION = "frm";
    public static final String DESIGNER_PATH = ConfigurationProvider.getInstance().getDesignerContext();
    private IDiagramProfile profile;
    @Inject
    private IDiagramProfileService _profileService = null;
    @Inject
    protected BPMNFormBuilderManager formBuilderManager;
    @Inject
    private VFSService vfsServices;

    public void setProfile(IDiagramProfile profile) {
        this.profile = profile;
    }

    public void init(ServletConfig config) throws ServletException {
        super.init(config);
    }

    protected void doPost(HttpServletRequest req, HttpServletResponse resp) throws ServletException, IOException {
        req.setCharacterEncoding("UTF-8");
        String json = req.getParameter("json");
        String uuid = Utils.getUUID(req);
        String profileName = Utils.getDefaultProfileName(req.getParameter("profile"));
        String preprocessingData = req.getParameter("ppdata");
        String taskId = req.getParameter("taskid");
        String formType = req.getParameter("formtype");
        String sessionId = req.getParameter("sessionid");
        if (this.profile == null) {
            this.profile = this._profileService.findProfile(req, profileName);
        }
        Repository repository = this.profile.getRepository();
        if (formType != null && formType.equals(FORMMODELER_FILE_EXTENSION)) {
            try {
                Asset processAsset = repository.loadAsset(uuid);
                DroolsFactoryImpl.init();
                BpsimFactoryImpl.init();
                Bpmn2JsonUnmarshaller unmarshaller = new Bpmn2JsonUnmarshaller();
                Definitions def = (Definitions)unmarshaller.unmarshall(json, preprocessingData).getContents().get(0);
                Path myPath = this.vfsServices.get(uuid.replaceAll("\\s", "%20"));
                TaskFormTemplateManager templateManager = new TaskFormTemplateManager(myPath, this.formBuilderManager, this.profile, processAsset, this.getServletContext().getRealPath(DESIGNER_PATH + TASKFORMS_PATH), def, taskId, formType);
                templateManager.processTemplates();
                resp.setContentType("application/json");
                resp.getWriter().write(this.storeInRepository(templateManager, processAsset.getAssetLocation(), repository, sessionId).toString());
            }
            catch (Throwable t) {
                _logger.error(t.getMessage());
                this.setFailResponse(resp);
            }
        } else {
            this.setFailResponse(resp);
        }
    }

    public void setFailResponse(HttpServletResponse resp) throws IOException {
        resp.setContentType("text/plain");
        resp.getWriter().write("fail");
    }

    public JSONArray storeInRepository(TaskFormTemplateManager templateManager, String location, Repository repository, String sessionId) throws Exception {
        JSONArray retArray = new JSONArray();
        List<TaskFormInfo> taskForms = templateManager.getTaskFormInformationList();
        for (TaskFormInfo taskForm : taskForms) {
            retArray.put((Object)this.storeTaskForm(taskForm, location, repository, sessionId));
        }
        return retArray;
    }

    public JSONObject storeTaskForm(final TaskFormInfo taskForm, final String location, final Repository repository, final String sessionId) throws Exception {
        try {
            final JSONObject retObj = new JSONObject();
            taskForm.getModelerOutputs().forEach(new BiConsumer<String, String>(){

                @Override
                public void accept(String extension, String content) {
                    try {
                        if (repository.assetExists(location.replaceAll("\\s", "%20") + "/" + taskForm.getId() + "." + extension)) {
                            Asset currentAsset = repository.loadAssetFromPath(location.replaceAll("\\s", "%20") + "/" + taskForm.getId() + "." + extension);
                            AssetBuilder formBuilder = AssetBuilderFactory.getAssetBuilder(currentAsset);
                            formBuilder.content(content);
                            String updatedFormId = repository.updateAsset(formBuilder.getAsset(), "", sessionId);
                            if (updatedFormId == null) {
                                _logger.error("Unable to update form: " + taskForm.getPkgName() + "/" + taskForm.getId() + "." + extension);
                            }
                        } else {
                            AssetBuilder modelerBuilder = AssetBuilderFactory.getAssetBuilder(Asset.AssetType.Byte);
                            modelerBuilder.name(taskForm.getId()).location(location.replaceAll("\\s", "%20")).type(extension).content(content.getBytes("UTF-8"));
                            String createdFormId = repository.createAsset(modelerBuilder.getAsset());
                            if (createdFormId == null) {
                                _logger.error("Unable to create form: " + taskForm.getPkgName() + "/" + taskForm.getId() + "." + extension);
                            }
                        }
                        Asset newModelerFormAsset = repository.loadAssetFromPath(taskForm.getPkgName() + "/" + taskForm.getId() + "." + extension);
                        String modelerUniqueId = newModelerFormAsset.getUniqueId();
                        if (Base64.isBase64((String)modelerUniqueId)) {
                            byte[] decoded = Base64.decodeBase64((String)modelerUniqueId);
                            try {
                                modelerUniqueId = new String(decoded, "UTF-8");
                            }
                            catch (UnsupportedEncodingException e) {
                                e.printStackTrace();
                            }
                        }
                        if (extension.equals(TaskFormsServlet.FORMMODELER_FILE_EXTENSION)) {
                            retObj.put("formuri", (Object)modelerUniqueId);
                        }
                    }
                    catch (Exception ex) {
                        _logger.error("Error creating form for: " + taskForm.getId() + "." + extension);
                    }
                }
            });
            return retObj;
        }
        catch (Exception e) {
            _logger.error(e.getMessage());
            return new JSONObject();
        }
    }
}

