/*
 * Decompiled with CFR 0.152.
 */
package org.jbpm.designer.web.server;

import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import javax.inject.Inject;
import javax.servlet.ServletConfig;
import javax.servlet.ServletException;
import javax.servlet.annotation.WebServlet;
import javax.servlet.http.HttpServlet;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.jbpm.designer.repository.Asset;
import org.jbpm.designer.repository.Repository;
import org.jbpm.designer.util.Utils;
import org.jbpm.designer.web.profile.IDiagramProfile;
import org.jbpm.designer.web.profile.IDiagramProfileService;
import org.jbpm.designer.web.server.ServletUtil;
import org.json.JSONObject;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@WebServlet(displayName="FormWidget", name="FormWidgetServlet", urlPatterns={"/formwidget"})
public class FormWidgetServlet
extends HttpServlet {
    private static final Logger _logger = LoggerFactory.getLogger(FormWidgetServlet.class);
    private IDiagramProfile profile;
    @Inject
    private IDiagramProfileService _profileService = null;

    public void setProfile(IDiagramProfile profile) {
        this.profile = profile;
    }

    public void init(ServletConfig config) throws ServletException {
        super.init(config);
    }

    protected void doPost(HttpServletRequest req, HttpServletResponse resp) throws ServletException, IOException {
        req.setCharacterEncoding("UTF-8");
        String profileName = Utils.getDefaultProfileName(req.getParameter("profile"));
        String action = req.getParameter("action");
        String widgetName = req.getParameter("widgetname");
        String uuid = Utils.getUUID(req);
        if (this.profile == null) {
            this.profile = this._profileService.findProfile(req, profileName);
        }
        Repository repository = this.profile.getRepository();
        if (action != null && action.equals("getwidgets")) {
            List<String> widgetList;
            try {
                widgetList = ServletUtil.getFormWidgetList(this.profile, repository, uuid);
            }
            catch (Throwable t) {
                widgetList = new ArrayList<String>();
            }
            JSONObject jsonObject = new JSONObject();
            if (widgetList != null && widgetList.size() > 0) {
                for (String widget : widgetList) {
                    try {
                        jsonObject.put(widget, (Object)widget);
                    }
                    catch (Exception e) {
                        e.printStackTrace();
                    }
                }
            }
            resp.setCharacterEncoding("UTF-8");
            resp.setContentType("application/json");
            resp.getWriter().write(jsonObject.toString());
        } else if (action != null && action.equals("getwidgetsource")) {
            try {
                Asset widgetAsset = repository.loadAssetFromPath(this.profile.getRepositoryGlobalDir(uuid) + "/" + widgetName + ".fw");
                resp.setCharacterEncoding("UTF-8");
                resp.setContentType("text/plain");
                resp.getWriter().write((String)widgetAsset.getAssetContent());
            }
            catch (Exception e) {
                resp.getWriter().write("");
            }
        }
    }
}

