/*
 * Decompiled with CFR 0.152.
 */
package org.jbpm.designer.util;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import org.apache.xml.utils.XMLChar;
import org.jbpm.designer.util.Utils;
import org.junit.Assert;
import org.junit.Test;

public class UtilsTest {
    @Test
    public void testToBPMNIdentifierNoPackage() {
        List<String> testIdShouldNotChange = Arrays.asList("myprocess", "process11", "pro2cess1", "process", "my11process1");
        ArrayList<String> toIdentifierShouldNotChange = new ArrayList<String>();
        for (String id : testIdShouldNotChange) {
            toIdentifierShouldNotChange.add(Utils.toBPMNIdentifier((String)id));
        }
        Assert.assertEquals(testIdShouldNotChange, toIdentifierShouldNotChange);
        Assert.assertTrue((boolean)this.areValidNcNames(testIdShouldNotChange));
        List<String> testIdShouldChange = Arrays.asList("1my=process", "111@process~", "!1process1@!", "22^^process*", "22my%11proces%s1()");
        ArrayList<String> toIdentifierShouldChange = new ArrayList<String>();
        for (String id : testIdShouldChange) {
            toIdentifierShouldChange.add(Utils.toBPMNIdentifier((String)id));
        }
        Assert.assertNotEquals(testIdShouldChange, toIdentifierShouldChange);
        Assert.assertTrue((boolean)toIdentifierShouldChange.containsAll(Arrays.asList("my3Dprocess", "process7E", "process14021", "E5Eprocess2A", "my2511proces25s12829")));
        Assert.assertTrue((boolean)this.areValidNcNames(toIdentifierShouldChange));
    }

    @Test
    public void testToBPMNIdentifierWithPackage() {
        List<String> testIdShouldNotChange = Arrays.asList("mypackage.myprocess", "mypackage.process1", "mypackage.pro2cess1", "mypackage.process", "mypackage.my11process1");
        ArrayList<String> toIdentifierShouldNotChange = new ArrayList<String>();
        for (String id : testIdShouldNotChange) {
            toIdentifierShouldNotChange.add(Utils.toBPMNIdentifier((String)id));
        }
        Assert.assertEquals(testIdShouldNotChange, toIdentifierShouldNotChange);
        Assert.assertTrue((boolean)this.areValidNcNames(testIdShouldNotChange));
        List<String> testIdShouldChange = Arrays.asList("1mypackage.1my=process", "111==mypackage.111@process~", "@!mypackge112.!1process1@!", "^^&mypa11ckage.22^^process*", "()my$$packa@@ge**^.22my%11proces%s1()");
        ArrayList<String> toIdentifierShouldChange = new ArrayList<String>();
        for (String id : testIdShouldChange) {
            toIdentifierShouldChange.add(Utils.toBPMNIdentifier((String)id));
        }
        Assert.assertNotEquals(testIdShouldChange, toIdentifierShouldChange);
        Assert.assertTrue((boolean)toIdentifierShouldChange.containsAll(Arrays.asList("mypackage.1my3Dprocess", "D3Dmypackage.11140process7E", "mypackge112.211process14021", "E5E26mypa11ckage.225E5Eprocess2A", "my2424packa4040ge2A2A5E.22my2511proces25s12829")));
        Assert.assertTrue((boolean)this.areValidNcNames(toIdentifierShouldChange));
    }

    public boolean areValidNcNames(List<String> names) {
        for (String id : names) {
            if (XMLChar.isValidNCName((String)id)) continue;
            return false;
        }
        return true;
    }
}

