/*
 * Decompiled with CFR 0.152.
 */
package org.jbpm.designer.web.server;

import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.OutputStreamWriter;
import javax.inject.Inject;
import javax.servlet.ServletConfig;
import javax.servlet.ServletException;
import javax.servlet.http.HttpServlet;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.apache.commons.codec.binary.Base64;
import org.apache.commons.lang3.StringEscapeUtils;
import org.jbpm.designer.repository.Asset;
import org.jbpm.designer.repository.AssetBuilderFactory;
import org.jbpm.designer.repository.Repository;
import org.jbpm.designer.repository.impl.AssetBuilder;
import org.jbpm.designer.util.Utils;
import org.jbpm.designer.web.profile.IDiagramProfile;
import org.jbpm.designer.web.profile.IDiagramProfileService;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class FileStoreServlet
extends HttpServlet {
    private static final long serialVersionUID = 1L;
    private static final Logger _logger = LoggerFactory.getLogger(FileStoreServlet.class);
    private String retData;
    protected IDiagramProfile profile;
    @Inject
    private IDiagramProfileService _profileService = null;

    public void init(ServletConfig config) throws ServletException {
        super.init(config);
    }

    protected void doPost(HttpServletRequest req, HttpServletResponse resp) throws ServletException, IOException {
        req.setCharacterEncoding("UTF-8");
        String fname = req.getParameter("fname");
        String fext = req.getParameter("fext");
        String data = req.getParameter("data");
        String dataEncoded = req.getParameter("data_encoded");
        String storeInRepo = req.getParameter("storeinrepo");
        String profileName = Utils.getDefaultProfileName(req.getParameter("profile"));
        String uuid = Utils.getUUID(req);
        String processid = req.getParameter("processid");
        if (this.profile == null) {
            this.profile = this._profileService.findProfile(req, profileName);
        }
        Repository repository = this.profile.getRepository();
        this.retData = "";
        this.retData = dataEncoded != null && dataEncoded.length() > 0 ? new String(Base64.decodeBase64((String)dataEncoded)) : StringEscapeUtils.ESCAPE_XML11.translate((CharSequence)data);
        if (fext != null && (fext.equals("bpmn2") || fext.equals("svg"))) {
            try {
                if (fext.equals("bpmn2")) {
                    resp.setContentType("application/xml; charset=UTF-8");
                } else if (fext.equals("svg")) {
                    resp.setContentType("image/svg+xml; charset=UTF-8");
                }
                if (processid != null) {
                    resp.setHeader("Content-Disposition", "attachment; filename=\"" + processid + "." + fext + "\"");
                } else if (uuid != null) {
                    resp.setHeader("Content-Disposition", "attachment; filename=\"" + uuid + "." + fext + "\"");
                } else {
                    resp.setHeader("Content-Disposition", "attachment; filename=\"" + fname + "." + fext + "\"");
                }
                resp.getWriter().write(this.retData);
            }
            catch (Exception e) {
                resp.sendError(500, e.getMessage());
            }
            if (storeInRepo != null && storeInRepo.equals("true")) {
                this.storeInRepository(uuid, this.retData, fext, processid, repository);
            }
        }
    }

    private void storeInRepository(String uuid, String retData, String fext, String processid, Repository repository) {
        try {
            if (processid != null) {
                Asset processAsset = repository.loadAsset(uuid);
                if (processid.startsWith(".")) {
                    processid = processid.substring(1, processid.length());
                }
                String assetFullName = processid + "-" + fext + "." + fext;
                repository.deleteAssetFromPath(processAsset.getAssetLocation() + assetFullName);
                ByteArrayOutputStream outputStream = new ByteArrayOutputStream();
                OutputStreamWriter outStreamWriter = new OutputStreamWriter(outputStream);
                outStreamWriter.write(retData);
                outStreamWriter.close();
                AssetBuilder builder = AssetBuilderFactory.getAssetBuilder(Asset.AssetType.Byte);
                builder.name(processid + "-" + fext).type(fext).location(processAsset.getAssetLocation()).version(processAsset.getVersion()).content(outputStream.toByteArray());
                Asset resourceAsset = builder.getAsset();
                repository.createAsset(resourceAsset);
            }
        }
        catch (Exception e) {
            _logger.error(e.getMessage());
        }
    }

    public String getRetData() {
        return this.retData;
    }
}

