/*
 * Decompiled with CFR 0.152.
 */
package org.jbpm.designer.expressioneditor.parser;

import java.lang.reflect.Method;
import java.util.List;
import org.drools.core.util.KieFunctions;
import org.jbpm.designer.expressioneditor.model.Condition;
import org.jbpm.designer.expressioneditor.model.ConditionExpression;

public class ExpressionScriptGenerator {
    public String generateScript(ConditionExpression expression, List<String> errors) {
        StringBuilder script = new StringBuilder();
        String operator = null;
        int validTerms = 0;
        if ("OR".equals(expression.getOperator())) {
            operator = "||";
        } else if ("AND".equals(expression.getOperator())) {
            operator = "&&";
        } else if (expression.getConditions().size() > 1) {
            operator = "&&";
        }
        for (Condition condition : expression.getConditions()) {
            if (this.addConditionToScript(condition, script, operator, validTerms, errors) > 0) {
                ++validTerms;
                continue;
            }
            return null;
        }
        return "return " + script.toString() + ";";
    }

    private int addConditionToScript(Condition condition, StringBuilder script, String operator, int validTerms, List<String> errors) {
        if (condition == null) {
            errors.add("INVALID_CONDITION_ERROR");
            return 0;
        }
        if (!this.isValidFunction(condition.getFunction())) {
            errors.add("Invalid function: " + condition.getFunction());
            return 0;
        }
        if (validTerms > 0) {
            script.append(" " + operator + " ");
        } else {
            script.append(" ");
        }
        String function = condition.getFunction().trim();
        script.append("KieFunctions." + function);
        script.append("(");
        boolean first = true;
        for (String param : condition.getParameters()) {
            if (first) {
                script.append(param);
                first = false;
            } else {
                script.append(", ");
                script.append("\"" + this.escapeStringParam(param) + "\"");
            }
            if (param != null && !param.isEmpty()) continue;
            errors.add("Parameter can not be null nor empty");
            return 0;
        }
        script.append(")");
        return 1;
    }

    private String escapeStringParam(String param) {
        if (param == null) {
            return null;
        }
        StringBuilder escapedParam = new StringBuilder(param.length() * 2);
        block5: for (int i = 0; i < param.length(); ++i) {
            char c = param.charAt(i);
            switch (c) {
                case '\"': {
                    escapedParam.append('\\');
                    escapedParam.append('\"');
                    continue block5;
                }
                case '\n': {
                    escapedParam.append('\\');
                    escapedParam.append('n');
                    continue block5;
                }
                case '\\': {
                    escapedParam.append('\\');
                    escapedParam.append('\\');
                    continue block5;
                }
                default: {
                    escapedParam.append(c);
                }
            }
        }
        return escapedParam.toString();
    }

    private boolean isValidFunction(String function) {
        if (function == null) {
            return false;
        }
        if (function.trim().isEmpty()) {
            return false;
        }
        function = function.trim();
        for (Method method : KieFunctions.class.getMethods()) {
            if (!function.equals(method.getName())) continue;
            return true;
        }
        return false;
    }
}

