/*
 * Decompiled with CFR 0.152.
 */
package org.jbpm.designer.repository.vfs;

import java.net.URI;
import java.util.ArrayList;
import java.util.Optional;
import junit.framework.TestCase;
import org.guvnor.structure.repositories.Branch;
import org.guvnor.structure.repositories.Repository;
import org.guvnor.structure.repositories.RepositoryService;
import org.jbpm.designer.repository.vfs.RepositoryDescriptor;
import org.jbpm.designer.repository.vfs.RepositoryDescriptorProvider;
import org.junit.Before;
import org.junit.Test;
import org.junit.runner.RunWith;
import org.mockito.InjectMocks;
import org.mockito.Matchers;
import org.mockito.Mock;
import org.mockito.Mockito;
import org.mockito.runners.MockitoJUnitRunner;
import org.uberfire.backend.vfs.Path;
import org.uberfire.backend.vfs.PathFactory;
import org.uberfire.io.IOService;
import org.uberfire.java.nio.file.FileSystem;
import org.uberfire.java.nio.file.FileSystemNotFoundException;
import org.uberfire.java.nio.file.spi.FileSystemProvider;
import org.uberfire.spaces.Space;

@RunWith(value=MockitoJUnitRunner.class)
public class RepositoryDescriptorProviderTest {
    @Mock
    private IOService ioService;
    @Mock
    private RepositoryService repositoryService;
    @InjectMocks
    private RepositoryDescriptorProvider repositoryDescriptorProvider;

    @Before
    public void setup() {
        FileSystem fs = (FileSystem)Mockito.mock(FileSystem.class);
        ((FileSystem)Mockito.doReturn((Object)Mockito.mock(FileSystemProvider.class)).when((Object)fs)).provider();
        ((IOService)Mockito.doReturn((Object)fs).when((Object)this.ioService)).getFileSystem((URI)Matchers.any());
        ArrayList<Repository> repositories = new ArrayList<Repository>();
        repositories.add(this.createRepository("repo1", "space1", "master", "master", "other-branch"));
        repositories.add(this.createRepository("repo2", "space1", "master", "master"));
        repositories.add(this.createRepository("repo1", "space2", "master", "master"));
        repositories.add(this.createRepository("repo with spaces", "space3", "master", "master"));
        ((RepositoryService)Mockito.doReturn(repositories).when((Object)this.repositoryService)).getAllRepositoriesFromAllUserSpaces();
    }

    @Test
    public void getRepositoryDescriptorForExistingRepositoriesTest() {
        this.repositoryDescriptorProvider.init();
        RepositoryDescriptor repo1space1Descriptor = this.repositoryDescriptorProvider.getRepositoryDescriptor(new Space("space1"), "repo1", "master");
        TestCase.assertEquals((String)"default://master@space1/repo1", (String)repo1space1Descriptor.getRepositoryRoot().toString());
        RepositoryDescriptor repo2space1Descriptor = this.repositoryDescriptorProvider.getRepositoryDescriptor(new Space("space1"), "repo2", "master");
        TestCase.assertEquals((String)"default://master@space1/repo2", (String)repo2space1Descriptor.getRepositoryRoot().toString());
        RepositoryDescriptor repo1space2Descriptor = this.repositoryDescriptorProvider.getRepositoryDescriptor(new Space("space2"), "repo1", "master");
        TestCase.assertEquals((String)"default://master@space2/repo1", (String)repo1space2Descriptor.getRepositoryRoot().toString());
        RepositoryDescriptor repoWithSpacesspace3Descriptor = this.repositoryDescriptorProvider.getRepositoryDescriptor(new Space("space3"), "repowithspaces", "master");
        TestCase.assertEquals((String)"default://master@space3/repowithspaces", (String)repoWithSpacesspace3Descriptor.getRepositoryRoot().toString());
    }

    @Test
    public void getRepositoryDescriptorForNewRepositoryTest() {
        this.repositoryDescriptorProvider.init();
        ((RepositoryService)Mockito.doReturn((Object)this.createRepository("repo2", "space2", "master", "master")).when((Object)this.repositoryService)).getRepositoryFromSpace(new Space("space2"), "repo2");
        RepositoryDescriptor repo2space2Descriptor = this.repositoryDescriptorProvider.getRepositoryDescriptor(new Space("space2"), "repo2", "master");
        TestCase.assertEquals((String)"default://master@space2/repo2", (String)repo2space2Descriptor.getRepositoryRoot().toString());
        ((RepositoryService)Mockito.doReturn((Object)this.createRepository("repo with spaces", "space2", "master", "master")).when((Object)this.repositoryService)).getRepositoryFromSpace(new Space("space2"), "repo with spaces");
        RepositoryDescriptor repoWithSpacesSpace2Descriptor = this.repositoryDescriptorProvider.getRepositoryDescriptor(new Space("space2"), "repo with spaces", "master");
        TestCase.assertEquals((String)"default://master@space2/repowithspaces", (String)repoWithSpacesSpace2Descriptor.getRepositoryRoot().toString());
    }

    @Test(expected=FileSystemNotFoundException.class)
    public void getRepositoryDescriptorForUnexistentRepositoryTest() {
        this.repositoryDescriptorProvider.init();
        this.repositoryDescriptorProvider.getRepositoryDescriptor(new Space("space2"), "repo2", "master");
    }

    private Repository createRepository(String alias, String spaceName, String defaultBranchName, String ... branchesNames) {
        Space space = new Space(spaceName);
        Repository repository = (Repository)Mockito.mock(Repository.class);
        ArrayList<Branch> branches = new ArrayList<Branch>();
        for (String branchName : branchesNames) {
            String branchURI = "default://" + branchName + "@" + spaceName + "/" + alias;
            Path branchPath = PathFactory.newPath((String)branchName, (String)branchURI);
            Branch branch = new Branch(branchName, branchPath);
            branches.add(branch);
            if (!branchName.equals(defaultBranchName)) continue;
            ((Repository)Mockito.doReturn(Optional.of(branch)).when((Object)repository)).getDefaultBranch();
        }
        ((Repository)Mockito.doReturn((Object)space).when((Object)repository)).getSpace();
        ((Repository)Mockito.doReturn((Object)alias).when((Object)repository)).getAlias();
        ((Repository)Mockito.doReturn(branches).when((Object)repository)).getBranches();
        return repository;
    }
}

