/*
 * Decompiled with CFR 0.152.
 */
package org.jbpm.designer.stencilset;

import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import org.apache.commons.io.IOUtils;
import org.mozilla.javascript.Context;
import org.mozilla.javascript.ImporterTopLevel;
import org.mozilla.javascript.Scriptable;
import org.mozilla.javascript.ScriptableObject;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class Beautifier {
    private static final Logger logger = LoggerFactory.getLogger(Beautifier.class);

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected static String getScriptFromFile(String filename) throws IOException {
        if (filename == null) {
            return null;
        }
        FileInputStream fis = null;
        byte[] b = null;
        try {
            fis = new FileInputStream(filename);
            int x = fis.available();
            b = new byte[x];
            fis.read(b);
        }
        catch (Throwable throwable) {
            IOUtils.closeQuietly(fis);
            throw throwable;
        }
        IOUtils.closeQuietly((InputStream)fis);
        return new String(b);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void main(String[] args) throws IOException {
        assert (args.length != 0);
        String stencilsetScript = "set = " + Beautifier.getScriptFromFile(args[0]);
        String beautifierScript = Beautifier.getScriptFromFile(ClassLoader.getSystemResource("org/oryxeditor/stencilset/beautifier.js").getFile());
        Context cx = Context.enter();
        cx.setOptimizationLevel(-1);
        try {
            ImporterTopLevel scope = new ImporterTopLevel(cx);
            cx.evaluateString((Scriptable)scope, stencilsetScript, "<cmd>", 1, null);
            cx.evaluateString((Scriptable)scope, beautifierScript, "<cmd>", 1, null);
            String result = (String)ScriptableObject.callMethod((Scriptable)scope, (String)"beautify", (Object[])new Object[]{scope.get("set", (Scriptable)scope)});
            System.out.println(result.toString());
        }
        finally {
            Context.exit();
        }
    }
}

