/*
 * Decompiled with CFR 0.152.
 */
package org.jbpm.designer.server.indexing;

import java.util.HashSet;
import org.jbpm.designer.query.DesignerFindDataTypesQuery;
import org.jbpm.designer.query.DesignerFindRuleFlowNamesQuery;
import org.junit.Assert;
import org.junit.Test;
import org.kie.workbench.common.services.refactoring.model.index.terms.valueterms.ValueResourceIndexTerm;
import org.kie.workbench.common.services.refactoring.model.index.terms.valueterms.ValueSharedPartIndexTerm;
import org.kie.workbench.common.services.refactoring.service.PartType;
import org.kie.workbench.common.services.refactoring.service.ResourceType;

public class QueryValidateTermsTest {
    private static final String ERROR_MSG = PartType.ACTIVATION_GROUP.toString() + "' can not be used";

    @Test
    public void findRuleFlowNamesQueryTermsTest() {
        DesignerFindRuleFlowNamesQuery query = new DesignerFindRuleFlowNamesQuery();
        HashSet<ValueSharedPartIndexTerm> queryTerms = new HashSet<ValueSharedPartIndexTerm>();
        try {
            query.validateTerms(queryTerms);
            Assert.fail((String)"The required rule-flow term is missing, but no exception was thrown.");
        }
        catch (IllegalArgumentException iae) {
            Assert.assertTrue((String)("Incorrect error message: " + iae.getMessage()), (boolean)iae.getMessage().contains("At least 1 term"));
        }
        queryTerms = new HashSet();
        queryTerms.add(new ValueSharedPartIndexTerm("not-rule-flow", PartType.ACTIVATION_GROUP));
        try {
            query.validateTerms(queryTerms);
            Assert.fail((String)"The required rule-flow term is missing, but no exception was thrown.");
        }
        catch (IllegalArgumentException iae) {
            Assert.assertTrue((String)("Incorrect error message: " + iae.getMessage()), (boolean)iae.getMessage().contains(ERROR_MSG));
        }
        queryTerms = new HashSet();
        queryTerms.add(new ValueSharedPartIndexTerm("not-rule-flow", PartType.ACTIVATION_GROUP));
        queryTerms.add(new ValueSharedPartIndexTerm("rule-flow", PartType.RULEFLOW_GROUP));
        try {
            query.validateTerms(queryTerms);
            Assert.fail((String)"The activation term is not acceptable here, but no exception was thrown.");
        }
        catch (IllegalArgumentException iae) {
            Assert.assertTrue((String)("Incorrect error message: " + iae.getMessage()), (boolean)iae.getMessage().contains(ERROR_MSG));
        }
        queryTerms = new HashSet();
        queryTerms.add(new ValueSharedPartIndexTerm("rule-flow", PartType.RULEFLOW_GROUP));
        query.validateTerms(queryTerms);
    }

    @Test
    public void designerFindDataTypesQueryTest() {
        DesignerFindDataTypesQuery query = new DesignerFindDataTypesQuery();
        HashSet<Object> queryTerms = new HashSet<Object>();
        try {
            query.validateTerms(queryTerms);
            Assert.fail((String)"The required java term is missing, but no exception was thrown.");
        }
        catch (IllegalArgumentException iae) {
            Assert.assertTrue((String)("Incorrect error message: " + iae.getMessage()), (boolean)iae.getMessage().contains("At least 1 term"));
        }
        queryTerms = new HashSet();
        queryTerms.add(new ValueSharedPartIndexTerm("not-rule-flow", PartType.ACTIVATION_GROUP));
        try {
            query.validateTerms(queryTerms);
            Assert.fail((String)"The required java term is missing, but no exception was thrown.");
        }
        catch (IllegalArgumentException iae) {
            Assert.assertTrue((String)("Incorrect error message: " + iae.getMessage()), (boolean)iae.getMessage().contains(ERROR_MSG));
        }
        queryTerms = new HashSet();
        queryTerms.add(new ValueSharedPartIndexTerm("not-rule-flow", PartType.ACTIVATION_GROUP));
        queryTerms.add(new ValueResourceIndexTerm("java.class", ResourceType.JAVA));
        try {
            query.validateTerms(queryTerms);
            Assert.fail((String)"The activation term is not acceptable here, but no exception was thrown.");
        }
        catch (IllegalArgumentException iae) {
            Assert.assertTrue((String)("Incorrect error message: " + iae.getMessage()), (boolean)iae.getMessage().contains(ERROR_MSG));
        }
        queryTerms = new HashSet();
        queryTerms.add(new ValueResourceIndexTerm("java.class", ResourceType.JAVA));
        query.validateTerms(queryTerms);
    }
}

