/*
 * Decompiled with CFR 0.152.
 */
package org.jbpm.designer.web.server;

import java.util.Collection;
import java.util.HashMap;
import javax.servlet.ServletConfig;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.apache.commons.codec.binary.Base64;
import org.jbpm.designer.helper.TestHttpServletRequest;
import org.jbpm.designer.helper.TestHttpServletResponse;
import org.jbpm.designer.helper.TestServletConfig;
import org.jbpm.designer.helper.TestServletContext;
import org.jbpm.designer.repository.Asset;
import org.jbpm.designer.repository.AssetBuilderFactory;
import org.jbpm.designer.repository.Filter;
import org.jbpm.designer.repository.Repository;
import org.jbpm.designer.repository.RepositoryBaseTest;
import org.jbpm.designer.repository.UriUtils;
import org.jbpm.designer.repository.filters.FilterByExtension;
import org.jbpm.designer.repository.impl.AssetBuilder;
import org.jbpm.designer.repository.vfs.VFSRepository;
import org.jbpm.designer.web.profile.IDiagramProfile;
import org.jbpm.designer.web.server.TaskFormsEditorServlet;
import org.junit.After;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class TaskFormsEditorServletTest
extends RepositoryBaseTest {
    Logger logger = LoggerFactory.getLogger(TaskFormsEditorServletTest.class);

    @Override
    @Before
    public void setup() {
        super.setup();
    }

    @Override
    @After
    public void teardown() {
        super.teardown();
    }

    @Test
    public void testSaveFrlFormAsset() throws Exception {
        VFSRepository repository = new VFSRepository(this.producer.getIoService());
        repository.setDescriptor(this.descriptor);
        this.profile.setRepository((Repository)repository);
        AssetBuilder builder = AssetBuilderFactory.getAssetBuilder((Asset.AssetType)Asset.AssetType.Text);
        builder.content((Object)"bpmn2 content").type("bpmn2").name("testprocess").location("/defaultPackage");
        String uniqueId = repository.createAsset(builder.getAsset());
        HashMap<String, String> params = new HashMap<String, String>();
        params.put("uuid", uniqueId);
        params.put("action", "save");
        params.put("profile", "jbpm");
        params.put("taskname", Base64.encodeBase64String((byte[])UriUtils.encode((String)"evaluate").getBytes()));
        params.put("tfvalue", "this is simple task content");
        params.put("formtype", "frm");
        TaskFormsEditorServlet taskFormsEditorServlet = new TaskFormsEditorServlet();
        taskFormsEditorServlet.setProfile((IDiagramProfile)this.profile);
        taskFormsEditorServlet.init((ServletConfig)new TestServletConfig(new TestServletContext((Repository)repository)));
        taskFormsEditorServlet.doPost((HttpServletRequest)new TestHttpServletRequest(params), (HttpServletResponse)new TestHttpServletResponse());
        Collection forms = repository.listAssets("/defaultPackage", (Filter)new FilterByExtension("frm"));
        Assert.assertNotNull((Object)forms);
        Assert.assertEquals((long)1L, (long)forms.size());
    }

    @Test
    public void testSaveFormFormAsset() throws Exception {
        VFSRepository repository = new VFSRepository(this.producer.getIoService());
        repository.setDescriptor(this.descriptor);
        this.profile.setRepository((Repository)repository);
        AssetBuilder builder = AssetBuilderFactory.getAssetBuilder((Asset.AssetType)Asset.AssetType.Text);
        builder.content((Object)"bpmn2 content").type("bpmn2").name("testprocess").location("/defaultPackage");
        String uniqueId = repository.createAsset(builder.getAsset());
        HashMap<String, String> params = new HashMap<String, String>();
        params.put("uuid", uniqueId);
        params.put("action", "save");
        params.put("profile", "jbpm");
        params.put("taskname", Base64.encodeBase64String((byte[])UriUtils.encode((String)"evaluate").getBytes()));
        params.put("tfvalue", "this is simple task content");
        params.put("formtype", "form");
        TaskFormsEditorServlet taskFormsEditorServlet = new TaskFormsEditorServlet();
        taskFormsEditorServlet.setProfile((IDiagramProfile)this.profile);
        taskFormsEditorServlet.init((ServletConfig)new TestServletConfig(new TestServletContext((Repository)repository)));
        taskFormsEditorServlet.doPost((HttpServletRequest)new TestHttpServletRequest(params), (HttpServletResponse)new TestHttpServletResponse());
        Collection forms = repository.listAssets("/defaultPackage", (Filter)new FilterByExtension("form"));
        Assert.assertNotNull((Object)forms);
        Assert.assertEquals((long)1L, (long)forms.size());
    }

    @Test
    public void testSaveFtlFormAsset() throws Exception {
        VFSRepository repository = new VFSRepository(this.producer.getIoService());
        repository.setDescriptor(this.descriptor);
        this.profile.setRepository((Repository)repository);
        AssetBuilder builder = AssetBuilderFactory.getAssetBuilder((Asset.AssetType)Asset.AssetType.Text);
        builder.content((Object)"bpmn2 content").type("bpmn2").name("testprocess").location("/defaultPackage");
        String uniqueId = repository.createAsset(builder.getAsset());
        HashMap<String, String> params = new HashMap<String, String>();
        params.put("uuid", uniqueId);
        params.put("action", "save");
        params.put("profile", "jbpm");
        params.put("taskname", Base64.encodeBase64String((byte[])UriUtils.encode((String)"evaluate").getBytes()));
        params.put("tfvalue", "this is simple task content");
        params.put("formtype", "ftl");
        TaskFormsEditorServlet taskFormsEditorServlet = new TaskFormsEditorServlet();
        taskFormsEditorServlet.setProfile((IDiagramProfile)this.profile);
        taskFormsEditorServlet.init((ServletConfig)new TestServletConfig(new TestServletContext((Repository)repository)));
        taskFormsEditorServlet.doPost((HttpServletRequest)new TestHttpServletRequest(params), (HttpServletResponse)new TestHttpServletResponse());
        Collection forms = repository.listAssets("/defaultPackage", (Filter)new FilterByExtension("ftl"));
        Assert.assertNotNull((Object)forms);
        Assert.assertEquals((long)0L, (long)forms.size());
    }

    @Test
    public void testLoadFrmFormAsset() throws Exception {
        VFSRepository repository = new VFSRepository(this.producer.getIoService());
        repository.setDescriptor(this.descriptor);
        this.profile.setRepository((Repository)repository);
        AssetBuilder builder = AssetBuilderFactory.getAssetBuilder((Asset.AssetType)Asset.AssetType.Text);
        builder.content((Object)"bpmn2 content").type("bpmn2").name("testprocess").location("/defaultPackage");
        String uniqueId = repository.createAsset(builder.getAsset());
        AssetBuilder builderForm = AssetBuilderFactory.getAssetBuilder((Asset.AssetType)Asset.AssetType.Text);
        builderForm.content((Object)"this is simple task content").type("frm").name("evaluate-taskform").location("/defaultPackage");
        String uniqueIdForm = repository.createAsset(builderForm.getAsset());
        HashMap<String, String> params = new HashMap<String, String>();
        params.put("uuid", uniqueId);
        params.put("action", "load");
        params.put("profile", "jbpm");
        params.put("taskname", Base64.encodeBase64String((byte[])UriUtils.encode((String)"evaluate").getBytes()));
        params.put("tfvalue", "this is simple task content");
        params.put("formtype", "frm");
        TaskFormsEditorServlet taskFormsEditorServlet = new TaskFormsEditorServlet();
        taskFormsEditorServlet.setProfile((IDiagramProfile)this.profile);
        taskFormsEditorServlet.init((ServletConfig)new TestServletConfig(new TestServletContext((Repository)repository)));
        TestHttpServletResponse response = new TestHttpServletResponse();
        taskFormsEditorServlet.doPost((HttpServletRequest)new TestHttpServletRequest(params), (HttpServletResponse)response);
        String formData = new String(response.getContent());
        this.logger.debug(formData);
        Assert.assertNotNull((Object)formData);
    }

    @Test
    public void testLoadFormFormAsset() throws Exception {
        VFSRepository repository = new VFSRepository(this.producer.getIoService());
        repository.setDescriptor(this.descriptor);
        this.profile.setRepository((Repository)repository);
        AssetBuilder builder = AssetBuilderFactory.getAssetBuilder((Asset.AssetType)Asset.AssetType.Text);
        builder.content((Object)"bpmn2 content").type("bpmn2").name("testprocess").location("/defaultPackage");
        String uniqueId = repository.createAsset(builder.getAsset());
        AssetBuilder builderForm = AssetBuilderFactory.getAssetBuilder((Asset.AssetType)Asset.AssetType.Text);
        builderForm.content((Object)"this is simple task content").type("form").name("evaluate-taskform").location("/defaultPackage");
        String uniqueIdForm = repository.createAsset(builderForm.getAsset());
        HashMap<String, String> params = new HashMap<String, String>();
        params.put("uuid", uniqueId);
        params.put("action", "load");
        params.put("profile", "jbpm");
        params.put("taskname", Base64.encodeBase64String((byte[])UriUtils.encode((String)"evaluate").getBytes()));
        params.put("tfvalue", "this is simple task content");
        params.put("formtype", "form");
        TaskFormsEditorServlet taskFormsEditorServlet = new TaskFormsEditorServlet();
        taskFormsEditorServlet.setProfile((IDiagramProfile)this.profile);
        taskFormsEditorServlet.init((ServletConfig)new TestServletConfig(new TestServletContext((Repository)repository)));
        TestHttpServletResponse response = new TestHttpServletResponse();
        taskFormsEditorServlet.doPost((HttpServletRequest)new TestHttpServletRequest(params), (HttpServletResponse)response);
        String formData = new String(response.getContent());
        this.logger.debug(formData);
        Assert.assertNotNull((Object)formData);
    }

    @Test
    public void testLoadFtlFormAsset() throws Exception {
        VFSRepository repository = new VFSRepository(this.producer.getIoService());
        repository.setDescriptor(this.descriptor);
        this.profile.setRepository((Repository)repository);
        AssetBuilder builder = AssetBuilderFactory.getAssetBuilder((Asset.AssetType)Asset.AssetType.Text);
        builder.content((Object)"bpmn2 content").type("bpmn2").name("testprocess").location("/defaultPackage");
        String uniqueId = repository.createAsset(builder.getAsset());
        AssetBuilder builderForm = AssetBuilderFactory.getAssetBuilder((Asset.AssetType)Asset.AssetType.Text);
        builderForm.content((Object)"this is simple task content").type("ftl").name("evaluate-taskform").location("/defaultPackage");
        String uniqueIdForm = repository.createAsset(builderForm.getAsset());
        HashMap<String, String> params = new HashMap<String, String>();
        params.put("uuid", uniqueId);
        params.put("action", "load");
        params.put("profile", "jbpm");
        params.put("taskname", Base64.encodeBase64String((byte[])UriUtils.encode((String)"evaluate").getBytes()));
        params.put("tfvalue", "this is simple task content");
        params.put("formtype", "ftl");
        TaskFormsEditorServlet taskFormsEditorServlet = new TaskFormsEditorServlet();
        taskFormsEditorServlet.setProfile((IDiagramProfile)this.profile);
        taskFormsEditorServlet.init((ServletConfig)new TestServletConfig(new TestServletContext((Repository)repository)));
        TestHttpServletResponse response = new TestHttpServletResponse();
        taskFormsEditorServlet.doPost((HttpServletRequest)new TestHttpServletRequest(params), (HttpServletResponse)response);
        String formData = new String(response.getContent());
        this.logger.debug(formData);
        Assert.assertEquals((Object)"false", (Object)formData);
    }

    @Test
    public void testSaveForm_i18nName() throws Exception {
        VFSRepository repository = new VFSRepository(this.producer.getIoService());
        repository.setDescriptor(this.descriptor);
        this.profile.setRepository((Repository)repository);
        AssetBuilder builder = AssetBuilderFactory.getAssetBuilder((Asset.AssetType)Asset.AssetType.Text);
        builder.content((Object)"bpmn2 content").type("bpmn2").name("BPTaskForm_i18nNames").location("/defaultPackage");
        String uniqueId = repository.createAsset(builder.getAsset());
        String taskName = "\u043f\u0440\u043e\u0432\u0435\u0440\u0438\u0442\u044c";
        HashMap<String, String> params = new HashMap<String, String>();
        params.put("uuid", uniqueId);
        params.put("action", "save");
        params.put("profile", "jbpm");
        params.put("taskname", Base64.encodeBase64String((byte[])UriUtils.encode((String)taskName).getBytes()));
        params.put("tfvalue", "this is simple task content");
        params.put("formtype", "form");
        TaskFormsEditorServlet taskFormsEditorServlet = new TaskFormsEditorServlet();
        taskFormsEditorServlet.setProfile((IDiagramProfile)this.profile);
        taskFormsEditorServlet.init((ServletConfig)new TestServletConfig(new TestServletContext((Repository)repository)));
        TestHttpServletResponse response = new TestHttpServletResponse();
        taskFormsEditorServlet.doPost((HttpServletRequest)new TestHttpServletRequest(params), (HttpServletResponse)response);
        Collection forms = repository.listAssets("/defaultPackage", (Filter)new FilterByExtension("form"));
        Assert.assertNotNull((Object)forms);
        Assert.assertEquals((long)1L, (long)forms.size());
    }

    @Test
    public void testSaveNotExistingTaskForm() throws Exception {
        VFSRepository repository = new VFSRepository(this.producer.getIoService());
        repository.setDescriptor(this.descriptor);
        this.profile.setRepository((Repository)repository);
        AssetBuilder builder = AssetBuilderFactory.getAssetBuilder((Asset.AssetType)Asset.AssetType.Text);
        builder.content((Object)"bpmn2 content").type("bpmn2").name("testprocess").location("/defaultPackage");
        String uniqueId = repository.createAsset(builder.getAsset());
        String taskName = "mytask";
        HashMap<String, String> params = new HashMap<String, String>();
        params.put("uuid", uniqueId);
        params.put("action", "save");
        params.put("profile", "jbpm");
        params.put("taskname", Base64.encodeBase64String((byte[])UriUtils.encode((String)taskName).getBytes()));
        params.put("tfvalue", "this is simple task content");
        params.put("formtype", "form");
        params.put("json", "{\"resourceId\":\"Definition\",\"properties\":{\"namespaces\":\"\",\"name\":\"\",\"expressionlanguage\":\"http://www.mvel.org/2.0\",\"executable\":\"true\",\"package\":\"\",\"vardefs\":\"\",\"customdescription\":\"\",\"customcaseidprefix\":\"\",\"customcaseroles\":\"\",\"adhocprocess\":\"false\",\"imports\":\"\",\"globals\":\"\",\"id\":\"evaluation.abc\",\"version\":\"1.0\",\"timeunit\":\"min\",\"currency\":\"\",\"targetnamespace\":\"http://www.omg.org/bpmn20\",\"typelanguage\":\"http://www.java.com/javaTypes\",\"processn\":\"abc\",\"documentation\":\"\"},\"stencil\":{\"id\":\"BPMNDiagram\"},\"childShapes\":[{\"resourceId\":\"_17704A2A-ABF7-4F52-A5C5-0A6C638B73B3\",\"properties\":{\"name\":\"myTask\",\"documentation\":\"\",\"isselectable\":\"true\",\"invisid\":\"\",\"isforcompensation\":\"\",\"assignments\":\"\",\"assignmentsview\":\"0 data inputs, 0 data outputs\",\"tasktype\":\"User\",\"messageref\":\"\",\"script\":\"\",\"script_language\":\"java\",\"bgcolor\":\"#fafad2\",\"bordercolor\":\"#000000\",\"fontcolor\":\"#000000\",\"fontsize\":\"\",\"datainputset\":\"\",\"dataoutputset\":\"\",\"origbgcolor\":\"#fafad2\",\"nomorph\":\"true\",\"origbordercolor\":\"#000000\",\"ruleflowgroup\":\"\",\"rulelanguage\":\"DRL\",\"onentryactions\":\"\",\"onexitactions\":\"\",\"isasync\":\"false\",\"customautostart\":\"false\",\"taskname\":\"myTask\",\"serviceoperation\":\"\",\"serviceinterface\":\"\",\"serviceimplementation\":\"Java\",\"actors\":\"\",\"groupid\":\"\",\"subject\":\"\",\"description\":\"\",\"content\":\"\",\"reassignment\":\"\",\"notifications\":\"\",\"locale\":\"\",\"createdby\":\"\",\"skippable\":\"true\",\"priority\":\"\",\"multipleinstance\":\"false\",\"multipleinstancecollectioninput\":\"\",\"multipleinstancecollectionoutput\":\"\",\"multipleinstancedatainput\":\"\",\"multipleinstancedataoutput\":\"\",\"multipleinstancecompletioncondition\":\"\",\"min\":\"5\",\"max\":\"10\",\"standarddeviation\":\"1\",\"mean\":\"0\",\"distributiontype\":\"uniform\",\"quantity\":\"1\",\"workinghours\":\"8\",\"unitcost\":\"0\"},\"stencil\":{\"id\":\"Task\"},\"childShapes\":[],\"outgoing\":[],\"bounds\":{\"lowerRight\":{\"x\":178,\"y\":210},\"upperLeft\":{\"x\":78,\"y\":130}},\"dockers\":[]}],\"bounds\":{\"lowerRight\":{\"x\":3000,\"y\":2000},\"upperLeft\":{\"x\":0,\"y\":0}},\"stencilset\":{\"url\":\"/org.kie.workbench.KIEWebapp/stencilsets/bpmn2.0jbpm/bpmn2.0jbpm.json\",\"namespace\":\"http://b3mn.org/stencilset/bpmn2.0#\"},\"ssextensions\":[]}");
        params.put("ppdata", "");
        TaskFormsEditorServlet taskFormsEditorServlet = new TaskFormsEditorServlet();
        taskFormsEditorServlet.setProfile((IDiagramProfile)this.profile);
        taskFormsEditorServlet.init((ServletConfig)new TestServletConfig(new TestServletContext((Repository)repository)));
        TestHttpServletResponse response = new TestHttpServletResponse();
        taskFormsEditorServlet.doPost((HttpServletRequest)new TestHttpServletRequest(params), (HttpServletResponse)response);
        Collection ftlForms = repository.listAssets("/defaultPackage", (Filter)new FilterByExtension("ftl"));
        Assert.assertNotNull((Object)ftlForms);
        Assert.assertEquals((long)0L, (long)ftlForms.size());
        Collection formForms = repository.listAssets("/defaultPackage", (Filter)new FilterByExtension("form"));
        Assert.assertNotNull((Object)formForms);
        Assert.assertEquals((long)1L, (long)formForms.size());
        params.remove("formtype");
        params.put("formtype", "frm");
        taskFormsEditorServlet = new TaskFormsEditorServlet();
        taskFormsEditorServlet.setProfile((IDiagramProfile)this.profile);
        taskFormsEditorServlet.init((ServletConfig)new TestServletConfig(new TestServletContext((Repository)repository)));
        response = new TestHttpServletResponse();
        taskFormsEditorServlet.doPost((HttpServletRequest)new TestHttpServletRequest(params), (HttpServletResponse)response);
        Collection ftlForms2 = repository.listAssets("/defaultPackage", (Filter)new FilterByExtension("ftl"));
        Assert.assertNotNull((Object)ftlForms2);
        Assert.assertEquals((long)0L, (long)ftlForms2.size());
        Collection frmForms = repository.listAssets("/defaultPackage", (Filter)new FilterByExtension("frm"));
        Assert.assertNotNull((Object)frmForms);
        Assert.assertEquals((long)1L, (long)frmForms.size());
    }

    @Test
    public void testSaveExistingTaskForm() throws Exception {
        VFSRepository repository = new VFSRepository(this.producer.getIoService());
        repository.setDescriptor(this.descriptor);
        this.profile.setRepository((Repository)repository);
        AssetBuilder processBuilder = AssetBuilderFactory.getAssetBuilder((Asset.AssetType)Asset.AssetType.Text);
        processBuilder.content((Object)"bpmn2 content").type("bpmn2").name("testprocess").location("/defaultPackage");
        String processUniqueId = repository.createAsset(processBuilder.getAsset());
        AssetBuilder formBuilder = AssetBuilderFactory.getAssetBuilder((Asset.AssetType)Asset.AssetType.Byte);
        formBuilder.content((Object)"form content".getBytes()).type("form").name("mytask-taskform").location("/defaultPackage");
        repository.createAsset(formBuilder.getAsset());
        AssetBuilder frmBuilder = AssetBuilderFactory.getAssetBuilder((Asset.AssetType)Asset.AssetType.Byte);
        frmBuilder.content((Object)"form content".getBytes()).type("frm").name("mytask-taskform").location("/defaultPackage");
        repository.createAsset(frmBuilder.getAsset());
        Collection ftlForms = repository.listAssets("/defaultPackage", (Filter)new FilterByExtension("ftl"));
        Assert.assertNotNull((Object)ftlForms);
        Assert.assertEquals((long)0L, (long)ftlForms.size());
        Collection formForms = repository.listAssets("/defaultPackage", (Filter)new FilterByExtension("form"));
        Assert.assertNotNull((Object)formForms);
        Assert.assertEquals((long)1L, (long)formForms.size());
        Collection frmForms = repository.listAssets("/defaultPackage", (Filter)new FilterByExtension("frm"));
        Assert.assertNotNull((Object)frmForms);
        Assert.assertEquals((long)1L, (long)frmForms.size());
        String taskName = "mytask";
        HashMap<String, String> params = new HashMap<String, String>();
        params.put("uuid", processUniqueId);
        params.put("action", "save");
        params.put("profile", "jbpm");
        params.put("taskname", Base64.encodeBase64String((byte[])UriUtils.encode((String)taskName).getBytes()));
        params.put("tfvalue", "this is simple task content");
        params.put("formtype", "form");
        params.put("json", "{\"resourceId\":\"Definition\",\"properties\":{\"namespaces\":\"\",\"name\":\"\",\"expressionlanguage\":\"http://www.mvel.org/2.0\",\"executable\":\"true\",\"package\":\"\",\"vardefs\":\"\",\"customdescription\":\"\",\"customcaseidprefix\":\"\",\"customcaseroles\":\"\",\"adhocprocess\":\"false\",\"imports\":\"\",\"globals\":\"\",\"id\":\"evaluation.abc\",\"version\":\"1.0\",\"timeunit\":\"min\",\"currency\":\"\",\"targetnamespace\":\"http://www.omg.org/bpmn20\",\"typelanguage\":\"http://www.java.com/javaTypes\",\"processn\":\"abc\",\"documentation\":\"\"},\"stencil\":{\"id\":\"BPMNDiagram\"},\"childShapes\":[{\"resourceId\":\"_17704A2A-ABF7-4F52-A5C5-0A6C638B73B3\",\"properties\":{\"name\":\"myTask\",\"documentation\":\"\",\"isselectable\":\"true\",\"invisid\":\"\",\"isforcompensation\":\"\",\"assignments\":\"\",\"assignmentsview\":\"0 data inputs, 0 data outputs\",\"tasktype\":\"User\",\"messageref\":\"\",\"script\":\"\",\"script_language\":\"java\",\"bgcolor\":\"#fafad2\",\"bordercolor\":\"#000000\",\"fontcolor\":\"#000000\",\"fontsize\":\"\",\"datainputset\":\"\",\"dataoutputset\":\"\",\"origbgcolor\":\"#fafad2\",\"nomorph\":\"true\",\"origbordercolor\":\"#000000\",\"ruleflowgroup\":\"\",\"rulelanguage\":\"DRL\",\"onentryactions\":\"\",\"onexitactions\":\"\",\"isasync\":\"false\",\"customautostart\":\"false\",\"taskname\":\"myTask\",\"serviceoperation\":\"\",\"serviceinterface\":\"\",\"serviceimplementation\":\"Java\",\"actors\":\"\",\"groupid\":\"\",\"subject\":\"\",\"description\":\"\",\"content\":\"\",\"reassignment\":\"\",\"notifications\":\"\",\"locale\":\"\",\"createdby\":\"\",\"skippable\":\"true\",\"priority\":\"\",\"multipleinstance\":\"false\",\"multipleinstancecollectioninput\":\"\",\"multipleinstancecollectionoutput\":\"\",\"multipleinstancedatainput\":\"\",\"multipleinstancedataoutput\":\"\",\"multipleinstancecompletioncondition\":\"\",\"min\":\"5\",\"max\":\"10\",\"standarddeviation\":\"1\",\"mean\":\"0\",\"distributiontype\":\"uniform\",\"quantity\":\"1\",\"workinghours\":\"8\",\"unitcost\":\"0\"},\"stencil\":{\"id\":\"Task\"},\"childShapes\":[],\"outgoing\":[],\"bounds\":{\"lowerRight\":{\"x\":178,\"y\":210},\"upperLeft\":{\"x\":78,\"y\":130}},\"dockers\":[]}],\"bounds\":{\"lowerRight\":{\"x\":3000,\"y\":2000},\"upperLeft\":{\"x\":0,\"y\":0}},\"stencilset\":{\"url\":\"/org.kie.workbench.KIEWebapp/stencilsets/bpmn2.0jbpm/bpmn2.0jbpm.json\",\"namespace\":\"http://b3mn.org/stencilset/bpmn2.0#\"},\"ssextensions\":[]}");
        params.put("ppdata", "");
        TaskFormsEditorServlet taskFormsEditorServlet = new TaskFormsEditorServlet();
        taskFormsEditorServlet.setProfile((IDiagramProfile)this.profile);
        taskFormsEditorServlet.init((ServletConfig)new TestServletConfig(new TestServletContext((Repository)repository)));
        TestHttpServletResponse response = new TestHttpServletResponse();
        taskFormsEditorServlet.doPost((HttpServletRequest)new TestHttpServletRequest(params), (HttpServletResponse)response);
        ftlForms = repository.listAssets("/defaultPackage", (Filter)new FilterByExtension("ftl"));
        Assert.assertNotNull((Object)ftlForms);
        Assert.assertEquals((long)0L, (long)ftlForms.size());
        formForms = repository.listAssets("/defaultPackage", (Filter)new FilterByExtension("form"));
        Assert.assertNotNull((Object)formForms);
        Assert.assertEquals((long)1L, (long)formForms.size());
        params.remove("formtype");
        params.put("formtype", "frm");
        taskFormsEditorServlet = new TaskFormsEditorServlet();
        taskFormsEditorServlet.setProfile((IDiagramProfile)this.profile);
        taskFormsEditorServlet.init((ServletConfig)new TestServletConfig(new TestServletContext((Repository)repository)));
        response = new TestHttpServletResponse();
        taskFormsEditorServlet.doPost((HttpServletRequest)new TestHttpServletRequest(params), (HttpServletResponse)response);
        ftlForms = repository.listAssets("/defaultPackage", (Filter)new FilterByExtension("ftl"));
        Assert.assertNotNull((Object)ftlForms);
        Assert.assertEquals((long)0L, (long)ftlForms.size());
        frmForms = repository.listAssets("/defaultPackage", (Filter)new FilterByExtension("frm"));
        Assert.assertNotNull((Object)frmForms);
        Assert.assertEquals((long)1L, (long)frmForms.size());
    }
}

