/*
 * Decompiled with CFR 0.152.
 */
package org.jbpm.designer.filter;

import java.io.IOException;
import java.io.StringReader;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.parsers.ParserConfigurationException;
import org.jbpm.designer.filter.DesignerInjectionFilter;
import org.jbpm.designer.filter.InjectionRule;
import org.jbpm.designer.filter.InjectionRules;
import org.junit.Assert;
import org.junit.Test;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.xml.sax.InputSource;
import org.xml.sax.SAXException;

public class DesignerInjectionFilterTest {
    private static final String INIT_STRING = "<head>some text</head><body>body content</body>";
    private static final StringBuffer INIT_BUFFER = new StringBuffer("<head>some text</head><body>body content</body>");
    private static final String EMPTY_RULE_XML = "<ruleNode name=\"named\" enabled=\"true\" insert-at=\"\"></ruleNode>";

    @Test
    public void testFindAndReplaceWithSameText() {
        String result = DesignerInjectionFilter.findAndReplace((String)"</body>", (String)INIT_STRING, (String)"</body>");
        Assert.assertEquals((String)"Find and replace the same text. Result string have to be unchanged.", (Object)INIT_STRING, (Object)result);
    }

    @Test
    public void testFindAndReplace() {
        String result = DesignerInjectionFilter.findAndReplace((String)" extended</body>", (String)INIT_STRING, (String)"</body>");
        String DIFFERENCE = " extended";
        Assert.assertEquals((String)"Source string have to be extended by \" extended\" value inside tag <body>", (Object)"<head>some text</head><body>body content extended</body>", (Object)result);
    }

    @Test
    public void testProcessContentWithoutFilters() throws Exception {
        InjectionRules rules = new InjectionRules();
        String result = DesignerInjectionFilter.processContent((StringBuffer)INIT_BUFFER, (InjectionRules)rules);
        Assert.assertEquals((String)"Missing rules can't to change source string.", (Object)INIT_STRING, (Object)result);
    }

    @Test
    public void testProcessContentWithEmptyFilter() throws Exception {
        InjectionRules rules = new InjectionRules();
        Element node = this.createDocument().getDocumentElement();
        InjectionRule rule = new InjectionRule((Node)node, "/");
        rules.add((Object)rule);
        String result = DesignerInjectionFilter.processContent((StringBuffer)INIT_BUFFER, (InjectionRules)rules);
        Assert.assertEquals((String)"Missing filters can't to change source string.", (Object)INIT_STRING, (Object)result);
    }

    @Test
    public void testProcessContentWithEmptyFilters() throws Exception {
        String[] insertAtVariations;
        InjectionRules rules = new InjectionRules();
        Element node = this.createDocument().getDocumentElement();
        for (String insertAt : insertAtVariations = new String[]{"head-begin", "head-begin", "head-end", "body-begin", "body-begin", "body-end"}) {
            node.setAttribute("insert-at", insertAt);
            InjectionRule rule = new InjectionRule((Node)node, "/");
            rules.add((Object)rule);
        }
        String result = DesignerInjectionFilter.processContent((StringBuffer)INIT_BUFFER, (InjectionRules)rules);
        Assert.assertEquals((String)"Empty filters can't to change source string.", (Object)INIT_STRING, (Object)result);
    }

    @Test
    public void testProcessContentHeadBegin() throws Exception {
        InjectionRules rules = new InjectionRules();
        rules.add((Object)this.createRule("head-begin", "Test"));
        String result = DesignerInjectionFilter.processContent((StringBuffer)INIT_BUFFER, (InjectionRules)rules);
        String DIFFERENCE = "\nTest\n<!-- mg#head#begin#marker -->";
        Assert.assertEquals((String)"Head tag have to start with \nTest\n<!-- mg#head#begin#marker -->", (Object)"<head>\nTest\n<!-- mg#head#begin#marker -->some text</head><body>body content</body>", (Object)result);
    }

    @Test
    public void testProcessContentHeadBeginTwice() throws Exception {
        InjectionRules rules = new InjectionRules();
        rules.add((Object)this.createRule("head-begin", "Test"));
        rules.add((Object)this.createRule("head-begin", "Second"));
        String result = DesignerInjectionFilter.processContent((StringBuffer)INIT_BUFFER, (InjectionRules)rules);
        String DIFFERENCE = "\nTest\nSecond\n<!-- mg#head#begin#marker -->";
        Assert.assertEquals((String)"Head tag have to start with \nTest\nSecond\n<!-- mg#head#begin#marker -->", (Object)"<head>\nTest\nSecond\n<!-- mg#head#begin#marker -->some text</head><body>body content</body>", (Object)result);
    }

    @Test
    public void testProcessContentHeadEnd() throws Exception {
        InjectionRules rules = new InjectionRules();
        rules.add((Object)this.createRule("head-end", "Test"));
        String result = DesignerInjectionFilter.processContent((StringBuffer)INIT_BUFFER, (InjectionRules)rules);
        String DIFFERENCE = "Test\n";
        Assert.assertEquals((String)"Head tag have to end with Test\n", (Object)"<head>some textTest\n</head><body>body content</body>", (Object)result);
    }

    @Test
    public void testProcessContentBodyBegin() throws Exception {
        InjectionRules rules = new InjectionRules();
        rules.add((Object)this.createRule("body-begin", "Test"));
        String result = DesignerInjectionFilter.processContent((StringBuffer)INIT_BUFFER, (InjectionRules)rules);
        String DIFFERENCE = "\nTest\n<!-- mg#body#begin#marker -->";
        Assert.assertEquals((String)"Body tag have to start with \nTest\n<!-- mg#body#begin#marker -->", (Object)"<head>some text</head><body>\nTest\n<!-- mg#body#begin#marker -->body content</body>", (Object)result);
    }

    @Test
    public void testProcessContentBodyBeginTwice() throws Exception {
        InjectionRules rules = new InjectionRules();
        rules.add((Object)this.createRule("body-begin", "Test"));
        rules.add((Object)this.createRule("body-begin", "Second"));
        String result = DesignerInjectionFilter.processContent((StringBuffer)INIT_BUFFER, (InjectionRules)rules);
        String DIFFERENCE = "\nTest\nSecond\n<!-- mg#body#begin#marker -->";
        Assert.assertEquals((String)"Body tag have to start with \nTest\nSecond\n<!-- mg#body#begin#marker -->", (Object)"<head>some text</head><body>\nTest\nSecond\n<!-- mg#body#begin#marker -->body content</body>", (Object)result);
    }

    @Test
    public void testProcessContentBodyEnd() throws Exception {
        InjectionRules rules = new InjectionRules();
        rules.add((Object)this.createRule("body-end", "Test"));
        String result = DesignerInjectionFilter.processContent((StringBuffer)INIT_BUFFER, (InjectionRules)rules);
        String DIFFERENCE = "Test\n\n";
        Assert.assertEquals((String)"Body tag have to end with Test\n\n", (Object)"<head>some text</head><body>body contentTest\n\n</body>", (Object)result);
    }

    private InjectionRule createRule(String insertAt, String cdataValue) throws Exception {
        Document doc = this.createDocument();
        Element node = doc.getDocumentElement();
        node.setAttribute("insert-at", insertAt);
        node.appendChild(doc.createCDATASection(cdataValue));
        return new InjectionRule((Node)node, "/");
    }

    private Document createDocument() throws ParserConfigurationException, IOException, SAXException {
        DocumentBuilderFactory factory = DocumentBuilderFactory.newInstance();
        factory.setNamespaceAware(true);
        DocumentBuilder builder = factory.newDocumentBuilder();
        InputSource is = new InputSource(new StringReader(EMPTY_RULE_XML));
        return builder.parse(is);
    }
}

