/*
 * Decompiled with CFR 0.152.
 */
package org.jbpm.designer.web.server;

import java.util.HashMap;
import java.util.Map;
import javax.servlet.ServletConfig;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.jbpm.designer.helper.TestHttpServletRequest;
import org.jbpm.designer.helper.TestHttpServletResponse;
import org.jbpm.designer.helper.TestServletConfig;
import org.jbpm.designer.helper.TestServletContext;
import org.jbpm.designer.repository.Asset;
import org.jbpm.designer.repository.AssetBuilderFactory;
import org.jbpm.designer.repository.Filter;
import org.jbpm.designer.repository.Repository;
import org.jbpm.designer.repository.RepositoryBaseTest;
import org.jbpm.designer.repository.filters.FilterByExtension;
import org.jbpm.designer.repository.impl.AssetBuilder;
import org.jbpm.designer.repository.vfs.VFSRepository;
import org.jbpm.designer.web.profile.IDiagramProfile;
import org.jbpm.designer.web.server.JbpmServiceRepositoryServlet;
import org.json.JSONArray;
import org.json.JSONObject;
import org.junit.After;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;

public class JbpmServiceRepositoryServletTest
extends RepositoryBaseTest {
    private Repository repository;
    private String uniqueId;
    private Map<String, String> params;

    @Override
    @Before
    public void setup() {
        super.setup();
        this.repository = new VFSRepository(this.producer.getIoService());
        ((VFSRepository)this.repository).setDescriptor(this.descriptor);
        this.profile.setRepository(this.repository);
        AssetBuilder builder = AssetBuilderFactory.getAssetBuilder((Asset.AssetType)Asset.AssetType.Text);
        builder.content((Object)"bpmn2 content").type("bpmn2").name("samplebpmn2process").location("/defaultPackage");
        this.uniqueId = this.repository.createAsset(builder.getAsset());
        this.params = new HashMap<String, String>();
    }

    @Override
    @After
    public void teardown() {
        super.teardown();
    }

    @Test
    public void testDisplayRepoContent() throws Exception {
        this.params.put("repourl", this.getClass().getResource("servicerepo").toURI().toString());
        this.params.put("profile", "jbpm");
        this.params.put("action", "display");
        TestHttpServletResponse testResponse = new TestHttpServletResponse();
        JbpmServiceRepositoryServlet jbpmServiceRepositoryServlet = new JbpmServiceRepositoryServlet();
        jbpmServiceRepositoryServlet.setProfile((IDiagramProfile)this.profile);
        jbpmServiceRepositoryServlet.init((ServletConfig)new TestServletConfig(new TestServletContext(this.repository)));
        jbpmServiceRepositoryServlet.doPost((HttpServletRequest)new TestHttpServletRequest(this.params), (HttpServletResponse)testResponse);
        String response = new String(testResponse.getContent(), "UTF-8");
        Assert.assertNotNull((Object)response);
        JSONObject json = new JSONObject(response);
        Assert.assertNotNull((Object)json);
        Assert.assertEquals((long)4L, (long)json.length());
        JSONArray maArray = (JSONArray)json.get("MicrosoftAcademy");
        Assert.assertNotNull((Object)maArray);
        Assert.assertEquals((long)9L, (long)maArray.length());
        Assert.assertEquals((Object)"MicrosoftAcademy", (Object)maArray.get(0));
        JSONArray syArray = (JSONArray)json.get("SwitchYardService");
        Assert.assertNotNull((Object)syArray);
        Assert.assertEquals((long)9L, (long)syArray.length());
        Assert.assertEquals((Object)"SwitchYardService", (Object)syArray.get(0));
        JSONArray minimalisticArray = (JSONArray)json.get("Minimalistic");
        Assert.assertNotNull((Object)minimalisticArray);
        Assert.assertEquals((long)9L, (long)minimalisticArray.length());
        Assert.assertEquals((Object)"Minimalistic", (Object)minimalisticArray.get(0));
        JSONArray rsArray = (JSONArray)json.get("Rewardsystem");
        Assert.assertNotNull((Object)rsArray);
        Assert.assertEquals((long)9L, (long)rsArray.length());
        Assert.assertEquals((Object)"Rewardsystem", (Object)rsArray.get(0));
    }

    @Test
    public void testDisplayEmptyRepoContent() throws Exception {
        this.params.put("repourl", this.getClass().getResource("emptyservicerepo").toURI().toString());
        this.params.put("profile", "jbpm");
        this.params.put("action", "display");
        TestHttpServletResponse testResponse = new TestHttpServletResponse();
        JbpmServiceRepositoryServlet jbpmServiceRepositoryServlet = new JbpmServiceRepositoryServlet();
        jbpmServiceRepositoryServlet.setProfile((IDiagramProfile)this.profile);
        jbpmServiceRepositoryServlet.init((ServletConfig)new TestServletConfig(new TestServletContext(this.repository)));
        jbpmServiceRepositoryServlet.doPost((HttpServletRequest)new TestHttpServletRequest(this.params), (HttpServletResponse)testResponse);
        Assert.assertEquals((Object)"false", (Object)new String(testResponse.getContent()));
    }

    @Test
    public void testInstallWid() throws Exception {
        this.params.put("repourl", this.getClass().getResource("servicerepo").toURI().toString());
        this.params.put("asset", "Rewardsystem");
        this.params.put("profile", "jbpm");
        this.params.put("category", "Rewards");
        this.params.put("action", "install");
        this.params.put("uuid", this.uniqueId);
        JbpmServiceRepositoryServlet jbpmServiceRepositoryServlet = new JbpmServiceRepositoryServlet();
        jbpmServiceRepositoryServlet.setProfile((IDiagramProfile)this.profile);
        jbpmServiceRepositoryServlet.init((ServletConfig)new TestServletConfig(new TestServletContext(this.repository)));
        jbpmServiceRepositoryServlet.doPost((HttpServletRequest)new TestHttpServletRequest(this.params), (HttpServletResponse)new TestHttpServletResponse());
        Assert.assertEquals((long)1L, (long)this.repository.listAssetsRecursively("/", (Filter)new FilterByExtension("bpmn2")).size());
        Assert.assertEquals((long)1L, (long)this.repository.listAssetsRecursively("/", (Filter)new FilterByExtension("wid")).size());
        Assert.assertEquals((long)0L, (long)this.repository.listAssetsRecursively("/", (Filter)new FilterByExtension("png")).size());
    }

    @Test
    public void testInstallInvalidWid() throws Exception {
        this.params.put("repourl", this.getClass().getResource("servicerepo").toURI().toString());
        this.params.put("asset", "InvalidService");
        this.params.put("profile", "jbpm");
        this.params.put("category", "InvalidServiceCategory");
        this.params.put("action", "install");
        this.params.put("uuid", this.uniqueId);
        JbpmServiceRepositoryServlet jbpmServiceRepositoryServlet = new JbpmServiceRepositoryServlet();
        jbpmServiceRepositoryServlet.setProfile((IDiagramProfile)this.profile);
        jbpmServiceRepositoryServlet.init((ServletConfig)new TestServletConfig(new TestServletContext(this.repository)));
        jbpmServiceRepositoryServlet.doPost((HttpServletRequest)new TestHttpServletRequest(this.params), (HttpServletResponse)new TestHttpServletResponse());
        Assert.assertEquals((long)1L, (long)this.repository.listAssetsRecursively("/", (Filter)new FilterByExtension("bpmn2")).size());
        Assert.assertEquals((long)0L, (long)this.repository.listAssetsRecursively("/", (Filter)new FilterByExtension("wid")).size());
        Assert.assertEquals((long)0L, (long)this.repository.listAssetsRecursively("/", (Filter)new FilterByExtension("png")).size());
    }

    @Test
    public void testInstallWidTwice() throws Exception {
        this.params.put("repourl", this.getClass().getResource("servicerepo").toURI().toString());
        this.params.put("asset", "MicrosoftAcademy");
        this.params.put("profile", "jbpm");
        this.params.put("category", "Search");
        this.params.put("action", "install");
        this.params.put("uuid", this.uniqueId);
        JbpmServiceRepositoryServlet jbpmServiceRepositoryServlet = new JbpmServiceRepositoryServlet();
        jbpmServiceRepositoryServlet.setProfile((IDiagramProfile)this.profile);
        jbpmServiceRepositoryServlet.init((ServletConfig)new TestServletConfig(new TestServletContext(this.repository)));
        jbpmServiceRepositoryServlet.doPost((HttpServletRequest)new TestHttpServletRequest(this.params), (HttpServletResponse)new TestHttpServletResponse());
        jbpmServiceRepositoryServlet.doPost((HttpServletRequest)new TestHttpServletRequest(this.params), (HttpServletResponse)new TestHttpServletResponse());
        Assert.assertEquals((long)1L, (long)this.repository.listAssetsRecursively("/", (Filter)new FilterByExtension("bpmn2")).size());
        Assert.assertEquals((long)1L, (long)this.repository.listAssetsRecursively("/", (Filter)new FilterByExtension("wid")).size());
        Assert.assertEquals((long)1L, (long)this.repository.listAssetsRecursively("/", (Filter)new FilterByExtension("png")).size());
    }

    @Test
    public void testInstallWidEmptyRepository() throws Exception {
        this.params.put("repourl", this.getClass().getResource("emptyservicerepo").toURI().toString());
        this.params.put("asset", "MicrosoftAcademy");
        this.params.put("profile", "jbpm");
        this.params.put("category", "Search");
        this.params.put("action", "install");
        this.params.put("uuid", this.uniqueId);
        JbpmServiceRepositoryServlet jbpmServiceRepositoryServlet = new JbpmServiceRepositoryServlet();
        jbpmServiceRepositoryServlet.setProfile((IDiagramProfile)this.profile);
        jbpmServiceRepositoryServlet.init((ServletConfig)new TestServletConfig(new TestServletContext(this.repository)));
        TestHttpServletResponse response = new TestHttpServletResponse();
        jbpmServiceRepositoryServlet.doPost((HttpServletRequest)new TestHttpServletRequest(this.params), (HttpServletResponse)response);
        Assert.assertEquals((Object)"false", (Object)new String(response.getContent()));
    }
}

