/*
 * Decompiled with CFR 0.152.
 */
package org.jbpm.designer.repository.servlet;

import java.util.HashMap;
import javax.servlet.ServletConfig;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.jbpm.designer.helper.TestHttpServletRequest;
import org.jbpm.designer.helper.TestHttpServletResponse;
import org.jbpm.designer.helper.TestServletConfig;
import org.jbpm.designer.helper.TestServletContext;
import org.jbpm.designer.repository.Asset;
import org.jbpm.designer.repository.AssetBuilderFactory;
import org.jbpm.designer.repository.Repository;
import org.jbpm.designer.repository.RepositoryBaseTest;
import org.jbpm.designer.repository.impl.AssetBuilder;
import org.jbpm.designer.repository.servlet.AssetServiceServlet;
import org.jbpm.designer.repository.vfs.VFSRepository;
import org.jbpm.designer.web.profile.IDiagramProfile;
import org.json.JSONObject;
import org.junit.After;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;

public class AssetServiceServletTest
extends RepositoryBaseTest {
    @Override
    @Before
    public void setup() {
        super.setup();
    }

    @Override
    @After
    public void teardown() {
        super.teardown();
    }

    @Test
    public void testCreateAsset() throws Exception {
        VFSRepository repository = new VFSRepository(this.producer.getIoService());
        repository.setDescriptor(this.descriptor);
        this.profile.setRepository((Repository)repository);
        HashMap<String, String> params = new HashMap<String, String>();
        params.put("profile", "jbpm");
        params.put("action", "createasset");
        params.put("assettype", "bpmn2");
        params.put("assetname", "testprocess");
        params.put("assetlocation", "/defaultPackage");
        params.put("", "");
        boolean processAssetExists = repository.assetExists("/defaultPackage/testprocess.bpmn2");
        Assert.assertFalse((boolean)processAssetExists);
        AssetServiceServlet assetServiceServlet = new AssetServiceServlet();
        assetServiceServlet.setProfile((IDiagramProfile)this.profile);
        assetServiceServlet.init((ServletConfig)new TestServletConfig(new TestServletContext((Repository)repository)));
        TestHttpServletResponse response = new TestHttpServletResponse();
        assetServiceServlet.doPost((HttpServletRequest)new TestHttpServletRequest(params), (HttpServletResponse)response);
        String jsonResponse = new String(response.getContent());
        Assert.assertNotNull((Object)jsonResponse);
        processAssetExists = repository.assetExists("/defaultPackage/testprocess.bpmn2");
        Assert.assertTrue((boolean)processAssetExists);
    }

    @Test
    public void testMultiByteCommitMessageOnAssetUpdate() throws Exception {
        VFSRepository repository = new VFSRepository(this.producer.getIoService());
        repository.setDescriptor(this.descriptor);
        this.profile.setRepository((Repository)repository);
        AssetBuilder builder = AssetBuilderFactory.getAssetBuilder((Asset.AssetType)Asset.AssetType.Text);
        builder.content((Object)"custom editors content").type("bpmn2").name("testprocess").location("/defaultPackage");
        String id = repository.createAsset(builder.getAsset());
        HashMap<String, String> params = new HashMap<String, String>();
        params.put("profile", "jbpm");
        params.put("action", "updateasset");
        params.put("assetid", id);
        params.put("assetcontent", "testprocess");
        params.put("commitmessage", "\u3053\u3093\u306b\u3061\u306f\u4e16\u754c");
        boolean processAssetExists = repository.assetExists("/defaultPackage/testprocess.bpmn2");
        Assert.assertTrue((boolean)processAssetExists);
        AssetServiceServlet assetServiceServlet = new AssetServiceServlet();
        assetServiceServlet.setProfile((IDiagramProfile)this.profile);
        assetServiceServlet.init((ServletConfig)new TestServletConfig(new TestServletContext((Repository)repository)));
        TestHttpServletResponse response = new TestHttpServletResponse();
        assetServiceServlet.doPost((HttpServletRequest)new TestHttpServletRequest(params), (HttpServletResponse)response);
        String jsonResponse = new String(response.getContent());
        Assert.assertNotNull((Object)jsonResponse);
        JSONObject jsonObject = new JSONObject(jsonResponse);
        Assert.assertNotNull((Object)jsonObject);
        Assert.assertEquals((Object)"\u3053\u3093\u306b\u3061\u306f\u4e16\u754c", (Object)jsonObject.getString("commitMessage"));
    }

    @Test
    public void testUpdateAsset() throws Exception {
        VFSRepository repository = new VFSRepository(this.producer.getIoService());
        repository.setDescriptor(this.descriptor);
        this.profile.setRepository((Repository)repository);
        AssetBuilder builder = AssetBuilderFactory.getAssetBuilder((Asset.AssetType)Asset.AssetType.Text);
        builder.content((Object)"custom editors content").type("bpmn2").name("testprocess").location("/defaultPackage");
        String id = repository.createAsset(builder.getAsset());
        HashMap<String, String> params = new HashMap<String, String>();
        params.put("profile", "jbpm");
        params.put("action", "updateasset");
        params.put("assetid", id);
        params.put("assetcontent", "testprocess");
        params.put("", "");
        boolean processAssetExists = repository.assetExists("/defaultPackage/testprocess.bpmn2");
        Assert.assertTrue((boolean)processAssetExists);
        AssetServiceServlet assetServiceServlet = new AssetServiceServlet();
        assetServiceServlet.setProfile((IDiagramProfile)this.profile);
        assetServiceServlet.init((ServletConfig)new TestServletConfig(new TestServletContext((Repository)repository)));
        TestHttpServletResponse response = new TestHttpServletResponse();
        assetServiceServlet.doPost((HttpServletRequest)new TestHttpServletRequest(params), (HttpServletResponse)response);
        String jsonResponse = new String(response.getContent());
        Assert.assertNotNull((Object)jsonResponse);
        processAssetExists = repository.assetExists(id);
        Assert.assertTrue((boolean)processAssetExists);
    }

    @Test
    public void testDeleteAsset() throws Exception {
        VFSRepository repository = new VFSRepository(this.producer.getIoService());
        repository.setDescriptor(this.descriptor);
        this.profile.setRepository((Repository)repository);
        AssetBuilder builder = AssetBuilderFactory.getAssetBuilder((Asset.AssetType)Asset.AssetType.Text);
        builder.content((Object)"custom editors content").type("bpmn2").name("testprocess").location("/defaultPackage");
        String id = repository.createAsset(builder.getAsset());
        HashMap<String, String> params = new HashMap<String, String>();
        params.put("profile", "jbpm");
        params.put("action", "deleteasset");
        params.put("assetid", id);
        params.put("", "");
        boolean processAssetExists = repository.assetExists("/defaultPackage/testprocess.bpmn2");
        Assert.assertTrue((boolean)processAssetExists);
        AssetServiceServlet assetServiceServlet = new AssetServiceServlet();
        assetServiceServlet.setProfile((IDiagramProfile)this.profile);
        assetServiceServlet.init((ServletConfig)new TestServletConfig(new TestServletContext((Repository)repository)));
        TestHttpServletResponse response = new TestHttpServletResponse();
        assetServiceServlet.doPost((HttpServletRequest)new TestHttpServletRequest(params), (HttpServletResponse)response);
        String jsonResponse = new String(response.getContent());
        Assert.assertNotNull((Object)jsonResponse);
        processAssetExists = repository.assetExists(id);
        Assert.assertFalse((boolean)processAssetExists);
    }

    @Test
    public void testAssetExists() throws Exception {
        VFSRepository repository = new VFSRepository(this.producer.getIoService());
        repository.setDescriptor(this.descriptor);
        this.profile.setRepository((Repository)repository);
        AssetBuilder builder = AssetBuilderFactory.getAssetBuilder((Asset.AssetType)Asset.AssetType.Text);
        builder.content((Object)"custom editors content").type("bpmn2").name("testprocess").location("/defaultPackage");
        String id = repository.createAsset(builder.getAsset());
        HashMap<String, String> params = new HashMap<String, String>();
        params.put("profile", "jbpm");
        params.put("action", "existsasset");
        params.put("assetid", id);
        params.put("", "");
        boolean processAssetExists = repository.assetExists("/defaultPackage/testprocess.bpmn2");
        Assert.assertTrue((boolean)processAssetExists);
        AssetServiceServlet assetServiceServlet = new AssetServiceServlet();
        assetServiceServlet.setProfile((IDiagramProfile)this.profile);
        assetServiceServlet.init((ServletConfig)new TestServletConfig(new TestServletContext((Repository)repository)));
        TestHttpServletResponse response = new TestHttpServletResponse();
        assetServiceServlet.doPost((HttpServletRequest)new TestHttpServletRequest(params), (HttpServletResponse)response);
        String jsonResponse = new String(response.getContent());
        this.assertJsonContains(jsonResponse, "\"answer\":\"true\"");
    }

    @Test
    public void testAssetDoesnotExists() throws Exception {
        VFSRepository repository = new VFSRepository(this.producer.getIoService());
        repository.setDescriptor(this.descriptor);
        this.profile.setRepository((Repository)repository);
        HashMap<String, String> params = new HashMap<String, String>();
        params.put("profile", "jbpm");
        params.put("action", "existsasset");
        params.put("assetid", "/defaultPackage/nonexistingprocess.bpmn2");
        params.put("", "");
        AssetServiceServlet assetServiceServlet = new AssetServiceServlet();
        assetServiceServlet.setProfile((IDiagramProfile)this.profile);
        assetServiceServlet.init((ServletConfig)new TestServletConfig(new TestServletContext((Repository)repository)));
        TestHttpServletResponse response = new TestHttpServletResponse();
        assetServiceServlet.doPost((HttpServletRequest)new TestHttpServletRequest(params), (HttpServletResponse)response);
        String jsonResponse = new String(response.getContent());
        this.assertJsonContains(jsonResponse, "\"answer\":\"false\"");
    }

    @Test
    public void testCreateDirectory() throws Exception {
        VFSRepository repository = new VFSRepository(this.producer.getIoService());
        repository.setDescriptor(this.descriptor);
        this.profile.setRepository((Repository)repository);
        HashMap<String, String> params = new HashMap<String, String>();
        params.put("profile", "jbpm");
        params.put("action", "createdir");
        params.put("assetlocation", "/defaultPackage");
        params.put("", "");
        boolean directoryExits = repository.directoryExists("/defaultPackage");
        Assert.assertFalse((boolean)directoryExits);
        AssetServiceServlet assetServiceServlet = new AssetServiceServlet();
        assetServiceServlet.setProfile((IDiagramProfile)this.profile);
        assetServiceServlet.init((ServletConfig)new TestServletConfig(new TestServletContext((Repository)repository)));
        TestHttpServletResponse response = new TestHttpServletResponse();
        assetServiceServlet.doPost((HttpServletRequest)new TestHttpServletRequest(params), (HttpServletResponse)response);
        String jsonResponse = new String(response.getContent());
        Assert.assertNotNull((Object)jsonResponse);
        directoryExits = repository.directoryExists("/defaultPackage");
        Assert.assertTrue((boolean)directoryExits);
    }

    @Test
    public void testDeleteDirectory() throws Exception {
        VFSRepository repository = new VFSRepository(this.producer.getIoService());
        repository.setDescriptor(this.descriptor);
        this.profile.setRepository((Repository)repository);
        repository.createDirectory("/defaultPackage");
        HashMap<String, String> params = new HashMap<String, String>();
        params.put("profile", "jbpm");
        params.put("action", "deletedir");
        params.put("assetlocation", "/defaultPackage");
        params.put("", "");
        boolean directoryExits = repository.directoryExists("/defaultPackage");
        Assert.assertTrue((boolean)directoryExits);
        AssetServiceServlet assetServiceServlet = new AssetServiceServlet();
        assetServiceServlet.setProfile((IDiagramProfile)this.profile);
        assetServiceServlet.init((ServletConfig)new TestServletConfig(new TestServletContext((Repository)repository)));
        TestHttpServletResponse response = new TestHttpServletResponse();
        assetServiceServlet.doPost((HttpServletRequest)new TestHttpServletRequest(params), (HttpServletResponse)response);
        String jsonResponse = new String(response.getContent());
        Assert.assertNotNull((Object)jsonResponse);
        directoryExits = repository.directoryExists("/defaultPackage");
        Assert.assertFalse((boolean)directoryExits);
    }

    @Test
    public void testDirectoryExists() throws Exception {
        VFSRepository repository = new VFSRepository(this.producer.getIoService());
        repository.setDescriptor(this.descriptor);
        this.profile.setRepository((Repository)repository);
        repository.createDirectory("/defaultPackage");
        HashMap<String, String> params = new HashMap<String, String>();
        params.put("profile", "jbpm");
        params.put("action", "existsdir");
        params.put("assetlocation", "/defaultPackage");
        params.put("", "");
        boolean directoryExits = repository.directoryExists("/defaultPackage");
        Assert.assertTrue((boolean)directoryExits);
        AssetServiceServlet assetServiceServlet = new AssetServiceServlet();
        assetServiceServlet.setProfile((IDiagramProfile)this.profile);
        assetServiceServlet.init((ServletConfig)new TestServletConfig(new TestServletContext((Repository)repository)));
        TestHttpServletResponse response = new TestHttpServletResponse();
        assetServiceServlet.doPost((HttpServletRequest)new TestHttpServletRequest(params), (HttpServletResponse)response);
        String jsonResponse = new String(response.getContent());
        this.assertJsonContains(jsonResponse, "\"answer\":\"true\"");
    }

    @Test
    public void testDirectoryDoesNotExist() throws Exception {
        VFSRepository repository = new VFSRepository(this.producer.getIoService());
        repository.setDescriptor(this.descriptor);
        this.profile.setRepository((Repository)repository);
        HashMap<String, String> params = new HashMap<String, String>();
        params.put("profile", "jbpm");
        params.put("action", "existsdir");
        params.put("assetlocation", "/defaultPackage");
        params.put("", "");
        boolean directoryExits = repository.directoryExists("/defaultPackage");
        Assert.assertFalse((boolean)directoryExits);
        AssetServiceServlet assetServiceServlet = new AssetServiceServlet();
        assetServiceServlet.setProfile((IDiagramProfile)this.profile);
        assetServiceServlet.init((ServletConfig)new TestServletConfig(new TestServletContext((Repository)repository)));
        TestHttpServletResponse response = new TestHttpServletResponse();
        assetServiceServlet.doPost((HttpServletRequest)new TestHttpServletRequest(params), (HttpServletResponse)response);
        String jsonResponse = new String(response.getContent());
        this.assertJsonContains(jsonResponse, "\"answer\":\"false\"");
    }

    @Test
    public void testListDirectories() throws Exception {
        VFSRepository repository = new VFSRepository(this.producer.getIoService());
        repository.setDescriptor(this.descriptor);
        this.profile.setRepository((Repository)repository);
        repository.createDirectory("/defaultPackage");
        HashMap<String, String> params = new HashMap<String, String>();
        params.put("profile", "jbpm");
        params.put("action", "listdirs");
        params.put("assetlocation", "/");
        params.put("", "");
        AssetServiceServlet assetServiceServlet = new AssetServiceServlet();
        assetServiceServlet.setProfile((IDiagramProfile)this.profile);
        assetServiceServlet.init((ServletConfig)new TestServletConfig(new TestServletContext((Repository)repository)));
        TestHttpServletResponse response = new TestHttpServletResponse();
        assetServiceServlet.doPost((HttpServletRequest)new TestHttpServletRequest(params), (HttpServletResponse)response);
        String jsonResponse = new String(response.getContent());
        this.assertJsonContains(jsonResponse, "\"answer\":[{\"name\":\"defaultPackage\"}]");
    }

    @Test
    public void testListAssets() throws Exception {
        VFSRepository repository = new VFSRepository(this.producer.getIoService());
        repository.setDescriptor(this.descriptor);
        this.profile.setRepository((Repository)repository);
        AssetBuilder builder = AssetBuilderFactory.getAssetBuilder((Asset.AssetType)Asset.AssetType.Text);
        builder.content((Object)"custom editors content").type("bpmn2").name("testprocess").location("/defaultPackage");
        String id = repository.createAsset(builder.getAsset());
        HashMap<String, String> params = new HashMap<String, String>();
        params.put("profile", "jbpm");
        params.put("action", "listassets");
        params.put("assetlocation", "/defaultPackage");
        params.put("", "");
        boolean directoryExits = repository.directoryExists("/defaultPackage");
        Assert.assertTrue((boolean)directoryExits);
        AssetServiceServlet assetServiceServlet = new AssetServiceServlet();
        assetServiceServlet.setProfile((IDiagramProfile)this.profile);
        assetServiceServlet.init((ServletConfig)new TestServletConfig(new TestServletContext((Repository)repository)));
        TestHttpServletResponse response = new TestHttpServletResponse();
        assetServiceServlet.doPost((HttpServletRequest)new TestHttpServletRequest(params), (HttpServletResponse)response);
        String jsonResponse = new String(response.getContent());
        Assert.assertNotNull((Object)jsonResponse);
        this.assertJsonContains(jsonResponse, "\"location\":\"/defaultPackage\"");
        this.assertJsonContains(jsonResponse, "\"description\":\"\"");
        this.assertJsonContains(jsonResponse, "\"name\":\"testprocess\"");
        this.assertJsonContains(jsonResponse, "\"owner\":\"\"");
        this.assertJsonContains(jsonResponse, "\"type\":\"bpmn2\"");
        this.assertJsonContains(jsonResponse, "\"fullname\":\"testprocess.bpmn2\"");
    }

    @Test
    public void testGetAssetSourceById() throws Exception {
        VFSRepository repository = new VFSRepository(this.producer.getIoService());
        repository.setDescriptor(this.descriptor);
        this.profile.setRepository((Repository)repository);
        AssetBuilder builder = AssetBuilderFactory.getAssetBuilder((Asset.AssetType)Asset.AssetType.Text);
        builder.content((Object)"custom editors content").type("bpmn2").name("testprocess").location("/defaultPackage");
        String id = repository.createAsset(builder.getAsset());
        HashMap<String, String> params = new HashMap<String, String>();
        params.put("profile", "jbpm");
        params.put("action", "getassetsource");
        params.put("assetid", id);
        params.put("loadoption", "optionbyid");
        boolean assetExists = repository.assetExists(id);
        Assert.assertTrue((boolean)assetExists);
        AssetServiceServlet assetServiceServlet = new AssetServiceServlet();
        assetServiceServlet.setProfile((IDiagramProfile)this.profile);
        assetServiceServlet.init((ServletConfig)new TestServletConfig(new TestServletContext((Repository)repository)));
        TestHttpServletResponse response = new TestHttpServletResponse();
        assetServiceServlet.doPost((HttpServletRequest)new TestHttpServletRequest(params), (HttpServletResponse)response);
        String jsonResponse = new String(response.getContent());
        Assert.assertNotNull((Object)jsonResponse);
        Assert.assertEquals((Object)jsonResponse, (Object)"custom editors content");
    }

    @Test
    public void testGetAssetSourceByPath() throws Exception {
        VFSRepository repository = new VFSRepository(this.producer.getIoService());
        repository.setDescriptor(this.descriptor);
        this.profile.setRepository((Repository)repository);
        AssetBuilder builder = AssetBuilderFactory.getAssetBuilder((Asset.AssetType)Asset.AssetType.Text);
        builder.content((Object)"custom editors content").type("bpmn2").name("testprocess").location("/defaultPackage");
        String id = repository.createAsset(builder.getAsset());
        HashMap<String, String> params = new HashMap<String, String>();
        params.put("profile", "jbpm");
        params.put("action", "getassetsource");
        params.put("assetlocation", "/defaultPackage/testprocess.bpmn2");
        params.put("loadoption", "optionbypath");
        boolean assetExists = repository.assetExists(id);
        Assert.assertTrue((boolean)assetExists);
        AssetServiceServlet assetServiceServlet = new AssetServiceServlet();
        assetServiceServlet.setProfile((IDiagramProfile)this.profile);
        assetServiceServlet.init((ServletConfig)new TestServletConfig(new TestServletContext((Repository)repository)));
        TestHttpServletResponse response = new TestHttpServletResponse();
        assetServiceServlet.doPost((HttpServletRequest)new TestHttpServletRequest(params), (HttpServletResponse)response);
        String jsonResponse = new String(response.getContent());
        Assert.assertEquals((Object)jsonResponse, (Object)"custom editors content");
    }

    @Test
    public void testGetAssetInfoById() throws Exception {
        VFSRepository repository = new VFSRepository(this.producer.getIoService());
        repository.setDescriptor(this.descriptor);
        this.profile.setRepository((Repository)repository);
        AssetBuilder builder = AssetBuilderFactory.getAssetBuilder((Asset.AssetType)Asset.AssetType.Text);
        builder.content((Object)"custom editors content").type("bpmn2").name("testprocess").location("/defaultPackage");
        String id = repository.createAsset(builder.getAsset());
        HashMap<String, String> params = new HashMap<String, String>();
        params.put("profile", "jbpm");
        params.put("action", "getassetinfo");
        params.put("assetid", id);
        params.put("loadoption", "optionbyid");
        boolean assetExists = repository.assetExists(id);
        Assert.assertTrue((boolean)assetExists);
        AssetServiceServlet assetServiceServlet = new AssetServiceServlet();
        assetServiceServlet.setProfile((IDiagramProfile)this.profile);
        assetServiceServlet.init((ServletConfig)new TestServletConfig(new TestServletContext((Repository)repository)));
        TestHttpServletResponse response = new TestHttpServletResponse();
        assetServiceServlet.doPost((HttpServletRequest)new TestHttpServletRequest(params), (HttpServletResponse)response);
        String jsonResponse = new String(response.getContent());
        this.assertJsonContains(jsonResponse, "\"location\":\"/defaultPackage\"");
        this.assertJsonContains(jsonResponse, "\"description\":\"\"");
        this.assertJsonContains(jsonResponse, "\"name\":\"testprocess\"");
        this.assertJsonContains(jsonResponse, "\"owner\":\"\"");
        this.assertJsonContains(jsonResponse, "\"type\":\"bpmn2\"");
        this.assertJsonContains(jsonResponse, "\"fullname\":\"testprocess.bpmn2\"");
    }

    @Test
    public void testGetAssetInfoByPath() throws Exception {
        VFSRepository repository = new VFSRepository(this.producer.getIoService());
        repository.setDescriptor(this.descriptor);
        this.profile.setRepository((Repository)repository);
        AssetBuilder builder = AssetBuilderFactory.getAssetBuilder((Asset.AssetType)Asset.AssetType.Text);
        builder.content((Object)"custom editors content").type("bpmn2").name("testprocess").location("/defaultPackage");
        String id = repository.createAsset(builder.getAsset());
        HashMap<String, String> params = new HashMap<String, String>();
        params.put("profile", "jbpm");
        params.put("action", "getassetinfo");
        params.put("assetlocation", "/defaultPackage/testprocess.bpmn2");
        params.put("loadoption", "optionbypath");
        boolean assetExists = repository.assetExists(id);
        Assert.assertTrue((boolean)assetExists);
        AssetServiceServlet assetServiceServlet = new AssetServiceServlet();
        assetServiceServlet.setProfile((IDiagramProfile)this.profile);
        assetServiceServlet.init((ServletConfig)new TestServletConfig(new TestServletContext((Repository)repository)));
        TestHttpServletResponse response = new TestHttpServletResponse();
        assetServiceServlet.doPost((HttpServletRequest)new TestHttpServletRequest(params), (HttpServletResponse)response);
        String jsonResponse = new String(response.getContent());
        this.assertJsonContains(jsonResponse, "\"location\":\"/defaultPackage\"");
        this.assertJsonContains(jsonResponse, "\"description\":\"\"");
        this.assertJsonContains(jsonResponse, "\"name\":\"testprocess\"");
        this.assertJsonContains(jsonResponse, "\"owner\":\"\"");
        this.assertJsonContains(jsonResponse, "\"type\":\"bpmn2\"");
        this.assertJsonContains(jsonResponse, "\"fullname\":\"testprocess.bpmn2\"");
    }

    private void assertJsonContains(String json, String expected) {
        Assert.assertNotNull((String)"No JSON string specified!", (Object)json);
        Assert.assertTrue((String)("Expected substring '" + expected + "' not found in JSON string '" + json + "'!"), (boolean)json.contains(expected));
    }
}

