/*
 * Decompiled with CFR 0.152.
 */
package org.jbpm.designer.web.server;

import java.io.IOException;
import java.io.PrintWriter;
import javax.inject.Inject;
import javax.servlet.ServletConfig;
import javax.servlet.ServletContext;
import javax.servlet.ServletException;
import javax.servlet.annotation.WebServlet;
import javax.servlet.http.HttpServlet;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.jbpm.designer.expressioneditor.server.ExpressionEditorProcessor;
import org.jbpm.designer.repository.Asset;
import org.jbpm.designer.repository.Repository;
import org.jbpm.designer.util.Utils;
import org.jbpm.designer.web.profile.IDiagramProfile;
import org.jbpm.designer.web.profile.IDiagramProfileService;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@WebServlet(displayName="CustomEditors", name="CustomEditorsServlet", urlPatterns={"/customeditors"})
public class CustomEditorsServlet
extends HttpServlet {
    private static final long serialVersionUID = 1L;
    private static final Logger _logger = LoggerFactory.getLogger(CustomEditorsServlet.class);
    public static final String CUSTOMEDITORS_NAME = "customeditors";
    private IDiagramProfile profile;
    @Inject
    private IDiagramProfileService _profileService = null;

    public void setProfile(IDiagramProfile profile) {
        this.profile = profile;
    }

    public void init(ServletConfig config) throws ServletException {
        super.init(config);
    }

    protected void doPost(HttpServletRequest req, HttpServletResponse resp) throws ServletException, IOException {
        String profileName = Utils.getDefaultProfileName(req.getParameter("profile"));
        String uuid = Utils.getUUID(req);
        if (this.isExpressionEditorRequest(req)) {
            ExpressionEditorProcessor expressionEditorProcessor = new ExpressionEditorProcessor();
            expressionEditorProcessor.doProcess(req, resp);
        } else {
            if (this.profile == null) {
                this.profile = this._profileService.findProfile(req, profileName);
            }
            String customEditorsJSON = this.getCustomEditorsJSON(this.profile, this.getServletContext(), uuid);
            PrintWriter pw = resp.getWriter();
            resp.setContentType("text/plain");
            resp.setCharacterEncoding("UTF-8");
            pw.write(customEditorsJSON);
        }
    }

    private String getCustomEditorsJSON(IDiagramProfile profile, ServletContext servletContext, String uuid) {
        String retStr = "";
        Repository repository = profile.getRepository();
        try {
            Asset customEditorAsset = repository.loadAssetFromPath(profile.getRepositoryGlobalDir(uuid) + "/" + CUSTOMEDITORS_NAME + ".json");
            retStr = (String)customEditorAsset.getAssetContent();
        }
        catch (Exception e) {
            _logger.error("Error retriving custom editors info: " + e.getMessage());
        }
        return retStr;
    }

    private boolean isExpressionEditorRequest(HttpServletRequest req) {
        return req.getParameter("expression_editor_command") != null && req.getParameter("expression_editor_message") != null;
    }
}

