/*
 * Decompiled with CFR 0.152.
 */
package org.jbpm.designer.web.server;

import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import junit.framework.Assert;
import org.jbpm.designer.repository.RepositoryBaseTest;
import org.jbpm.designer.web.profile.IDiagramProfileService;
import org.jbpm.designer.web.server.CalledElementServlet;
import org.junit.After;
import org.junit.Before;
import org.junit.Test;
import org.junit.runner.RunWith;
import org.kie.soup.project.datamodel.oracle.FieldAccessorsAndMutators;
import org.kie.soup.project.datamodel.oracle.ModelField;
import org.kie.soup.project.datamodel.oracle.PackageDataModelOracle;
import org.mockito.InjectMocks;
import org.mockito.Matchers;
import org.mockito.Mock;
import org.mockito.Mockito;
import org.mockito.Spy;
import org.mockito.runners.MockitoJUnitRunner;
import org.mockito.verification.VerificationMode;

@RunWith(value=MockitoJUnitRunner.class)
public class CalledElementServletTest
extends RepositoryBaseTest {
    @Mock
    IDiagramProfileService profileService;
    @Spy
    @InjectMocks
    private CalledElementServlet servlet = new CalledElementServlet();

    @Override
    @Before
    public void setup() {
        super.setup();
        Mockito.when((Object)this.profileService.findProfile((HttpServletRequest)Matchers.any(HttpServletRequest.class), Matchers.anyString())).thenReturn((Object)this.profile);
    }

    @Override
    @After
    public void teardown() {
        super.teardown();
    }

    @Test
    public void testDoPostFindProfile() throws Exception {
        HttpServletRequest request = (HttpServletRequest)Mockito.mock(HttpServletRequest.class);
        try {
            this.servlet.doPost(request, (HttpServletResponse)Mockito.mock(HttpServletResponse.class));
        }
        catch (Exception exception) {
            // empty catch block
        }
        ((IDiagramProfileService)Mockito.verify((Object)this.profileService, (VerificationMode)Mockito.times((int)1))).findProfile(request, "jbpm");
    }

    @Test
    public void testDoPostProfileAlreadySet() throws Exception {
        HttpServletRequest request = (HttpServletRequest)Mockito.mock(HttpServletRequest.class);
        this.servlet.profile = this.profile;
        try {
            this.servlet.doPost(request, (HttpServletResponse)Mockito.mock(HttpServletResponse.class));
        }
        catch (Exception exception) {
            // empty catch block
        }
        ((IDiagramProfileService)Mockito.verify((Object)this.profileService, (VerificationMode)Mockito.never())).findProfile((HttpServletRequest)Matchers.any(HttpServletRequest.class), Matchers.anyString());
    }

    @Test
    public void testGetJavaTypeNames() throws Exception {
        PackageDataModelOracle oracle = (PackageDataModelOracle)Mockito.mock(PackageDataModelOracle.class);
        Mockito.when((Object)oracle.getProjectPackageNames()).thenReturn(Arrays.asList("org"));
        ModelField[] modelFields = new ModelField[]{new ModelField("this", "org.Address", ModelField.FIELD_CLASS_TYPE.REGULAR_CLASS, ModelField.FIELD_ORIGIN.SELF, FieldAccessorsAndMutators.ACCESSOR, "this"), new ModelField("street", String.class.getName(), ModelField.FIELD_CLASS_TYPE.REGULAR_CLASS, ModelField.FIELD_ORIGIN.DECLARED, FieldAccessorsAndMutators.BOTH, "String"), new ModelField("homeAddress", Boolean.class.getName(), ModelField.FIELD_CLASS_TYPE.REGULAR_CLASS, ModelField.FIELD_ORIGIN.DECLARED, FieldAccessorsAndMutators.BOTH, "Boolean"), new ModelField("number", Integer.class.getName(), ModelField.FIELD_CLASS_TYPE.REGULAR_CLASS, ModelField.FIELD_ORIGIN.DECLARED, FieldAccessorsAndMutators.BOTH, "Integer")};
        HashMap<String, ModelField[]> fields = new HashMap<String, ModelField[]>();
        fields.put("org.Address", modelFields);
        Mockito.when((Object)oracle.getProjectModelFields()).thenReturn(fields);
        CalledElementServlet servlet = new CalledElementServlet();
        List javatypeNameList = servlet.getJavaTypeNames(oracle);
        Assert.assertNotNull((Object)javatypeNameList);
        Assert.assertEquals((int)1, (int)javatypeNameList.size());
        Assert.assertEquals((String)"org.Address", (String)((String)javatypeNameList.get(0)));
    }
}

