/*
 * Decompiled with CFR 0.152.
 */
package org.jbpm.designer.repository;

import java.net.URI;
import java.util.HashMap;
import java.util.Map;
import org.jbpm.designer.repository.vfs.RepositoryDescriptor;
import org.uberfire.io.IOService;
import org.uberfire.io.impl.IOServiceDotFileImpl;
import org.uberfire.java.nio.file.FileSystem;
import org.uberfire.java.nio.file.FileSystemAlreadyExistsException;
import org.uberfire.java.nio.file.Path;

public class VFSFileSystemProducer {
    private IOService ioService = new IOServiceDotFileImpl();

    public RepositoryDescriptor produceFileSystem(Map<String, String> env) {
        FileSystem fileSystem;
        URI repositoryRoot = URI.create(env.get("repository.root"));
        try {
            fileSystem = this.ioService.newFileSystem(repositoryRoot, env);
        }
        catch (FileSystemAlreadyExistsException e) {
            fileSystem = this.ioService.getFileSystem(repositoryRoot);
        }
        String fetchCommand = env.get("fetch.cmd");
        if (fetchCommand != null) {
            fileSystem = this.ioService.getFileSystem(URI.create(env.get("repository.root") + fetchCommand));
        }
        HashMap<String, String> map = new HashMap<String, String>();
        map.put(env.get("repository.root"), "designer-repo");
        Path rootPath = fileSystem.provider().getPath(repositoryRoot);
        return new RepositoryDescriptor(repositoryRoot, fileSystem, rootPath);
    }

    public IOService getIoService() {
        return this.ioService;
    }
}

