/*
 * Decompiled with CFR 0.152.
 */
package org.jbpm.designer.server.service;

import java.io.ByteArrayInputStream;
import java.io.UnsupportedEncodingException;
import java.net.URI;
import java.util.Arrays;
import java.util.HashMap;
import java.util.Map;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.xpath.XPath;
import javax.xml.xpath.XPathConstants;
import javax.xml.xpath.XPathExpression;
import javax.xml.xpath.XPathFactory;
import org.apache.commons.codec.binary.Base64;
import org.guvnor.common.services.backend.metadata.MetadataServerSideService;
import org.guvnor.common.services.shared.metadata.model.Metadata;
import org.jbpm.designer.repository.Asset;
import org.jbpm.designer.repository.Directory;
import org.jbpm.designer.repository.Repository;
import org.jbpm.designer.repository.RepositoryBaseTest;
import org.jbpm.designer.repository.UriUtils;
import org.jbpm.designer.repository.vfs.VFSRepository;
import org.jbpm.designer.server.service.DefaultDesignerAssetService;
import org.junit.After;
import org.junit.AfterClass;
import org.junit.Assert;
import org.junit.Before;
import org.junit.BeforeClass;
import org.junit.Test;
import org.junit.runner.RunWith;
import org.mockito.ArgumentCaptor;
import org.mockito.InjectMocks;
import org.mockito.Matchers;
import org.mockito.Mock;
import org.mockito.Mockito;
import org.mockito.runners.MockitoJUnitRunner;
import org.mockito.verification.VerificationMode;
import org.uberfire.backend.server.util.Paths;
import org.uberfire.io.IOService;
import org.uberfire.java.nio.file.DirectoryStream;
import org.uberfire.java.nio.file.Path;
import org.w3c.dom.Document;
import org.w3c.dom.Element;

@RunWith(value=MockitoJUnitRunner.class)
public class DefaultDesignerAssetServiceTest
extends RepositoryBaseTest {
    @Mock
    private IOService ioService;
    @Mock
    MetadataServerSideService metadataService;
    @InjectMocks
    DefaultDesignerAssetService service;
    @Mock
    private Repository repository;
    private XPath xpath = XPathFactory.newInstance().newXPath();

    @BeforeClass
    public static void setupOnce() {
        System.setProperty("org.uberfire.nio.git.daemon.enabled", "false");
        System.setProperty("org.uberfire.nio.git.ssh.enabled", "false");
    }

    @AfterClass
    public static void cleanOnce() {
        System.clearProperty("org.uberfire.nio.git.daemon.enabled");
        System.clearProperty("org.uberfire.nio.git.ssh.enabled");
    }

    @Override
    @Before
    public void setup() {
        super.setup();
    }

    @Override
    @After
    public void teardown() {
        super.teardown();
    }

    @Test
    public void testUpdateMetaData() throws Exception {
        VFSRepository repository = new VFSRepository(this.producer.getIoService());
        repository.setDescriptor(this.descriptor);
        Directory testProjectDir = repository.createDirectory("/mytestproject");
        org.uberfire.backend.vfs.Path path = Paths.convert((Path)this.producer.getIoService().get(URI.create(this.decodeUniqueId(testProjectDir.getUniqueId()))));
        Metadata metadata = new Metadata();
        HashMap map = new HashMap();
        Mockito.when((Object)this.metadataService.setUpAttributes(path, metadata)).thenReturn(map);
        this.service.updateMetadata(path, metadata);
        ((IOService)Mockito.verify((Object)this.ioService)).setAttributes((Path)Matchers.any(Path.class), (Map)Matchers.eq(map));
    }

    @Test
    public void testCreateProcessWithDefaultPackage() throws Exception {
        org.uberfire.backend.vfs.Path pathSource = (org.uberfire.backend.vfs.Path)Mockito.mock(org.uberfire.backend.vfs.Path.class);
        Mockito.when((Object)pathSource.toURI()).thenReturn((Object)"file://p0/Evaluation/src/main/resources");
        DefaultDesignerAssetService assetService = new DefaultDesignerAssetService();
        assetService.setRepository(this.repository);
        ArgumentCaptor assetArgumentCaptor = ArgumentCaptor.forClass(Asset.class);
        assetService.createProcess(pathSource, "MyProcess.bpmn2");
        ((Repository)Mockito.verify((Object)this.repository, (VerificationMode)Mockito.times((int)1))).createAsset((Asset)assetArgumentCaptor.capture());
        Asset asset = (Asset)assetArgumentCaptor.getValue();
        Assert.assertNotNull((Object)asset);
        Assert.assertNotNull((Object)asset.getAssetContent());
        Element element = this.getProcessElementFromXml((String)asset.getAssetContent());
        Assert.assertNotNull((Object)element);
        String processId = element.getAttribute("id");
        Assert.assertNotNull((Object)processId);
        Assert.assertEquals((Object)"Evaluation.MyProcess", (Object)processId);
        String packageName = element.getAttribute("drools:packageName");
        Assert.assertNotNull((Object)packageName);
        Assert.assertEquals((Object)"", (Object)packageName);
    }

    @Test
    public void testCreateProcessWithDefaultPackageNoProject() throws Exception {
        org.uberfire.backend.vfs.Path pathSource = (org.uberfire.backend.vfs.Path)Mockito.mock(org.uberfire.backend.vfs.Path.class);
        Mockito.when((Object)pathSource.toURI()).thenReturn((Object)"file://p0/src/main");
        DefaultDesignerAssetService assetService = new DefaultDesignerAssetService();
        assetService.setRepository(this.repository);
        ArgumentCaptor assetArgumentCaptor = ArgumentCaptor.forClass(Asset.class);
        assetService.createProcess(pathSource, "MyProcess.bpmn2");
        ((Repository)Mockito.verify((Object)this.repository, (VerificationMode)Mockito.times((int)1))).createAsset((Asset)assetArgumentCaptor.capture());
        Asset asset = (Asset)assetArgumentCaptor.getValue();
        Assert.assertNotNull((Object)asset);
        Assert.assertNotNull((Object)asset.getAssetContent());
        Element element = this.getProcessElementFromXml((String)asset.getAssetContent());
        Assert.assertNotNull((Object)element);
        String processId = element.getAttribute("id");
        Assert.assertNotNull((Object)processId);
        Assert.assertEquals((Object)"MyProcess", (Object)processId);
        String packageName = element.getAttribute("drools:packageName");
        Assert.assertNotNull((Object)packageName);
        Assert.assertEquals((Object)"", (Object)packageName);
    }

    @Test
    public void testCreateProcessWithSingleLevelPackage() throws Exception {
        org.uberfire.backend.vfs.Path pathSource = (org.uberfire.backend.vfs.Path)Mockito.mock(org.uberfire.backend.vfs.Path.class);
        Mockito.when((Object)pathSource.toURI()).thenReturn((Object)"file://p0/Evaluation/src/main/resources/org");
        DefaultDesignerAssetService assetService = new DefaultDesignerAssetService();
        assetService.setRepository(this.repository);
        ArgumentCaptor assetArgumentCaptor = ArgumentCaptor.forClass(Asset.class);
        assetService.createProcess(pathSource, "MyProcess.bpmn2");
        ((Repository)Mockito.verify((Object)this.repository, (VerificationMode)Mockito.times((int)1))).createAsset((Asset)assetArgumentCaptor.capture());
        Asset asset = (Asset)assetArgumentCaptor.getValue();
        Assert.assertNotNull((Object)asset);
        Assert.assertNotNull((Object)asset.getAssetContent());
        Element element = this.getProcessElementFromXml((String)asset.getAssetContent());
        Assert.assertNotNull((Object)element);
        String processId = element.getAttribute("id");
        Assert.assertNotNull((Object)processId);
        Assert.assertEquals((Object)"Evaluation.org.MyProcess", (Object)processId);
        String packageName = element.getAttribute("drools:packageName");
        Assert.assertNotNull((Object)packageName);
        Assert.assertEquals((Object)"org", (Object)packageName);
    }

    @Test
    public void testCreateProcessWithMultiLevelPackage() throws Exception {
        org.uberfire.backend.vfs.Path pathSource = (org.uberfire.backend.vfs.Path)Mockito.mock(org.uberfire.backend.vfs.Path.class);
        Mockito.when((Object)pathSource.toURI()).thenReturn((Object)"file://p0/Evaluation/src/main/resources/org/jbpm/test/process");
        DefaultDesignerAssetService assetService = new DefaultDesignerAssetService();
        assetService.setRepository(this.repository);
        ArgumentCaptor assetArgumentCaptor = ArgumentCaptor.forClass(Asset.class);
        assetService.createProcess(pathSource, "MyProcess.bpmn2");
        ((Repository)Mockito.verify((Object)this.repository, (VerificationMode)Mockito.times((int)1))).createAsset((Asset)assetArgumentCaptor.capture());
        Asset asset = (Asset)assetArgumentCaptor.getValue();
        Assert.assertNotNull((Object)asset);
        Assert.assertNotNull((Object)asset.getAssetContent());
        Element element = this.getProcessElementFromXml((String)asset.getAssetContent());
        Assert.assertNotNull((Object)element);
        String processId = element.getAttribute("id");
        Assert.assertNotNull((Object)processId);
        Assert.assertEquals((Object)"Evaluation.org.jbpm.test.process.MyProcess", (Object)processId);
        String packageName = element.getAttribute("drools:packageName");
        Assert.assertNotNull((Object)packageName);
        Assert.assertEquals((Object)"org.jbpm.test.process", (Object)packageName);
        Element definitionsElement = this.getDefinitionsElementFromXml((String)asset.getAssetContent());
        Assert.assertNotNull((Object)definitionsElement);
        String exporter = definitionsElement.getAttributeNode("exporter").getValue();
        Assert.assertNotNull((Object)exporter);
        Assert.assertEquals((Object)"jBPM Designer", (Object)exporter);
        String exporterVersion = definitionsElement.getAttributeNode("exporterVersion").getValue();
        Assert.assertNotNull((Object)exporterVersion);
        Assert.assertEquals((Object)"1.0", (Object)exporterVersion);
    }

    @Test
    public void testCreateCaseDefinitionWithDefaultPackage() throws Exception {
        org.uberfire.backend.vfs.Path pathSource = (org.uberfire.backend.vfs.Path)Mockito.mock(org.uberfire.backend.vfs.Path.class);
        Mockito.when((Object)pathSource.toURI()).thenReturn((Object)"file://p0/Evaluation/src/main/resources/org/jbpm/test/cases");
        DefaultDesignerAssetService assetService = new DefaultDesignerAssetService();
        assetService.setRepository(this.repository);
        ArgumentCaptor assetArgumentCaptor = ArgumentCaptor.forClass(Asset.class);
        assetService.createCaseDefinition(pathSource, "MyCase.bpmn2", "HR");
        ((Repository)Mockito.verify((Object)this.repository, (VerificationMode)Mockito.times((int)1))).createAsset((Asset)assetArgumentCaptor.capture());
        Asset asset = (Asset)assetArgumentCaptor.getValue();
        Assert.assertNotNull((Object)asset);
        Assert.assertNotNull((Object)asset.getAssetContent());
        Element element = this.getProcessElementFromXml((String)asset.getAssetContent());
        Assert.assertNotNull((Object)element);
        String processId = element.getAttribute("id");
        Assert.assertNotNull((Object)processId);
        Assert.assertEquals((Object)"Evaluation.org.jbpm.test.cases.MyCase", (Object)processId);
        String packageName = element.getAttribute("drools:packageName");
        Assert.assertNotNull((Object)packageName);
        Assert.assertEquals((Object)"org.jbpm.test.cases", (Object)packageName);
        String adHoc = element.getAttribute("drools:adHoc");
        Assert.assertNotNull((Object)adHoc);
        Assert.assertEquals((Object)"true", (Object)adHoc);
        Element metadataElement = this.getMetaDataElementFromXml((String)asset.getAssetContent());
        String caseIdPrefix = metadataElement.getAttribute("name");
        Assert.assertNotNull((Object)caseIdPrefix);
        Assert.assertEquals((Object)"customCaseIdPrefix", (Object)caseIdPrefix);
        String caseIdPrefixValue = metadataElement.getFirstChild().getNextSibling().getTextContent();
        Assert.assertNotNull((Object)caseIdPrefixValue);
        Assert.assertEquals((Object)"HR", (Object)caseIdPrefixValue);
        Element definitionsElement = this.getDefinitionsElementFromXml((String)asset.getAssetContent());
        Assert.assertNotNull((Object)definitionsElement);
        String exporter = definitionsElement.getAttributeNode("exporter").getValue();
        Assert.assertNotNull((Object)exporter);
        Assert.assertEquals((Object)"jBPM Designer", (Object)exporter);
        String exporterVersion = definitionsElement.getAttributeNode("exporterVersion").getValue();
        Assert.assertNotNull((Object)exporterVersion);
        Assert.assertEquals((Object)"1.0", (Object)exporterVersion);
    }

    @Test
    public void testCreateCaseDefinitionWithPackageNoPrefix() throws Exception {
        org.uberfire.backend.vfs.Path pathSource = (org.uberfire.backend.vfs.Path)Mockito.mock(org.uberfire.backend.vfs.Path.class);
        Mockito.when((Object)pathSource.toURI()).thenReturn((Object)"file://p0/Evaluation/src/main/resources/org/jbpm/test/cases");
        DefaultDesignerAssetService assetService = new DefaultDesignerAssetService();
        assetService.setRepository(this.repository);
        ArgumentCaptor assetArgumentCaptor = ArgumentCaptor.forClass(Asset.class);
        assetService.createCaseDefinition(pathSource, "MyCase.bpmn2", "");
        ((Repository)Mockito.verify((Object)this.repository, (VerificationMode)Mockito.times((int)1))).createAsset((Asset)assetArgumentCaptor.capture());
        Asset asset = (Asset)assetArgumentCaptor.getValue();
        Assert.assertNotNull((Object)asset);
        Assert.assertNotNull((Object)asset.getAssetContent());
        Element element = this.getProcessElementFromXml((String)asset.getAssetContent());
        Assert.assertNotNull((Object)element);
        String processId = element.getAttribute("id");
        Assert.assertNotNull((Object)processId);
        Assert.assertEquals((Object)"Evaluation.org.jbpm.test.cases.MyCase", (Object)processId);
        String packageName = element.getAttribute("drools:packageName");
        Assert.assertNotNull((Object)packageName);
        Assert.assertEquals((Object)"org.jbpm.test.cases", (Object)packageName);
        String adHoc = element.getAttribute("drools:adHoc");
        Assert.assertNotNull((Object)adHoc);
        Assert.assertEquals((Object)"true", (Object)adHoc);
        Element metadataElement = this.getMetaDataElementFromXml((String)asset.getAssetContent());
        String caseIdPrefix = metadataElement.getAttribute("name");
        Assert.assertNotNull((Object)caseIdPrefix);
        Assert.assertEquals((Object)"customCaseIdPrefix", (Object)caseIdPrefix);
        String caseIdPrefixValue = metadataElement.getFirstChild().getNextSibling().getTextContent();
        Assert.assertNotNull((Object)caseIdPrefixValue);
        Assert.assertEquals((Object)"CASE", (Object)caseIdPrefixValue);
    }

    @Test
    public void testIsCaseProject() throws Exception {
        DefaultDesignerAssetService assetService = new DefaultDesignerAssetService();
        assetService.setRepository(this.repository);
        assetService.setIoService(this.ioService);
        org.uberfire.backend.vfs.Path packagePath = (org.uberfire.backend.vfs.Path)Mockito.mock(org.uberfire.backend.vfs.Path.class);
        Mockito.when((Object)packagePath.toURI()).thenReturn((Object)"file://p0/Evaluation/");
        org.uberfire.backend.vfs.Path pathSource = (org.uberfire.backend.vfs.Path)Mockito.mock(org.uberfire.backend.vfs.Path.class);
        Mockito.when((Object)pathSource.toURI()).thenReturn((Object)"file://p0/Evaluation/.caseproject");
        assetService.createProcess(pathSource, ".caseproject");
        DirectoryStream directoryStream = (DirectoryStream)Mockito.mock(DirectoryStream.class);
        Mockito.when((Object)this.ioService.newDirectoryStream((Path)Matchers.any(), (DirectoryStream.Filter)Matchers.any())).thenReturn((Object)directoryStream);
        Mockito.when((Object)directoryStream.iterator()).thenReturn(Arrays.asList(packagePath).iterator());
        Assert.assertTrue((boolean)assetService.isCaseProject(packagePath));
    }

    private Element getProcessElementFromXml(String content) throws Exception {
        DocumentBuilderFactory factory = DocumentBuilderFactory.newInstance();
        DocumentBuilder builder = factory.newDocumentBuilder();
        ByteArrayInputStream input = new ByteArrayInputStream(content.getBytes("UTF-8"));
        Document xml = builder.parse(input);
        XPathExpression expr = this.xpath.compile("/definitions/process");
        Element element = (Element)expr.evaluate(xml, XPathConstants.NODE);
        return element;
    }

    private Element getMetaDataElementFromXml(String content) throws Exception {
        DocumentBuilderFactory factory = DocumentBuilderFactory.newInstance();
        DocumentBuilder builder = factory.newDocumentBuilder();
        ByteArrayInputStream input = new ByteArrayInputStream(content.getBytes("UTF-8"));
        Document xml = builder.parse(input);
        XPathExpression expr = this.xpath.compile("/definitions/process/extensionElements/metaData");
        Element element = (Element)expr.evaluate(xml, XPathConstants.NODE);
        return element;
    }

    private Element getDefinitionsElementFromXml(String content) throws Exception {
        DocumentBuilderFactory factory = DocumentBuilderFactory.newInstance();
        DocumentBuilder builder = factory.newDocumentBuilder();
        ByteArrayInputStream input = new ByteArrayInputStream(content.getBytes("UTF-8"));
        Document xml = builder.parse(input);
        XPathExpression expr = this.xpath.compile("/definitions");
        Element element = (Element)expr.evaluate(xml, XPathConstants.NODE);
        return element;
    }

    private String decodeUniqueId(String uniqueId) {
        if (Base64.isArrayByteBase64((byte[])uniqueId.getBytes())) {
            byte[] decoded = Base64.decodeBase64((String)uniqueId);
            try {
                String uri = new String(decoded, "UTF-8");
                return UriUtils.encode((String)uri);
            }
            catch (UnsupportedEncodingException unsupportedEncodingException) {
                // empty catch block
            }
        }
        return UriUtils.encode((String)uniqueId);
    }
}

