/*
 * Decompiled with CFR 0.152.
 */
package org.jbpm.designer.bpmn2.util;

import org.eclipse.bpmn2.Lane;
import org.eclipse.bpmn2.Task;
import org.eclipse.bpmn2.di.BPMNEdge;
import org.eclipse.bpmn2.di.BPMNShape;
import org.eclipse.dd.di.DiagramElement;
import org.jbpm.designer.bpmn2.util.DIZorderComparator;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;
import org.junit.runner.RunWith;
import org.mockito.Mock;
import org.mockito.Mockito;
import org.mockito.runners.MockitoJUnitRunner;

@RunWith(value=MockitoJUnitRunner.class)
public class DIZorderComparatorTest {
    private DIZorderComparator comparator;
    @Mock
    private Lane lane;
    @Mock
    private BPMNShape laneShape;
    @Mock
    private Task task;
    @Mock
    private BPMNShape taskShape;

    @Before
    public void setUp() throws Exception {
        this.comparator = new DIZorderComparator();
        Mockito.when((Object)this.laneShape.getBpmnElement()).thenReturn((Object)this.lane);
        Mockito.when((Object)this.taskShape.getBpmnElement()).thenReturn((Object)this.task);
    }

    @Test
    public void testShapeBeforeEdge() throws Exception {
        Assert.assertTrue((this.comparator.compare((DiagramElement)Mockito.mock(BPMNShape.class), (DiagramElement)Mockito.mock(BPMNEdge.class)) < 0 ? 1 : 0) != 0);
    }

    @Test
    public void testEdgeAfterShape() throws Exception {
        Assert.assertTrue((this.comparator.compare((DiagramElement)Mockito.mock(BPMNEdge.class), (DiagramElement)Mockito.mock(BPMNShape.class)) > 0 ? 1 : 0) != 0);
    }

    @Test
    public void testLaneBeforeTask() throws Exception {
        Assert.assertTrue((this.comparator.compare((DiagramElement)this.laneShape, (DiagramElement)this.taskShape) < 0 ? 1 : 0) != 0);
    }

    @Test
    public void testTaskBeforeLane() throws Exception {
        Assert.assertTrue((this.comparator.compare((DiagramElement)this.taskShape, (DiagramElement)this.laneShape) > 0 ? 1 : 0) != 0);
    }
}

