/*
 * Decompiled with CFR 0.152.
 */
package org.jbpm.designer.web.preprocessing.impl;

import java.io.UnsupportedEncodingException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.servlet.ServletContext;
import javax.servlet.http.HttpServletRequest;
import org.apache.commons.codec.binary.Base64;
import org.guvnor.common.services.project.events.NewProjectEvent;
import org.guvnor.common.services.project.model.Module;
import org.guvnor.common.services.project.model.WorkspaceProject;
import org.jbpm.designer.helper.TestHttpServletRequest;
import org.jbpm.designer.helper.TestIDiagramProfile;
import org.jbpm.designer.helper.TestServletContext;
import org.jbpm.designer.repository.Asset;
import org.jbpm.designer.repository.AssetBuilderFactory;
import org.jbpm.designer.repository.Directory;
import org.jbpm.designer.repository.Repository;
import org.jbpm.designer.repository.RepositoryBaseTest;
import org.jbpm.designer.repository.UriUtils;
import org.jbpm.designer.repository.VFSFileSystemProducer;
import org.jbpm.designer.repository.impl.AssetBuilder;
import org.jbpm.designer.web.preprocessing.impl.JbpmPreprocessingUnit;
import org.jbpm.designer.web.profile.IDiagramProfile;
import org.jbpm.process.workitem.WorkDefinitionImpl;
import org.junit.After;
import org.junit.AfterClass;
import org.junit.Assert;
import org.junit.Before;
import org.junit.BeforeClass;
import org.junit.Test;
import org.junit.runner.RunWith;
import org.kie.api.runtime.KieContainer;
import org.kie.workbench.common.services.backend.builder.core.Builder;
import org.kie.workbench.common.services.backend.builder.core.LRUBuilderCache;
import org.kie.workbench.common.services.shared.project.KieModule;
import org.mockito.InjectMocks;
import org.mockito.Mockito;
import org.mockito.Spy;
import org.mockito.runners.MockitoJUnitRunner;
import org.stringtemplate.v4.ST;

@RunWith(value=MockitoJUnitRunner.class)
public class JbpmPreprocessingUnitVFSGitTest
extends RepositoryBaseTest {
    protected static final String REPOSITORY_ROOT = "designer-playground";
    protected static final String VFS_REPOSITORY_ROOT = "git://designer-playground";
    protected static final String USERNAME = "guvnorngtestuser1";
    protected static final String PASSWORD = "test1234";
    protected static final String ORIGIN_URL = "https://github.com/mswiderski/designer-playground.git";
    protected static final String FETCH_COMMAND = "?fetch";
    protected static String gitLocalClone = System.getProperty("java.io.tmpdir") + "git-repo";
    protected static Map<String, String> env = new HashMap<String, String>();
    protected VFSFileSystemProducer producer = new VFSFileSystemProducer();
    protected String dirName = "myprocesses";
    protected String processFileName = "process";
    @Spy
    @InjectMocks
    private JbpmPreprocessingUnit preprocessingUnitVFS = new JbpmPreprocessingUnit();

    @BeforeClass
    public static void prepare() {
        env.put("username", USERNAME);
        env.put("password", PASSWORD);
        env.put("origin", ORIGIN_URL);
        env.put("fetch.cmd", FETCH_COMMAND);
        System.setProperty("org.kie.nio.git.dir", gitLocalClone);
    }

    @AfterClass
    public static void cleanup() {
        System.clearProperty("org.kie.nio.git.dir");
    }

    @Override
    @Before
    public void setup() {
        super.setup();
    }

    @Override
    @After
    public void teardown() {
        super.teardown();
    }

    @Test
    public void testProprocess() {
        Repository repository = this.createRepository();
        repository.createDirectory("/" + this.dirName);
        repository.createDirectory("/global");
        AssetBuilder builder = AssetBuilderFactory.getAssetBuilder((Asset.AssetType)Asset.AssetType.Text);
        builder.content((Object)"bpmn2 content").type("bpmn2").name(this.processFileName).location("/" + this.dirName);
        String uniqueId = repository.createAsset(builder.getAsset());
        this.preprocessingUnitVFS.init((ServletContext)new TestServletContext(), "/", null);
        HashMap<String, String> params = new HashMap<String, String>();
        params.put("uuid", uniqueId);
        this.preprocessingUnitVFS.preprocess((HttpServletRequest)new TestHttpServletRequest(params), null, (IDiagramProfile)new TestIDiagramProfile(repository), null, false, false, null, null);
        Collection globalAssets = repository.listAssets("/global");
        Assert.assertNotNull((Object)globalAssets);
        Assert.assertEquals((long)10L, (long)globalAssets.size());
        repository.assetExists("/global/customeditors.json");
        repository.assetExists("/global/themes.json");
        repository.assetExists("/global/defaultemailicon.gif");
        repository.assetExists("/global/defaultmilestoneicon.png");
        repository.assetExists("/global/defaultsubcaseicon.png");
        repository.assetExists("/global/defaultlogicon.gif");
        repository.assetExists("/global/defaultservicenodeicon.png");
        repository.assetExists("/global/defaultbusinessrulesicon.png");
        repository.assetExists("/global/defaultdecisionicon.png");
        repository.assetExists("/global/patterns.json");
        repository.assetExists("/global/.gitignore");
        Collection defaultStuff = repository.listAssets("/" + this.dirName);
        Assert.assertNotNull((Object)defaultStuff);
        Assert.assertEquals((long)2L, (long)defaultStuff.size());
        repository.assetExists("/" + this.dirName.replaceAll("\\s", "%20") + "/WorkDefinitions.wid");
        repository.assetExists("/" + this.dirName.replaceAll("\\s", "%20") + "/process.bpmn2");
        repository.assetExists("/" + this.dirName.replaceAll("\\s", "%20") + "/.gitignore");
    }

    @Test
    public void testWorkitemParameterValues() throws Exception {
        Repository repository = this.createRepository();
        Directory testProjectDir = repository.createDirectory("/" + this.dirName);
        repository.createDirectory("/global");
        KieModule mockModule = (KieModule)Mockito.mock(KieModule.class);
        AssetBuilder builder = AssetBuilderFactory.getAssetBuilder((Asset.AssetType)Asset.AssetType.Text);
        builder.content((Object)"[\n    [\n        \"name\" : \"TestServiceWithParamValues\",\n        \"description\" : \"TestServiceWithParamValues\",\n        \"parameters\" : [\n            \"param1\" : new StringDataType(),\n            \"param2\" : new StringDataType(),\n            \"param3\" : new StringDataType()\n        ],\n        \"parameterValues\" : [\n            \"param1\" : new EnumDataType(\"org.jbpm.designer.web.preprocessing.impl.CarsEnum\"),\n            \"param2\" : \"\",\n            \"param3\" : \"one,two,three\"\n        ],\n        \"results\" : [\n            \"result1\" : new StringDataType(),\n            \"result2\" : new StringDataType()\n        ],\n        \"displayName\" : \"TestServiceWithParamValues\",\n        \"icon\" : \"widicon.png\",\n        \"category\": \"MyTestServices\",\n\t    \"dependencies\" : [\n        ]\n    ]\n]\n").type("wid").name("processwid").location("/" + this.dirName);
        String uniqueWidID = repository.createAsset(builder.getAsset());
        AssetBuilder builder2 = AssetBuilderFactory.getAssetBuilder((Asset.AssetType)Asset.AssetType.Byte);
        builder2.content((Object)"".getBytes()).type("png").name("widicon").location("/" + this.dirName);
        String uniqueIconID = repository.createAsset(builder2.getAsset());
        JbpmPreprocessingUnit preprocessingUnitVFS = new JbpmPreprocessingUnit();
        preprocessingUnitVFS.setBuilderCache(this.getBuilderCache(mockModule));
        preprocessingUnitVFS.init((ServletContext)new TestServletContext(), "/", null);
        Asset widAsset = repository.loadAsset(uniqueWidID);
        HashMap workDefinitions = new HashMap();
        preprocessingUnitVFS.evaluateWorkDefinitions(workDefinitions, widAsset, widAsset.getAssetLocation(), repository, mockModule);
        Assert.assertNotNull(workDefinitions);
        Assert.assertEquals((long)1L, (long)workDefinitions.size());
        Assert.assertTrue((boolean)workDefinitions.containsKey("TestServiceWithParamValues"));
        Assert.assertNotNull((Object)((WorkDefinitionImpl)workDefinitions.get("TestServiceWithParamValues")).getParameterValues());
        Assert.assertEquals((long)2L, (long)((WorkDefinitionImpl)workDefinitions.get("TestServiceWithParamValues")).getParameterValues().size());
        Map paramValues = ((WorkDefinitionImpl)workDefinitions.get("TestServiceWithParamValues")).getParameterValues();
        Assert.assertTrue((boolean)paramValues.containsKey("param1"));
        Assert.assertTrue((boolean)paramValues.containsKey("param3"));
        Assert.assertFalse((boolean)paramValues.containsKey("param2"));
        Assert.assertEquals((Object)"TOYOTA,MAZDA,FORD,NISSAN,HONDA", paramValues.get("param1"));
        Assert.assertEquals((Object)"one,two,three", paramValues.get("param3"));
        HashMap customParams = new HashMap();
        for (Map.Entry widEntry : workDefinitions.entrySet()) {
            WorkDefinitionImpl widImpl = (WorkDefinitionImpl)widEntry.getValue();
            if (widImpl.getParameterValues() == null) continue;
            Map widImplParamValues = widImpl.getParameterValues();
            HashMap<String, List<String>> customParamsValueMap = new HashMap<String, List<String>>();
            for (Map.Entry widParamValueEntry : widImplParamValues.entrySet()) {
                if (widParamValueEntry.getValue() == null || !(widParamValueEntry.getValue() instanceof String)) continue;
                customParamsValueMap.put((String)widParamValueEntry.getKey(), Arrays.asList(((String)widParamValueEntry.getValue()).split(",\\s*")));
            }
            customParams.put((String)widEntry.getKey(), customParamsValueMap);
        }
        Assert.assertNotNull(customParams);
        Assert.assertEquals((long)1L, (long)customParams.size());
        Assert.assertTrue((boolean)customParams.containsKey("TestServiceWithParamValues"));
        Assert.assertEquals((long)2L, (long)((Map)customParams.get("TestServiceWithParamValues")).size());
        ST workItemTemplate = new ST("$workitemDefs:{k| $workitemDefs.(k).parameters:{k1| $if(customParams.(k).(k1))$ $k1.name$ $endif$ }$ }$", '$', '$');
        workItemTemplate.add("workitemDefs", workDefinitions);
        workItemTemplate.add("customParams", customParams);
        Assert.assertTrue((boolean)workItemTemplate.render().contains("param1"));
        Assert.assertTrue((boolean)workItemTemplate.render().contains("param3"));
        Assert.assertFalse((boolean)workItemTemplate.render().contains("param2"));
        ST workItemTemplate2 = new ST("$workitemDefs:{k| $workitemDefs.(k).parameters:{k1| $if(customParams.(k).(k1))$ $else$ $k1.name$ $endif$ }$ }$", '$', '$');
        workItemTemplate2.add("workitemDefs", workDefinitions);
        workItemTemplate2.add("customParams", customParams);
        Assert.assertFalse((boolean)workItemTemplate2.render().contains("param1"));
        Assert.assertFalse((boolean)workItemTemplate2.render().contains("param3"));
        Assert.assertTrue((boolean)workItemTemplate2.render().contains("param2"));
    }

    @Test
    public void testEmptyCustomEditor() throws Exception {
        Repository repository = this.createRepository();
        Directory testProjectDir = repository.createDirectory("/" + this.dirName);
        repository.createDirectory("/global");
        KieModule mockModule = (KieModule)Mockito.mock(KieModule.class);
        AssetBuilder builder = AssetBuilderFactory.getAssetBuilder((Asset.AssetType)Asset.AssetType.Text);
        builder.content((Object)"\n[\n\n  [\n    \"name\" : \"Rewardsystem\",\n    \"description\" : \"Notifies the Reward System\",\n    \"displayName\" : \"Rewardsystem\",\n    \"defaultHandler\": \"mvel: com.rewardsystem.MyRewardsHandler()\",\n    \"category\" : \"Rewards\",\n    \"customEditor\" : \"\",\n    \"icon\" : \"widicon.png\",\n  ]\n\n]").type("wid").name("processwid").location("/" + this.dirName);
        String uniqueWidID = repository.createAsset(builder.getAsset());
        AssetBuilder builder2 = AssetBuilderFactory.getAssetBuilder((Asset.AssetType)Asset.AssetType.Byte);
        builder2.content((Object)"".getBytes()).type("png").name("widicon").location("/" + this.dirName);
        String uniqueIconID = repository.createAsset(builder2.getAsset());
        JbpmPreprocessingUnit preprocessingUnitVFS = new JbpmPreprocessingUnit();
        preprocessingUnitVFS.setBuilderCache(this.getBuilderCache(mockModule));
        preprocessingUnitVFS.init((ServletContext)new TestServletContext(), "/", null);
        Asset widAsset = repository.loadAsset(uniqueWidID);
        HashMap workDefinitions = new HashMap();
        preprocessingUnitVFS.evaluateWorkDefinitions(workDefinitions, widAsset, widAsset.getAssetLocation(), repository, mockModule);
        Assert.assertNotNull(workDefinitions);
        Assert.assertEquals((long)1L, (long)workDefinitions.size());
        Assert.assertTrue((boolean)workDefinitions.containsKey("Rewardsystem"));
        Assert.assertTrue((((WorkDefinitionImpl)workDefinitions.get("Rewardsystem")).getCustomEditor() == null ? 1 : 0) != 0);
        ST workItemTemplate = new ST("$workitemDefs:{k| $if(workitemDefs.(k).customEditor)$CEdefined$else$CEnotdefined$endif$ }$", '$', '$');
        workItemTemplate.add("workitemDefs", workDefinitions);
        Assert.assertFalse((boolean)workItemTemplate.render().contains("CEdefined"));
        Assert.assertTrue((boolean)workItemTemplate.render().contains("CEnotdefined"));
        ((WorkDefinitionImpl)workDefinitions.get("Rewardsystem")).setCustomEditor("myRewardsCustomEditor");
        ST workItemTemplate2 = new ST("$workitemDefs:{k| $if(workitemDefs.(k).customEditor)$CEdefined$else$CEnotdefined$endif$ }$", '$', '$');
        workItemTemplate2.add("workitemDefs", workDefinitions);
        Assert.assertTrue((boolean)workItemTemplate2.render().contains("CEdefined"));
        Assert.assertFalse((boolean)workItemTemplate2.render().contains("CEnotdefined"));
    }

    @Test
    public void testCaseProjectSetting() throws Exception {
        Repository repository = this.createRepository();
        Directory testProjectDir = repository.createDirectory("/" + this.dirName);
        repository.createDirectory("/global");
        KieModule mockModule = (KieModule)Mockito.mock(KieModule.class);
        AssetBuilder builder = AssetBuilderFactory.getAssetBuilder((Asset.AssetType)Asset.AssetType.Text);
        builder.content((Object)"\n[\n\n  [\n    \"name\" : \"MyCustomWorkitem\",\n    \"description\" : \"\",\n    \"displayName\" : \"MyCustomWorkitem\",\n    \"defaultHandler\": \"mvel: com.rewardsystem.MyCustomHandler()\",\n    \"category\" : \"Custom\",\n    \"customEditor\" : \"\",\n    \"icon\" : \"widicon.png\",\n  ]\n\n]").type("wid").name("processwid").location("/" + this.dirName);
        String uniqueWidID = repository.createAsset(builder.getAsset());
        AssetBuilder builder2 = AssetBuilderFactory.getAssetBuilder((Asset.AssetType)Asset.AssetType.Byte);
        builder2.content((Object)"".getBytes()).type("png").name("widicon").location("/" + this.dirName);
        String uniqueIconID = repository.createAsset(builder2.getAsset());
        JbpmPreprocessingUnit preprocessingUnitVFS = new JbpmPreprocessingUnit();
        preprocessingUnitVFS.setBuilderCache(this.getBuilderCache(mockModule));
        preprocessingUnitVFS.init((ServletContext)new TestServletContext(), "/", null);
        Asset widAsset = repository.loadAsset(uniqueWidID);
        HashMap workDefinitions = new HashMap();
        preprocessingUnitVFS.evaluateWorkDefinitions(workDefinitions, widAsset, widAsset.getAssetLocation(), repository, mockModule);
        Assert.assertNotNull(workDefinitions);
        Assert.assertEquals((long)1L, (long)workDefinitions.size());
        Assert.assertTrue((boolean)workDefinitions.containsKey("MyCustomWorkitem"));
        ST workItemTemplate = new ST("$if(caseproject)$CaseProjectTrue$else$CaseProjectFalse$endif$", '$', '$');
        workItemTemplate.add("workitemDefs", workDefinitions);
        Assert.assertFalse((boolean)workItemTemplate.render().contains("CaseProjectTrue"));
        Assert.assertTrue((boolean)workItemTemplate.render().contains("CaseProjectFalse"));
    }

    @Test
    public void testEmptyIcon() throws Exception {
        Repository repository = this.createRepository();
        Directory testProjectDir = repository.createDirectory("/" + this.dirName);
        repository.createDirectory("/global");
        KieModule mockModule = (KieModule)Mockito.mock(KieModule.class);
        AssetBuilder builder = AssetBuilderFactory.getAssetBuilder((Asset.AssetType)Asset.AssetType.Text);
        builder.content((Object)"\n[\n\n  [\n    \"name\" : \"Rewardsystem\",\n    \"description\" : \"Notifies the Reward System\",\n    \"displayName\" : \"Rewardsystem\",\n    \"defaultHandler\": \"mvel: com.rewardsystem.MyRewardsHandler()\",\n    \"category\" : \"Rewards\",\n    \"customEditor\" : \"true\",\n    \"icon\" : \"\",\n  ]\n\n]").type("wid").name("processwid").location("/" + this.dirName);
        String uniqueWidID = repository.createAsset(builder.getAsset());
        AssetBuilder builder2 = AssetBuilderFactory.getAssetBuilder((Asset.AssetType)Asset.AssetType.Byte);
        builder2.content((Object)"".getBytes()).type("png").name("defaultservicenodeicon").location("/global");
        String uniqueIconID = repository.createAsset(builder2.getAsset());
        JbpmPreprocessingUnit preprocessingUnitVFS = new JbpmPreprocessingUnit();
        preprocessingUnitVFS.setBuilderCache(this.getBuilderCache(mockModule));
        preprocessingUnitVFS.init((ServletContext)new TestServletContext(), "/", null);
        Asset widAsset = repository.loadAsset(uniqueWidID);
        preprocessingUnitVFS.setGlobalDir(new TestIDiagramProfile(repository).getRepositoryGlobalDir());
        HashMap workDefinitions = new HashMap();
        preprocessingUnitVFS.evaluateWorkDefinitions(workDefinitions, widAsset, widAsset.getAssetLocation(), repository, mockModule);
        Assert.assertNotNull(workDefinitions);
        Assert.assertEquals((long)1L, (long)workDefinitions.size());
        Assert.assertTrue((boolean)workDefinitions.containsKey("Rewardsystem"));
        Assert.assertNotNull((Object)((WorkDefinitionImpl)workDefinitions.get("Rewardsystem")).getIcon());
        Assert.assertEquals((Object)"/global/defaultservicenodeicon.png", (Object)((WorkDefinitionImpl)workDefinitions.get("Rewardsystem")).getIcon());
    }

    @Test
    public void testEmptyAndInvalidWidNames() throws Exception {
        Repository repository = this.createRepository();
        Directory testProjectDir = repository.createDirectory("/" + this.dirName);
        repository.createDirectory("/global");
        KieModule mockModule = (KieModule)Mockito.mock(KieModule.class);
        AssetBuilder builder = AssetBuilderFactory.getAssetBuilder((Asset.AssetType)Asset.AssetType.Text);
        builder.content((Object)"\n[\n\n  [\n    \"name\" : \"12~!#!@$#@$#@%$#^$%&^%&^&(&)()()+_)|}{|';';/.,:{|}\",\n    \"description\" : \"Invalid Name\",\n    \"displayName\" : \"Invalid Name\",\n    \"defaultHandler\": \"\",\n    \"category\" : \"Invalid Names Category\",\n    \"customEditor\" : \"false\",\n    \"icon\" : \"\",\n  ],\n  [\n    \"name\" : \"\",\n    \"description\" : \"Empty Name\",\n    \"displayName\" : \"Empty Name\",\n    \"defaultHandler\": \"\",\n    \"category\" : \"Empty Names Category\",\n    \"customEditor\" : \"false\",\n    \"icon\" : \"\",\n  ],\n  [\n    \"name\" : \"      \",\n    \"description\" : \"Spaces Only Name\",\n    \"displayName\" : \"Spaces Only Name\",\n    \"defaultHandler\": \"\",\n    \"category\" : \"Spaces Only Names Category\",\n    \"customEditor\" : \"false\",\n    \"icon\" : \"\",\n  ],\n  [\n    \"name\" : \"\u91d1\u6c5f\u6b62\u30cf\u30aa\u30e6\u30d8\u624b\u5831\u3067\u3083\u3086\u63b2\u60a9\u30d5\u30c1\u7d4c\u58c1\u5426\u8a03\u55c5\u3051\u307d\",\n    \"description\" : \"Unicode Name\",\n    \"displayName\" : \"Unicode Name\",\n    \"defaultHandler\": \"\",\n    \"category\" : \"Unicode Names Category\",\n    \"customEditor\" : \"false\",\n    \"icon\" : \"\",\n  ],\n  [\n    \"name\" : \"\u91d1\u6c5f\u6b62\u30cf\u30aa\u30e6\u30d8\u624b\u5831 \u91d1\u6c5f\u6b62\u30cf\u30aa\u30e6\u30d8\u624b\u5831 \u91d1\u6c5f\u6b62\u30cf\u30aa\u30e6\u30d8\u624b\u5831\",\n    \"description\" : \"Unicode Name With Spaces\",\n    \"displayName\" : \"Unicode Name With Spaces\",\n    \"defaultHandler\": \"\",\n    \"category\" : \"Unicode Names With Spaces Category\",\n    \"customEditor\" : \"false\",\n    \"icon\" : \"\",\n  ],\n  [\n    \"name\" : \"ThisIsASampleWidName\",\n    \"description\" : \"Non Unicode Name\",\n    \"displayName\" : \"NonUnicode Name\",\n    \"defaultHandler\": \"\",\n    \"category\" : \"NonUnicode Names Category\",\n    \"customEditor\" : \"false\",\n    \"icon\" : \"\",\n  ],\n  [\n    \"name\" : \"This is some other sample Name\",\n    \"description\" : \"Non Unicode Name with spaces\",\n    \"displayName\" : \"NonUnicode Name with spaces\",\n    \"defaultHandler\": \"\",\n    \"category\" : \"NonUnicode Names with spaces Category\",\n    \"customEditor\" : \"false\",\n    \"icon\" : \"\",\n  ],\n  [\n    \"name\" : \"This_is_a_sample_name_with_underscores\",\n    \"description\" : \"Non Unicode Name with spaces\",\n    \"displayName\" : \"NonUnicode Name with spaces\",\n    \"defaultHandler\": \"\",\n    \"category\" : \"NonUnicode Names with spaces Category\",\n    \"customEditor\" : \"false\",\n    \"icon\" : \"\",\n  ],\n  [\n    \"name\" : \"_This__is__some_name_with__bunch_of___underscores__\",\n    \"description\" : \"Non Unicode Name with spaces\",\n    \"displayName\" : \"NonUnicode Name with spaces\",\n    \"defaultHandler\": \"\",\n    \"category\" : \"NonUnicode Names with spaces Category\",\n    \"customEditor\" : \"false\",\n    \"icon\" : \"\",\n  ],\n\n]").type("wid").name("processwid").location("/" + this.dirName);
        String uniqueWidID = repository.createAsset(builder.getAsset());
        AssetBuilder builder2 = AssetBuilderFactory.getAssetBuilder((Asset.AssetType)Asset.AssetType.Byte);
        builder2.content((Object)"".getBytes()).type("png").name("defaultservicenodeicon").location("/global");
        String uniqueIconID = repository.createAsset(builder2.getAsset());
        JbpmPreprocessingUnit preprocessingUnitVFS = new JbpmPreprocessingUnit();
        preprocessingUnitVFS.setBuilderCache(this.getBuilderCache(mockModule));
        preprocessingUnitVFS.init((ServletContext)new TestServletContext(), "/", null);
        Asset widAsset = repository.loadAsset(uniqueWidID);
        preprocessingUnitVFS.setGlobalDir(new TestIDiagramProfile(repository).getRepositoryGlobalDir());
        HashMap workDefinitions = new HashMap();
        preprocessingUnitVFS.evaluateWorkDefinitions(workDefinitions, widAsset, widAsset.getAssetLocation(), repository, mockModule);
        Assert.assertNotNull(workDefinitions);
        Assert.assertEquals((long)6L, (long)workDefinitions.size());
        ArrayList<String> validWidNames = new ArrayList<String>(Arrays.asList("\u91d1\u6c5f\u6b62\u30cf\u30aa\u30e6\u30d8\u624b\u5831\u3067\u3083\u3086\u63b2\u60a9\u30d5\u30c1\u7d4c\u58c1\u5426\u8a03\u55c5\u3051\u307d", "\u91d1\u6c5f\u6b62\u30cf\u30aa\u30e6\u30d8\u624b\u5831\u91d1\u6c5f\u6b62\u30cf\u30aa\u30e6\u30d8\u624b\u5831\u91d1\u6c5f\u6b62\u30cf\u30aa\u30e6\u30d8\u624b\u5831", "ThisIsASampleWidName", "ThisissomeothersampleName", "This_is_a_sample_name_with_underscores", "_This__is__some_name_with__bunch_of___underscores__"));
        for (Map.Entry entry : workDefinitions.entrySet()) {
            Assert.assertTrue((boolean)validWidNames.contains(entry.getKey()));
            Assert.assertTrue((boolean)validWidNames.contains(((WorkDefinitionImpl)entry.getValue()).getName()));
        }
    }

    private String decodeUniqueId(String uniqueId) {
        if (Base64.isBase64((String)uniqueId)) {
            byte[] decoded = Base64.decodeBase64((String)uniqueId);
            try {
                String uri = new String(decoded, "UTF-8");
                return UriUtils.encode((String)uri);
            }
            catch (UnsupportedEncodingException unsupportedEncodingException) {
                // empty catch block
            }
        }
        return UriUtils.encode((String)uniqueId);
    }

    private LRUBuilderCache getBuilderCache(KieModule kieModule) {
        NewProjectEvent event = (NewProjectEvent)Mockito.mock(NewProjectEvent.class);
        WorkspaceProject project = (WorkspaceProject)Mockito.mock(WorkspaceProject.class);
        LRUBuilderCache builderCache = (LRUBuilderCache)Mockito.mock(LRUBuilderCache.class);
        KieContainer kieContainer = (KieContainer)Mockito.mock(KieContainer.class);
        Mockito.when((Object)kieContainer.getClassLoader()).thenReturn((Object)this.getClass().getClassLoader());
        Builder workbenchBuilder = (Builder)Mockito.mock(Builder.class);
        Mockito.when((Object)workbenchBuilder.getKieContainer()).thenReturn((Object)kieContainer);
        Mockito.when((Object)builderCache.getBuilder((Module)Mockito.anyObject())).thenReturn((Object)workbenchBuilder);
        return builderCache;
    }
}

