/*
 * Decompiled with CFR 0.152.
 */
package org.jbpm.designer.bpmn2.impl;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import org.jbpm.designer.bpmn2.impl.helpers.SimpleEdge;
import org.jbpm.designer.bpmn2.utils.Bpmn2Loader;
import org.jbpm.designer.bpmn2.validation.BPMN2SyntaxCheckerTest;
import org.json.JSONArray;
import org.json.JSONObject;
import org.junit.Assert;
import org.junit.Test;

public class Bpmn2JsonMarshallerTest {
    private static final String COST_PER_TIME_UNIT = "unitcost";
    private static final String PROCESSING_TIME_MAX = "max";
    private static final String PROCESSING_TIME_MIN = "min";
    private static final String PROCESSING_TIME_MEAN = "mean";
    private static final String PROBABILITY = "probability";
    private static final String WORKING_HOURS = "workinghours";
    private static final String QUANTITY = "quantity";
    private static final String STANDARD_DEVIATION = "standarddeviation";
    private static final String DISTRIBUTION_TYPE = "distributiontype";
    private Bpmn2Loader loader = new Bpmn2Loader(Bpmn2JsonMarshallerTest.class);

    @Test
    public void testGroupMarshalling() throws Exception {
        JSONObject process = this.loader.loadProcessFromXml("group.bpmn2");
        JSONObject group = Bpmn2Loader.getChildByName(process, "group");
        Assert.assertNotNull((String)"Group with name 'group' not found in process.", (Object)group);
        Assert.assertEquals((String)"Group has wrong documentation.", (Object)"group documentation", (Object)Bpmn2Loader.getDocumentationFor(group));
    }

    @Test
    public void testBoundaryEventDocumentation() throws Exception {
        JSONObject process = this.loader.loadProcessFromXml("boundaryEventsDocumentation.bpmn2");
        JSONObject boundaryEvent = Bpmn2Loader.getChildByName(process, "CancelOnTimer");
        Assert.assertNotNull((String)"BoundaryEvent with name 'CancelOnTimer' not found in process.", (Object)boundaryEvent);
        Assert.assertEquals((String)"BoundaryEvent has wrong documentation.", (Object)"Cancel task on timeout.", (Object)Bpmn2Loader.getDocumentationFor(boundaryEvent));
    }

    @Test
    public void testSwimlaneDocumentation() throws Exception {
        JSONObject process = this.loader.loadProcessFromXml("swimlane.bpmn2");
        JSONObject swimlane = Bpmn2Loader.getChildByName(process, "Documented Swimlane");
        Assert.assertNotNull((String)"Swimlane with name 'Documented Swimlane' not found in process.", (Object)swimlane);
        Assert.assertEquals((String)"Swimlane has wrong documentation.", (Object)"Some documentation for swimlane.", (Object)Bpmn2Loader.getDocumentationFor(swimlane));
    }

    @Test
    public void testConstraint() throws Exception {
        JSONObject process = this.loader.loadProcessFromXml("constraint.bpmn2");
        JSONObject condition1 = Bpmn2Loader.getChildByName(process, "Condition1");
        JSONObject condition2 = Bpmn2Loader.getChildByName(process, "Condition2");
        JSONObject condition1Properties = condition1.getJSONObject("properties");
        JSONObject condition2Properties = condition2.getJSONObject("properties");
        Assert.assertEquals((Object)"return  KieFunctions.endsWith(customVar, \"sample\");", (Object)condition1Properties.getString("conditionexpression"));
        Assert.assertEquals((Object)"return  !KieFunctions.isNull(intVar);", (Object)condition2Properties.getString("conditionexpression"));
    }

    @Test
    public void testMultiLineNames() throws Exception {
        JSONObject process = this.loader.loadProcessFromXml("multiLineNames.bpmn2");
        JSONObject lane = Bpmn2Loader.getChildByName(process, "my\nlane");
        Assert.assertNotNull((Object)lane);
        Assert.assertNotNull((Object)Bpmn2Loader.getChildByName(lane, "my\nuser\ntask"));
        Assert.assertNotNull((Object)Bpmn2Loader.getChildByName(lane, "my\nmessage"));
        JSONObject adhocSubprocess = Bpmn2Loader.getChildByName(lane, "my\nadhoc\nsubprocess");
        Assert.assertNotNull((Object)adhocSubprocess);
        Assert.assertNotNull((Object)Bpmn2Loader.getChildByName(adhocSubprocess, "my\ntask\nin\nadhoc"));
        Assert.assertNotNull((Object)Bpmn2Loader.getChildByName(adhocSubprocess, "my\nmessage\nin\nsubprocess\nin\nlane"));
        Assert.assertNotNull((Object)Bpmn2Loader.getChildByName(process, "my\nstart"));
        Assert.assertNotNull((Object)Bpmn2Loader.getChildByName(process, "my\nflow\nin\nlane"));
        Assert.assertNotNull((Object)Bpmn2Loader.getChildByName(process, "my\ngate"));
        Assert.assertNotNull((Object)Bpmn2Loader.getChildByName(process, "my\nterminate\nend"));
        Assert.assertNotNull((Object)Bpmn2Loader.getChildByName(process, "my\nthrowing\nmessage"));
        Assert.assertNotNull((Object)Bpmn2Loader.getChildByName(process, "my\nend"));
        Assert.assertNotNull((Object)Bpmn2Loader.getChildByName(process, "my\nflow"));
        JSONObject embeddedSubprocess = Bpmn2Loader.getChildByName(process, "my\nsubprocess");
        Assert.assertNotNull((Object)embeddedSubprocess);
        Assert.assertNotNull((Object)Bpmn2Loader.getChildByName(embeddedSubprocess, "my\nmessage\nstart"));
        Assert.assertNotNull((Object)Bpmn2Loader.getChildByName(embeddedSubprocess, "my\ninner\nend"));
        Assert.assertNotNull((Object)Bpmn2Loader.getChildByName(embeddedSubprocess, "my\nflow\nin\nsubprocess"));
        Assert.assertNotNull((Object)Bpmn2Loader.getChildByName(embeddedSubprocess, "my\nmanual\ntask"));
        Assert.assertNotNull((Object)Bpmn2Loader.getChildByName(embeddedSubprocess, "my\nescalation\nevent"));
    }

    @Test
    public void testTextAnnotationEdges() throws Exception {
        ArrayList<SimpleEdge> expectedEdges = new ArrayList<SimpleEdge>();
        expectedEdges.add(SimpleEdge.createEdge("Start\nAnnotation").addPoint(15, 15).addPoint(1, 25));
        expectedEdges.add(SimpleEdge.createEdge("Task\nIn\nLane\nAnnotation").addPoint(50, 40).addPoint(380, 184).addPoint(331, 184).addPoint(1, 25));
        expectedEdges.add(SimpleEdge.createEdge("WID\nTask\nannotation").addPoint(50, 40).addPoint(690, 507).addPoint(1, 25));
        expectedEdges.add(SimpleEdge.createEdge("User\nTask\nAnnotation").addPoint(50, 40).addPoint(196, 646).addPoint(1, 25));
        expectedEdges.add(SimpleEdge.createEdge("Gateway\nin\nlane\nannotation").addPoint(20, 20).addPoint(1, 25));
        expectedEdges.add(SimpleEdge.createEdge("End\nIn\nSwimlane").addPoint(14, 14).addPoint(915, 231).addPoint(1, 25));
        expectedEdges.add(SimpleEdge.createEdge("Subprocess's\nAnnotation").addPoint(100, 80).addPoint(495, 847).addPoint(1, 25));
        expectedEdges.add(SimpleEdge.createEdge("Swimlane's\nAnnotation").addPoint(300, 125).addPoint(1066, 320).addPoint(1, 25));
        JSONObject process = this.loader.loadProcessFromXml("textAnnotation.bpmn2");
        List<JSONObject> edges = Bpmn2Loader.getChildByTypeName(process, "Association_Undirected");
        List<JSONObject> annotations = Bpmn2Loader.getChildByTypeName(process, "TextAnnotation");
        annotations.addAll(Bpmn2Loader.getChildByTypeName(Bpmn2Loader.getChildByName(process, "swimlane"), "TextAnnotation"));
        ArrayList<SimpleEdge> actualEdges = new ArrayList<SimpleEdge>();
        for (JSONObject edge : edges) {
            SimpleEdge current = null;
            String associatedWith = ((JSONObject)edge.getJSONArray("outgoing").get(0)).getString("resourceId");
            for (JSONObject annotation : annotations) {
                if (!Bpmn2Loader.getResourceId(annotation).equals(associatedWith)) continue;
                current = SimpleEdge.createEdge(Bpmn2Loader.getNameFor(annotation));
            }
            JSONArray dockers = edge.getJSONArray("dockers");
            for (int i = 0; i < dockers.length(); ++i) {
                JSONObject dockerPoint = (JSONObject)dockers.get(i);
                current.addPoint(Float.parseFloat(dockerPoint.getString("x")), Float.parseFloat(dockerPoint.getString("y")));
            }
            actualEdges.add(current);
        }
        Assert.assertEquals(expectedEdges, actualEdges);
    }

    @Test
    public void testTextAnnotationLink() throws Exception {
        JSONObject process = this.loader.loadProcessFromXml("textAnnotation.bpmn2");
        Assert.assertEquals((long)2L, (long)Bpmn2Loader.getChildByName(process, "Start").getJSONArray("outgoing").length());
        Assert.assertEquals((long)2L, (long)Bpmn2Loader.getChildByName(process, "ServiceTask").getJSONArray("outgoing").length());
        Assert.assertEquals((long)0L, (long)Bpmn2Loader.getChildByName(process, "End2").getJSONArray("outgoing").length());
        JSONObject swimlane = Bpmn2Loader.getChildByName(process, "swimlane");
        Assert.assertEquals((long)1L, (long)swimlane.getJSONArray("outgoing").length());
        Assert.assertEquals((long)2L, (long)Bpmn2Loader.getChildByName(swimlane, "ManualTask").getJSONArray("outgoing").length());
        Assert.assertEquals((long)3L, (long)Bpmn2Loader.getChildByName(swimlane, "Gateway").getJSONArray("outgoing").length());
        Assert.assertEquals((long)1L, (long)Bpmn2Loader.getChildByName(swimlane, "End1").getJSONArray("outgoing").length());
        JSONObject subprocess = Bpmn2Loader.getChildByName(process, "Subprocess");
        Assert.assertEquals((long)2L, (long)subprocess.getJSONArray("outgoing").length());
        Assert.assertEquals((long)1L, (long)Bpmn2Loader.getChildByName(subprocess, "Task_1").getJSONArray("outgoing").length());
    }

    @Test
    public void testSendTaskDataInputs() throws Exception {
        String[] variableNames = new String[]{"Comment", "Content", "CreatedBy", "GroupId", "Locale", "NotCompletedNotify", "NotCompletedReassign", "NotStartedNotify", "NotStartedReassign", "Priority", "Skippable", "TaskName", "MyDataInput1", "MyDataInput2"};
        JSONObject process = this.loader.loadProcessFromXml("nonusertaskdatainputs.bpmn2");
        JSONObject sendtask = Bpmn2Loader.getChildByName(process, "MySendTask");
        JSONObject properties = sendtask.getJSONObject("properties");
        String datainputset = properties.getString("datainputset");
        for (String variableName : variableNames) {
            String dataInput = variableName + ":String";
            Assert.assertTrue((String)("Variable \"" + variableName + "\" not found in datainputset"), (boolean)datainputset.contains(dataInput));
        }
        String assignments = properties.getString("assignments");
        for (String variableName : variableNames) {
            String assignment = "[din]" + variableName + "=a" + variableName;
            Assert.assertTrue((String)("Assignment \"" + assignment + "\" not found in assignments"), (boolean)assignments.contains(assignment));
        }
    }

    @Test
    public void testCustomTaskTaskName() throws Exception {
        String assignment;
        String dataInput;
        String[] existingVariableNames = new String[]{"Message", "DataInput1"};
        String[] nonExistingVariableNames = new String[]{"TaskName"};
        JSONObject process = this.loader.loadProcessFromXml("customtasktaskname.bpmn2");
        JSONObject logtask = Bpmn2Loader.getChildByName(process, "Log");
        JSONObject properties = logtask.getJSONObject("properties");
        String datainputset = properties.getString("datainputset");
        String assignments = properties.getString("assignments");
        for (String variableName : existingVariableNames) {
            dataInput = variableName + ":String";
            Assert.assertTrue((String)("Variable \"" + variableName + "\" not found in datainputset"), (boolean)datainputset.contains(dataInput));
        }
        for (String variableName : existingVariableNames) {
            assignment = "[din]" + variableName + "=";
            Assert.assertTrue((String)("Assignment \"" + assignment + "\" not found in assignments"), (boolean)assignments.contains(assignment));
        }
        for (String variableName : nonExistingVariableNames) {
            dataInput = variableName + ":String";
            Assert.assertFalse((String)("Variable \"" + variableName + "\" found in datainputset"), (boolean)datainputset.contains(dataInput));
        }
        for (String variableName : nonExistingVariableNames) {
            assignment = "[din]" + variableName + "=";
            Assert.assertFalse((String)("Assignment \"" + assignment + "\" found in assignments"), (boolean)assignments.contains(assignment));
        }
    }

    @Test
    public void testSimulationStartEvent() throws Exception {
        JSONObject process = this.loader.loadProcessFromXml("simulationProcess.bpmn2");
        JSONObject startEvent = Bpmn2Loader.getChildByName(process, "StartEvent");
        JSONObject properties = startEvent.getJSONObject("properties");
        Assert.assertEquals((long)99L, (long)properties.getInt(PROBABILITY));
        Assert.assertEquals((long)5L, (long)properties.getInt(PROCESSING_TIME_MAX));
        Assert.assertEquals((long)4L, (long)properties.getInt(PROCESSING_TIME_MIN));
        Assert.assertEquals((Object)"uniform", (Object)properties.getString(DISTRIBUTION_TYPE));
    }

    @Test
    public void testSimulationUserTask() throws Exception {
        JSONObject process = this.loader.loadProcessFromXml("simulationProcess.bpmn2");
        JSONObject userTask = Bpmn2Loader.getChildByName(process, "UserTask");
        JSONObject properties = userTask.getJSONObject("properties");
        Assert.assertEquals((long)8L, (long)properties.getInt(COST_PER_TIME_UNIT));
        Assert.assertEquals((long)7L, (long)properties.getInt(PROCESSING_TIME_MAX));
        Assert.assertEquals((long)3L, (long)properties.getInt(PROCESSING_TIME_MIN));
        Assert.assertEquals((long)5L, (long)properties.getInt(WORKING_HOURS));
        Assert.assertEquals((long)2L, (long)properties.getInt(QUANTITY));
        Assert.assertEquals((Object)"uniform", (Object)properties.getString(DISTRIBUTION_TYPE));
    }

    @Test
    public void testSimulationGatewayProbability() throws Exception {
        JSONObject process = this.loader.loadProcessFromXml("simulationProcess.bpmn2");
        JSONObject lowSequence = Bpmn2Loader.getChildByName(process, "LowProbability");
        JSONObject highSequence = Bpmn2Loader.getChildByName(process, "HighProbability");
        JSONObject lowProperties = lowSequence.getJSONObject("properties");
        Assert.assertEquals((long)30L, (long)lowProperties.getInt(PROBABILITY));
        JSONObject highProperties = highSequence.getJSONObject("properties");
        Assert.assertEquals((long)70L, (long)highProperties.getInt(PROBABILITY));
    }

    @Test
    public void testSimulationThrowEvent() throws Exception {
        JSONObject process = this.loader.loadProcessFromXml("simulationProcess.bpmn2");
        JSONObject throwEvent = Bpmn2Loader.getChildByName(process, "ThrowEvent");
        JSONObject properties = throwEvent.getJSONObject("properties");
        Assert.assertEquals((long)3L, (long)properties.getInt(PROCESSING_TIME_MEAN));
        Assert.assertEquals((Object)"poisson", (Object)properties.getString(DISTRIBUTION_TYPE));
    }

    @Test
    public void testSimulationCallActivity() throws Exception {
        JSONObject process = this.loader.loadProcessFromXml("simulationProcess.bpmn2");
        JSONObject callActivity = Bpmn2Loader.getChildByName(process, "CallActivity");
        JSONObject properties = callActivity.getJSONObject("properties");
        Assert.assertEquals((long)3L, (long)properties.getInt(COST_PER_TIME_UNIT));
        Assert.assertEquals((long)2L, (long)properties.getInt(PROCESSING_TIME_MEAN));
        Assert.assertEquals((long)1L, (long)properties.getInt(STANDARD_DEVIATION));
        Assert.assertEquals((Object)"normal", (Object)properties.getString(DISTRIBUTION_TYPE));
    }

    @Test
    public void testSimulationEndEvent() throws Exception {
        JSONObject process = this.loader.loadProcessFromXml("simulationProcess.bpmn2");
        JSONObject endEvent = Bpmn2Loader.getChildByName(process, "EndEvent");
        JSONObject properties = endEvent.getJSONObject("properties");
        Assert.assertEquals((long)9L, (long)properties.getInt(PROCESSING_TIME_MAX));
        Assert.assertEquals((long)8L, (long)properties.getInt(PROCESSING_TIME_MIN));
        Assert.assertEquals((Object)"uniform", (Object)properties.getString(DISTRIBUTION_TYPE));
    }

    @Test
    public void testSimulationSubProcess() throws Exception {
        JSONObject process = this.loader.loadProcessFromXml("simulationProcess.bpmn2");
        JSONObject subProcess = Bpmn2Loader.getChildByName(process, "SubProcess");
        JSONObject properties = subProcess.getJSONObject("properties");
        Assert.assertEquals((long)12L, (long)properties.getInt(COST_PER_TIME_UNIT));
        Assert.assertEquals((long)6L, (long)properties.getInt(PROCESSING_TIME_MAX));
        Assert.assertEquals((long)2L, (long)properties.getInt(PROCESSING_TIME_MIN));
        Assert.assertEquals((Object)"uniform", (Object)properties.getString(DISTRIBUTION_TYPE));
    }

    @Test
    public void testSimulationSubService() throws Exception {
        JSONObject process = this.loader.loadProcessFromXml("simulationProcess.bpmn2");
        JSONObject serviceTask = Bpmn2Loader.getChildByName(Bpmn2Loader.getChildByName(process, "SubProcess"), "SubService");
        JSONObject properties = serviceTask.getJSONObject("properties");
        Assert.assertEquals((long)14L, (long)properties.getInt(COST_PER_TIME_UNIT));
        Assert.assertEquals((long)7L, (long)properties.getInt(PROCESSING_TIME_MEAN));
        Assert.assertEquals((Object)"poisson", (Object)properties.getString(DISTRIBUTION_TYPE));
    }

    @Test
    public void testSimulationBoundaryEvent() throws Exception {
        JSONObject process = this.loader.loadProcessFromXml("simulationProcess.bpmn2");
        JSONObject boundaryEvent = Bpmn2Loader.getChildByName(process, "BoundaryEvent");
        JSONObject properties = boundaryEvent.getJSONObject("properties");
        Assert.assertEquals((long)13L, (long)properties.getInt(PROCESSING_TIME_MAX));
        Assert.assertEquals((long)4L, (long)properties.getInt(PROCESSING_TIME_MIN));
        Assert.assertEquals((long)85L, (long)properties.getInt(PROBABILITY));
        Assert.assertEquals((Object)"uniform", (Object)properties.getString(DISTRIBUTION_TYPE));
    }

    @Test
    public void testSimulationCancelEvent() throws Exception {
        JSONObject process = this.loader.loadProcessFromXml("simulationProcess.bpmn2");
        JSONObject cancelEvent = Bpmn2Loader.getChildByName(process, "CancelEvent");
        JSONObject properties = cancelEvent.getJSONObject("properties");
        Assert.assertEquals((long)15L, (long)properties.getInt(PROCESSING_TIME_MAX));
        Assert.assertEquals((long)6L, (long)properties.getInt(PROCESSING_TIME_MIN));
        Assert.assertEquals((Object)"uniform", (Object)properties.getString(DISTRIBUTION_TYPE));
    }

    @Test
    public void testUserTaskAndTaskName() throws Exception {
        JSONObject process = this.loader.loadProcessFromXml("userTaskWithTaskName.bpmn2", BPMN2SyntaxCheckerTest.class, null);
        JSONObject userTask = Bpmn2Loader.getChildByName(process, "User Task");
        JSONObject properties = userTask.getJSONObject("properties");
        Assert.assertEquals((Object)"taskForSomebody", (Object)properties.getString("taskname"));
        Assert.assertEquals((Object)true, (Object)properties.getBoolean("isasync"));
    }

    @Test
    public void testCallActivity() throws Exception {
        JSONObject process = this.loader.loadProcessFromXml("callActivity.bpmn2", BPMN2SyntaxCheckerTest.class, null);
        JSONObject callActivity = Bpmn2Loader.getChildByName(process, "callActivity");
        JSONObject properties = callActivity.getJSONObject("properties");
        Assert.assertEquals((Object)"abc.noCalledElementCallActivity", (Object)properties.getString("calledelement"));
        Assert.assertEquals((Object)true, (Object)properties.getBoolean("isabortparent"));
    }

    @Test
    public void testNoCalledElementCallActivity() throws Exception {
        JSONObject process = this.loader.loadProcessFromXml("noCalledElementCallActivity.bpmn2", BPMN2SyntaxCheckerTest.class, null);
        JSONObject callActivity = Bpmn2Loader.getChildByName(process, "callActivity");
        JSONObject properties = callActivity.getJSONObject("properties");
        Assert.assertFalse((boolean)properties.has("calledelement"));
    }

    @Test
    public void testErrorBoundaryEvent() throws Exception {
        JSONObject process = this.loader.loadProcessFromXml("errorBoundaryEvent.bpmn2", BPMN2SyntaxCheckerTest.class, null);
        JSONObject lane = Bpmn2Loader.getChildByName(process, "myLane");
        JSONObject error = Bpmn2Loader.getChildByName(lane, "MyError");
        JSONObject properties = error.getJSONObject("properties");
        Assert.assertEquals((Object)"errorReference", (Object)properties.getString("errorref"));
    }

    @Test
    public void testErrorBoundaryEventMissingDefinition() throws Exception {
        JSONObject process = this.loader.loadProcessFromXml("errorBoundaryEventMissingDefinition.bpmn2", BPMN2SyntaxCheckerTest.class, null);
        JSONObject lane = Bpmn2Loader.getChildByName(process, "myLane");
        JSONObject error = Bpmn2Loader.getChildByName(lane, "MyError");
        JSONObject properties = error.getJSONObject("properties");
        Assert.assertEquals((Object)"", (Object)properties.getString("errorref"));
    }

    @Test
    public void testServiceTaskInterfaceAndOperation() throws Exception {
        JSONObject process = this.loader.loadProcessFromXml("serviceTaskInterfaceAndOperation.bpmn2");
        JSONObject serviceTask = Bpmn2Loader.getChildByName(process, "Send PO");
        JSONObject properties = serviceTask.getJSONObject("properties");
        Assert.assertEquals((Object)"Java", (Object)properties.getString("serviceimplementation"));
        Assert.assertEquals((Object)"sendInterface", (Object)properties.getString("serviceinterface"));
        Assert.assertEquals((Object)"sendOperation", (Object)properties.getString("serviceoperation"));
        Assert.assertEquals((Object)true, (Object)properties.getBoolean("isasync"));
    }

    @Test
    public void testServiceTaskNoInterfaceNoOperation() throws Exception {
        JSONObject process = this.loader.loadProcessFromXml("serviceTaskNoInterfaceNoOperation.bpmn2");
        JSONObject serviceTask = Bpmn2Loader.getChildByName(process, "Send PO");
        JSONObject properties = serviceTask.getJSONObject("properties");
        Assert.assertEquals((Object)"Java", (Object)properties.getString("serviceimplementation"));
        Assert.assertEquals((Object)"", (Object)properties.getString("serviceinterface"));
        Assert.assertEquals((Object)"", (Object)properties.getString("serviceoperation"));
    }

    @Test
    public void testSubprocessTaskAssignments() throws Exception {
        JSONObject process = this.loader.loadProcessFromXml("subprocessTaskAssignments.bpmn2");
        JSONObject subprocess = Bpmn2Loader.getChildByName(process, "Embedded subprocess");
        JSONObject userTask = Bpmn2Loader.getChildByName(subprocess, "UserTask");
        JSONObject properties = userTask.getJSONObject("properties");
        Assert.assertTrue((boolean)properties.getString("datainputset").contains("sInput:String"));
        Assert.assertTrue((boolean)properties.getString("dataoutputset").contains("iOutput:Integer"));
        JSONObject subprocessProperties = subprocess.getJSONObject("properties");
        Assert.assertEquals((Object)true, (Object)subprocessProperties.getBoolean("isasync"));
    }

    @Test
    public void testEndEventsAssignments() throws Exception {
        JSONObject process = this.loader.loadProcessFromXml("subprocessTaskAssignments.bpmn2");
        JSONObject subprocess = Bpmn2Loader.getChildByName(process, "Embedded subprocess");
        JSONObject subEnd = Bpmn2Loader.getChildByName(subprocess, "SubEnd");
        JSONObject subProperties = subEnd.getJSONObject("properties");
        Assert.assertEquals((Object)"intSubInput:Integer", (Object)subProperties.getString("datainput"));
        Assert.assertEquals((Object)"[din]intVar->intSubInput", (Object)subProperties.getString("datainputassociations"));
        JSONObject endEvent = Bpmn2Loader.getChildByName(process, "End Event");
        JSONObject properties = endEvent.getJSONObject("properties");
        Assert.assertEquals((Object)"intInput:Integer", (Object)properties.getString("datainput"));
        Assert.assertEquals((Object)"[din]intVar->intInput", (Object)properties.getString("datainputassociations"));
    }

    @Test
    public void testBusinessRuleTask() throws Exception {
        JSONObject process = this.loader.loadProcessFromXml("businessRule.bpmn2", BPMN2SyntaxCheckerTest.class, null);
        JSONObject ruleTask = Bpmn2Loader.getChildByName(process, "businessRuleTask");
        JSONObject properties = ruleTask.getJSONObject("properties");
        Assert.assertEquals((Object)"simpleGroup", (Object)properties.getString("ruleflowgroup"));
        Assert.assertEquals((Object)true, (Object)properties.getBoolean("isasync"));
        Assert.assertEquals((Object)"DRL", (Object)properties.getString("rulelanguage"));
    }

    @Test
    public void testReceiveTask() throws Exception {
        JSONObject process = this.loader.loadProcessFromXml("receiveTask.bpmn2");
        JSONObject receiveTask = Bpmn2Loader.getChildByName(process, "receiveTask");
        JSONObject properties = receiveTask.getJSONObject("properties");
        Assert.assertEquals((Object)"parcel", (Object)properties.getString("messageref"));
        Assert.assertEquals((Object)true, (Object)properties.getBoolean("isasync"));
    }

    @Test
    public void testSendTask() throws Exception {
        JSONObject process = this.loader.loadProcessFromXml("sendTask.bpmn2");
        JSONObject sendTask = Bpmn2Loader.getChildByName(process, "sendTask");
        JSONObject properties = sendTask.getJSONObject("properties");
        Assert.assertEquals((Object)"parcel", (Object)properties.getString("messageref"));
        Assert.assertEquals((Object)true, (Object)properties.getBoolean("isasync"));
    }

    @Test
    public void testRestTaskAssignments() throws Exception {
        String[] existingVariableNames = new String[]{"Content", "ContentType", "ResultClass", "Method", "Username", "Password", "ReadTimeout", "ConnectTimeout", "Url"};
        JSONObject process = this.loader.loadProcessFromXml("restTask.bpmn2");
        JSONObject restTask = Bpmn2Loader.getChildByName(process, "REST");
        JSONObject properties = restTask.getJSONObject("properties");
        String datainputset = properties.getString("datainputset");
        String dataoutputset = properties.getString("dataoutputset");
        String assignments = properties.getString("assignments");
        for (String variableName : existingVariableNames) {
            String dataInput = variableName + ":String";
            Assert.assertTrue((String)("Variable \"" + variableName + "\" not found in datainputset"), (boolean)datainputset.contains(dataInput));
        }
        for (String variableName : existingVariableNames) {
            String assignment = "[din]" + variableName + "=";
            Assert.assertTrue((String)("Assignment \"" + assignment + "\" not found in assignments"), (boolean)assignments.contains(assignment));
        }
        Assert.assertTrue((boolean)assignments.contains("[dout]Result->processVariable"));
        Assert.assertTrue((boolean)dataoutputset.contains("Result:java.lang.Object"));
    }

    @Test
    public void testCallActivityAssignments() throws Exception {
        JSONObject process = this.loader.loadProcessFromXml("callActivityInSubprocess.bpmn2");
        JSONObject subProcess = Bpmn2Loader.getChildByName(process, "SubProcess");
        JSONObject callActivity = Bpmn2Loader.getChildByName(subProcess, "callActivity");
        JSONObject properties = callActivity.getJSONObject("properties");
        String datainputset = properties.getString("datainputset");
        String dataoutputset = properties.getString("dataoutputset");
        String assignments = properties.getString("assignments");
        Assert.assertTrue((boolean)assignments.contains("[dout]innerOutput->intVariable"));
        Assert.assertTrue((boolean)assignments.contains("[din]intVariable->innerInput"));
        Assert.assertTrue((boolean)assignments.contains("[din]innerConstant=stringConstant"));
        Assert.assertTrue((boolean)datainputset.contains("innerInput:Integer"));
        Assert.assertTrue((boolean)datainputset.contains("innerConstant:String"));
        Assert.assertTrue((boolean)dataoutputset.contains("innerOutput:Integer"));
    }

    @Test
    public void testProcessCustomProperties() throws Exception {
        JSONObject process = this.loader.loadProcessFromXml("customProperties.bpmn2");
        JSONObject properties = process.getJSONObject("properties");
        String caseIdPrefix = properties.getString("customcaseidprefix");
        String caseRoles = properties.getString("customcaseroles");
        Assert.assertEquals((Object)"HR", (Object)caseIdPrefix);
        Assert.assertEquals((Object)"owner:1,participant:2", (Object)caseRoles);
    }

    @Test
    public void testTaskCustomProperties() throws Exception {
        JSONObject process = this.loader.loadProcessFromXml("customPropertiesTask.bpmn2");
        JSONObject task = Bpmn2Loader.getChildByName(process, "Task_1");
        JSONObject properties = task.getJSONObject("properties");
        String autoStart = properties.getString("customautostart");
        Assert.assertEquals((Object)"true", (Object)autoStart);
    }

    @Test
    public void testOnEntryOnExitActions() throws Exception {
        JSONObject process = this.loader.loadProcessFromXml("onEntryonExitActions.bpmn2");
        JSONObject bcTask = Bpmn2Loader.getChildByName(process, "bc");
        JSONObject properties = bcTask.getJSONObject("properties");
        Assert.assertEquals((Object)"onExit1;\nonExit2;\n", (Object)properties.getString("onexitactions"));
        Assert.assertEquals((Object)"onEntry1;\nonEntry2;\n", (Object)properties.getString("onentryactions"));
    }

    @Test
    public void testOnEntryOnExitActionsEscaping() throws Exception {
        JSONObject process = this.loader.loadProcessFromXml("onEntryonExitActionsEscaping.bpmn2");
        JSONObject task = Bpmn2Loader.getChildByName(process, "task");
        JSONObject properties = task.getJSONObject("properties");
        Assert.assertEquals((Object)"myVariable = \"\\\\\"text in quotes\\\\\"\";\\nSystem.out.println(myVariable);\\n", (Object)properties.getString("onentryactions"));
        Assert.assertEquals((Object)"myVariable = \"\\\\\"another text in quotes\\\\\"\";\\nSystem.out.println(myVariable);\\n", (Object)properties.getString("onexitactions"));
    }

    @Test
    public void testAdHocSubprocessDroolsCompletionCondition() throws Exception {
        JSONObject process = this.loader.loadProcessFromXml("adHocSubprocessCompletionCondition.bpmn2");
        JSONObject adHocSubprocess = Bpmn2Loader.getChildByName(process, "abcde");
        JSONObject properties = adHocSubprocess.getJSONObject("properties");
        String completionCondition = properties.getString("adhoccompletioncondition");
        String scriptLanguage = properties.getString("script_language");
        Assert.assertEquals((Object)"org.kie.api.runtime.process.CaseData(data.get(\"claimReportDone\") == true)", (Object)completionCondition);
        Assert.assertEquals((Object)"drools", (Object)scriptLanguage);
    }

    @Test
    public void testDMNBusinessRuleTask() throws Exception {
        JSONObject process = this.loader.loadProcessFromXml("dmnBusinessRule.bpmn2");
        JSONObject ruleTask = Bpmn2Loader.getChildByName(process, "test");
        JSONObject properties = ruleTask.getJSONObject("properties");
        Assert.assertEquals((Object)"DMN", (Object)properties.getString("rulelanguage"));
    }

    @Test
    public void testCallActivityAbortParent() throws Exception {
        JSONObject process = this.loader.loadProcessFromXml("callActivityAbortParent.bpmn2");
        JSONObject callActivity = Bpmn2Loader.getChildByName(process, "callActivity");
        JSONObject properties = callActivity.getJSONObject("properties");
        Assert.assertEquals((Object)false, (Object)properties.getBoolean("isabortparent"));
    }

    @Test
    public void testCustomWorkitemAssignments() throws Exception {
        List<String> testWorkItemNames = Arrays.asList("SampleUserWorkitem");
        JSONObject process = this.loader.loadProcessFromXml("customWorkitemAssignments.bpmn2", testWorkItemNames);
        JSONObject workitem = Bpmn2Loader.getChildByName(process, "SampleUserWorkitem");
        JSONObject workItemPropertiesProperties = workitem.getJSONObject("properties");
        Assert.assertEquals((Object)"lastNameIn:String,firstNameIn:String", (Object)workItemPropertiesProperties.getString("datainputset"));
        Assert.assertEquals((Object)"lastNameOut:String,firstNameOut:String", (Object)workItemPropertiesProperties.getString("dataoutputset"));
        Assert.assertEquals((Object)"[din]lastName->lastNameIn,[din]firstName->firstNameIn,[dout]lastNameOut->lastName,[dout]firstNameOut->firstName", (Object)workItemPropertiesProperties.getString("assignments"));
    }

    @Test
    public void testBusinessRuleTaskInputOutputSetWithSpacesAndUnderscores() throws Exception {
        JSONObject process = this.loader.loadProcessFromXml("businessRuleTaskWithDataInputsOutputsWithSpaces.bpmn2");
        JSONObject businessRuleTask = Bpmn2Loader.getChildByName(process, "mytask");
        JSONObject businessRuleTaskProperties = businessRuleTask.getJSONObject("properties");
        Assert.assertEquals((Object)"[din]aaa->_first in,[din]bbb->_second in,[din]_third in=123,[dout]_first out->ccc,[dout]_second out->bbb", (Object)businessRuleTaskProperties.getString("assignments"));
        Assert.assertEquals((Object)"_first in:String,_second in:Object,_third in:Integer", (Object)businessRuleTaskProperties.getString("datainputset"));
        Assert.assertEquals((Object)"_first out:String,_second out:Integer", (Object)businessRuleTaskProperties.getString("dataoutputset"));
    }

    @Test
    public void testStartEventOutputSetWithSpacesAndUnderscores() throws Exception {
        JSONObject process = this.loader.loadProcessFromXml("startEventWithDataInputWithSpaces.bpmn2");
        JSONObject startEvent = Bpmn2Loader.getChildByName(process, "abc");
        JSONObject startEventProperties = startEvent.getJSONObject("properties");
        Assert.assertEquals((Object)"_first out:String", (Object)startEventProperties.getString("dataoutput"));
        Assert.assertEquals((Object)"[dout]_first out->aaa", (Object)startEventProperties.getString("dataoutputassociations"));
    }

    @Test
    public void testEndEventOutputSetWithSpacesAndUnderscores() throws Exception {
        JSONObject process = this.loader.loadProcessFromXml("endEventWithDataInputWithSpaces.bpmn2");
        JSONObject endEvent = Bpmn2Loader.getChildByName(process, "abc");
        JSONObject endEventProperties = endEvent.getJSONObject("properties");
        Assert.assertEquals((Object)"_first in:String", (Object)endEventProperties.getString("datainput"));
        Assert.assertEquals((Object)"[din]aaa->_first in", (Object)endEventProperties.getString("datainputassociations"));
    }

    @Test
    public void testCallActivityInputsOutputSetWithSpacesAndUnderscores() throws Exception {
        JSONObject process = this.loader.loadProcessFromXml("callActivityWithDataInputOutputWithSpaces.bpmn2");
        JSONObject callActivity = Bpmn2Loader.getChildByName(process, "abc");
        JSONObject callActivityProperties = callActivity.getJSONObject("properties");
        Assert.assertEquals((Object)"[din]aaa->_first in,[dout]_first out->aaa", (Object)callActivityProperties.getString("assignments"));
        Assert.assertEquals((Object)"_first in:String", (Object)callActivityProperties.getString("datainputset"));
        Assert.assertEquals((Object)"_first out:String", (Object)callActivityProperties.getString("dataoutputset"));
    }

    @Test
    public void testUserTaskInputsOutputSetWithSpacesAndUnderscores() throws Exception {
        JSONObject process = this.loader.loadProcessFromXml("userTaskWithDataInputOutputWithSpaces.bpmn2");
        JSONObject callActivity = Bpmn2Loader.getChildByName(process, "abc");
        JSONObject callActivityProperties = callActivity.getJSONObject("properties");
        Assert.assertEquals((Object)"[din]aaa->_first in,[dout]_first out->bbb", (Object)callActivityProperties.getString("assignments"));
        Assert.assertEquals((Object)"_first in:String", (Object)callActivityProperties.getString("datainputset"));
        Assert.assertEquals((Object)"_first out:String", (Object)callActivityProperties.getString("dataoutputset"));
    }

    @Test
    public void testProcessAndUserTaskWithXMLEscapeChars() throws Exception {
        JSONObject process = this.loader.loadProcessFromXml("usertaskWithXMLEscapeChars.bpmn2");
        JSONObject processProperties = process.getJSONObject("properties");
        String processName = processProperties.getString("processn");
        Assert.assertEquals((Object)"\"'<>&Process", (Object)processName);
        List<JSONObject> userTasks = Bpmn2Loader.getChildByTypeName(process, "Task");
        Assert.assertNotNull(userTasks);
        Assert.assertEquals((long)1L, (long)userTasks.size());
        JSONObject userTask = userTasks.get(0);
        Assert.assertNotNull((Object)userTask);
        JSONObject userTaskProperties = userTask.getJSONObject("properties");
        String userTaskName = userTaskProperties.getString("name");
        Assert.assertEquals((Object)"\"'<>&Task", (Object)userTaskName);
    }

    @Test
    public void testProcessWithEmptyOnEntryOnExitNode() throws Exception {
        JSONObject process = this.loader.loadProcessFromXml("usertaskWithEmptyOnEntryOnExistActions.bpmn2");
        JSONObject processProperties = process.getJSONObject("properties");
        String processName = processProperties.getString("processn");
        Assert.assertEquals((Object)"MyProcess", (Object)processName);
        List<JSONObject> userTasks = Bpmn2Loader.getChildByTypeName(process, "Task");
        Assert.assertNotNull(userTasks);
        Assert.assertEquals((long)1L, (long)userTasks.size());
        JSONObject userTask = userTasks.get(0);
        Assert.assertNotNull((Object)userTask);
        JSONObject userTaskProperties = userTask.getJSONObject("properties");
        String userTaskName = userTaskProperties.getString("name");
        Assert.assertEquals((Object)"MyTask", (Object)userTaskName);
    }

    @Test
    public void testCatchEventDefinitionRef() throws Exception {
        JSONObject process = this.loader.loadProcessFromXml("catchEventDefinitionRef.bpmn2");
        JSONObject processProperties = process.getJSONObject("properties");
        String processName = processProperties.getString("processn");
        Assert.assertEquals((Object)"catchDefinitionRef", (Object)processName);
        JSONObject catchEvent = Bpmn2Loader.getChildByName(process, "mytimer");
        Assert.assertNotNull((Object)catchEvent);
    }

    @Test
    public void testThrowEventDefinitionRef() throws Exception {
        JSONObject process = this.loader.loadProcessFromXml("throwEventDefinitionRef.bpmn2");
        JSONObject processProperties = process.getJSONObject("properties");
        String processName = processProperties.getString("processn");
        Assert.assertEquals((Object)"throwDefinitionRef", (Object)processName);
        JSONObject catchEvent = Bpmn2Loader.getChildByName(process, "mysignalEvent");
        Assert.assertNotNull((Object)catchEvent);
    }

    @Test
    public void testStartEventDefinitionRef() throws Exception {
        JSONObject process = this.loader.loadProcessFromXml("startEventDefinitionRef.bpmn2");
        JSONObject processProperties = process.getJSONObject("properties");
        String processName = processProperties.getString("processn");
        Assert.assertEquals((Object)"startDefinitionRef", (Object)processName);
        JSONObject startEvent = Bpmn2Loader.getChildByName(process, "mytimerstart");
        Assert.assertNotNull((Object)startEvent);
    }

    @Test
    public void testEndEventDefinitionRef() throws Exception {
        JSONObject process = this.loader.loadProcessFromXml("endEventDefinitionRef.bpmn2");
        JSONObject processProperties = process.getJSONObject("properties");
        String processName = processProperties.getString("processn");
        Assert.assertEquals((Object)"endEventDefinitionRef", (Object)processName);
        JSONObject endEvent = Bpmn2Loader.getChildByName(process, "mysignalendEvent");
        Assert.assertNotNull((Object)endEvent);
    }

    @Test
    public void testBoundaryEventDefinitionRef() throws Exception {
        JSONObject process = this.loader.loadProcessFromXml("boundaryEventDefinitionRef.bpmn2");
        JSONObject processProperties = process.getJSONObject("properties");
        String processName = processProperties.getString("processn");
        Assert.assertEquals((Object)"boundaryDefinitionRef", (Object)processName);
        JSONObject endEvent = Bpmn2Loader.getChildByName(process, "myboundarytimer");
        Assert.assertNotNull((Object)endEvent);
    }

    @Test
    public void testMessageRefNodes() throws Exception {
        JSONObject process = this.loader.loadProcessFromXml("messageRefNodes.bpmn2");
        JSONObject startMessageEvent = Bpmn2Loader.getChildByName(process, "start");
        JSONObject startMessageEventProperties = startMessageEvent.getJSONObject("properties");
        Assert.assertEquals((Object)"messageOne", (Object)startMessageEventProperties.getString("messageref"));
        JSONObject sendTask = Bpmn2Loader.getChildByName(process, "send");
        JSONObject sendTaskProperties = sendTask.getJSONObject("properties");
        Assert.assertEquals((Object)"messagetwo", (Object)sendTaskProperties.getString("messageref"));
        JSONObject receiveTask = Bpmn2Loader.getChildByName(process, "receive");
        JSONObject receiveTaskProperties = receiveTask.getJSONObject("properties");
        Assert.assertEquals((Object)"messagethree", (Object)receiveTaskProperties.getString("messageref"));
        JSONObject endMessageEvent = Bpmn2Loader.getChildByName(process, "end");
        JSONObject endMessageEventProperties = endMessageEvent.getJSONObject("properties");
        Assert.assertEquals((Object)"messagefour", (Object)endMessageEventProperties.getString("messageref"));
    }

    @Test
    public void testProcessCustomSlaDueDate() throws Exception {
        JSONObject process = this.loader.loadProcessFromXml("customProperties.bpmn2");
        JSONObject properties = process.getJSONObject("properties");
        String slaDueDate = properties.getString("customsladuedate");
        Assert.assertEquals((Object)"3m", (Object)slaDueDate);
    }

    @Test
    public void testTaskCustomSlaDueDate() throws Exception {
        JSONObject process = this.loader.loadProcessFromXml("customPropertiesTask.bpmn2");
        JSONObject task = Bpmn2Loader.getChildByName(process, "Task_1");
        JSONObject properties = task.getJSONObject("properties");
        String slaDueDate = properties.getString("customsladuedate");
        Assert.assertEquals((Object)"3m", (Object)slaDueDate);
    }

    @Test
    public void testAdHocSubprocessActivationCondition() throws Exception {
        JSONObject process = this.loader.loadProcessFromXml("adHocSubprocessActivationCondition.bpmn2");
        JSONObject adHocSubprocess = Bpmn2Loader.getChildByName(process, "abcde");
        JSONObject properties = adHocSubprocess.getJSONObject("properties");
        String completionCondition = properties.getString("adhocactivationcondition");
        String scriptLanguage = properties.getString("script_language");
        Assert.assertEquals((Object)"org.kie.api.runtime.process.CaseData(data.get(\"Done\") == true)", (Object)completionCondition);
        Assert.assertEquals((Object)"drools", (Object)scriptLanguage);
    }
}

