/*
 * Decompiled with CFR 0.152.
 */
package org.jbpm.designer.taskforms.builder;

import java.io.InputStream;
import org.apache.commons.io.IOUtils;
import org.eclipse.bpmn2.Definitions;
import org.guvnor.common.services.backend.util.CommentedOptionFactory;
import org.jbpm.designer.bpmn2.impl.Bpmn2UnmarshallingTest;
import org.jbpm.designer.bpmn2.utils.Bpmn2Loader;
import org.jbpm.designer.taskforms.builder.BPMNKieWorkbenchFormBuilderService;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;
import org.junit.runner.RunWith;
import org.kie.soup.project.datamodel.commons.util.MVELEvaluator;
import org.kie.soup.project.datamodel.commons.util.RawMVELEvaluator;
import org.kie.workbench.common.forms.commons.shared.layout.FormLayoutTemplateGenerator;
import org.kie.workbench.common.forms.commons.shared.layout.impl.StaticFormLayoutTemplateGenerator;
import org.kie.workbench.common.forms.data.modeller.service.ext.ModelReaderService;
import org.kie.workbench.common.forms.data.modeller.service.impl.ext.dmo.runtime.RuntimeDMOModelReader;
import org.kie.workbench.common.forms.editor.service.backend.FormModelHandlerManager;
import org.kie.workbench.common.forms.editor.service.shared.ModuleFormFinderService;
import org.kie.workbench.common.forms.editor.service.shared.model.FormModelSynchronizationUtil;
import org.kie.workbench.common.forms.editor.service.shared.model.impl.FormModelSynchronizationUtilImpl;
import org.kie.workbench.common.forms.fields.test.TestFieldManager;
import org.kie.workbench.common.forms.fields.test.TestMetaDataEntryManager;
import org.kie.workbench.common.forms.jbpm.model.authoring.process.BusinessProcessFormModel;
import org.kie.workbench.common.forms.jbpm.model.authoring.task.TaskFormModel;
import org.kie.workbench.common.forms.jbpm.server.service.BPMNFormModelGenerator;
import org.kie.workbench.common.forms.jbpm.server.service.formGeneration.BPMNFormGeneratorService;
import org.kie.workbench.common.forms.jbpm.server.service.formGeneration.impl.authoring.BPMNVFSFormDefinitionGeneratorService;
import org.kie.workbench.common.forms.jbpm.server.service.impl.BPMNFormModelGeneratorImpl;
import org.kie.workbench.common.forms.jbpm.server.service.impl.BusinessProcessFormModelHandler;
import org.kie.workbench.common.forms.jbpm.server.service.impl.TaskFormModelHandler;
import org.kie.workbench.common.forms.jbpm.service.shared.BPMFinderService;
import org.kie.workbench.common.forms.model.FormDefinition;
import org.kie.workbench.common.forms.service.shared.FieldManager;
import org.kie.workbench.common.forms.service.shared.meta.processing.MetaDataEntryManager;
import org.kie.workbench.common.forms.services.backend.serialization.FormDefinitionSerializer;
import org.kie.workbench.common.forms.services.backend.serialization.impl.FieldSerializer;
import org.kie.workbench.common.forms.services.backend.serialization.impl.FormDefinitionSerializerImpl;
import org.kie.workbench.common.forms.services.backend.serialization.impl.FormModelSerializer;
import org.kie.workbench.common.services.backend.project.ModuleClassLoaderHelper;
import org.kie.workbench.common.services.shared.project.KieModule;
import org.kie.workbench.common.services.shared.project.KieModuleService;
import org.mockito.Matchers;
import org.mockito.Mock;
import org.mockito.Mockito;
import org.mockito.runners.MockitoJUnitRunner;
import org.uberfire.io.IOService;
import org.uberfire.java.nio.file.Path;

@RunWith(value=MockitoJUnitRunner.class)
public class BPMNKieWorkbenchFormBuilderServiceTest {
    @Mock
    private IOService ioService;
    @Mock
    private org.uberfire.backend.vfs.Path formPath;
    @Mock
    private FormModelHandlerManager formModelHandlerManager;
    @Mock
    private ModelReaderService<org.uberfire.backend.vfs.Path> modelReaderService;
    @Mock
    private ModuleFormFinderService moduleFormFinderService;
    @Mock
    private CommentedOptionFactory commentedOptionFactory;
    private Bpmn2Loader loader = new Bpmn2Loader(Bpmn2UnmarshallingTest.class);
    private Definitions definitions;
    private BPMNKieWorkbenchFormBuilderService builderService;
    @Mock
    private KieModule module;
    @Mock
    private KieModuleService moduleService;
    @Mock
    private ModuleClassLoaderHelper moduleClassLoaderHelper;
    @Mock
    private BPMFinderService bpmFinderService;
    private FieldManager fieldManager = new TestFieldManager();
    private StaticFormLayoutTemplateGenerator formLayoutTemplateGenerator = new StaticFormLayoutTemplateGenerator();
    private FormDefinitionSerializer formSerializer;

    @Before
    public void initTest() throws Exception {
        Mockito.when((Object)((KieModule)this.moduleService.resolveModule((org.uberfire.backend.vfs.Path)Matchers.any()))).thenReturn((Object)this.module);
        Mockito.when((Object)this.moduleClassLoaderHelper.getModuleClassLoader((KieModule)Matchers.any())).thenReturn((Object)this.getClass().getClassLoader());
        Mockito.when((Object)this.formPath.toURI()).thenReturn((Object)"file://fakepath.frm");
        Mockito.when((Object)this.ioService.exists((Path)Matchers.any())).thenReturn((Object)false);
        this.definitions = this.loader.loadProcessFromJson("userTask.json");
        this.formSerializer = new FormDefinitionSerializerImpl(new FieldSerializer(), new FormModelSerializer(), (MetaDataEntryManager)new TestMetaDataEntryManager());
        Mockito.when((Object)this.formModelHandlerManager.getFormModelHandler((Class)Matchers.any())).then(invocationOnMock -> {
            if (BusinessProcessFormModel.class.equals(invocationOnMock.getArguments()[0])) {
                return new BusinessProcessFormModelHandler(this.moduleService, this.moduleClassLoaderHelper, (FieldManager)new TestFieldManager(), this.bpmFinderService);
            }
            return new TaskFormModelHandler(this.moduleService, this.moduleClassLoaderHelper, (FieldManager)new TestFieldManager(), this.bpmFinderService);
        });
        Mockito.when((Object)this.modelReaderService.getModelReader((Object)((org.uberfire.backend.vfs.Path)Matchers.any()))).thenReturn((Object)new RuntimeDMOModelReader(this.getClass().getClassLoader(), (MVELEvaluator)new RawMVELEvaluator()));
        this.builderService = new BPMNKieWorkbenchFormBuilderService(this.ioService, this.formModelHandlerManager, (BPMNFormModelGenerator)new BPMNFormModelGeneratorImpl(this.moduleService, this.moduleClassLoaderHelper), this.formSerializer, (FormLayoutTemplateGenerator)new StaticFormLayoutTemplateGenerator(), (BPMNFormGeneratorService)new BPMNVFSFormDefinitionGeneratorService(this.fieldManager, this.modelReaderService, this.formModelHandlerManager, this.moduleFormFinderService, this.formSerializer, this.ioService, this.commentedOptionFactory, (FormModelSynchronizationUtil)new FormModelSynchronizationUtilImpl(this.fieldManager, (FormLayoutTemplateGenerator)this.formLayoutTemplateGenerator)));
    }

    @Test
    public void testBasicFuncionallities() throws Exception {
        Assert.assertEquals((String)"Form extension must be 'frm'", (Object)"frm", (Object)this.builderService.getFormExtension());
        String formContent = this.builderService.buildEmptyFormContent("fakeName");
        Assert.assertNotNull((String)"Form content must not be null", (Object)formContent);
        FormDefinition form = this.formSerializer.deserialize(formContent);
        Assert.assertNotNull((String)"Form must not be null", (Object)form);
        Assert.assertNull((String)"FormModel must be null", (Object)form.getModel());
        Assert.assertEquals((String)"Form should not have fields", (long)0L, (long)form.getFields().size());
        Assert.assertNotNull((String)"Form layout must not be null", (Object)form.getLayoutTemplate());
    }

    @Test
    public void testCreateNonExistingProcessForm() throws Exception {
        this.testCreateProcessForm(false);
    }

    @Test
    public void testCreateExistingProcessForm() throws Exception {
        this.testCreateProcessForm(true);
    }

    protected void testCreateProcessForm(boolean exists) throws Exception {
        Mockito.when((Object)this.ioService.exists((Path)Matchers.any())).thenReturn((Object)exists);
        Mockito.when((Object)this.ioService.readAllString((Path)Matchers.any())).thenReturn((Object)IOUtils.toString((InputStream)BPMNKieWorkbenchFormBuilderServiceTest.class.getResourceAsStream("processForm.json")));
        String formConent = this.builderService.buildFormContent(this.formPath, this.definitions, null);
        Assert.assertNotNull((String)"Form Content cannot be null", (Object)formConent);
        FormDefinition form = this.formSerializer.deserialize(formConent);
        Assert.assertNotNull((String)"Form cannot be null", (Object)form);
        Assert.assertNotNull((String)"FormModel cannot be null", (Object)form.getModel());
        Assert.assertTrue((String)"FormModel must be a BusinessProcessFormModel", (boolean)(form.getModel() instanceof BusinessProcessFormModel));
        Assert.assertNotNull((String)"Layout must be null", (Object)form.getLayoutTemplate());
    }

    @Test
    public void testCreateNonExistingTaskForm() throws Exception {
        this.testCreateTaskForm(false);
    }

    @Test
    public void testCreateExistingTaskForm() throws Exception {
        this.testCreateTaskForm(true);
    }

    protected void testCreateTaskForm(boolean exists) throws Exception {
        Mockito.when((Object)this.ioService.exists((Path)Matchers.any())).thenReturn((Object)exists);
        Mockito.when((Object)this.ioService.readAllString((Path)Matchers.any())).thenReturn((Object)IOUtils.toString((InputStream)BPMNKieWorkbenchFormBuilderServiceTest.class.getResourceAsStream("taskForm.json")));
        String formConent = this.builderService.buildFormContent(this.formPath, this.definitions, "_E57BCFF4-0787-40FA-83AC-627F06BF8F36");
        Assert.assertNotNull((String)"Form Content cannot be null", (Object)formConent);
        FormDefinition form = this.formSerializer.deserialize(formConent);
        Assert.assertNotNull((String)"Form cannot be null", (Object)form);
        Assert.assertNotNull((String)"FormModel cannot be null", (Object)form.getModel());
        Assert.assertTrue((String)"FormModel must be a TaskFormModel", (boolean)(form.getModel() instanceof TaskFormModel));
        Assert.assertNotNull((String)"Layout must be null", (Object)form.getLayoutTemplate());
    }
}

