/*
 * Decompiled with CFR 0.152.
 */
package org.jbpm.designer.web.server;

import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import javax.servlet.ServletConfig;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import junit.framework.Assert;
import org.jbpm.designer.helper.TestHttpServletRequest;
import org.jbpm.designer.helper.TestHttpServletResponse;
import org.jbpm.designer.helper.TestServletConfig;
import org.jbpm.designer.helper.TestServletContext;
import org.jbpm.designer.repository.Asset;
import org.jbpm.designer.repository.AssetBuilderFactory;
import org.jbpm.designer.repository.Repository;
import org.jbpm.designer.repository.RepositoryBaseTest;
import org.jbpm.designer.repository.UriUtils;
import org.jbpm.designer.repository.impl.AssetBuilder;
import org.jbpm.designer.repository.vfs.VFSRepository;
import org.jbpm.designer.web.profile.IDiagramProfileService;
import org.jbpm.designer.web.server.CalledElementServlet;
import org.junit.After;
import org.junit.Before;
import org.junit.Test;
import org.junit.runner.RunWith;
import org.kie.soup.project.datamodel.oracle.FieldAccessorsAndMutators;
import org.kie.soup.project.datamodel.oracle.ModelField;
import org.kie.soup.project.datamodel.oracle.PackageDataModelOracle;
import org.mockito.InjectMocks;
import org.mockito.Matchers;
import org.mockito.Mock;
import org.mockito.Mockito;
import org.mockito.runners.MockitoJUnitRunner;
import org.mockito.verification.VerificationMode;

@RunWith(value=MockitoJUnitRunner.class)
public class CalledElementServletTest
extends RepositoryBaseTest {
    @Mock
    IDiagramProfileService profileService;
    @InjectMocks
    private CalledElementServlet servlet = (CalledElementServlet)Mockito.spy((Object)new CalledElementServlet());

    @Override
    @Before
    public void setup() {
        super.setup();
        Mockito.when((Object)this.profileService.findProfile((HttpServletRequest)Matchers.any(HttpServletRequest.class), Matchers.anyString())).thenReturn((Object)this.profile);
    }

    @Override
    @After
    public void teardown() {
        super.teardown();
    }

    @Test
    public void testDoPostFindProfile() throws Exception {
        HttpServletRequest request = (HttpServletRequest)Mockito.mock(HttpServletRequest.class);
        try {
            this.servlet.doPost(request, (HttpServletResponse)Mockito.mock(HttpServletResponse.class));
        }
        catch (Exception exception) {
            // empty catch block
        }
        ((IDiagramProfileService)Mockito.verify((Object)this.profileService, (VerificationMode)Mockito.times((int)1))).findProfile(request, "jbpm");
    }

    @Test
    public void testDoPostProfileAlreadySet() throws Exception {
        HttpServletRequest request = (HttpServletRequest)Mockito.mock(HttpServletRequest.class);
        this.servlet.profile = this.profile;
        try {
            this.servlet.doPost(request, (HttpServletResponse)Mockito.mock(HttpServletResponse.class));
        }
        catch (Exception exception) {
            // empty catch block
        }
        ((IDiagramProfileService)Mockito.verify((Object)this.profileService, (VerificationMode)Mockito.never())).findProfile((HttpServletRequest)Matchers.any(HttpServletRequest.class), Matchers.anyString());
    }

    @Test
    public void testGetJavaTypeNames() throws Exception {
        PackageDataModelOracle oracle = (PackageDataModelOracle)Mockito.mock(PackageDataModelOracle.class);
        Mockito.when((Object)oracle.getModulePackageNames()).thenReturn(Arrays.asList("org"));
        ModelField[] modelFields = new ModelField[]{new ModelField("this", "org.Address", ModelField.FIELD_CLASS_TYPE.REGULAR_CLASS, ModelField.FIELD_ORIGIN.SELF, FieldAccessorsAndMutators.ACCESSOR, "this"), new ModelField("street", String.class.getName(), ModelField.FIELD_CLASS_TYPE.REGULAR_CLASS, ModelField.FIELD_ORIGIN.DECLARED, FieldAccessorsAndMutators.BOTH, "String"), new ModelField("homeAddress", Boolean.class.getName(), ModelField.FIELD_CLASS_TYPE.REGULAR_CLASS, ModelField.FIELD_ORIGIN.DECLARED, FieldAccessorsAndMutators.BOTH, "Boolean"), new ModelField("number", Integer.class.getName(), ModelField.FIELD_CLASS_TYPE.REGULAR_CLASS, ModelField.FIELD_ORIGIN.DECLARED, FieldAccessorsAndMutators.BOTH, "Integer")};
        HashMap<String, ModelField[]> fields = new HashMap<String, ModelField[]>();
        fields.put("org.Address", modelFields);
        Mockito.when((Object)oracle.getModuleModelFields()).thenReturn(fields);
        CalledElementServlet servlet = new CalledElementServlet();
        List javatypeNameList = servlet.getJavaTypeNames(oracle);
        Assert.assertNotNull((Object)javatypeNameList);
        Assert.assertEquals((int)1, (int)javatypeNameList.size());
        Assert.assertEquals((String)"org.Address", (String)((String)javatypeNameList.get(0)));
    }

    @Test
    public void testGetProcessInfo() throws Exception {
        VFSRepository repository = new VFSRepository(this.producer.getIoService());
        repository.setDescriptor(this.descriptor);
        this.profile.setRepository((Repository)repository);
        AssetBuilder builder = AssetBuilderFactory.getAssetBuilder((Asset.AssetType)Asset.AssetType.Text);
        builder.content((Object)"<bpmn2:process id=\"com.sample.testprocess1\" drools:packageName=\"com.myteam.myproject\" drools:version=\"1.0\" name=\"Test Process 1\" isExecutable=\"true\"></bpmn2:process>").type("bpmn2").name("testprocess1").location("/defaultPackage");
        repository.createAsset(builder.getAsset());
        builder = AssetBuilderFactory.getAssetBuilder((Asset.AssetType)Asset.AssetType.Text);
        builder.content((Object)"<bpmn2:process id=\"com.sample.testprocess2\" drools:packageName=\"com.myteam.myproject\" drools:version=\"1.0\" name=\"Test Process 2\" isExecutable=\"true\"></bpmn2:process>").type("bpmn2").name("testprocess2").location("/defaultPackage");
        repository.createAsset(builder.getAsset());
        CalledElementServlet servlet = new CalledElementServlet();
        servlet.profile = this.profile;
        HashMap<String, String> params = new HashMap<String, String>();
        params.put("action", "showProcessesInPackage");
        servlet.init((ServletConfig)new TestServletConfig(new TestServletContext((Repository)repository)));
        TestHttpServletResponse response = new TestHttpServletResponse();
        servlet.doPost((HttpServletRequest)new TestHttpServletRequest(params), (HttpServletResponse)response);
        String returnData = new String(response.getContent());
        Assert.assertNotNull((Object)returnData);
        Assert.assertTrue((boolean)returnData.contains("com.sample.testprocess1|/defaultPackage|testprocess1.bpmn2"));
        Assert.assertTrue((boolean)returnData.contains("com.sample.testprocess2|/defaultPackage|testprocess2.bpmn2"));
    }

    @Test
    public void testOpenProcessInTabExtendedChars() throws Exception {
        VFSRepository repository = new VFSRepository(this.producer.getIoService());
        repository.setDescriptor(this.descriptor);
        this.profile.setRepository((Repository)repository);
        AssetBuilder builder = AssetBuilderFactory.getAssetBuilder((Asset.AssetType)Asset.AssetType.Text);
        builder.content((Object)"<bpmn2:process id=\"com.myteam.\u0442\u0435\u0441\u0442\u041f\u0440\u043e\u0446\u0435\u0441\u0441\" drools:packageName=\"com.myteam\" drools:version=\"1.0\" name=\"Test Process 1\" isExecutable=\"true\"></bpmn2:process>").type("bpmn2").name("\u0442\u0435\u0441\u0442\u041f\u0440\u043e\u0446\u0435\u0441\u0441").location("/defaultPackage");
        repository.createAsset(builder.getAsset());
        CalledElementServlet servlet = new CalledElementServlet();
        servlet.profile = this.profile;
        HashMap<String, String> params = new HashMap<String, String>();
        params.put("action", "openprocessintab");
        params.put("pid", "com.myteam.\u0442\u0435\u0441\u0442\u041f\u0440\u043e\u0446\u0435\u0441\u0441");
        servlet.init((ServletConfig)new TestServletConfig(new TestServletContext((Repository)repository)));
        TestHttpServletResponse response = new TestHttpServletResponse();
        servlet.doPost((HttpServletRequest)new TestHttpServletRequest(params), (HttpServletResponse)response);
        String returnData = new String(response.getContent());
        Assert.assertNotNull((Object)returnData);
        Assert.assertTrue((boolean)returnData.contains("\u0442\u0435\u0441\u0442\u041f\u0440\u043e\u0446\u0435\u0441\u0441.bpmn2"));
        Assert.assertTrue((boolean)returnData.contains(UriUtils.encode((String)"\u0442\u0435\u0441\u0442\u041f\u0440\u043e\u0446\u0435\u0441\u0441.bpmn2")));
    }
}

