/*
 * Decompiled with CFR 0.152.
 */
package org.jbpm.designer.uberfire.backend.server.impl;

import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import javax.annotation.PostConstruct;
import javax.enterprise.context.ApplicationScoped;
import javax.inject.Inject;
import javax.inject.Named;
import org.guvnor.structure.organizationalunit.OrganizationalUnitService;
import org.guvnor.structure.repositories.Repository;
import org.guvnor.structure.repositories.RepositoryEnvironmentConfigurations;
import org.guvnor.structure.repositories.RepositoryService;
import org.guvnor.structure.server.config.ConfigGroup;
import org.guvnor.structure.server.config.ConfigType;
import org.guvnor.structure.server.config.ConfigurationFactory;
import org.guvnor.structure.server.config.ConfigurationService;
import org.uberfire.commons.services.cdi.Startup;
import org.uberfire.commons.services.cdi.StartupType;
import org.uberfire.io.IOService;

@ApplicationScoped
@Startup(value=StartupType.BOOTSTRAP)
public class AppSetup {
    private static final String JBPM_REPO_PLAYGROUND = "jbpm-playground";
    private static final String JBPM_URL = "https://github.com/guvnorngtestuser1/jbpm-console-ng-playground-kjar.git";
    private static final String userName = "guvnorngtestuser1";
    private static final String password = "test1234";
    private static final String GLOBAL_SETTINGS = "settings";
    @Inject
    @Named(value="ioStrategy")
    private IOService ioService;
    @Inject
    private RepositoryService repositoryService;
    @Inject
    private OrganizationalUnitService organizationalUnitService;
    @Inject
    private ConfigurationService configurationService;
    @Inject
    private ConfigurationFactory configurationFactory;

    @PostConstruct
    public void onStartup() {
        try {
            Collection groups;
            Repository jbpmRepo = this.repositoryService.getRepository(JBPM_REPO_PLAYGROUND);
            if (jbpmRepo == null) {
                RepositoryEnvironmentConfigurations configurations = new RepositoryEnvironmentConfigurations();
                configurations.setOrigin(JBPM_URL);
                configurations.setUserName(userName);
                configurations.setPassword(password);
                jbpmRepo = this.repositoryService.createRepository("git", JBPM_REPO_PLAYGROUND, configurations);
            }
            if ((groups = this.organizationalUnitService.getOrganizationalUnits()) == null || groups.isEmpty()) {
                ArrayList<Repository> repositories = new ArrayList<Repository>();
                repositories.add(jbpmRepo);
                this.organizationalUnitService.createOrganizationalUnit("demo", "demo@jbpm.org", null, repositories);
            }
            List globalConfigGroups = this.configurationService.getConfiguration(ConfigType.GLOBAL);
            boolean globalSettingsDefined = false;
            for (ConfigGroup globalConfigGroup : globalConfigGroups) {
                if (!GLOBAL_SETTINGS.equals(globalConfigGroup.getName())) continue;
                globalSettingsDefined = true;
                break;
            }
            if (!globalSettingsDefined) {
                this.configurationService.addConfiguration(this.getGlobalConfiguration());
            }
        }
        catch (Exception e) {
            throw new RuntimeException("Error when starting designer " + e.getMessage(), e);
        }
    }

    private ConfigGroup getGlobalConfiguration() {
        ConfigGroup group = this.configurationFactory.newConfigGroup(ConfigType.GLOBAL, GLOBAL_SETTINGS, "");
        group.addConfigItem(this.configurationFactory.newConfigItem("drools.dateformat", "dd-MMM-yyyy"));
        group.addConfigItem(this.configurationFactory.newConfigItem("drools.datetimeformat", "dd-MMM-yyyy hh:mm:ss"));
        group.addConfigItem(this.configurationFactory.newConfigItem("drools.defaultlanguage", "en"));
        group.addConfigItem(this.configurationFactory.newConfigItem("drools.defaultcountry", "US"));
        group.addConfigItem(this.configurationFactory.newConfigItem("build.enable-incremental", "true"));
        group.addConfigItem(this.configurationFactory.newConfigItem("rule-modeller-onlyShowDSLStatements", "false"));
        return group;
    }
}

