    private static final String CONNECTION_FACTORY_NAME = "jms/RemoteConnectionFactory"; // &lt;1&gt;
    private static final String KSESSION_QUEUE_NAME = "jms/queue/KIE.SESSION";
    private static final String TASK_QUEUE_NAME = "jms/queue/KIE.TASK";
    private static final String RESPONSE_QUEUE_NAME = "jms/queue/KIE.RESPONSE"; 

    public void startProcessViaJmsRemoteJavaAPI(String hostname, int jmsConnPort, 
            String deploymentId, String user, String password, 
            String processId) throws NamingException {

        InitialContext remoteInitialContext = getRemoteInitialContext();

        String queueName = KSESSION_QUEUE_NAME;
        Queue sessionQueue = (Queue) remoteInitialContext.lookup(queueName);
        queueName = TASK_QUEUE_NAME;
        Queue taskQueue = (Queue) remoteInitialContext.lookup(queueName);
        queueName = RESPONSE_QUEUE_NAME;
        Queue responseQueue = (Queue) remoteInitialContext.lookup(queueName);

        String connFactoryName = CONNECTION_FACTORY_NAME;
        ConnectionFactory connFact = (ConnectionFactory) remoteInitialContext.lookup(connFactoryName);

        RuntimeEngine engine = RemoteRuntimeEngineFactory.newJmsBuilder()
                .addDeploymentId(deploymentId)
                .addConnectionFactory(connFact) // &lt;2&gt; 
                .addKieSessionQueue(sessionQueue)
                .addTaskServiceQueue(taskQueue)
                .addResponseQueue(responseQueue)
                .addUserName(user)
                .addPassword(password)
                .addHostName(hostname)
                .addJmsConnectorPort(jmsConnPort)
                .disableTaskSecurity() // &lt;3&gt;
                .build();

        // Create KieSession instances and use them
        KieSession ksession = engine.getKieSession();
        
        // Each operation on a KieSession, TaskService or AuditLogService (client) instance 
        // sends a request for the operation to the server side and waits for the response
        // If something goes wrong on the server side, the client will throw an exception. 
        ProcessInstance processInstance = ksession.startProcess(processId);
        long procId = processInstance.getId();
    }    