/*
 * Decompiled with CFR 0.152.
 */
package org.jbpm.event.emitters.elasticsearch;

import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.databind.MapperFeature;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.databind.SerializationFeature;
import java.text.DateFormat;
import java.text.SimpleDateFormat;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import org.jbpm.event.emitters.elasticsearch.DefaultESInstanceViewTransformer;
import org.jbpm.event.emitters.elasticsearch.ESInstanceViewTransformer;
import org.jbpm.event.emitters.elasticsearch.ESInstanceViewTransformerFactory;
import org.jbpm.persistence.api.integration.InstanceView;
import org.jbpm.persistence.api.integration.model.CaseInstanceView;
import org.jbpm.persistence.api.integration.model.ProcessInstanceView;
import org.jbpm.persistence.api.integration.model.TaskInstanceView;
import org.jbpm.persistence.api.integration.model.TaskOperationView;

public class DefaultESInstanceViewTransformerFactory
implements ESInstanceViewTransformerFactory {
    private final String dateFormatStr = System.getProperty("org.jbpm.event.emitters.elasticsearch.date_format", System.getProperty("org.kie.server.json.date_format", "yyyy-MM-dd'T'HH:mm:ss.SSSZ"));
    private final boolean ignoreNull = Boolean.getBoolean("org.jbpm.event.emitters.elasticsearch.ignoreNull");
    protected Map<Class<?>, ESInstanceViewTransformer> viewMapping = new ConcurrentHashMap();

    public DefaultESInstanceViewTransformerFactory() {
        DefaultESInstanceViewTransformer taskView = new DefaultESInstanceViewTransformer("tasks", "task");
        this.viewMapping.put(TaskOperationView.class, taskView);
        this.viewMapping.put(TaskInstanceView.class, taskView);
        this.viewMapping.put(ProcessInstanceView.class, new DefaultESInstanceViewTransformer("processes", "process"));
        this.viewMapping.put(CaseInstanceView.class, new DefaultESInstanceViewTransformer("cases", "case"));
    }

    @Override
    public void configureObjectMapper(ObjectMapper mapper) {
        mapper.setDateFormat((DateFormat)new SimpleDateFormat(this.dateFormatStr));
        mapper.configure(SerializationFeature.WRITE_DATES_AS_TIMESTAMPS, false);
        mapper.configure(MapperFeature.PROPAGATE_TRANSIENT_MARKER, true);
        if (this.ignoreNull) {
            mapper.setSerializationInclusion(JsonInclude.Include.NON_NULL);
        }
    }

    @Override
    public ESInstanceViewTransformer getInstanceViewTransformer(InstanceView<?> view) {
        return this.viewMapping.get(view.getClass());
    }
}

