/*
 * Decompiled with CFR 0.152.
 */
package org.jbpm.examples.checklist.impl;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.jbpm.examples.checklist.ChecklistContext;
import org.jbpm.examples.checklist.ChecklistContextConstraint;
import org.jbpm.examples.checklist.ChecklistItem;
import org.jbpm.examples.checklist.ChecklistManager;
import org.jbpm.examples.checklist.impl.ChecklistItemFactory;
import org.jbpm.examples.checklist.impl.DefaultChecklistContext;
import org.jbpm.runtime.manager.impl.SimpleRuntimeEnvironment;
import org.jbpm.services.task.impl.model.GroupImpl;
import org.jbpm.services.task.impl.model.I18NTextImpl;
import org.jbpm.services.task.impl.model.PeopleAssignmentsImpl;
import org.jbpm.services.task.impl.model.TaskDataImpl;
import org.jbpm.services.task.impl.model.TaskImpl;
import org.jbpm.services.task.impl.model.UserImpl;
import org.kie.api.definition.process.WorkflowProcess;
import org.kie.api.runtime.KieSession;
import org.kie.api.runtime.manager.RuntimeEngine;
import org.kie.api.runtime.manager.RuntimeEnvironment;
import org.kie.api.runtime.manager.RuntimeManager;
import org.kie.api.runtime.process.ProcessInstance;
import org.kie.api.task.TaskService;
import org.kie.api.task.model.OrganizationalEntity;
import org.kie.api.task.model.PeopleAssignments;
import org.kie.api.task.model.Task;
import org.kie.api.task.model.TaskData;
import org.kie.api.task.model.User;
import org.kie.internal.runtime.manager.RuntimeManagerFactory;
import org.kie.internal.runtime.manager.context.EmptyContext;
import org.kie.internal.task.api.InternalTaskService;
import org.kie.internal.task.api.model.InternalPeopleAssignments;
import org.kie.internal.task.api.model.InternalTask;

public class DefaultChecklistManager
implements ChecklistManager {
    private RuntimeManager manager;
    private List<ChecklistContext> contexts = new ArrayList<ChecklistContext>();
    private org.kie.internal.runtime.manager.RuntimeEnvironment environment;

    public DefaultChecklistManager(org.kie.internal.runtime.manager.RuntimeEnvironment environment) {
        this.environment = environment;
    }

    @Override
    public List<ChecklistContext> getContexts() {
        return this.contexts;
    }

    @Override
    public long createContext(String name, String userId) {
        RuntimeEngine runtime = this.getRuntime();
        HashMap<String, String> params = new HashMap<String, String>();
        params.put("startUser", userId);
        ProcessInstance processInstance = runtime.getKieSession().startProcess(name == null ? "org.jbpm.examples.checklist.AdHocProcess" : name, params);
        this.manager.disposeRuntimeEngine(runtime);
        DefaultChecklistContext context = new DefaultChecklistContext();
        this.contexts.add(context);
        return processInstance.getId();
    }

    @Override
    public List<ChecklistItem> getTasks(long processInstanceId, List<ChecklistContextConstraint> contexts) {
        List<ChecklistItem> items = this.getTasks(processInstanceId);
        ArrayList<ChecklistItem> results = new ArrayList<ChecklistItem>();
        for (ChecklistItem item : items) {
            if (contexts != null) {
                for (ChecklistContextConstraint context : contexts) {
                    if (!context.acceptsTask(item)) break;
                }
            }
            results.add(item);
        }
        return results;
    }

    public List<ChecklistItem> getTasks(long processInstanceId) {
        RuntimeEngine runtime = this.getRuntime();
        KieSession ksession = runtime.getKieSession();
        ProcessInstance processInstance = ksession.getProcessInstance(processInstanceId);
        HashMap<String, ChecklistItem> orderingIds = new HashMap<String, ChecklistItem>();
        if (processInstance != null) {
            WorkflowProcess process = (WorkflowProcess)ksession.getKieBase().getProcess(processInstance.getProcessId());
            Collection<ChecklistItem> result = ChecklistItemFactory.getPendingChecklistItems(process);
            result.addAll(ChecklistItemFactory.getLoggedChecklistItems(processInstance.getId(), process));
            for (ChecklistItem item : result) {
                if (item.getOrderingNb() == null || item.getOrderingNb().trim().length() <= 0) continue;
                orderingIds.put(item.getOrderingNb(), item);
            }
        }
        TaskService taskService = runtime.getTaskService();
        List taskIds = taskService.getTasksByProcessInstanceId(processInstanceId);
        ArrayList<ChecklistItem> result = new ArrayList<ChecklistItem>();
        for (Long taskId : taskIds) {
            Task task = taskService.getTaskById(taskId.longValue());
            if (task == null) continue;
            ChecklistItem item = ChecklistItemFactory.createChecklistItem(task);
            if (item.getOrderingNb() != null) {
                orderingIds.put(item.getOrderingNb(), item);
                continue;
            }
            result.add(item);
        }
        for (ChecklistItem item : orderingIds.values()) {
            result.add(item);
        }
        Collections.sort(result, new Comparator<ChecklistItem>(){

            @Override
            public int compare(ChecklistItem o1, ChecklistItem o2) {
                if (o1.getOrderingNb() != null && o2.getOrderingNb() != null) {
                    return o1.getOrderingNb().compareTo(o2.getOrderingNb());
                }
                if (o1.getTaskId() != null && o2.getTaskId() != null) {
                    return o1.getTaskId().compareTo(o2.getTaskId());
                }
                throw new IllegalArgumentException();
            }
        });
        this.manager.disposeRuntimeEngine(runtime);
        return result;
    }

    @Override
    public ChecklistItem addTask(String userId, String[] actorIds, String[] groupIds, String name, String orderingId, long processInstanceId) {
        RuntimeEngine runtime = this.getRuntime();
        TaskImpl task = new TaskImpl();
        this.setTaskName((InternalTask)task, name);
        this.setTaskDescription((InternalTask)task, orderingId);
        TaskDataImpl taskData = new TaskDataImpl();
        taskData.setProcessInstanceId(processInstanceId);
        taskData.setSkipable(false);
        taskData.setCreatedBy((User)new UserImpl(userId));
        task.setTaskData((TaskData)taskData);
        InternalPeopleAssignments peopleAssignments = (InternalPeopleAssignments)task.getPeopleAssignments();
        if (peopleAssignments == null) {
            peopleAssignments = new PeopleAssignmentsImpl();
            peopleAssignments.setPotentialOwners(new ArrayList());
            peopleAssignments.setBusinessAdministrators(new ArrayList());
            peopleAssignments.setExcludedOwners(new ArrayList());
            peopleAssignments.setRecipients(new ArrayList());
            peopleAssignments.setTaskStakeholders(new ArrayList());
            task.setPeopleAssignments((PeopleAssignments)peopleAssignments);
        }
        ArrayList<OrganizationalEntity> potentialOwners = new ArrayList<OrganizationalEntity>();
        for (String actorId : actorIds) {
            potentialOwners.add((OrganizationalEntity)new UserImpl(actorId));
        }
        for (String groupId : groupIds) {
            potentialOwners.add((OrganizationalEntity)new GroupImpl(groupId));
        }
        this.setTaskPotentialOwners((Task)task, potentialOwners);
        List businessAdministrators = peopleAssignments.getBusinessAdministrators();
        businessAdministrators.add(new UserImpl("Administrator"));
        TaskService taskService = runtime.getTaskService();
        long taskId = taskService.addTask((Task)task, (Map)null);
        this.manager.disposeRuntimeEngine(runtime);
        return ChecklistItemFactory.createChecklistItem(taskService.getTaskById(taskId));
    }

    @Override
    public void updateTaskName(long taskId, String name) {
        RuntimeEngine runtime = this.getRuntime();
        ArrayList<I18NTextImpl> names = new ArrayList<I18NTextImpl>();
        names.add(new I18NTextImpl("en-UK", name));
        ((InternalTaskService)runtime.getTaskService()).setTaskNames(taskId, names);
        this.manager.disposeRuntimeEngine(runtime);
    }

    private void setTaskName(InternalTask task, String name) {
        ArrayList<I18NTextImpl> names = new ArrayList<I18NTextImpl>();
        names.add(new I18NTextImpl("en-UK", name));
        task.setNames(names);
        ArrayList<I18NTextImpl> subjects = new ArrayList<I18NTextImpl>();
        subjects.add(new I18NTextImpl("en-UK", name));
        task.setSubjects(subjects);
    }

    @Override
    public void updateTaskDescription(long taskId, String description) {
        RuntimeEngine runtime = this.getRuntime();
        ArrayList<I18NTextImpl> descriptions = new ArrayList<I18NTextImpl>();
        descriptions.add(new I18NTextImpl("en-UK", description));
        ((InternalTaskService)runtime.getTaskService()).setDescriptions(taskId, descriptions);
        this.manager.disposeRuntimeEngine(runtime);
    }

    private void setTaskDescription(InternalTask task, String description) {
        ArrayList<I18NTextImpl> descriptions = new ArrayList<I18NTextImpl>();
        descriptions.add(new I18NTextImpl("en-UK", description));
        task.setDescriptions(descriptions);
    }

    @Override
    public void updateTaskPriority(long taskId, int priority) {
        RuntimeEngine runtime = this.getRuntime();
        ((InternalTaskService)runtime.getTaskService()).setPriority(taskId, priority);
        this.manager.disposeRuntimeEngine(runtime);
    }

    @Override
    public void updateTaskPotentialOwners(long taskId, List<OrganizationalEntity> potentialOwners) {
    }

    private void setTaskPotentialOwners(Task task, List<OrganizationalEntity> potentialOwners) {
        ((InternalPeopleAssignments)task.getPeopleAssignments()).setPotentialOwners(potentialOwners);
    }

    @Override
    public void claimTask(String userId, long taskId) {
        RuntimeEngine runtime = this.getRuntime();
        runtime.getTaskService().claim(taskId, userId);
        this.manager.disposeRuntimeEngine(runtime);
    }

    @Override
    public void releaseTask(String userId, long taskId) {
        RuntimeEngine runtime = this.getRuntime();
        runtime.getTaskService().release(taskId, userId);
        this.manager.disposeRuntimeEngine(runtime);
    }

    @Override
    public void completeTask(String userId, long taskId) {
        RuntimeEngine runtime = this.getRuntime();
        runtime.getTaskService().start(taskId, userId);
        runtime.getTaskService().complete(taskId, userId, null);
        this.manager.disposeRuntimeEngine(runtime);
    }

    @Override
    public void abortTask(String userId, long taskId) {
        RuntimeEngine runtime = this.getRuntime();
        runtime.getTaskService().start(taskId, userId);
        runtime.getTaskService().fail(taskId, userId, null);
        this.manager.disposeRuntimeEngine(runtime);
    }

    @Override
    public void selectOptionalTask(String taskName, long processInstanceId) {
        RuntimeEngine runtime = this.getRuntime();
        runtime.getKieSession().signalEvent(taskName, null, processInstanceId);
        this.manager.disposeRuntimeEngine(runtime);
    }

    protected RuntimeEngine getRuntime() {
        if (this.manager == null) {
            if (this.environment == null) {
                this.environment = new SimpleRuntimeEnvironment();
            }
            this.manager = RuntimeManagerFactory.Factory.get().newSingletonRuntimeManager((RuntimeEnvironment)this.environment);
        }
        return this.manager.getRuntimeEngine(EmptyContext.get());
    }
}

