/*
 * Decompiled with CFR 0.152.
 */
package org.jbpm.examples.evaluation;

import java.util.HashMap;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.jbpm.process.workitem.wsht.hornetq.HornetQHTWorkItemHandler;
import org.kie.api.io.ResourceType;
import org.kie.api.runtime.process.WorkItemHandler;
import org.kie.internal.KnowledgeBase;
import org.kie.internal.builder.KnowledgeBuilder;
import org.kie.internal.builder.KnowledgeBuilderFactory;
import org.kie.internal.event.KnowledgeRuntimeEventManager;
import org.kie.internal.io.ResourceFactory;
import org.kie.internal.logger.KnowledgeRuntimeLogger;
import org.kie.internal.logger.KnowledgeRuntimeLoggerFactory;
import org.kie.internal.runtime.KnowledgeRuntime;
import org.kie.internal.runtime.StatefulKnowledgeSession;

public class EvaluationExample {
    public static final void main(String[] args) {
        try {
            KnowledgeBase kbase = EvaluationExample.readKnowledgeBase();
            StatefulKnowledgeSession ksession = kbase.newStatefulKnowledgeSession();
            final KnowledgeRuntimeLogger logger = KnowledgeRuntimeLoggerFactory.newThreadedFileLogger((KnowledgeRuntimeEventManager)ksession, (String)"test", (int)1000);
            final HornetQHTWorkItemHandler hornetQHTWorkItemHandler = new HornetQHTWorkItemHandler((KnowledgeRuntime)ksession);
            Runtime.getRuntime().addShutdownHook(new Thread(){

                @Override
                public void run() {
                    if (logger != null) {
                        try {
                            hornetQHTWorkItemHandler.dispose();
                        }
                        catch (Exception ex) {
                            Logger.getLogger(EvaluationExample.class.getName()).log(Level.SEVERE, null, ex);
                        }
                        logger.close();
                        System.exit(0);
                    }
                }
            });
            ksession.getWorkItemManager().registerWorkItemHandler("Human Task", (WorkItemHandler)hornetQHTWorkItemHandler);
            HashMap<String, String> params = new HashMap<String, String>();
            params.put("employee", "krisv");
            params.put("reason", "Yearly performance evaluation");
            ksession.startProcess("com.sample.evaluation", params);
        }
        catch (Throwable t) {
            t.printStackTrace();
        }
    }

    private static KnowledgeBase readKnowledgeBase() throws Exception {
        KnowledgeBuilder kbuilder = KnowledgeBuilderFactory.newKnowledgeBuilder();
        kbuilder.add(ResourceFactory.newClassPathResource((String)"evaluation/Evaluation.bpmn"), ResourceType.BPMN2);
        return kbuilder.newKnowledgeBase();
    }
}

