/*
 * Decompiled with CFR 0.152.
 */
package org.jbpm.examples.checklist.impl;

import java.util.ArrayList;
import java.util.List;
import org.drools.core.process.core.Work;
import org.jbpm.examples.checklist.ChecklistItem;
import org.jbpm.examples.checklist.impl.DefaultChecklistItem;
import org.jbpm.workflow.core.node.HumanTaskNode;
import org.kie.api.definition.process.Node;
import org.kie.api.definition.process.NodeContainer;
import org.kie.api.definition.process.WorkflowProcess;
import org.kie.api.task.model.I18NText;
import org.kie.api.task.model.OrganizationalEntity;
import org.kie.api.task.model.Status;
import org.kie.api.task.model.Task;
import org.kie.api.task.model.User;

public final class ChecklistItemFactory {
    public static ChecklistItem createChecklistItem(Task task) {
        return new DefaultChecklistItem(ChecklistItemFactory.getText(task.getNames()), ChecklistItemFactory.getStatus(task.getTaskData().getStatus()), task.getId(), ChecklistItemFactory.getActors(task), task.getPriority(), task.getTaskData().getProcessId(), task.getTaskData().getProcessInstanceId(), ChecklistItemFactory.getText(task.getDescriptions()));
    }

    private static String getText(List<I18NText> texts) {
        if (texts == null) {
            return null;
        }
        for (I18NText text : texts) {
            if (!"en-UK".equals(text.getLanguage())) continue;
            return text.getText();
        }
        return null;
    }

    private static ChecklistItem.Status getStatus(Status status) {
        switch (status) {
            case Completed: {
                return ChecklistItem.Status.Completed;
            }
            case Ready: 
            case Created: {
                return ChecklistItem.Status.Created;
            }
            case Error: 
            case Exited: 
            case Failed: 
            case Obsolete: {
                return ChecklistItem.Status.Aborted;
            }
            case Suspended: 
            case InProgress: {
                return ChecklistItem.Status.InProgress;
            }
            case Reserved: {
                return ChecklistItem.Status.Reserved;
            }
        }
        return null;
    }

    private static String getActors(Task task) {
        User actualOwner = task.getTaskData().getActualOwner();
        if (actualOwner != null) {
            return actualOwner.getId();
        }
        String result = "";
        for (OrganizationalEntity o : task.getPeopleAssignments().getPotentialOwners()) {
            if (result.length() != 0) {
                result = result + ",";
            }
            result = result + o.getId();
        }
        return result;
    }

    public static List<ChecklistItem> getPendingChecklistItems(WorkflowProcess process) {
        ArrayList<ChecklistItem> result = new ArrayList<ChecklistItem>();
        ChecklistItemFactory.getPendingChecklistItems((NodeContainer)process, result, process.getId());
        return result;
    }

    private static void getPendingChecklistItems(NodeContainer container, List<ChecklistItem> result, String processId) {
        for (Node node : container.getNodes()) {
            if (node instanceof HumanTaskNode) {
                String groupId;
                String actorId;
                Work workItem = ((HumanTaskNode)node).getWork();
                int priority = 0;
                String priorityString = (String)workItem.getParameter("Priority");
                if (priorityString != null) {
                    try {
                        priority = new Integer(priorityString);
                    }
                    catch (NumberFormatException e) {
                        // empty catch block
                    }
                }
                if ((actorId = (String)workItem.getParameter("ActorId")) != null && actorId.trim().length() == 0) {
                    actorId = null;
                }
                if ((groupId = (String)workItem.getParameter("GroupId")) != null && groupId.trim().length() == 0) {
                    groupId = null;
                }
                String actors = null;
                actors = actorId == null ? (groupId == null ? "" : groupId) : (groupId == null ? actorId : actorId + "," + groupId);
                result.add(ChecklistItemFactory.createPendingChecklistItem((String)workItem.getParameter("TaskName"), actors, (String)workItem.getParameter("Comment"), priority, processId));
                continue;
            }
            if (!(node instanceof NodeContainer)) continue;
            ChecklistItemFactory.getPendingChecklistItems((NodeContainer)node, result, processId);
        }
    }

    private static ChecklistItem createPendingChecklistItem(String name, String actors, String orderingNb, long priority, String processId) {
        return new DefaultChecklistItem(name == null ? "" : name, ChecklistItem.Status.Pending, null, actors == null ? "" : actors, priority, processId, null, orderingNb);
    }
}

