/*
 * Decompiled with CFR 0.152.
 */
package org.jbpm.examples.checklist.impl;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.KeyEvent;
import java.awt.event.KeyListener;
import java.util.ArrayList;
import java.util.List;
import javax.swing.DefaultComboBoxModel;
import javax.swing.ImageIcon;
import javax.swing.JButton;
import javax.swing.JComboBox;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JTable;
import javax.swing.JTextField;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;
import javax.swing.table.DefaultTableCellRenderer;
import javax.swing.table.DefaultTableModel;
import org.jbpm.examples.checklist.ChecklistContextConstraint;
import org.jbpm.examples.checklist.ChecklistItem;
import org.jbpm.examples.checklist.ChecklistManager;
import org.jbpm.examples.checklist.impl.CreateItemDialog;
import org.jbpm.examples.checklist.impl.DefaultChecklistManager;
import org.jbpm.test.JBPMHelper;
import org.kie.api.KieServices;
import org.kie.api.io.ResourceType;
import org.kie.api.runtime.manager.RuntimeEnvironment;
import org.kie.api.runtime.manager.RuntimeEnvironmentBuilder;
import org.kie.api.task.UserGroupCallback;

public class ChecklistUI
extends JFrame {
    private static final long serialVersionUID = 510L;
    private static ImageIcon[] ICONS = new ImageIcon[]{new ImageIcon(ChecklistUI.class.getResource("/checklist/status/check32.png")), new ImageIcon(ChecklistUI.class.getResource("/checklist/status/inprogress32.png")), new ImageIcon(ChecklistUI.class.getResource("/checklist/status/abort32.png")), new ImageIcon(ChecklistUI.class.getResource("/checklist/status/optional32.png"))};
    private static ImageIcon[] TYPE_ICONS = new ImageIcon[]{new ImageIcon(ChecklistUI.class.getResource("/checklist/type/UserTask.png")), new ImageIcon(ChecklistUI.class.getResource("/checklist/type/ScriptTask.png")), new ImageIcon(ChecklistUI.class.getResource("/checklist/type/CallActivity.png")), new ImageIcon(ChecklistUI.class.getResource("/checklist/type/ServiceTask.png"))};
    private ChecklistManager checklistManager;
    List<ChecklistItem> items = null;
    private JComboBox contexts;
    private JTable itemTable;
    private JTextField userNameTextField;
    private boolean ctrl = false;

    public ChecklistUI() {
        this.setSize(new Dimension(450, 350));
        this.setTitle("Checklist");
        this.setDefaultCloseOperation(3);
        this.initializeComponent();
        JBPMHelper.startH2Server();
        JBPMHelper.setupDataSource();
        RuntimeEnvironment environment = RuntimeEnvironmentBuilder.Factory.get().newDefaultBuilder().userGroupCallback(new UserGroupCallback(){

            public List<String> getGroupsForUser(String userId, List<String> groupIds, List<String> allExistingGroupIds) {
                ArrayList<String> result = new ArrayList<String>();
                if ("actor4".equals(userId)) {
                    result.add("group1");
                } else if ("krisv".equals(userId)) {
                    result.add("employee");
                } else if ("john".equals(userId)) {
                    result.add("manager");
                }
                return result;
            }

            public boolean existsUser(String arg0) {
                return true;
            }

            public boolean existsGroup(String arg0) {
                return true;
            }
        }).addAsset(KieServices.Factory.get().getResources().newClassPathResource("checklist/SampleChecklistProcess.bpmn"), ResourceType.BPMN2).addAsset(KieServices.Factory.get().getResources().newClassPathResource("checklist/AdHocProcess.bpmn"), ResourceType.BPMN2).addAsset(KieServices.Factory.get().getResources().newClassPathResource("checklist/travel.bpmn"), ResourceType.BPMN2).addAsset(KieServices.Factory.get().getResources().newClassPathResource("checklist/expenses.bpmn"), ResourceType.BPMN2).get();
        this.checklistManager = new DefaultChecklistManager(environment);
    }

    private void initializeComponent() {
        JPanel panel = new JPanel();
        panel.setLayout(new GridBagLayout());
        this.getRootPane().setLayout(new BorderLayout());
        this.getRootPane().add((Component)panel, "Center");
        JButton createButton = new JButton("New...");
        createButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent event) {
                ChecklistUI.this.create();
            }
        });
        GridBagConstraints c = new GridBagConstraints();
        c.insets = new Insets(5, 5, 5, 5);
        c.anchor = 17;
        panel.add((Component)createButton, c);
        this.contexts = new JComboBox(new DefaultComboBoxModel());
        this.contexts.setPreferredSize(new Dimension(80, 24));
        this.contexts.setSize(new Dimension(80, 24));
        c = new GridBagConstraints();
        c.weightx = 1.0;
        c.anchor = 13;
        c.fill = 2;
        c.insets = new Insets(5, 5, 5, 5);
        panel.add((Component)this.contexts, c);
        this.contexts.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                ChecklistUI.this.refresh();
            }
        });
        JButton refreshButton = new JButton("Refresh");
        refreshButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent event) {
                ChecklistUI.this.refresh();
            }
        });
        c = new GridBagConstraints();
        c.insets = new Insets(5, 5, 5, 5);
        panel.add((Component)refreshButton, c);
        this.itemTable = new JTable(1, 6);
        this.itemTable.setRowHeight(35);
        this.itemTable.setShowHorizontalLines(false);
        this.itemTable.setShowVerticalLines(false);
        this.itemTable.addKeyListener(new KeyListener(){

            @Override
            public void keyTyped(KeyEvent e) {
            }

            @Override
            public void keyReleased(KeyEvent e) {
                ChecklistUI.this.ctrl = false;
            }

            @Override
            public void keyPressed(KeyEvent e) {
                if (e.isControlDown()) {
                    ChecklistUI.this.ctrl = true;
                }
            }
        });
        this.itemTable.getSelectionModel().addListSelectionListener(new ListSelectionListener(){

            @Override
            public void valueChanged(ListSelectionEvent e) {
                int index = e.getFirstIndex();
                if (index >= 0 && index < ChecklistUI.this.items.size()) {
                    ChecklistItem item = ChecklistUI.this.items.get(index);
                    if (item.getStatus() == ChecklistItem.Status.Created) {
                        String actorId = ChecklistUI.this.getActorId();
                        try {
                            ChecklistUI.this.checklistManager.claimTask(actorId, item.getTaskId());
                            if (ChecklistUI.this.ctrl) {
                                ChecklistUI.this.checklistManager.abortTask(actorId, item.getTaskId());
                            } else {
                                ChecklistUI.this.checklistManager.completeTask(actorId, item.getTaskId());
                            }
                        }
                        catch (Throwable throwable) {
                            // empty catch block
                        }
                        ChecklistUI.this.refresh();
                    } else if (item.getStatus() == ChecklistItem.Status.Reserved) {
                        String actorId = ChecklistUI.this.getActorId();
                        if (item.getActors().equals(actorId)) {
                            try {
                                if (ChecklistUI.this.ctrl) {
                                    ChecklistUI.this.checklistManager.abortTask(actorId, item.getTaskId());
                                } else {
                                    ChecklistUI.this.checklistManager.completeTask(actorId, item.getTaskId());
                                }
                            }
                            catch (Throwable throwable) {
                                // empty catch block
                            }
                            ChecklistUI.this.refresh();
                        }
                    } else if (item.getStatus() == ChecklistItem.Status.Optional) {
                        try {
                            ChecklistUI.this.checklistManager.selectOptionalTask(item.getName(), Long.valueOf((String)ChecklistUI.this.contexts.getSelectedItem()));
                        }
                        catch (Throwable t) {
                            t.printStackTrace();
                        }
                        ChecklistUI.this.refresh();
                    }
                }
            }
        });
        c = new GridBagConstraints();
        c.gridy = 1;
        c.weightx = 1.0;
        c.weighty = 1.0;
        c.gridwidth = 3;
        c.fill = 1;
        c.insets = new Insets(5, 5, 5, 5);
        panel.add((Component)this.itemTable, c);
        JLabel nameLabel = new JLabel("Logged in as:");
        c = new GridBagConstraints();
        c.gridy = 2;
        c.insets = new Insets(5, 5, 5, 5);
        c.anchor = 17;
        panel.add((Component)nameLabel, c);
        this.userNameTextField = new JTextField("krisv");
        this.userNameTextField.setPreferredSize(new Dimension(80, 20));
        this.userNameTextField.setSize(new Dimension(80, 20));
        c = new GridBagConstraints();
        c.gridy = 2;
        c.fill = 1;
        c.weightx = 1.0;
        c.insets = new Insets(5, 5, 5, 5);
        c.anchor = 17;
        panel.add((Component)this.userNameTextField, c);
        JButton createItemButton = new JButton("+");
        createItemButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent event) {
                ChecklistUI.this.createNewItem();
            }
        });
        c = new GridBagConstraints();
        c.gridy = 2;
        c.insets = new Insets(5, 5, 5, 5);
        c.anchor = 13;
        panel.add((Component)createItemButton, c);
        panel.doLayout();
    }

    private String getActorId() {
        return this.userNameTextField.getText();
    }

    private void refresh() {
        Long processInstanceId = this.getSelectedProcessInstance();
        if (processInstanceId != null) {
            List<ChecklistContextConstraint> contexts = null;
            this.items = this.checklistManager.getTasks(processInstanceId, contexts);
        } else {
            this.items = new ArrayList<ChecklistItem>();
        }
        DefaultTableModel tableModel = new DefaultTableModel(this.items.size(), 5);
        for (int i = 0; i < this.items.size(); ++i) {
            ChecklistItem item = this.items.get(i);
            String orderingNb = item.getOrderingNb();
            if (orderingNb == null) {
                orderingNb = "";
            } else if (orderingNb.endsWith("+")) {
                orderingNb = "*";
            }
            tableModel.setValueAt((Object)item.getStatus(), i, 0);
            tableModel.setValueAt("(" + orderingNb + ")", i, 1);
            tableModel.setValueAt(item.getName(), i, 2);
            tableModel.setValueAt(item.getType(), i, 3);
            tableModel.setValueAt(item.getActors(), i, 4);
        }
        this.itemTable.setModel(tableModel);
        this.itemTable.getColumnModel().getColumn(0).setCellRenderer(new DefaultTableCellRenderer(){
            private static final long serialVersionUID = 6L;

            @Override
            public Component getTableCellRendererComponent(JTable table, Object value, boolean isSelected, boolean hasFocus, int row, int column) {
                super.getTableCellRendererComponent(table, value, isSelected, hasFocus, row, column);
                JLabel label = new JLabel();
                if (value != null) {
                    label.setHorizontalAlignment(0);
                    switch ((ChecklistItem.Status)((Object)value)) {
                        case Completed: {
                            label.setIcon(ICONS[0]);
                            break;
                        }
                        case Aborted: {
                            label.setIcon(ICONS[2]);
                            break;
                        }
                        case InProgress: {
                            label.setIcon(ICONS[1]);
                            break;
                        }
                        case Created: {
                            label.setIcon(ICONS[1]);
                            break;
                        }
                        case Reserved: {
                            label.setIcon(ICONS[1]);
                            break;
                        }
                        case Ready: {
                            label.setIcon(ICONS[1]);
                            break;
                        }
                        case Optional: {
                            label.setIcon(ICONS[3]);
                            break;
                        }
                        case Pending: {
                            break;
                        }
                    }
                }
                return label;
            }
        });
        this.itemTable.getColumnModel().getColumn(3).setCellRenderer(new DefaultTableCellRenderer(){
            private static final long serialVersionUID = 6L;

            @Override
            public Component getTableCellRendererComponent(JTable table, Object value, boolean isSelected, boolean hasFocus, int row, int column) {
                super.getTableCellRendererComponent(table, value, isSelected, hasFocus, row, column);
                JLabel label = new JLabel();
                label.setHorizontalAlignment(0);
                if (value != null) {
                    String s = (String)value;
                    if ("HumanTaskNode".equals(s)) {
                        label.setIcon(TYPE_ICONS[0]);
                    } else if ("ActionNode".equals(s)) {
                        label.setIcon(TYPE_ICONS[1]);
                    } else if ("SubProcessNode".equals(s)) {
                        label.setIcon(TYPE_ICONS[2]);
                    } else if ("WorkItemNode".equals(s)) {
                        label.setIcon(TYPE_ICONS[3]);
                    }
                }
                return label;
            }
        });
        this.itemTable.getColumnModel().getColumn(0).setPreferredWidth(32);
        this.itemTable.getColumnModel().getColumn(0).setMaxWidth(32);
        this.itemTable.getColumnModel().getColumn(1).setPreferredWidth(40);
        this.itemTable.getColumnModel().getColumn(2).setPreferredWidth(230);
        this.itemTable.getColumnModel().getColumn(3).setPreferredWidth(32);
        this.itemTable.getColumnModel().getColumn(3).setMaxWidth(32);
        this.itemTable.getColumnModel().getColumn(4).setPreferredWidth(120);
    }

    private void create() {
        String s = (String)JOptionPane.showInputDialog(this, "Select Checklist Template:", "Select Template", -1, null, new Object[]{"None", "Business Trip", "Sample1"}, "None");
        if (s == null) {
            return;
        }
        String processId = null;
        if ("Sample1".equals(s)) {
            processId = "org.jbpm.examples.checklist.sample1";
        } else if ("Business Trip".equals(s)) {
            processId = "org.jbpm.examples.checklist.travel";
        }
        long processInstanceId = this.checklistManager.createContext(processId, this.getActorId());
        String contextName = processInstanceId + "";
        this.contexts.addItem(contextName);
        this.contexts.setSelectedItem(contextName);
        this.refresh();
    }

    private Long getSelectedProcessInstance() {
        Object selected = this.contexts.getSelectedItem();
        if (selected != null) {
            try {
                return new Long((String)selected);
            }
            catch (NumberFormatException numberFormatException) {
                // empty catch block
            }
        }
        return null;
    }

    private void createNewItem() {
        if (this.getSelectedProcessInstance() != null) {
            CreateItemDialog dialog = new CreateItemDialog(this, this.getActorId());
            dialog.setVisible(true);
            String name = dialog.getItemName();
            if (name != null) {
                ChecklistItem item = this.getSelectedItem();
                String orderingNb = null;
                orderingNb = item != null ? item.getOrderingNb() + "+" : (this.items.size() == 0 ? "1+" : this.items.get(this.items.size() - 1).getOrderingNb() + "+");
                String[] actors = null;
                String actorIds = dialog.getActors();
                actors = actorIds.trim().length() == 0 ? new String[]{} : actorIds.split(",");
                String[] groups = null;
                String groupIds = dialog.getGroups();
                groups = groupIds.trim().length() == 0 ? new String[]{} : groupIds.split(",");
                this.checklistManager.addTask(dialog.getActors(), actors, groups, name, orderingNb, this.getSelectedProcessInstance());
                this.refresh();
            }
        }
    }

    private ChecklistItem getSelectedItem() {
        int index = this.itemTable.getSelectedRow();
        if (index >= 0) {
            return this.items.get(index);
        }
        return null;
    }

    public static void main(String[] args) {
        new ChecklistUI().setVisible(true);
    }
}

