/*
 * Decompiled with CFR 0.152.
 */
package org.jbpm.examples.evaluation;

import java.util.HashMap;
import java.util.List;
import org.kie.api.KieServices;
import org.kie.api.io.ResourceType;
import org.kie.api.runtime.KieSession;
import org.kie.api.runtime.manager.RuntimeEngine;
import org.kie.api.runtime.manager.RuntimeEnvironment;
import org.kie.api.runtime.manager.RuntimeEnvironmentBuilder;
import org.kie.api.runtime.manager.RuntimeManager;
import org.kie.api.runtime.manager.RuntimeManagerFactory;
import org.kie.api.task.TaskService;
import org.kie.api.task.model.TaskSummary;
import org.kie.test.util.db.PersistenceUtil;

public class EvaluationExample {
    public static final void main(String[] args) {
        try {
            RuntimeManager manager = EvaluationExample.getRuntimeManager("evaluation/Evaluation.bpmn");
            RuntimeEngine runtime = manager.getRuntimeEngine(null);
            KieSession ksession = runtime.getKieSession();
            HashMap<String, String> params = new HashMap<String, String>();
            params.put("employee", "krisv");
            params.put("reason", "Yearly performance evaluation");
            ksession.startProcess("com.sample.evaluation", params);
            TaskService taskService = runtime.getTaskService();
            List tasks = taskService.getTasksAssignedAsPotentialOwner("krisv", "en-UK");
            TaskSummary task = (TaskSummary)tasks.get(0);
            System.out.println("'krisv' completing task " + task.getName() + ": " + task.getDescription());
            taskService.start(task.getId().longValue(), "krisv");
            HashMap<String, String> results = new HashMap<String, String>();
            results.put("performance", "exceeding");
            taskService.complete(task.getId().longValue(), "krisv", results);
            tasks = taskService.getTasksAssignedAsPotentialOwner("john", "en-UK");
            task = (TaskSummary)tasks.get(0);
            System.out.println("'john' completing task " + task.getName() + ": " + task.getDescription());
            taskService.start(task.getId().longValue(), "john");
            results = new HashMap();
            results.put("performance", "acceptable");
            taskService.complete(task.getId().longValue(), "john", results);
            tasks = taskService.getTasksAssignedAsPotentialOwner("mary", "en-UK");
            task = (TaskSummary)tasks.get(0);
            System.out.println("'mary' completing task " + task.getName() + ": " + task.getDescription());
            taskService.start(task.getId().longValue(), "mary");
            results = new HashMap();
            results.put("performance", "outstanding");
            taskService.complete(task.getId().longValue(), "mary", results);
            System.out.println("Process instance completed");
            manager.disposeRuntimeEngine(runtime);
        }
        catch (Throwable t) {
            t.printStackTrace();
        }
        System.exit(0);
    }

    private static RuntimeManager getRuntimeManager(String process) {
        PersistenceUtil.setupPoolingDataSource();
        RuntimeEnvironment environment = RuntimeEnvironmentBuilder.Factory.get().newDefaultBuilder().addAsset(KieServices.Factory.get().getResources().newClassPathResource(process), ResourceType.BPMN2).get();
        return RuntimeManagerFactory.Factory.get().newSingletonRuntimeManager(environment);
    }
}

