/*
 * Decompiled with CFR 0.152.
 */
package org.jbpm.examples.request;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.HashMap;
import javax.swing.JButton;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JTextField;
import org.jbpm.examples.request.Person;
import org.jbpm.examples.request.Request;
import org.jbpm.examples.request.UIWorkItemHandler;
import org.jbpm.workflow.instance.node.DynamicNodeInstance;
import org.jbpm.workflow.instance.node.DynamicUtils;
import org.kie.api.KieServices;
import org.kie.api.event.KieRuntimeEventManager;
import org.kie.api.event.process.DefaultProcessEventListener;
import org.kie.api.event.process.ProcessEventListener;
import org.kie.api.event.process.ProcessStartedEvent;
import org.kie.api.io.ResourceType;
import org.kie.api.runtime.KieRuntime;
import org.kie.api.runtime.KieSession;
import org.kie.api.runtime.manager.RuntimeEnvironment;
import org.kie.api.runtime.manager.RuntimeEnvironmentBuilder;
import org.kie.api.runtime.manager.RuntimeManagerFactory;
import org.kie.api.runtime.process.WorkItem;
import org.kie.api.runtime.process.WorkItemHandler;
import org.kie.api.runtime.process.WorkItemManager;
import org.kie.api.runtime.process.WorkflowProcessInstance;

public class RequestUI
extends JFrame {
    private static final long serialVersionUID = 510L;
    private int requestId = 0;
    private JTextField nameField;
    private JTextField amountField;
    private JTextField signalField;
    private JTextField processField;
    private KieSession ksession;
    private WorkflowProcessInstance processInstance;

    public static void main(String[] args) {
        new RequestUI().setVisible(true);
    }

    public RequestUI() {
        this.setSize(new Dimension(400, 300));
        this.setTitle("Requests");
        this.setDefaultCloseOperation(2);
        this.initializeComponent();
    }

    private void initializeComponent() {
        JPanel panel = new JPanel();
        panel.setLayout(new GridBagLayout());
        this.getRootPane().setLayout(new BorderLayout());
        this.getRootPane().add((Component)panel, "Center");
        JLabel nameLabel = new JLabel("Name");
        GridBagConstraints c = new GridBagConstraints();
        c.anchor = 13;
        c.insets = new Insets(5, 5, 5, 5);
        panel.add((Component)nameLabel, c);
        this.nameField = new JTextField();
        c = new GridBagConstraints();
        c.gridx = 1;
        c.weightx = 1.0;
        c.fill = 2;
        c.insets = new Insets(5, 5, 5, 5);
        panel.add((Component)this.nameField, c);
        JLabel amountLabel = new JLabel("Amount");
        c = new GridBagConstraints();
        c.gridy = 1;
        c.anchor = 13;
        c.insets = new Insets(5, 5, 5, 5);
        panel.add((Component)amountLabel, c);
        this.amountField = new JTextField();
        c = new GridBagConstraints();
        c.gridx = 1;
        c.gridy = 1;
        c.weightx = 1.0;
        c.fill = 2;
        c.insets = new Insets(5, 5, 5, 5);
        panel.add((Component)this.amountField, c);
        JButton selectButton = new JButton("Request");
        selectButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent event) {
                RequestUI.this.select();
            }
        });
        c = new GridBagConstraints();
        c.gridy = 2;
        c.insets = new Insets(5, 5, 5, 5);
        panel.add((Component)selectButton, c);
        JLabel signalLabel = new JLabel("Signal");
        c = new GridBagConstraints();
        c.gridy = 3;
        c.anchor = 13;
        c.insets = new Insets(5, 5, 5, 5);
        panel.add((Component)signalLabel, c);
        this.signalField = new JTextField();
        c = new GridBagConstraints();
        c.gridx = 1;
        c.gridy = 3;
        c.weightx = 1.0;
        c.fill = 2;
        c.insets = new Insets(5, 5, 5, 5);
        panel.add((Component)this.signalField, c);
        JButton signalButton = new JButton("Signal");
        signalButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent event) {
                RequestUI.this.signal();
            }
        });
        c = new GridBagConstraints();
        c.gridy = 4;
        c.insets = new Insets(5, 5, 5, 5);
        panel.add((Component)signalButton, c);
        JLabel addLabel = new JLabel("Process");
        c = new GridBagConstraints();
        c.gridy = 5;
        c.anchor = 13;
        c.insets = new Insets(5, 5, 5, 5);
        panel.add((Component)addLabel, c);
        this.processField = new JTextField("com.sample.contactCustomer");
        c = new GridBagConstraints();
        c.gridx = 1;
        c.gridy = 5;
        c.weightx = 1.0;
        c.fill = 2;
        c.insets = new Insets(5, 5, 5, 5);
        panel.add((Component)this.processField, c);
        JButton addButton = new JButton("Dynamically add sub-process");
        addButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent event) {
                RequestUI.this.addSubProcessInstance();
            }
        });
        c = new GridBagConstraints();
        c.gridy = 6;
        c.gridwidth = 2;
        c.anchor = 17;
        c.insets = new Insets(5, 5, 5, 5);
        panel.add((Component)addButton, c);
        this.ksession = this.createKieSession();
    }

    private void select() {
        int id = ++this.requestId;
        Request request = new Request(id + "");
        request.setPersonId(this.nameField.getText());
        request.setAmount(Long.parseLong(this.amountField.getText()));
        if (this.ksession == null) {
            this.ksession = this.createKieSession();
        }
        this.ksession.insert((Object)request);
        HashMap<String, Request> params = new HashMap<String, Request>();
        params.put("request", request);
        this.processInstance = (WorkflowProcessInstance)this.ksession.startProcess("com.sample.requestHandling", params);
        this.ksession.insert((Object)this.processInstance);
        this.ksession.fireAllRules();
    }

    private void signal() {
        this.ksession.signalEvent(this.signalField.getText(), null, this.processInstance.getId());
    }

    private void addSubProcessInstance() {
        DynamicNodeInstance dynamicNodeInstance = (DynamicNodeInstance)this.processInstance.getNodeInstances().iterator().next();
        DynamicUtils.addDynamicSubProcess((DynamicNodeInstance)dynamicNodeInstance, (KieRuntime)this.ksession, (String)"com.sample.contactCustomer", null);
    }

    private KieSession createKieSession() {
        try {
            final KieSession ksession = RequestUI.getKieSession();
            KieServices.Factory.get().getLoggers().newThreadedFileLogger((KieRuntimeEventManager)ksession, "test", 1000);
            UIWorkItemHandler handler = new UIWorkItemHandler();
            ksession.getWorkItemManager().registerWorkItemHandler("Human Task", (WorkItemHandler)handler);
            handler.setVisible(true);
            ksession.getWorkItemManager().registerWorkItemHandler("Email", new WorkItemHandler(){

                public void executeWorkItem(WorkItem workItem, WorkItemManager manager) {
                    System.out.println("Sending email ...");
                    manager.completeWorkItem(workItem.getId(), null);
                }

                public void abortWorkItem(WorkItem workItem, WorkItemManager manager) {
                }
            });
            Person person = new Person("john", "John Doe");
            person.setAge(40);
            ksession.insert((Object)person);
            person = new Person("krisv", "Kris Verlaenen");
            person.setAge(30);
            ksession.insert((Object)person);
            person = new Person("baby", "Baby");
            person.setAge(1);
            ksession.insert((Object)person);
            ksession.addEventListener((ProcessEventListener)new DefaultProcessEventListener(){

                public void beforeProcessStarted(ProcessStartedEvent event) {
                    ksession.insert((Object)event);
                }
            });
            return ksession;
        }
        catch (Throwable t) {
            throw new RuntimeException("Could not initialize session!", t);
        }
    }

    private static KieSession getKieSession() throws Exception {
        RuntimeEnvironment environment = RuntimeEnvironmentBuilder.Factory.get().newEmptyBuilder().addAsset(KieServices.Factory.get().getResources().newClassPathResource("request/requestHandling.bpmn"), ResourceType.BPMN2).addAsset(KieServices.Factory.get().getResources().newClassPathResource("request/contactCustomer.bpmn"), ResourceType.BPMN2).addAsset(KieServices.Factory.get().getResources().newClassPathResource("request/validation.drl"), ResourceType.DRL).addAsset(KieServices.Factory.get().getResources().newClassPathResource("request/eventProcessing.drl"), ResourceType.DRL).addAsset(KieServices.Factory.get().getResources().newClassPathResource("request/exceptions.drl"), ResourceType.DRL).addAsset(KieServices.Factory.get().getResources().newClassPathResource("request/adhoc.drl"), ResourceType.DRL).get();
        return RuntimeManagerFactory.Factory.get().newSingletonRuntimeManager(environment).getRuntimeEngine(null).getKieSession();
    }
}

