/*
 * Decompiled with CFR 0.152.
 */
package org.jbpm.process.instance;

import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.drools.SessionConfiguration;
import org.drools.WorkingMemory;
import org.drools.common.AbstractWorkingMemory;
import org.drools.common.InternalKnowledgeRuntime;
import org.drools.common.InternalRuleBase;
import org.drools.definition.process.Process;
import org.drools.event.ProcessEventSupport;
import org.drools.event.RuleFlowGroupDeactivatedEvent;
import org.drools.event.process.ProcessEventListener;
import org.drools.event.rule.ActivationCreatedEvent;
import org.drools.event.rule.AgendaEventListener;
import org.drools.event.rule.DefaultAgendaEventListener;
import org.drools.impl.KnowledgeBaseImpl;
import org.drools.rule.Rule;
import org.drools.runtime.KnowledgeRuntime;
import org.drools.runtime.process.EventListener;
import org.drools.runtime.process.WorkItemManager;
import org.drools.util.CompositeClassLoader;
import org.jbpm.process.core.event.EventFilter;
import org.jbpm.process.core.event.EventTypeFilter;
import org.jbpm.process.instance.InternalProcessRuntime;
import org.jbpm.process.instance.ProcessInstance;
import org.jbpm.process.instance.ProcessInstanceFactory;
import org.jbpm.process.instance.ProcessInstanceFactoryRegistry;
import org.jbpm.process.instance.ProcessInstanceManager;
import org.jbpm.process.instance.ProcessInstanceManagerFactory;
import org.jbpm.process.instance.event.SignalManager;
import org.jbpm.process.instance.event.SignalManagerFactory;
import org.jbpm.process.instance.timer.TimerManager;
import org.jbpm.ruleflow.core.RuleFlowProcess;
import org.jbpm.workflow.core.node.EventTrigger;
import org.jbpm.workflow.core.node.StartNode;
import org.jbpm.workflow.core.node.Trigger;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ProcessRuntimeImpl
implements InternalProcessRuntime {
    private AbstractWorkingMemory workingMemory;
    private InternalKnowledgeRuntime kruntime;
    private ProcessInstanceManager processInstanceManager;
    private SignalManager signalManager;
    private TimerManager timerManager;
    private ProcessEventSupport processEventSupport;

    public ProcessRuntimeImpl(InternalKnowledgeRuntime kruntime) {
        this.kruntime = kruntime;
        ((CompositeClassLoader)this.getRootClassLoader()).addClassLoader(this.getClass().getClassLoader());
        this.initProcessInstanceManager();
        this.initSignalManager();
        this.timerManager = new TimerManager(kruntime, kruntime.getTimerService());
        this.processEventSupport = new ProcessEventSupport();
        this.initProcessEventListeners();
    }

    public ProcessRuntimeImpl(AbstractWorkingMemory workingMemory) {
        this.workingMemory = workingMemory;
        this.kruntime = workingMemory.getKnowledgeRuntime();
        ((CompositeClassLoader)this.getRootClassLoader()).addClassLoader(this.getClass().getClassLoader());
        this.initProcessInstanceManager();
        this.initSignalManager();
        this.timerManager = new TimerManager(this.kruntime, this.kruntime.getTimerService());
        this.processEventSupport = new ProcessEventSupport();
        this.initProcessEventListeners();
        this.initProcessActivationListener();
    }

    private void initProcessInstanceManager() {
        String processInstanceManagerClass = ((SessionConfiguration)this.kruntime.getSessionConfiguration()).getProcessInstanceManagerFactory();
        try {
            this.processInstanceManager = ((ProcessInstanceManagerFactory)this.loadClass(processInstanceManagerClass).newInstance()).createProcessInstanceManager(this.kruntime);
        }
        catch (InstantiationException e) {
            throw new RuntimeException(e);
        }
        catch (IllegalAccessException e) {
            throw new RuntimeException(e);
        }
    }

    private void initSignalManager() {
        String signalManagerClass = ((SessionConfiguration)this.kruntime.getSessionConfiguration()).getSignalManagerFactory();
        try {
            this.signalManager = ((SignalManagerFactory)this.loadClass(signalManagerClass).newInstance()).createSignalManager(this.kruntime);
        }
        catch (InstantiationException e) {
            throw new RuntimeException(e);
        }
        catch (IllegalAccessException e) {
            throw new RuntimeException(e);
        }
    }

    private Class<?> loadClass(String className) {
        try {
            return this.getRootClassLoader().loadClass(className);
        }
        catch (ClassNotFoundException e) {
            throw new RuntimeException(e);
        }
    }

    private ClassLoader getRootClassLoader() {
        return ((InternalRuleBase)((KnowledgeBaseImpl)this.kruntime.getKnowledgeBase()).getRuleBase()).getRootClassLoader();
    }

    public org.drools.runtime.process.ProcessInstance startProcess(String processId) {
        return this.startProcess(processId, null);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public org.drools.runtime.process.ProcessInstance startProcess(String processId, Map<String, Object> parameters) {
        try {
            Process process;
            this.kruntime.startOperation();
            if (!this.kruntime.getActionQueue().isEmpty()) {
                this.kruntime.executeQueuedActions();
            }
            if ((process = this.kruntime.getKnowledgeBase().getProcess(processId)) == null) {
                throw new IllegalArgumentException("Unknown process ID: " + processId);
            }
            ProcessInstance processInstance = this.startProcess(process, parameters);
            if (processInstance != null) {
                this.getProcessEventSupport().fireBeforeProcessStarted((org.drools.runtime.process.ProcessInstance)processInstance, (KnowledgeRuntime)this.kruntime);
                processInstance.start();
                this.getProcessEventSupport().fireAfterProcessStarted((org.drools.runtime.process.ProcessInstance)processInstance, (KnowledgeRuntime)this.kruntime);
            }
            ProcessInstance processInstance2 = processInstance;
            return processInstance2;
        }
        finally {
            this.kruntime.endOperation();
        }
    }

    private ProcessInstance startProcess(Process process, Map<String, Object> parameters) {
        ProcessInstanceFactory conf = ProcessInstanceFactoryRegistry.INSTANCE.getProcessInstanceFactory(process);
        if (conf == null) {
            throw new IllegalArgumentException("Illegal process type: " + process.getClass());
        }
        return conf.createProcessInstance(process, this.kruntime, parameters);
    }

    @Override
    public ProcessInstanceManager getProcessInstanceManager() {
        return this.processInstanceManager;
    }

    @Override
    public TimerManager getTimerManager() {
        return this.timerManager;
    }

    @Override
    public SignalManager getSignalManager() {
        return this.signalManager;
    }

    public Collection<org.drools.runtime.process.ProcessInstance> getProcessInstances() {
        return this.processInstanceManager.getProcessInstances();
    }

    public org.drools.runtime.process.ProcessInstance getProcessInstance(long id) {
        return this.processInstanceManager.getProcessInstance(id);
    }

    public void removeProcessInstance(org.drools.runtime.process.ProcessInstance processInstance) {
        this.processInstanceManager.removeProcessInstance(processInstance);
    }

    private void initProcessEventListeners() {
        for (Process process : this.kruntime.getKnowledgeBase().getProcesses()) {
            List<Trigger> triggers;
            StartNode startNode;
            if (!(process instanceof RuleFlowProcess) || (startNode = ((RuleFlowProcess)process).getStart()) == null || (triggers = startNode.getTriggers()) == null) continue;
            for (Trigger trigger : triggers) {
                if (!(trigger instanceof EventTrigger)) continue;
                List<EventFilter> filters = ((EventTrigger)trigger).getEventFilters();
                String type = null;
                for (EventFilter filter : filters) {
                    if (!(filter instanceof EventTypeFilter)) continue;
                    type = ((EventTypeFilter)filter).getType();
                }
                this.signalManager.addEventListener(type, new StartProcessEventListener(process.getId(), filters, trigger.getInMappings()));
            }
        }
    }

    @Override
    public ProcessEventSupport getProcessEventSupport() {
        return this.processEventSupport;
    }

    public void addEventListener(ProcessEventListener listener) {
        this.processEventSupport.addEventListener((java.util.EventListener)listener);
    }

    public void removeEventListener(ProcessEventListener listener) {
        this.processEventSupport.removeEventListener((java.util.EventListener)listener);
    }

    public List<ProcessEventListener> getProcessEventListeners() {
        return this.processEventSupport.getEventListeners();
    }

    private void initProcessActivationListener() {
        this.kruntime.addEventListener((AgendaEventListener)new DefaultAgendaEventListener(){

            public void activationCreated(ActivationCreatedEvent event) {
                String ruleName;
                String ruleFlowGroup = ((Rule)event.getActivation().getRule()).getRuleFlowGroup();
                if ("DROOLS_SYSTEM".equals(ruleFlowGroup) && (ruleName = event.getActivation().getRule().getName()).startsWith("RuleFlowStateNode-")) {
                    int index = ruleName.indexOf("-", 18);
                    index = ruleName.indexOf("-", index + 1);
                    String eventType = ruleName.substring(0, index);
                    ProcessRuntimeImpl.this.signalManager.signalEvent(eventType, event);
                }
            }
        });
        this.workingMemory.addEventListener((org.drools.event.AgendaEventListener)new org.drools.event.DefaultAgendaEventListener(){

            public void afterRuleFlowGroupDeactivated(RuleFlowGroupDeactivatedEvent event, WorkingMemory workingMemory) {
                ProcessRuntimeImpl.this.signalManager.signalEvent("RuleFlowGroup_" + event.getRuleFlowGroup().getName(), null);
            }
        });
    }

    public void abortProcessInstance(long processInstanceId) {
        org.drools.runtime.process.ProcessInstance processInstance = this.getProcessInstance(processInstanceId);
        if (processInstance == null) {
            throw new IllegalArgumentException("Could not find process instance for id " + processInstanceId);
        }
        ((ProcessInstance)processInstance).setState(3);
    }

    public WorkItemManager getWorkItemManager() {
        return this.kruntime.getWorkItemManager();
    }

    public void signalEvent(String type, Object event) {
        this.signalManager.signalEvent(type, event);
    }

    public void signalEvent(String type, Object event, long processInstanceId) {
        this.signalManager.signalEvent(processInstanceId, type, event);
    }

    public void setProcessEventSupport(ProcessEventSupport processEventSupport) {
        this.processEventSupport = processEventSupport;
    }

    public void dispose() {
        this.processEventSupport.reset();
        this.timerManager.dispose();
    }

    public void clearProcessInstances() {
        this.processInstanceManager.clearProcessInstances();
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private class StartProcessEventListener
    implements EventListener {
        private String processId;
        private List<EventFilter> eventFilters;
        private Map<String, String> inMappings;

        public StartProcessEventListener(String processId, List<EventFilter> eventFilters, Map<String, String> inMappings) {
            this.processId = processId;
            this.eventFilters = eventFilters;
            this.inMappings = inMappings;
        }

        public String[] getEventTypes() {
            return null;
        }

        public void signalEvent(String type, Object event) {
            for (EventFilter filter : this.eventFilters) {
                if (filter.acceptsEvent(type, event)) continue;
                return;
            }
            HashMap<String, Object> params = null;
            if (this.inMappings != null && !this.inMappings.isEmpty()) {
                params = new HashMap<String, Object>();
                for (Map.Entry<String, String> entry : this.inMappings.entrySet()) {
                    if ("event".equals(entry.getValue())) {
                        params.put(entry.getKey(), event);
                        continue;
                    }
                    params.put(entry.getKey(), entry.getValue());
                }
            }
            ProcessRuntimeImpl.this.startProcess(this.processId, params);
        }
    }
}

