/*
 * Decompiled with CFR 0.152.
 */
package org.jbpm.process.instance;

import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.drools.RuleBase;
import org.drools.SessionConfiguration;
import org.drools.WorkingMemory;
import org.drools.common.AbstractWorkingMemory;
import org.drools.common.InternalKnowledgeRuntime;
import org.drools.common.InternalRuleBase;
import org.drools.definition.process.Process;
import org.drools.event.ProcessEventSupport;
import org.drools.event.RuleFlowGroupDeactivatedEvent;
import org.drools.event.knowledgebase.AfterProcessAddedEvent;
import org.drools.event.knowledgebase.AfterProcessRemovedEvent;
import org.drools.event.knowledgebase.DefaultKnowledgeBaseEventListener;
import org.drools.event.knowledgebase.KnowledgeBaseEventListener;
import org.drools.event.process.ProcessEventListener;
import org.drools.event.rule.ActivationCreatedEvent;
import org.drools.event.rule.AgendaEventListener;
import org.drools.event.rule.DefaultAgendaEventListener;
import org.drools.impl.InternalKnowledgeBase;
import org.drools.rule.Rule;
import org.drools.runtime.KnowledgeRuntime;
import org.drools.runtime.StatefulKnowledgeSession;
import org.drools.runtime.process.EventListener;
import org.drools.runtime.process.WorkItemManager;
import org.drools.time.AcceptsTimerJobFactoryManager;
import org.drools.time.impl.DefaultTimerJobFactoryManager;
import org.drools.time.impl.TimerJobFactoryManager;
import org.drools.time.impl.TrackableTimeJobFactoryManager;
import org.drools.util.CompositeClassLoader;
import org.jbpm.process.core.event.EventFilter;
import org.jbpm.process.core.event.EventTypeFilter;
import org.jbpm.process.instance.InternalProcessRuntime;
import org.jbpm.process.instance.ProcessInstance;
import org.jbpm.process.instance.ProcessInstanceFactory;
import org.jbpm.process.instance.ProcessInstanceFactoryRegistry;
import org.jbpm.process.instance.ProcessInstanceManager;
import org.jbpm.process.instance.ProcessInstanceManagerFactory;
import org.jbpm.process.instance.event.SignalManager;
import org.jbpm.process.instance.event.SignalManagerFactory;
import org.jbpm.process.instance.timer.TimerManager;
import org.jbpm.ruleflow.core.RuleFlowProcess;
import org.jbpm.workflow.core.node.EventTrigger;
import org.jbpm.workflow.core.node.StartNode;
import org.jbpm.workflow.core.node.Trigger;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ProcessRuntimeImpl
implements InternalProcessRuntime {
    private AbstractWorkingMemory workingMemory;
    private InternalKnowledgeRuntime kruntime;
    private ProcessInstanceManager processInstanceManager;
    private SignalManager signalManager;
    private TimerManager timerManager;
    private ProcessEventSupport processEventSupport;
    private DefaultKnowledgeBaseEventListener knowledgeBaseListener;

    public ProcessRuntimeImpl(InternalKnowledgeRuntime kruntime) {
        this.kruntime = kruntime;
        AcceptsTimerJobFactoryManager jfm = (AcceptsTimerJobFactoryManager)kruntime.getTimerService();
        if (jfm.getTimerJobFactoryManager() instanceof DefaultTimerJobFactoryManager) {
            jfm.setTimerJobFactoryManager((TimerJobFactoryManager)new TrackableTimeJobFactoryManager());
        }
        ((AcceptsTimerJobFactoryManager)kruntime.getTimerService()).setTimerJobFactoryManager((TimerJobFactoryManager)new TrackableTimeJobFactoryManager());
        ((CompositeClassLoader)this.getRootClassLoader()).addClassLoader(this.getClass().getClassLoader());
        this.initProcessInstanceManager();
        this.initSignalManager();
        this.timerManager = new TimerManager(kruntime, kruntime.getTimerService());
        this.processEventSupport = new ProcessEventSupport();
        this.initProcessEventListeners();
        this.initProcessActivationListener();
    }

    public ProcessRuntimeImpl(AbstractWorkingMemory workingMemory) {
        this.workingMemory = workingMemory;
        AcceptsTimerJobFactoryManager jfm = (AcceptsTimerJobFactoryManager)workingMemory.getTimerService();
        if (jfm.getTimerJobFactoryManager() instanceof DefaultTimerJobFactoryManager) {
            jfm.setTimerJobFactoryManager((TimerJobFactoryManager)new TrackableTimeJobFactoryManager());
        }
        this.kruntime = workingMemory.getKnowledgeRuntime();
        ((CompositeClassLoader)this.getRootClassLoader()).addClassLoader(this.getClass().getClassLoader());
        this.initProcessInstanceManager();
        this.initSignalManager();
        this.timerManager = new TimerManager(this.kruntime, this.kruntime.getTimerService());
        this.processEventSupport = new ProcessEventSupport();
        this.initProcessEventListeners();
        this.initProcessActivationListener();
    }

    private void initProcessInstanceManager() {
        String processInstanceManagerClass = ((SessionConfiguration)this.kruntime.getSessionConfiguration()).getProcessInstanceManagerFactory();
        try {
            this.processInstanceManager = ((ProcessInstanceManagerFactory)this.loadClass(processInstanceManagerClass).newInstance()).createProcessInstanceManager(this.kruntime);
        }
        catch (InstantiationException e) {
            throw new RuntimeException(e);
        }
        catch (IllegalAccessException e) {
            throw new RuntimeException(e);
        }
    }

    private void initSignalManager() {
        String signalManagerClass = ((SessionConfiguration)this.kruntime.getSessionConfiguration()).getSignalManagerFactory();
        try {
            this.signalManager = ((SignalManagerFactory)this.loadClass(signalManagerClass).newInstance()).createSignalManager(this.kruntime);
        }
        catch (InstantiationException e) {
            throw new RuntimeException(e);
        }
        catch (IllegalAccessException e) {
            throw new RuntimeException(e);
        }
    }

    private Class<?> loadClass(String className) {
        try {
            return this.getRootClassLoader().loadClass(className);
        }
        catch (ClassNotFoundException e) {
            throw new RuntimeException(e);
        }
    }

    private ClassLoader getRootClassLoader() {
        RuleBase ruleBase = ((InternalKnowledgeBase)this.kruntime.getKnowledgeBase()).getRuleBase();
        if (ruleBase != null) {
            return ((InternalRuleBase)((InternalKnowledgeBase)this.kruntime.getKnowledgeBase()).getRuleBase()).getRootClassLoader();
        }
        CompositeClassLoader result = new CompositeClassLoader();
        result.addClassLoader(this.getClass().getClassLoader());
        return result;
    }

    public org.drools.runtime.process.ProcessInstance startProcess(String processId) {
        return this.startProcess(processId, null);
    }

    public org.drools.runtime.process.ProcessInstance startProcess(String processId, Map<String, Object> parameters) {
        org.drools.runtime.process.ProcessInstance processInstance = this.createProcessInstance(processId, parameters);
        if (processInstance != null) {
            return this.startProcessInstance(processInstance.getId());
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public org.drools.runtime.process.ProcessInstance createProcessInstance(String processId, Map<String, Object> parameters) {
        try {
            Process process;
            this.kruntime.startOperation();
            if (!this.kruntime.getActionQueue().isEmpty()) {
                this.kruntime.executeQueuedActions();
            }
            if ((process = this.kruntime.getKnowledgeBase().getProcess(processId)) == null) {
                throw new IllegalArgumentException("Unknown process ID: " + processId);
            }
            ProcessInstance processInstance = this.startProcess(process, parameters);
            return processInstance;
        }
        finally {
            this.kruntime.endOperation();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public org.drools.runtime.process.ProcessInstance startProcessInstance(long processInstanceId) {
        try {
            this.kruntime.startOperation();
            if (!this.kruntime.getActionQueue().isEmpty()) {
                this.kruntime.executeQueuedActions();
            }
            org.drools.runtime.process.ProcessInstance processInstance = this.getProcessInstance(processInstanceId);
            this.getProcessEventSupport().fireBeforeProcessStarted(processInstance, (KnowledgeRuntime)this.kruntime);
            ((ProcessInstance)processInstance).start();
            this.getProcessEventSupport().fireAfterProcessStarted(processInstance, (KnowledgeRuntime)this.kruntime);
            org.drools.runtime.process.ProcessInstance processInstance2 = processInstance;
            return processInstance2;
        }
        finally {
            this.kruntime.endOperation();
        }
    }

    private ProcessInstance startProcess(Process process, Map<String, Object> parameters) {
        ProcessInstanceFactory conf = ProcessInstanceFactoryRegistry.INSTANCE.getProcessInstanceFactory(process);
        if (conf == null) {
            throw new IllegalArgumentException("Illegal process type: " + process.getClass());
        }
        return conf.createProcessInstance(process, this.kruntime, parameters);
    }

    @Override
    public ProcessInstanceManager getProcessInstanceManager() {
        return this.processInstanceManager;
    }

    @Override
    public TimerManager getTimerManager() {
        return this.timerManager;
    }

    @Override
    public SignalManager getSignalManager() {
        return this.signalManager;
    }

    public Collection<org.drools.runtime.process.ProcessInstance> getProcessInstances() {
        return this.processInstanceManager.getProcessInstances();
    }

    public org.drools.runtime.process.ProcessInstance getProcessInstance(long id) {
        return this.processInstanceManager.getProcessInstance(id);
    }

    public void removeProcessInstance(org.drools.runtime.process.ProcessInstance processInstance) {
        this.processInstanceManager.removeProcessInstance(processInstance);
    }

    private void initProcessEventListeners() {
        for (Process process : this.kruntime.getKnowledgeBase().getProcesses()) {
            this.initProcessEventListener(process);
        }
        this.knowledgeBaseListener = new DefaultKnowledgeBaseEventListener(){

            public void afterProcessAdded(AfterProcessAddedEvent event) {
                ProcessRuntimeImpl.this.initProcessEventListener(event.getProcess());
            }

            public void afterProcessRemoved(AfterProcessRemovedEvent event) {
                if (event.getProcess() instanceof RuleFlowProcess) {
                    String type = (String)((RuleFlowProcess)event.getProcess()).getMetaData().get("StartProcessEventType");
                    StartProcessEventListener listener = (StartProcessEventListener)((RuleFlowProcess)event.getProcess()).getMetaData().get("StartProcessEventListener");
                    if (type != null && listener != null) {
                        ProcessRuntimeImpl.this.signalManager.removeEventListener(type, listener);
                    }
                }
            }
        };
        this.kruntime.getKnowledgeBase().addEventListener((KnowledgeBaseEventListener)this.knowledgeBaseListener);
    }

    private void initProcessEventListener(Process process) {
        List<Trigger> triggers;
        StartNode startNode;
        if (process instanceof RuleFlowProcess && (startNode = ((RuleFlowProcess)process).getStart()) != null && (triggers = startNode.getTriggers()) != null) {
            for (Trigger trigger : triggers) {
                if (!(trigger instanceof EventTrigger)) continue;
                List<EventFilter> filters = ((EventTrigger)trigger).getEventFilters();
                String type = null;
                for (EventFilter filter : filters) {
                    if (!(filter instanceof EventTypeFilter)) continue;
                    type = ((EventTypeFilter)filter).getType();
                }
                StartProcessEventListener listener = new StartProcessEventListener(process.getId(), filters, trigger.getInMappings());
                this.signalManager.addEventListener(type, listener);
                ((RuleFlowProcess)process).getMetaData().put("StartProcessEventType", type);
                ((RuleFlowProcess)process).getMetaData().put("StartProcessEventListener", listener);
            }
        }
    }

    @Override
    public ProcessEventSupport getProcessEventSupport() {
        return this.processEventSupport;
    }

    public void addEventListener(ProcessEventListener listener) {
        this.processEventSupport.addEventListener((java.util.EventListener)listener);
    }

    public void removeEventListener(ProcessEventListener listener) {
        this.processEventSupport.removeEventListener((java.util.EventListener)listener);
    }

    public List<ProcessEventListener> getProcessEventListeners() {
        return this.processEventSupport.getEventListeners();
    }

    private void initProcessActivationListener() {
        this.kruntime.addEventListener((AgendaEventListener)new DefaultAgendaEventListener(){

            public void activationCreated(ActivationCreatedEvent event) {
                String ruleName;
                String ruleFlowGroup = ((Rule)event.getActivation().getRule()).getRuleFlowGroup();
                if ("DROOLS_SYSTEM".equals(ruleFlowGroup) && (ruleName = event.getActivation().getRule().getName()).startsWith("RuleFlowStateNode-")) {
                    int index = ruleName.indexOf("-", 18);
                    index = ruleName.indexOf("-", index + 1);
                    String eventType = ruleName.substring(0, index);
                    ProcessRuntimeImpl.this.signalManager.signalEvent(eventType, event);
                }
            }
        });
        if (this.workingMemory != null) {
            this.workingMemory.addEventListener((org.drools.event.AgendaEventListener)new org.drools.event.DefaultAgendaEventListener(){

                public void afterRuleFlowGroupDeactivated(RuleFlowGroupDeactivatedEvent event, WorkingMemory workingMemory) {
                    if (ProcessRuntimeImpl.this.kruntime instanceof StatefulKnowledgeSession) {
                        ProcessRuntimeImpl.this.signalManager.signalEvent("RuleFlowGroup_" + event.getRuleFlowGroup().getName() + "_" + ((StatefulKnowledgeSession)ProcessRuntimeImpl.this.kruntime).getId(), null);
                    } else {
                        ProcessRuntimeImpl.this.signalManager.signalEvent("RuleFlowGroup_" + event.getRuleFlowGroup().getName(), null);
                    }
                }
            });
        }
    }

    public void abortProcessInstance(long processInstanceId) {
        org.drools.runtime.process.ProcessInstance processInstance = this.getProcessInstance(processInstanceId);
        if (processInstance == null) {
            throw new IllegalArgumentException("Could not find process instance for id " + processInstanceId);
        }
        ((ProcessInstance)processInstance).setState(3);
    }

    public WorkItemManager getWorkItemManager() {
        return this.kruntime.getWorkItemManager();
    }

    public void signalEvent(String type, Object event) {
        this.signalManager.signalEvent(type, event);
    }

    public void signalEvent(String type, Object event, long processInstanceId) {
        this.signalManager.signalEvent(processInstanceId, type, event);
    }

    public void setProcessEventSupport(ProcessEventSupport processEventSupport) {
        this.processEventSupport = processEventSupport;
    }

    public void dispose() {
        this.processEventSupport.reset();
        this.timerManager.dispose();
        if (this.kruntime != null) {
            this.kruntime.getKnowledgeBase().removeEventListener((KnowledgeBaseEventListener)this.knowledgeBaseListener);
            this.kruntime = null;
        }
        this.workingMemory = null;
    }

    public void clearProcessInstances() {
        this.processInstanceManager.clearProcessInstances();
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private class StartProcessEventListener
    implements EventListener {
        private String processId;
        private List<EventFilter> eventFilters;
        private Map<String, String> inMappings;

        public StartProcessEventListener(String processId, List<EventFilter> eventFilters, Map<String, String> inMappings) {
            this.processId = processId;
            this.eventFilters = eventFilters;
            this.inMappings = inMappings;
        }

        public String[] getEventTypes() {
            return null;
        }

        public void signalEvent(String type, Object event) {
            for (EventFilter filter : this.eventFilters) {
                if (filter.acceptsEvent(type, event)) continue;
                return;
            }
            HashMap<String, Object> params = null;
            if (this.inMappings != null && !this.inMappings.isEmpty()) {
                params = new HashMap<String, Object>();
                for (Map.Entry<String, String> entry : this.inMappings.entrySet()) {
                    if ("event".equals(entry.getValue())) {
                        params.put(entry.getKey(), event);
                        continue;
                    }
                    params.put(entry.getKey(), entry.getValue());
                }
            }
            ProcessRuntimeImpl.this.startProcess(this.processId, params);
        }
    }
}

