/*
 * Decompiled with CFR 0.152.
 */
package org.jbpm.workflow.instance.node;

import java.util.Collection;
import org.drools.runtime.process.WorkflowProcessInstance;
import org.jbpm.process.instance.context.exception.ExceptionScopeInstance;
import org.jbpm.process.instance.context.variable.VariableScopeInstance;
import org.jbpm.workflow.core.node.FaultNode;
import org.jbpm.workflow.instance.NodeInstance;
import org.jbpm.workflow.instance.NodeInstanceContainer;
import org.jbpm.workflow.instance.impl.NodeInstanceImpl;
import org.jbpm.workflow.instance.node.CompositeNodeInstance;

public class FaultNodeInstance
extends NodeInstanceImpl {
    private static final long serialVersionUID = 510L;

    protected FaultNode getFaultNode() {
        return (FaultNode)this.getNode();
    }

    public void internalTrigger(org.drools.runtime.process.NodeInstance from, String type) {
        if (!"DROOLS_DEFAULT".equals(type)) {
            throw new IllegalArgumentException("A FaultNode only accepts default incoming connections!");
        }
        String faultName = this.getFaultName();
        ExceptionScopeInstance exceptionScopeInstance = this.getExceptionScopeInstance(faultName);
        NodeInstanceContainer nodeInstanceContainer = (NodeInstanceContainer)this.getNodeInstanceContainer();
        nodeInstanceContainer.removeNodeInstance(this);
        if (this.getFaultNode().isTerminateParent()) {
            if (nodeInstanceContainer instanceof CompositeNodeInstance) {
                ((CompositeNodeInstance)nodeInstanceContainer).cancel();
            } else if (nodeInstanceContainer instanceof WorkflowProcessInstance) {
                Collection nodeInstances = ((WorkflowProcessInstance)nodeInstanceContainer).getNodeInstances();
                for (org.drools.runtime.process.NodeInstance nodeInstance : nodeInstances) {
                    ((NodeInstance)nodeInstance).cancel();
                }
            }
        }
        if (exceptionScopeInstance != null) {
            this.handleException(faultName, exceptionScopeInstance);
        } else {
            nodeInstanceContainer.setState(3);
        }
    }

    protected ExceptionScopeInstance getExceptionScopeInstance(String faultName) {
        return (ExceptionScopeInstance)this.resolveContextInstance("ExceptionScope", faultName);
    }

    protected String getFaultName() {
        return this.getFaultNode().getFaultName();
    }

    protected Object getFaultData() {
        Object value = null;
        String faultVariable = this.getFaultNode().getFaultVariable();
        if (faultVariable != null) {
            VariableScopeInstance variableScopeInstance = (VariableScopeInstance)this.resolveContextInstance("VariableScope", faultVariable);
            if (variableScopeInstance != null) {
                value = variableScopeInstance.getVariable(faultVariable);
            } else {
                System.err.println("Could not find variable scope for variable " + faultVariable);
                System.err.println("when trying to execute fault node " + this.getFaultNode().getName());
                System.err.println("Continuing without setting value.");
            }
        }
        return value;
    }

    protected void handleException(String faultName, ExceptionScopeInstance exceptionScopeInstance) {
        exceptionScopeInstance.handleException(faultName, this.getFaultData());
    }
}

