/*
 * Decompiled with CFR 0.152.
 */
package org.jbpm.process.core.timer;

import java.util.concurrent.ConcurrentHashMap;
import org.drools.core.time.TimerService;
import org.jbpm.process.core.timer.impl.GlobalTimerService;

public class TimerServiceRegistry {
    public static final String TIMER_SERVICE_SUFFIX = "-timerServiceId";
    private ConcurrentHashMap<String, TimerService> registeredServices = new ConcurrentHashMap();
    private static TimerServiceRegistry instance;

    public static TimerServiceRegistry getInstance() {
        if (instance == null) {
            instance = new TimerServiceRegistry();
        }
        return instance;
    }

    public void registerTimerService(String id, TimerService timerService) {
        if (timerService instanceof GlobalTimerService) {
            ((GlobalTimerService)timerService).setTimerServiceId(id);
        }
        this.registeredServices.put(id, timerService);
    }

    public TimerService get(String id) {
        if (id == null) {
            return null;
        }
        return this.registeredServices.get(id);
    }

    public TimerService remove(String id) {
        return this.registeredServices.remove(id);
    }
}

