/*
 * Decompiled with CFR 0.152.
 */
package org.jbpm.process.instance;

import java.lang.reflect.Constructor;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.Map;
import org.kie.KnowledgeBase;
import org.kie.definition.process.Process;
import org.kie.runtime.KnowledgeRuntime;
import org.kie.runtime.process.ProcessInstance;

public final class StartProcessHelper {
    public static final String PROCESS_COMPARATOR_CLASS_KEY = "jbpm.process.name.comparator";
    private static String comparatorClass = System.getProperty("jbpm.process.name.comparator");

    public static ProcessInstance startProcessByName(KnowledgeRuntime kruntime, String name, Map<String, Object> parameters) {
        if (name == null) {
            throw new IllegalArgumentException("Name cannot be null");
        }
        String processId = StartProcessHelper.findLatestProcessByName(kruntime.getKnowledgeBase(), name);
        if (processId == null) {
            throw new IllegalArgumentException("Could not find process with name " + name);
        }
        return kruntime.startProcess(processId, parameters);
    }

    public static ProcessInstance startProcessByName(KnowledgeRuntime kruntime, String name, Map<String, Object> parameters, Comparator<Process> comparator) {
        if (name == null) {
            throw new IllegalArgumentException("Name cannot be null");
        }
        String processId = StartProcessHelper.findLatestProcessByName(kruntime.getKnowledgeBase(), name, comparator);
        if (processId == null) {
            throw new IllegalArgumentException("Could not find process with name " + name);
        }
        return kruntime.startProcess(processId, parameters);
    }

    public static String findLatestProcessByName(KnowledgeBase kbase, String processName) {
        if (kbase == null) {
            return null;
        }
        return StartProcessHelper.findLatestProcessByName(kbase.getProcesses(), processName);
    }

    public static String findLatestProcessByName(KnowledgeBase kbase, String processName, Comparator<Process> comparator) {
        if (kbase == null) {
            return null;
        }
        return StartProcessHelper.findLatestProcessByName(kbase.getProcesses(), processName, comparator);
    }

    public static String findLatestProcessByName(Collection<Process> processes, String processName) {
        return StartProcessHelper.findLatestProcessByName(processes, processName, StartProcessHelper.getComparator(processName));
    }

    public static String findLatestProcessByName(Collection<Process> processes, String processName, Comparator<Process> comparator) {
        if (processes == null || processName == null) {
            return null;
        }
        Process highestVersionProcess = Collections.max(processes, comparator);
        if (highestVersionProcess != null && processName.equals(highestVersionProcess.getName())) {
            return highestVersionProcess.getId();
        }
        return null;
    }

    protected static Comparator<Process> getComparator(String name) {
        if (comparatorClass != null) {
            try {
                Class<?> comparatorClazz = Class.forName(comparatorClass);
                Constructor<?> constructor = comparatorClazz.getConstructor(String.class);
                return (Comparator)constructor.newInstance(name);
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        return new NumberVersionComparator(name);
    }

    private static class NumberVersionComparator
    implements Comparator<Process> {
        private String processName;

        private NumberVersionComparator(String processName) {
            this.processName = processName;
        }

        @Override
        public int compare(Process o1, Process o2) {
            if (o1.getName().equals(this.processName) && o2.getName().equals(this.processName)) {
                try {
                    if (Double.valueOf(o1.getVersion()) > Double.valueOf(o2.getVersion())) {
                        return 1;
                    }
                    return -1;
                }
                catch (NumberFormatException e) {
                    throw new IllegalArgumentException("Could not parse version: " + o1.getVersion() + " " + o2.getVersion());
                }
            }
            if (o1.getName().equals(this.processName)) {
                return 1;
            }
            return -1;
        }
    }
}

