/*
 * Decompiled with CFR 0.152.
 */
package org.jbpm.workflow.instance.node;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import org.jbpm.workflow.core.WorkflowProcess;
import org.jbpm.workflow.core.node.CompositeNode;
import org.jbpm.workflow.core.node.EventNode;
import org.jbpm.workflow.core.node.EventNodeInterface;
import org.jbpm.workflow.core.node.StartNode;
import org.jbpm.workflow.instance.NodeInstance;
import org.jbpm.workflow.instance.NodeInstanceContainer;
import org.jbpm.workflow.instance.WorkflowProcessInstance;
import org.jbpm.workflow.instance.impl.NodeInstanceFactory;
import org.jbpm.workflow.instance.impl.NodeInstanceFactoryRegistry;
import org.jbpm.workflow.instance.impl.NodeInstanceImpl;
import org.jbpm.workflow.instance.node.EndNodeInstance;
import org.jbpm.workflow.instance.node.EventBasedNodeInstanceInterface;
import org.jbpm.workflow.instance.node.EventNodeInstanceInterface;
import org.jbpm.workflow.instance.node.StateBasedNodeInstance;
import org.kie.definition.process.Connection;
import org.kie.definition.process.Node;
import org.kie.definition.process.NodeContainer;
import org.kie.runtime.process.EventListener;

public class CompositeNodeInstance
extends StateBasedNodeInstance
implements NodeInstanceContainer,
EventNodeInstanceInterface,
EventBasedNodeInstanceInterface {
    private static final long serialVersionUID = 510L;
    private final List<NodeInstance> nodeInstances = new ArrayList<NodeInstance>();
    private long nodeInstanceCounter = 0L;
    private int state = 1;

    @Override
    public void setProcessInstance(WorkflowProcessInstance processInstance) {
        super.setProcessInstance(processInstance);
        this.registerExternalEventNodeListeners();
    }

    private void registerExternalEventNodeListeners() {
        for (Node node : this.getCompositeNode().getNodes()) {
            if (!(node instanceof EventNode) || !"external".equals(((EventNode)node).getScope())) continue;
            this.getProcessInstance().addEventListener(((EventNode)node).getType(), new DoNothingEventListener(), true);
        }
    }

    protected CompositeNode getCompositeNode() {
        return (CompositeNode)this.getNode();
    }

    @Override
    public NodeContainer getNodeContainer() {
        return this.getCompositeNode();
    }

    @Override
    public void internalTrigger(org.kie.runtime.process.NodeInstance from, String type) {
        super.internalTrigger(from, type);
        CompositeNode.NodeAndType nodeAndType = this.getCompositeNode().internalGetLinkedIncomingNode(type);
        if (nodeAndType != null) {
            List connections = nodeAndType.getNode().getIncomingConnections(nodeAndType.getType());
            for (Connection connection : connections) {
                if (!(connection.getFrom() instanceof CompositeNode.CompositeNodeStart) || from != null && ((CompositeNode.CompositeNodeStart)connection.getFrom()).getInNode().getId() != from.getNodeId()) continue;
                NodeInstance nodeInstance = this.getNodeInstance(connection.getFrom());
                nodeInstance.trigger(null, nodeAndType.getType());
                return;
            }
        } else {
            boolean found = false;
            for (Node node : this.getCompositeNode().getNodes()) {
                StartNode startNode;
                if (!(node instanceof StartNode) || (startNode = (StartNode)node).getTriggers() != null && !startNode.getTriggers().isEmpty()) continue;
                NodeInstance nodeInstance = this.getNodeInstance(startNode);
                nodeInstance.trigger(null, null);
                found = true;
            }
            if (found) {
                return;
            }
        }
        if (this.isLinkedIncomingNodeRequired()) {
            throw new IllegalArgumentException("Could not find start for composite node: " + type);
        }
    }

    protected boolean isLinkedIncomingNodeRequired() {
        return true;
    }

    public void triggerCompleted(String outType) {
        boolean cancelRemainingInstances = this.getCompositeNode().isCancelRemainingInstances();
        this.triggerCompleted(outType, cancelRemainingInstances);
        if (cancelRemainingInstances) {
            while (!this.nodeInstances.isEmpty()) {
                NodeInstance nodeInstance = this.nodeInstances.get(0);
                nodeInstance.cancel();
            }
        }
    }

    @Override
    public void cancel() {
        while (!this.nodeInstances.isEmpty()) {
            NodeInstance nodeInstance = this.nodeInstances.get(0);
            nodeInstance.cancel();
        }
        super.cancel();
    }

    @Override
    public void addNodeInstance(NodeInstance nodeInstance) {
        ((NodeInstanceImpl)nodeInstance).setId(this.nodeInstanceCounter++);
        this.nodeInstances.add(nodeInstance);
    }

    @Override
    public void removeNodeInstance(NodeInstance nodeInstance) {
        this.nodeInstances.remove(nodeInstance);
    }

    public Collection<org.kie.runtime.process.NodeInstance> getNodeInstances() {
        return new ArrayList<org.kie.runtime.process.NodeInstance>(this.getNodeInstances(false));
    }

    @Override
    public Collection<NodeInstance> getNodeInstances(boolean recursive) {
        List<NodeInstance> result = this.nodeInstances;
        if (recursive) {
            result = new ArrayList<NodeInstance>(result);
            for (NodeInstance nodeInstance : this.nodeInstances) {
                if (!(nodeInstance instanceof NodeInstanceContainer)) continue;
                result.addAll(((NodeInstanceContainer)((Object)nodeInstance)).getNodeInstances(true));
            }
        }
        return Collections.unmodifiableCollection(result);
    }

    public NodeInstance getNodeInstance(long nodeInstanceId) {
        for (NodeInstance nodeInstance : this.nodeInstances) {
            if (nodeInstance.getId() != nodeInstanceId) continue;
            return nodeInstance;
        }
        return null;
    }

    @Override
    public NodeInstance getFirstNodeInstance(long nodeId) {
        for (NodeInstance nodeInstance : this.nodeInstances) {
            if (nodeInstance.getNodeId() != nodeId) continue;
            return nodeInstance;
        }
        return null;
    }

    @Override
    public NodeInstance getNodeInstance(Node node) {
        if (node instanceof CompositeNode.CompositeNodeStart) {
            CompositeNodeStartInstance nodeInstance = new CompositeNodeStartInstance();
            nodeInstance.setNodeId(node.getId());
            nodeInstance.setNodeInstanceContainer(this);
            nodeInstance.setProcessInstance(this.getProcessInstance());
            return nodeInstance;
        }
        if (node instanceof CompositeNode.CompositeNodeEnd) {
            CompositeNodeEndInstance nodeInstance = new CompositeNodeEndInstance();
            nodeInstance.setNodeId(node.getId());
            nodeInstance.setNodeInstanceContainer(this);
            nodeInstance.setProcessInstance(this.getProcessInstance());
            return nodeInstance;
        }
        NodeInstanceFactory conf = NodeInstanceFactoryRegistry.INSTANCE.getProcessNodeInstanceFactory(node);
        if (conf == null) {
            throw new IllegalArgumentException("Illegal node type: " + node.getClass());
        }
        NodeInstanceImpl nodeInstance = (NodeInstanceImpl)conf.getNodeInstance(node, this.getProcessInstance(), this);
        if (nodeInstance == null) {
            throw new IllegalArgumentException("Illegal node type: " + node.getClass());
        }
        return nodeInstance;
    }

    @Override
    public void signalEvent(String type, Object event) {
        super.signalEvent(type, event);
        for (Node node : this.getCompositeNode().internalGetNodes()) {
            if (!(node instanceof EventNodeInterface) || !((EventNodeInterface)node).acceptsEvent(type, event)) continue;
            if (node instanceof EventNode && ((EventNode)node).getFrom() == null) {
                EventNodeInstanceInterface eventNodeInstance = (EventNodeInstanceInterface)((Object)this.getNodeInstance(node));
                eventNodeInstance.signalEvent(type, event);
                continue;
            }
            List<NodeInstance> nodeInstances = this.getNodeInstances(node.getId());
            if (nodeInstances == null || nodeInstances.isEmpty()) continue;
            for (NodeInstance nodeInstance : nodeInstances) {
                ((EventNodeInstanceInterface)((Object)nodeInstance)).signalEvent(type, event);
            }
        }
    }

    public List<NodeInstance> getNodeInstances(long nodeId) {
        ArrayList<NodeInstance> result = new ArrayList<NodeInstance>();
        for (NodeInstance nodeInstance : this.nodeInstances) {
            if (nodeInstance.getNodeId() != nodeId) continue;
            result.add(nodeInstance);
        }
        return result;
    }

    @Override
    public void addEventListeners() {
        super.addEventListeners();
        for (NodeInstance nodeInstance : this.nodeInstances) {
            if (!(nodeInstance instanceof EventBasedNodeInstanceInterface)) continue;
            ((EventBasedNodeInstanceInterface)((Object)nodeInstance)).addEventListeners();
        }
    }

    @Override
    public void removeEventListeners() {
        super.removeEventListeners();
        for (NodeInstance nodeInstance : this.nodeInstances) {
            if (!(nodeInstance instanceof EventBasedNodeInstanceInterface)) continue;
            ((EventBasedNodeInstanceInterface)((Object)nodeInstance)).removeEventListeners();
        }
    }

    @Override
    public void nodeInstanceCompleted(NodeInstance nodeInstance, String outType) {
        if (nodeInstance instanceof EndNodeInstance) {
            if (((WorkflowProcess)this.getProcessInstance().getProcess()).isAutoComplete() && this.nodeInstances.isEmpty()) {
                this.triggerCompleted("DROOLS_DEFAULT");
            }
        } else {
            throw new IllegalArgumentException("Completing a node instance that has no outgoing connection not supported.");
        }
    }

    @Override
    public void setState(int state) {
        this.state = state;
    }

    @Override
    public int getState() {
        return this.state;
    }

    private static final class DoNothingEventListener
    implements EventListener,
    Serializable {
        private static final long serialVersionUID = 5L;

        private DoNothingEventListener() {
        }

        public String[] getEventTypes() {
            return null;
        }

        public void signalEvent(String type, Object event) {
        }
    }

    public class CompositeNodeEndInstance
    extends NodeInstanceImpl {
        private static final long serialVersionUID = 510L;

        public CompositeNode.CompositeNodeEnd getCompositeNodeEnd() {
            return (CompositeNode.CompositeNodeEnd)this.getNode();
        }

        @Override
        public void internalTrigger(org.kie.runtime.process.NodeInstance from, String type) {
            this.triggerCompleted();
        }

        public void triggerCompleted() {
            CompositeNodeInstance.this.triggerCompleted(this.getCompositeNodeEnd().getOutType());
        }
    }

    public class CompositeNodeStartInstance
    extends NodeInstanceImpl {
        private static final long serialVersionUID = 510L;

        public CompositeNode.CompositeNodeStart getCompositeNodeStart() {
            return (CompositeNode.CompositeNodeStart)this.getNode();
        }

        @Override
        public void internalTrigger(org.kie.runtime.process.NodeInstance from, String type) {
            this.triggerCompleted();
        }

        public void triggerCompleted() {
            this.triggerCompleted("DROOLS_DEFAULT", true);
        }
    }
}

