/*
 * Decompiled with CFR 0.152.
 */
package org.jbpm.workflow.core.impl;

import java.io.Serializable;
import java.util.HashMap;
import java.util.Map;
import org.jbpm.process.core.Context;
import org.jbpm.workflow.core.NodeContainer;
import org.kie.definition.process.Node;

public class NodeContainerImpl
implements Serializable,
NodeContainer {
    private static final long serialVersionUID = 510L;
    private Map<Long, Node> nodes = new HashMap<Long, Node>();

    @Override
    public void addNode(Node node) {
        this.validateAddNode(node);
        if (!this.nodes.containsValue(node)) {
            this.nodes.put(new Long(node.getId()), node);
        }
    }

    protected void validateAddNode(Node node) {
        if (node == null) {
            throw new IllegalArgumentException("Node is null!");
        }
    }

    public Node[] getNodes() {
        return this.nodes.values().toArray(new Node[this.nodes.size()]);
    }

    public Node getNode(long id) {
        Node node = this.nodes.get(id);
        if (node == null) {
            throw new IllegalArgumentException("Unknown node id: " + id);
        }
        return node;
    }

    @Override
    public Node internalGetNode(long id) {
        return this.getNode(id);
    }

    @Override
    public void removeNode(Node node) {
        this.validateRemoveNode(node);
        this.nodes.remove(new Long(node.getId()));
    }

    protected void validateRemoveNode(Node node) {
        if (node == null) {
            throw new IllegalArgumentException("Node is null");
        }
        if (this.nodes.get(node.getId()) == null) {
            throw new IllegalArgumentException("Unknown node: " + node);
        }
    }

    @Override
    public Context resolveContext(String contextId, Object param) {
        return null;
    }
}

