/*
 * Decompiled with CFR 0.152.
 */
package org.jbpm.process.core.timer.impl;

import java.io.Serializable;
import java.util.Collection;
import java.util.concurrent.Callable;
import java.util.concurrent.atomic.AtomicLong;
import org.drools.core.time.AcceptsTimerJobFactoryManager;
import org.drools.core.time.InternalSchedulerService;
import org.drools.core.time.JobContext;
import org.drools.core.time.JobHandle;
import org.drools.core.time.TimerService;
import org.drools.core.time.Trigger;
import org.drools.core.time.impl.TimerJobInstance;
import org.jbpm.process.core.timer.GlobalSchedulerService;
import org.jbpm.process.core.timer.TimerServiceRegistry;
import org.jbpm.process.core.timer.impl.GlobalTimerService;
import org.jbpm.process.instance.timer.TimerManager;
import org.quartz.Job;
import org.quartz.JobDetail;
import org.quartz.JobExecutionContext;
import org.quartz.JobExecutionException;
import org.quartz.JobPersistenceException;
import org.quartz.Scheduler;
import org.quartz.SchedulerException;
import org.quartz.SchedulerMetaData;
import org.quartz.SimpleTrigger;
import org.quartz.impl.StdSchedulerFactory;
import org.quartz.impl.jdbcjobstore.JobStoreCMT;

public class QuartzSchedulerService
implements GlobalSchedulerService {
    private AtomicLong idCounter = new AtomicLong();
    private TimerService globalTimerService;
    private Scheduler scheduler;

    public JobHandle scheduleJob(org.drools.core.time.Job job, JobContext ctx, Trigger trigger) {
        Long id = this.idCounter.getAndIncrement();
        String jobname = null;
        if (ctx instanceof TimerManager.ProcessJobContext) {
            TimerManager.ProcessJobContext processCtx = (TimerManager.ProcessJobContext)ctx;
            jobname = processCtx.getSessionId() + "-" + processCtx.getProcessInstanceId() + "-" + processCtx.getTimer().getId();
            if (processCtx instanceof TimerManager.StartProcessJobContext) {
                jobname = "StartProcess-" + ((TimerManager.StartProcessJobContext)processCtx).getProcessId() + "-" + processCtx.getTimer().getId();
            }
        } else {
            jobname = "Timer-" + ctx.getClass().getSimpleName() + "-" + id;
        }
        try {
            JobDetail jobDetail = this.scheduler.getJobDetail(jobname, "jbpm");
            if (jobDetail != null) {
                TimerJobInstance timerJobInstance = (TimerJobInstance)jobDetail.getJobDataMap().get((Object)"timerJobInstance");
                return timerJobInstance.getJobHandle();
            }
        }
        catch (SchedulerException e) {
            // empty catch block
        }
        GlobalQuartzJobHandle quartzJobHandle = new GlobalQuartzJobHandle(id, jobname, "jbpm");
        TimerJobInstance jobInstance = ((AcceptsTimerJobFactoryManager)this.globalTimerService).getTimerJobFactoryManager().createTimerJobInstance(job, ctx, trigger, (JobHandle)quartzJobHandle, (InternalSchedulerService)this.globalTimerService);
        quartzJobHandle.setTimerJobInstance(jobInstance);
        this.internalSchedule(jobInstance);
        return quartzJobHandle;
    }

    public boolean removeJob(JobHandle jobHandle) {
        GlobalQuartzJobHandle quartzJobHandle = (GlobalQuartzJobHandle)jobHandle;
        try {
            boolean removed = this.scheduler.deleteJob(quartzJobHandle.getJobName(), quartzJobHandle.getJobGroup());
            return removed;
        }
        catch (SchedulerException e) {
            throw new RuntimeException("Exception while removing job", e);
        }
        catch (RuntimeException e) {
            try {
                SchedulerMetaData metadata = this.scheduler.getMetaData();
                if (metadata.getJobStoreClass().isAssignableFrom(JobStoreCMT.class)) {
                    return true;
                }
            }
            catch (SchedulerException e1) {
                // empty catch block
            }
            throw e;
        }
    }

    public void internalSchedule(TimerJobInstance timerJobInstance) {
        GlobalQuartzJobHandle quartzJobHandle = (GlobalQuartzJobHandle)timerJobInstance.getJobHandle();
        JobDetail jobq = new JobDetail(quartzJobHandle.getJobName(), quartzJobHandle.getJobGroup(), QuartzJob.class);
        jobq.getJobDataMap().put((Object)"timerJobInstance", (Object)timerJobInstance);
        SimpleTrigger triggerq = new SimpleTrigger(quartzJobHandle.getJobName() + "_trigger", quartzJobHandle.getJobGroup(), timerJobInstance.getTrigger().hasNextFireTime());
        try {
            if (this.scheduler.isShutdown()) {
                return;
            }
            ((AcceptsTimerJobFactoryManager)this.globalTimerService).getTimerJobFactoryManager().addTimerJobInstance(timerJobInstance);
            JobDetail jobDetail = this.scheduler.getJobDetail(quartzJobHandle.getJobName(), quartzJobHandle.getJobGroup());
            if (jobDetail == null) {
                this.scheduler.scheduleJob(jobq, (org.quartz.Trigger)triggerq);
            } else {
                this.scheduler.addJob(jobq, true);
                triggerq.setJobName(quartzJobHandle.getJobName());
                triggerq.setJobGroup(quartzJobHandle.getJobGroup());
                this.scheduler.rescheduleJob(quartzJobHandle.getJobName() + "_trigger", quartzJobHandle.getJobGroup(), (org.quartz.Trigger)triggerq);
            }
        }
        catch (JobPersistenceException e) {
            this.internalSchedule(new InmemoryTimerJobInstanceDelegate(quartzJobHandle.getJobName(), ((GlobalTimerService)this.globalTimerService).getTimerServiceId()));
        }
        catch (SchedulerException e) {
            ((AcceptsTimerJobFactoryManager)this.globalTimerService).getTimerJobFactoryManager().removeTimerJobInstance(timerJobInstance);
            throw new RuntimeException("Exception while scheduling job", e);
        }
    }

    @Override
    public void initScheduler(TimerService timerService) {
        this.globalTimerService = timerService;
        try {
            this.scheduler = StdSchedulerFactory.getDefaultScheduler();
            this.scheduler.start();
        }
        catch (SchedulerException e) {
            throw new RuntimeException("Exception when initializing QuartzSchedulerService", e);
        }
    }

    @Override
    public void shutdown() {
        if (this.scheduler != null) {
            try {
                this.scheduler.shutdown();
            }
            catch (SchedulerException schedulerException) {
                // empty catch block
            }
        }
    }

    public static class InmemoryTimerJobInstanceDelegate
    implements TimerJobInstance,
    Serializable,
    Callable<Void> {
        private static final long serialVersionUID = 1L;
        private String jobname;
        private String timerServiceId;
        private transient TimerJobInstance delegate;

        public InmemoryTimerJobInstanceDelegate(String jobName, String timerServiceId) {
            this.jobname = jobName;
            this.timerServiceId = timerServiceId;
        }

        public JobHandle getJobHandle() {
            this.findDelegate();
            return this.delegate.getJobHandle();
        }

        public org.drools.core.time.Job getJob() {
            this.findDelegate();
            return this.delegate.getJob();
        }

        public Trigger getTrigger() {
            this.findDelegate();
            return this.delegate.getTrigger();
        }

        public JobContext getJobContext() {
            this.findDelegate();
            return this.delegate.getJobContext();
        }

        protected void findDelegate() {
            if (this.delegate == null) {
                Collection timers = ((AcceptsTimerJobFactoryManager)TimerServiceRegistry.getInstance().get(this.timerServiceId)).getTimerJobFactoryManager().getTimerJobInstances();
                for (TimerJobInstance instance : timers) {
                    if (!((GlobalQuartzJobHandle)instance.getJobHandle()).getJobName().equals(this.jobname)) continue;
                    this.delegate = instance;
                    break;
                }
            }
        }

        @Override
        public Void call() throws Exception {
            this.findDelegate();
            return (Void)((Callable)this.delegate).call();
        }
    }

    public static class QuartzJob
    implements Job {
        public void execute(JobExecutionContext quartzContext) throws JobExecutionException {
            TimerJobInstance timerJobInstance = (TimerJobInstance)quartzContext.getJobDetail().getJobDataMap().get((Object)"timerJobInstance");
            try {
                ((Callable)timerJobInstance).call();
            }
            catch (Exception e) {
                throw new RuntimeException("Exception when executing scheduled job", e);
            }
        }
    }

    public static class GlobalQuartzJobHandle
    extends GlobalTimerService.GlobalJobHandle {
        private static final long serialVersionUID = 510L;
        private String jobName;
        private String jobGroup;

        public GlobalQuartzJobHandle(long id, String name, String group) {
            super(id);
            this.jobName = name;
            this.jobGroup = group;
        }

        public String getJobName() {
            return this.jobName;
        }

        public void setJobName(String jobName) {
            this.jobName = jobName;
        }

        public String getJobGroup() {
            return this.jobGroup;
        }

        public void setJobGroup(String jobGroup) {
            this.jobGroup = jobGroup;
        }
    }
}

