/*
 * Decompiled with CFR 0.152.
 */
package org.jbpm.workflow.instance.impl;

import java.util.HashMap;
import java.util.Map;
import org.jbpm.workflow.core.node.ActionNode;
import org.jbpm.workflow.core.node.CatchLinkNode;
import org.jbpm.workflow.core.node.CompositeContextNode;
import org.jbpm.workflow.core.node.CompositeNode;
import org.jbpm.workflow.core.node.DynamicNode;
import org.jbpm.workflow.core.node.EndNode;
import org.jbpm.workflow.core.node.EventNode;
import org.jbpm.workflow.core.node.EventSubProcessNode;
import org.jbpm.workflow.core.node.FaultNode;
import org.jbpm.workflow.core.node.ForEachNode;
import org.jbpm.workflow.core.node.HumanTaskNode;
import org.jbpm.workflow.core.node.Join;
import org.jbpm.workflow.core.node.MilestoneNode;
import org.jbpm.workflow.core.node.RuleSetNode;
import org.jbpm.workflow.core.node.Split;
import org.jbpm.workflow.core.node.StartNode;
import org.jbpm.workflow.core.node.StateNode;
import org.jbpm.workflow.core.node.SubProcessNode;
import org.jbpm.workflow.core.node.ThrowLinkNode;
import org.jbpm.workflow.core.node.TimerNode;
import org.jbpm.workflow.core.node.WorkItemNode;
import org.jbpm.workflow.instance.impl.NodeInstanceFactory;
import org.jbpm.workflow.instance.impl.factory.CreateNewNodeFactory;
import org.jbpm.workflow.instance.impl.factory.ReuseNodeFactory;
import org.jbpm.workflow.instance.node.ActionNodeInstance;
import org.jbpm.workflow.instance.node.CatchLinkNodeInstance;
import org.jbpm.workflow.instance.node.CompositeContextNodeInstance;
import org.jbpm.workflow.instance.node.CompositeNodeInstance;
import org.jbpm.workflow.instance.node.DynamicNodeInstance;
import org.jbpm.workflow.instance.node.EndNodeInstance;
import org.jbpm.workflow.instance.node.EventNodeInstance;
import org.jbpm.workflow.instance.node.EventSubProcessNodeInstance;
import org.jbpm.workflow.instance.node.FaultNodeInstance;
import org.jbpm.workflow.instance.node.ForEachNodeInstance;
import org.jbpm.workflow.instance.node.HumanTaskNodeInstance;
import org.jbpm.workflow.instance.node.JoinInstance;
import org.jbpm.workflow.instance.node.MilestoneNodeInstance;
import org.jbpm.workflow.instance.node.RuleSetNodeInstance;
import org.jbpm.workflow.instance.node.SplitInstance;
import org.jbpm.workflow.instance.node.StartNodeInstance;
import org.jbpm.workflow.instance.node.StateNodeInstance;
import org.jbpm.workflow.instance.node.SubProcessNodeInstance;
import org.jbpm.workflow.instance.node.ThrowLinkNodeInstance;
import org.jbpm.workflow.instance.node.TimerNodeInstance;
import org.jbpm.workflow.instance.node.WorkItemNodeInstance;
import org.kie.api.definition.process.Node;

public class NodeInstanceFactoryRegistry {
    public static final NodeInstanceFactoryRegistry INSTANCE = new NodeInstanceFactoryRegistry();
    private Map<Class<? extends Node>, NodeInstanceFactory> registry = new HashMap<Class<? extends Node>, NodeInstanceFactory>();

    private NodeInstanceFactoryRegistry() {
        this.register(RuleSetNode.class, new CreateNewNodeFactory(RuleSetNodeInstance.class));
        this.register(Split.class, new CreateNewNodeFactory(SplitInstance.class));
        this.register(Join.class, new ReuseNodeFactory(JoinInstance.class));
        this.register(StartNode.class, new CreateNewNodeFactory(StartNodeInstance.class));
        this.register(EndNode.class, new CreateNewNodeFactory(EndNodeInstance.class));
        this.register(MilestoneNode.class, new CreateNewNodeFactory(MilestoneNodeInstance.class));
        this.register(SubProcessNode.class, new CreateNewNodeFactory(SubProcessNodeInstance.class));
        this.register(ActionNode.class, new CreateNewNodeFactory(ActionNodeInstance.class));
        this.register(WorkItemNode.class, new CreateNewNodeFactory(WorkItemNodeInstance.class));
        this.register(TimerNode.class, new CreateNewNodeFactory(TimerNodeInstance.class));
        this.register(FaultNode.class, new CreateNewNodeFactory(FaultNodeInstance.class));
        this.register(EventSubProcessNode.class, new CreateNewNodeFactory(EventSubProcessNodeInstance.class));
        this.register(CompositeNode.class, new CreateNewNodeFactory(CompositeNodeInstance.class));
        this.register(CompositeContextNode.class, new CreateNewNodeFactory(CompositeContextNodeInstance.class));
        this.register(HumanTaskNode.class, new CreateNewNodeFactory(HumanTaskNodeInstance.class));
        this.register(ForEachNode.class, new CreateNewNodeFactory(ForEachNodeInstance.class));
        this.register(EventNode.class, new CreateNewNodeFactory(EventNodeInstance.class));
        this.register(StateNode.class, new CreateNewNodeFactory(StateNodeInstance.class));
        this.register(DynamicNode.class, new CreateNewNodeFactory(DynamicNodeInstance.class));
        this.register(CatchLinkNode.class, new CreateNewNodeFactory(CatchLinkNodeInstance.class));
        this.register(ThrowLinkNode.class, new CreateNewNodeFactory(ThrowLinkNodeInstance.class));
    }

    public void register(Class<? extends Node> cls, NodeInstanceFactory factory) {
        this.registry.put(cls, factory);
    }

    public NodeInstanceFactory getProcessNodeInstanceFactory(Node node) {
        for (Class<?> clazz = node.getClass(); clazz != null; clazz = clazz.getSuperclass()) {
            NodeInstanceFactory result = this.registry.get(clazz);
            if (result == null) continue;
            return result;
        }
        return null;
    }
}

