/*
 * Decompiled with CFR 0.152.
 */
package org.jbpm.process;

import java.util.ArrayList;
import java.util.HashMap;
import org.drools.core.process.core.datatype.DataType;
import org.drools.core.process.core.datatype.impl.type.ListDataType;
import org.drools.core.process.core.datatype.impl.type.ObjectDataType;
import org.jbpm.process.core.context.variable.Variable;
import org.jbpm.process.instance.impl.Action;
import org.jbpm.process.test.Person;
import org.jbpm.process.test.TestProcessEventListener;
import org.jbpm.ruleflow.core.RuleFlowProcess;
import org.jbpm.test.util.AbstractBaseTest;
import org.jbpm.workflow.core.DroolsAction;
import org.jbpm.workflow.core.impl.ConnectionImpl;
import org.jbpm.workflow.core.impl.DroolsConsequenceAction;
import org.jbpm.workflow.core.node.ActionNode;
import org.jbpm.workflow.core.node.EndNode;
import org.jbpm.workflow.core.node.ForEachNode;
import org.jbpm.workflow.core.node.StartNode;
import org.junit.Assert;
import org.junit.Test;
import org.kie.api.definition.process.Node;
import org.kie.api.definition.process.Process;
import org.kie.api.event.process.ProcessEventListener;
import org.kie.api.runtime.KieSession;
import org.kie.api.runtime.process.ProcessContext;
import org.slf4j.LoggerFactory;

public class ForEachTest
extends AbstractBaseTest {
    private String[] eventOrder = new String[]{"bvc-persons", "avc-persons", "bps", "bnt-0", "bnl-0", "bnt-1", "bvc-3:2:child", "avc-3:2:child", "bvc-3:2:child", "avc-3:2:child", "bvc-3:2:child", "avc-3:2:child", "bnt-1:5:9", "bnl-1:5:9", "anl-1:5:9", "ant-1:5:9", "bnt-1:6:13", "bnl-1:6:13", "anl-1:6:13", "ant-1:6:13", "bnt-1:7:16", "bnl-1:7:16", "bnl-1", "bnt-18", "bnl-18", "bpc", "apc", "anl-18", "ant-18", "anl-1", "anl-1:7:16", "ant-1:7:16", "ant-1", "anl-0", "ant-0", "aps"};

    @Override
    public void addLogger() {
        this.logger = LoggerFactory.getLogger(this.getClass());
    }

    @Test
    public void testForEach() {
        RuleFlowProcess process = new RuleFlowProcess();
        process.setId("org.drools.core.process.foreach");
        process.setName("ForEach Process");
        ArrayList<Variable> variables = new ArrayList<Variable>();
        Variable variable = new Variable();
        variable.setName("persons");
        ListDataType listDataType = new ListDataType();
        ObjectDataType personDataType = new ObjectDataType();
        personDataType.setClassName("org.jbpm.process.test.Person");
        listDataType.setType((DataType)personDataType);
        variable.setType((DataType)listDataType);
        variables.add(variable);
        process.getVariableScope().setVariables(variables);
        StartNode startNode = new StartNode();
        startNode.setName("Start");
        startNode.setId(1L);
        process.addNode((Node)startNode);
        EndNode endNode = new EndNode();
        endNode.setName("EndNode");
        endNode.setId(2L);
        process.addNode((Node)endNode);
        ForEachNode forEachNode = new ForEachNode();
        forEachNode.setName("ForEach");
        forEachNode.setId(3L);
        forEachNode.setCollectionExpression("persons");
        personDataType = new ObjectDataType();
        personDataType.setClassName("org.drools.Person");
        process.addNode((Node)forEachNode);
        new ConnectionImpl((Node)startNode, "DROOLS_DEFAULT", (Node)forEachNode, "DROOLS_DEFAULT");
        new ConnectionImpl((Node)forEachNode, "DROOLS_DEFAULT", (Node)endNode, "DROOLS_DEFAULT");
        final ArrayList myList = new ArrayList();
        ActionNode actionNode = new ActionNode();
        actionNode.setName("Print child");
        DroolsConsequenceAction action = new DroolsConsequenceAction("java", null);
        action.setMetaData("Action", (Object)new Action(){

            public void execute(ProcessContext context) throws Exception {
                ForEachTest.this.logger.info("Executed action for child {}", (Object)((Person)context.getVariable("child")).getName());
                myList.add("Executed action");
            }
        });
        actionNode.setAction((DroolsAction)action);
        forEachNode.addNode((Node)actionNode);
        forEachNode.linkIncomingConnections("DROOLS_DEFAULT", actionNode.getId(), "DROOLS_DEFAULT");
        forEachNode.linkOutgoingConnections(actionNode.getId(), "DROOLS_DEFAULT", "DROOLS_DEFAULT");
        forEachNode.setVariable("child", (DataType)personDataType);
        KieSession ksession = this.createKieSession(new Process[]{process});
        HashMap parameters = new HashMap();
        ArrayList<Person> persons = new ArrayList<Person>();
        persons.add(new Person("John Doe"));
        persons.add(new Person("Jane Doe"));
        persons.add(new Person("Jack"));
        parameters.put("persons", persons);
        TestProcessEventListener procEventListener = new TestProcessEventListener();
        ksession.addEventListener((ProcessEventListener)procEventListener);
        ksession.startProcess("org.drools.core.process.foreach", parameters);
        Assert.assertEquals((long)3L, (long)myList.size());
        this.verifyEventHistory(this.eventOrder, procEventListener.getEventHistory());
    }
}

