/*
 * Decompiled with CFR 0.152.
 */
package org.jbpm.workflow.instance.node;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.regex.Matcher;
import org.jbpm.test.util.AbstractBaseTest;
import org.jbpm.workflow.instance.node.StateBasedNodeInstance;
import org.junit.Assert;
import org.junit.Test;
import org.slf4j.LoggerFactory;

public class ParameterResolverTest
extends AbstractBaseTest {
    @Override
    public void addLogger() {
        this.logger = LoggerFactory.getLogger(this.getClass());
    }

    @Test
    public void testSingleVariable() {
        String[] expected = new String[]{"var1"};
        String s = "#{var1}";
        ArrayList<String> foundVariables = new ArrayList<String>();
        Matcher matcher = StateBasedNodeInstance.PARAMETER_MATCHER.matcher(s);
        while (matcher.find()) {
            String paramName = matcher.group(1);
            foundVariables.add(paramName);
        }
        Assert.assertEquals((long)1L, (long)foundVariables.size());
        Assert.assertEquals(Arrays.asList(expected), foundVariables);
    }

    @Test
    public void testSingleVariableEnclosedWithText() {
        String[] expected = new String[]{"var1"};
        String s = "this is my #{var1} variable";
        ArrayList<String> foundVariables = new ArrayList<String>();
        Matcher matcher = StateBasedNodeInstance.PARAMETER_MATCHER.matcher(s);
        while (matcher.find()) {
            String paramName = matcher.group(1);
            foundVariables.add(paramName);
        }
        Assert.assertEquals((long)1L, (long)foundVariables.size());
        Assert.assertEquals(Arrays.asList(expected), foundVariables);
    }

    @Test
    public void testMultiVariableWithoutWhitespace() {
        String[] expected = new String[]{"var1", "var2"};
        String s = "#{var1}=#{var2}";
        ArrayList<String> foundVariables = new ArrayList<String>();
        Matcher matcher = StateBasedNodeInstance.PARAMETER_MATCHER.matcher(s);
        while (matcher.find()) {
            String paramName = matcher.group(1);
            foundVariables.add(paramName);
        }
        Assert.assertEquals((long)2L, (long)foundVariables.size());
        Assert.assertEquals(Arrays.asList(expected), foundVariables);
    }

    @Test
    public void testMultiVariableSeparatedWithComma() {
        String[] expected = new String[]{"var1", "var2"};
        String s = "#{var1},#{var2}";
        ArrayList<String> foundVariables = new ArrayList<String>();
        Matcher matcher = StateBasedNodeInstance.PARAMETER_MATCHER.matcher(s);
        while (matcher.find()) {
            String paramName = matcher.group(1);
            foundVariables.add(paramName);
        }
        Assert.assertEquals((long)2L, (long)foundVariables.size());
        Assert.assertEquals(Arrays.asList(expected), foundVariables);
    }

    @Test
    public void testMultiVariableEnclosedWithText() {
        String[] expected = new String[]{"var1", "var2"};
        String s = "Here are my two #{var1},#{var2} variables";
        ArrayList<String> foundVariables = new ArrayList<String>();
        Matcher matcher = StateBasedNodeInstance.PARAMETER_MATCHER.matcher(s);
        while (matcher.find()) {
            String paramName = matcher.group(1);
            foundVariables.add(paramName);
        }
        Assert.assertEquals((long)2L, (long)foundVariables.size());
        Assert.assertEquals(Arrays.asList(expected), foundVariables);
    }

    @Test
    public void testMultiVariableNextToEachOther() {
        String[] expected = new String[]{"var1", "var2"};
        String s = "#{var1}#{var2}";
        ArrayList<String> foundVariables = new ArrayList<String>();
        Matcher matcher = StateBasedNodeInstance.PARAMETER_MATCHER.matcher(s);
        while (matcher.find()) {
            String paramName = matcher.group(1);
            foundVariables.add(paramName);
        }
        Assert.assertEquals((long)2L, (long)foundVariables.size());
        Assert.assertEquals(Arrays.asList(expected), foundVariables);
    }
}

