/*
 * Decompiled with CFR 0.152.
 */
package org.jbpm.process;

import java.util.ArrayList;
import org.drools.core.process.core.datatype.DataType;
import org.drools.core.process.core.datatype.impl.type.ObjectDataType;
import org.jbpm.process.core.context.variable.Variable;
import org.jbpm.process.core.event.EventFilter;
import org.jbpm.process.core.event.EventTypeFilter;
import org.jbpm.process.instance.impl.Action;
import org.jbpm.process.test.Person;
import org.jbpm.process.test.TestProcessEventListener;
import org.jbpm.ruleflow.core.RuleFlowProcess;
import org.jbpm.test.util.AbstractBaseTest;
import org.jbpm.workflow.core.DroolsAction;
import org.jbpm.workflow.core.impl.ConnectionImpl;
import org.jbpm.workflow.core.impl.DroolsConsequenceAction;
import org.jbpm.workflow.core.node.ActionNode;
import org.jbpm.workflow.core.node.CompositeNode;
import org.jbpm.workflow.core.node.EndNode;
import org.jbpm.workflow.core.node.EventNode;
import org.jbpm.workflow.core.node.Join;
import org.jbpm.workflow.core.node.MilestoneNode;
import org.jbpm.workflow.core.node.StartNode;
import org.junit.Assert;
import org.junit.Test;
import org.kie.api.definition.process.Node;
import org.kie.api.definition.process.Process;
import org.kie.api.event.process.ProcessEventListener;
import org.kie.api.runtime.KieSession;
import org.kie.api.runtime.process.ProcessContext;
import org.kie.api.runtime.process.ProcessInstance;
import org.slf4j.LoggerFactory;

public class EventTest
extends AbstractBaseTest {
    String[] test1EventOrder = new String[]{"bps", "bnt-0", "bnl-0", "bnt-1", "ant-1", "anl-0", "ant-0", "aps", "bvc-event", "avc-event", "bnl-2", "bnt-3", "bnl-3", "bnt-4", "bnl-4", "bnt-5", "bnl-5", "bpc", "anl-1", "apc", "anl-5", "ant-5", "anl-4", "ant-4", "anl-3", "ant-3", "anl-2"};
    String[] test2EventOrder = new String[]{"bps", "bnt-0", "bnl-0", "bnt-1", "ant-1", "anl-0", "ant-0", "aps", "bvc-event", "avc-event", "bnl-2", "bnt-3", "bnl-3", "bnt-4", "bnl-4", "anl-4", "ant-4", "anl-3", "ant-3", "anl-2", "bvc-event", "avc-event", "bnl-5", "bnt-6", "bnl-6", "bnt-7", "bnl-7", "anl-7", "ant-7", "anl-6", "ant-6", "anl-5"};
    String[] test3EventOrder = new String[]{"bps", "bnt-0", "bnl-0", "bnt-1", "ant-1", "anl-0", "ant-0", "aps", "bvc-event", "avc-event", "bnl-2", "bnt-3", "bnl-3", "bnt-1", "ant-1", "anl-3", "ant-3", "anl-2", "bvc-event", "avc-event", "bnl-4", "bnt-5", "bnl-5", "bnt-1", "bnl-1", "bnt-6", "bnl-6", "bpc", "apc", "anl-6", "ant-6", "anl-1", "ant-1", "anl-5", "ant-5", "anl-4"};
    String[] test3aEventOrder = new String[]{"bps", "bnt-0", "bnl-0", "bnt-1", "ant-1", "anl-0", "ant-0", "aps", "bvc-event", "avc-event", "bnl-2", "bnt-3", "bnl-3", "bnt-1", "ant-1", "anl-3", "ant-3", "anl-2", "bvc-event", "avc-event", "bnl-4", "bnt-5", "bnl-5", "bnt-1", "ant-1", "anl-5", "ant-5", "anl-4", "bvc-event", "avc-event", "bnl-6", "bnt-7", "bnl-7", "bnt-1", "bnl-1", "bnt-8", "bnl-8", "bpc", "anl-1", "apc", "anl-8", "ant-8", "anl-1", "ant-1", "anl-7", "ant-7", "anl-6"};
    String[] test4EventOrder = new String[]{"bps", "bnt-0", "bnl-0", "bnt-1", "ant-1", "anl-0", "ant-0", "aps", "bnl-2", "bnt-3", "bnl-3", "bnt-1", "ant-1", "anl-3", "ant-3", "anl-2", "bnl-4", "bnt-5", "bnl-5", "bnt-1", "bnl-1", "bnt-6", "bnl-6", "bpc", "apc", "anl-6", "ant-6", "anl-1", "ant-1", "anl-5", "ant-5", "anl-4"};
    String[] test5EventOrder = new String[]{"bps", "bnt-0", "bnl-0", "bnt-1", "bnt-1:4", "ant-1:4", "ant-1", "anl-0", "ant-0", "aps", "bvc-event", "avc-event", "bnl-1:5", "bnt-1:6", "bnl-1:6", "bnt-1:7", "bnl-1:7", "bnl-1", "bnt-8", "bnl-8", "bpc", "apc", "anl-8", "ant-8", "anl-1", "anl-1:4", "anl-1:7", "ant-1:7", "anl-1:6", "ant-1:6", "anl-1:5"};

    @Override
    public void addLogger() {
        this.logger = LoggerFactory.getLogger(this.getClass());
    }

    @Test
    public void testEvent1() {
        RuleFlowProcess process = new RuleFlowProcess();
        process.setId("org.drools.core.process.event");
        process.setName("Event Process");
        ArrayList<Variable> variables = new ArrayList<Variable>();
        Variable variable = new Variable();
        variable.setName("event");
        ObjectDataType personDataType = new ObjectDataType();
        personDataType.setClassName("org.drools.Person");
        variable.setType((DataType)personDataType);
        variables.add(variable);
        process.getVariableScope().setVariables(variables);
        StartNode startNode = new StartNode();
        startNode.setName("Start");
        startNode.setId(1L);
        process.addNode((Node)startNode);
        MilestoneNode milestoneNode = new MilestoneNode();
        milestoneNode.setName("Milestone");
        milestoneNode.setConstraint("eval(false)");
        milestoneNode.setId(2L);
        process.addNode((Node)milestoneNode);
        new ConnectionImpl((Node)startNode, "DROOLS_DEFAULT", (Node)milestoneNode, "DROOLS_DEFAULT");
        EventNode eventNode = new EventNode();
        EventTypeFilter eventFilter = new EventTypeFilter();
        eventFilter.setType("myEvent");
        eventNode.addEventFilter((EventFilter)eventFilter);
        eventNode.setVariableName("event");
        eventNode.setId(3L);
        process.addNode((Node)eventNode);
        final ArrayList myList = new ArrayList();
        ActionNode actionNode = new ActionNode();
        actionNode.setName("Print");
        DroolsConsequenceAction action = new DroolsConsequenceAction("java", null);
        action.setMetaData("Action", (Object)new Action(){

            public void execute(ProcessContext context) throws Exception {
                EventTest.this.logger.info("Detected event for person {}", (Object)((Person)context.getVariable("event")).getName());
                myList.add("Executed action");
            }
        });
        actionNode.setAction((DroolsAction)action);
        actionNode.setId(4L);
        process.addNode((Node)actionNode);
        new ConnectionImpl((Node)eventNode, "DROOLS_DEFAULT", (Node)actionNode, "DROOLS_DEFAULT");
        Join join = new Join();
        join.setName("XOR Join");
        join.setType(2);
        join.setId(5L);
        process.addNode((Node)join);
        new ConnectionImpl((Node)milestoneNode, "DROOLS_DEFAULT", (Node)join, "DROOLS_DEFAULT");
        new ConnectionImpl((Node)actionNode, "DROOLS_DEFAULT", (Node)join, "DROOLS_DEFAULT");
        EndNode endNode = new EndNode();
        endNode.setName("EndNode");
        endNode.setId(6L);
        process.addNode((Node)endNode);
        new ConnectionImpl((Node)join, "DROOLS_DEFAULT", (Node)endNode, "DROOLS_DEFAULT");
        KieSession ksession = this.createKieSession(new Process[]{process});
        TestProcessEventListener procEventListener = new TestProcessEventListener();
        ksession.addEventListener((ProcessEventListener)procEventListener);
        ProcessInstance processInstance = ksession.startProcess("org.drools.core.process.event");
        Assert.assertEquals((long)0L, (long)myList.size());
        Person jack = new Person();
        jack.setName("Jack");
        processInstance.signalEvent("myEvent", (Object)jack);
        Assert.assertEquals((long)1L, (long)myList.size());
        Assert.assertEquals((long)2L, (long)processInstance.getState());
        this.verifyEventHistory(this.test1EventOrder, procEventListener.getEventHistory());
    }

    @Test
    public void testEvent2() {
        RuleFlowProcess process = new RuleFlowProcess();
        process.setId("org.drools.core.process.event");
        process.setName("Event Process");
        ArrayList<Variable> variables = new ArrayList<Variable>();
        Variable variable = new Variable();
        variable.setName("event");
        ObjectDataType personDataType = new ObjectDataType();
        personDataType.setClassName("org.drools.Person");
        variable.setType((DataType)personDataType);
        variables.add(variable);
        process.getVariableScope().setVariables(variables);
        StartNode startNode = new StartNode();
        startNode.setName("Start");
        startNode.setId(1L);
        process.addNode((Node)startNode);
        MilestoneNode milestoneNode = new MilestoneNode();
        milestoneNode.setName("Milestone");
        milestoneNode.setConstraint("eval(false)");
        milestoneNode.setId(2L);
        process.addNode((Node)milestoneNode);
        new ConnectionImpl((Node)startNode, "DROOLS_DEFAULT", (Node)milestoneNode, "DROOLS_DEFAULT");
        EndNode endNode = new EndNode();
        endNode.setName("EndNode");
        endNode.setId(3L);
        process.addNode((Node)endNode);
        new ConnectionImpl((Node)milestoneNode, "DROOLS_DEFAULT", (Node)endNode, "DROOLS_DEFAULT");
        EventNode eventNode = new EventNode();
        EventTypeFilter eventFilter = new EventTypeFilter();
        eventFilter.setType("myEvent");
        eventNode.addEventFilter((EventFilter)eventFilter);
        eventNode.setVariableName("event");
        eventNode.setId(4L);
        process.addNode((Node)eventNode);
        final ArrayList myList = new ArrayList();
        ActionNode actionNode = new ActionNode();
        actionNode.setName("Print");
        DroolsConsequenceAction action = new DroolsConsequenceAction("java", null);
        action.setMetaData("Action", (Object)new Action(){

            public void execute(ProcessContext context) throws Exception {
                EventTest.this.logger.info("Detected event for person {}", (Object)((Person)context.getVariable("event")).getName());
                myList.add("Executed action");
            }
        });
        actionNode.setAction((DroolsAction)action);
        actionNode.setId(5L);
        process.addNode((Node)actionNode);
        new ConnectionImpl((Node)eventNode, "DROOLS_DEFAULT", (Node)actionNode, "DROOLS_DEFAULT");
        EndNode endNode2 = new EndNode();
        endNode2.setName("EndNode");
        endNode2.setTerminate(false);
        endNode2.setId(6L);
        process.addNode((Node)endNode2);
        new ConnectionImpl((Node)actionNode, "DROOLS_DEFAULT", (Node)endNode2, "DROOLS_DEFAULT");
        KieSession ksession = this.createKieSession(new Process[]{process});
        TestProcessEventListener procEventListener = new TestProcessEventListener();
        ksession.addEventListener((ProcessEventListener)procEventListener);
        ProcessInstance processInstance = ksession.startProcess("org.drools.core.process.event");
        Assert.assertEquals((long)0L, (long)myList.size());
        Person jack = new Person();
        jack.setName("Jack");
        processInstance.signalEvent("myEvent", (Object)jack);
        Assert.assertEquals((long)1L, (long)myList.size());
        Person john = new Person();
        john.setName("John");
        processInstance.signalEvent("myEvent", (Object)john);
        Assert.assertEquals((long)2L, (long)myList.size());
        this.verifyEventHistory(this.test2EventOrder, procEventListener.getEventHistory());
    }

    @Test
    public void testEvent3() {
        RuleFlowProcess process = new RuleFlowProcess();
        process.setId("org.drools.core.process.event");
        process.setName("Event Process");
        ArrayList<Variable> variables = new ArrayList<Variable>();
        Variable variable = new Variable();
        variable.setName("event");
        ObjectDataType personDataType = new ObjectDataType();
        personDataType.setClassName("org.drools.Person");
        variable.setType((DataType)personDataType);
        variables.add(variable);
        process.getVariableScope().setVariables(variables);
        StartNode startNode = new StartNode();
        startNode.setName("Start");
        startNode.setId(1L);
        process.addNode((Node)startNode);
        EventNode eventNode = new EventNode();
        EventTypeFilter eventFilter = new EventTypeFilter();
        eventFilter.setType("myEvent");
        eventNode.addEventFilter((EventFilter)eventFilter);
        eventNode.setVariableName("event");
        eventNode.setId(3L);
        process.addNode((Node)eventNode);
        final ArrayList myList = new ArrayList();
        ActionNode actionNode = new ActionNode();
        actionNode.setName("Print");
        DroolsConsequenceAction action = new DroolsConsequenceAction("java", null);
        action.setMetaData("Action", (Object)new Action(){

            public void execute(ProcessContext context) throws Exception {
                EventTest.this.logger.info("Detected event for person {}", (Object)((Person)context.getVariable("event")).getName());
                myList.add("Executed action");
            }
        });
        actionNode.setAction((DroolsAction)action);
        actionNode.setId(4L);
        process.addNode((Node)actionNode);
        new ConnectionImpl((Node)eventNode, "DROOLS_DEFAULT", (Node)actionNode, "DROOLS_DEFAULT");
        EventNode eventNode2 = new EventNode();
        eventFilter = new EventTypeFilter();
        eventFilter.setType("myOtherEvent");
        eventNode2.addEventFilter((EventFilter)eventFilter);
        eventNode2.setVariableName("event");
        eventNode2.setId(5L);
        process.addNode((Node)eventNode2);
        ActionNode actionNode2 = new ActionNode();
        actionNode2.setName("Print");
        action = new DroolsConsequenceAction("java", null);
        action.setMetaData("Action", (Object)new Action(){

            public void execute(ProcessContext context) throws Exception {
                EventTest.this.logger.info("Detected other event for person {}", (Object)((Person)context.getVariable("event")).getName());
                myList.add("Executed action");
            }
        });
        actionNode2.setAction((DroolsAction)action);
        actionNode2.setId(6L);
        process.addNode((Node)actionNode2);
        new ConnectionImpl((Node)eventNode2, "DROOLS_DEFAULT", (Node)actionNode2, "DROOLS_DEFAULT");
        Join join = new Join();
        join.setName("AND Join");
        join.setType(1);
        join.setId(7L);
        process.addNode((Node)join);
        new ConnectionImpl((Node)startNode, "DROOLS_DEFAULT", (Node)join, "DROOLS_DEFAULT");
        new ConnectionImpl((Node)actionNode, "DROOLS_DEFAULT", (Node)join, "DROOLS_DEFAULT");
        new ConnectionImpl((Node)actionNode2, "DROOLS_DEFAULT", (Node)join, "DROOLS_DEFAULT");
        EndNode endNode = new EndNode();
        endNode.setName("EndNode");
        endNode.setId(8L);
        process.addNode((Node)endNode);
        new ConnectionImpl((Node)join, "DROOLS_DEFAULT", (Node)endNode, "DROOLS_DEFAULT");
        KieSession ksession = this.createKieSession(new Process[]{process});
        TestProcessEventListener procEventListener = new TestProcessEventListener();
        ksession.addEventListener((ProcessEventListener)procEventListener);
        ProcessInstance processInstance = ksession.startProcess("org.drools.core.process.event");
        Assert.assertEquals((long)0L, (long)myList.size());
        Person jack = new Person();
        jack.setName("Jack");
        processInstance.signalEvent("myEvent", (Object)jack);
        Assert.assertEquals((long)1L, (long)myList.size());
        Assert.assertEquals((long)1L, (long)processInstance.getState());
        Person john = new Person();
        john.setName("John");
        processInstance.signalEvent("myOtherEvent", (Object)john);
        Assert.assertEquals((long)2L, (long)myList.size());
        Assert.assertEquals((long)2L, (long)processInstance.getState());
        this.verifyEventHistory(this.test3EventOrder, procEventListener.getEventHistory());
    }

    @Test
    public void testEvent3a() {
        RuleFlowProcess process = new RuleFlowProcess();
        process.setId("org.drools.core.process.event");
        process.setName("Event Process");
        ArrayList<Variable> variables = new ArrayList<Variable>();
        Variable variable = new Variable();
        variable.setName("event");
        ObjectDataType personDataType = new ObjectDataType();
        personDataType.setClassName("org.drools.Person");
        variable.setType((DataType)personDataType);
        variables.add(variable);
        process.getVariableScope().setVariables(variables);
        StartNode startNode = new StartNode();
        startNode.setName("Start");
        startNode.setId(1L);
        process.addNode((Node)startNode);
        EventNode eventNode = new EventNode();
        EventTypeFilter eventFilter = new EventTypeFilter();
        eventFilter.setType("myEvent");
        eventNode.addEventFilter((EventFilter)eventFilter);
        eventNode.setVariableName("event");
        eventNode.setId(3L);
        process.addNode((Node)eventNode);
        final ArrayList myList = new ArrayList();
        ActionNode actionNode = new ActionNode();
        actionNode.setName("Print");
        DroolsConsequenceAction action = new DroolsConsequenceAction("java", null);
        action.setMetaData("Action", (Object)new Action(){

            public void execute(ProcessContext context) throws Exception {
                EventTest.this.logger.info("Detected event for person {}", (Object)((Person)context.getVariable("event")).getName());
                myList.add("Executed action");
            }
        });
        actionNode.setAction((DroolsAction)action);
        actionNode.setId(4L);
        process.addNode((Node)actionNode);
        new ConnectionImpl((Node)eventNode, "DROOLS_DEFAULT", (Node)actionNode, "DROOLS_DEFAULT");
        EventNode eventNode2 = new EventNode();
        eventFilter = new EventTypeFilter();
        eventFilter.setType("myOtherEvent");
        eventNode2.addEventFilter((EventFilter)eventFilter);
        eventNode2.setVariableName("event");
        eventNode2.setId(5L);
        process.addNode((Node)eventNode2);
        ActionNode actionNode2 = new ActionNode();
        actionNode2.setName("Print");
        action = new DroolsConsequenceAction("java", null);
        action.setMetaData("Action", (Object)new Action(){

            public void execute(ProcessContext context) throws Exception {
                EventTest.this.logger.info("Detected other event for person {}", (Object)((Person)context.getVariable("event")).getName());
                myList.add("Executed action");
            }
        });
        actionNode2.setAction((DroolsAction)action);
        actionNode2.setId(6L);
        process.addNode((Node)actionNode2);
        new ConnectionImpl((Node)eventNode2, "DROOLS_DEFAULT", (Node)actionNode2, "DROOLS_DEFAULT");
        Join join = new Join();
        join.setName("AND Join");
        join.setType(1);
        join.setId(7L);
        process.addNode((Node)join);
        new ConnectionImpl((Node)startNode, "DROOLS_DEFAULT", (Node)join, "DROOLS_DEFAULT");
        new ConnectionImpl((Node)actionNode, "DROOLS_DEFAULT", (Node)join, "DROOLS_DEFAULT");
        new ConnectionImpl((Node)actionNode2, "DROOLS_DEFAULT", (Node)join, "DROOLS_DEFAULT");
        EndNode endNode = new EndNode();
        endNode.setName("EndNode");
        endNode.setId(8L);
        process.addNode((Node)endNode);
        new ConnectionImpl((Node)join, "DROOLS_DEFAULT", (Node)endNode, "DROOLS_DEFAULT");
        KieSession ksession = this.createKieSession(new Process[]{process});
        TestProcessEventListener procEventListener = new TestProcessEventListener();
        ksession.addEventListener((ProcessEventListener)procEventListener);
        System.setProperty("jbpm.loop.level.disabled", "true");
        ProcessInstance processInstance = ksession.startProcess("org.drools.core.process.event");
        Assert.assertEquals((long)0L, (long)myList.size());
        Person jack = new Person();
        jack.setName("Jack");
        processInstance.signalEvent("myEvent", (Object)jack);
        Assert.assertEquals((long)1L, (long)myList.size());
        Assert.assertEquals((long)1L, (long)processInstance.getState());
        processInstance.signalEvent("myEvent", (Object)jack);
        Assert.assertEquals((long)2L, (long)myList.size());
        Assert.assertEquals((long)1L, (long)processInstance.getState());
        Person john = new Person();
        john.setName("John");
        processInstance.signalEvent("myOtherEvent", (Object)john);
        Assert.assertEquals((long)3L, (long)myList.size());
        Assert.assertEquals((long)2L, (long)processInstance.getState());
        System.clearProperty("jbpm.loop.level.disabled");
        this.verifyEventHistory(this.test3aEventOrder, procEventListener.getEventHistory());
    }

    @Test
    public void testEvent4() {
        RuleFlowProcess process = new RuleFlowProcess();
        process.setId("org.drools.core.process.event");
        process.setName("Event Process");
        ArrayList<Variable> variables = new ArrayList<Variable>();
        Variable variable = new Variable();
        variable.setName("event");
        ObjectDataType personDataType = new ObjectDataType();
        personDataType.setClassName("org.drools.Person");
        variable.setType((DataType)personDataType);
        variables.add(variable);
        process.getVariableScope().setVariables(variables);
        StartNode startNode = new StartNode();
        startNode.setName("Start");
        startNode.setId(1L);
        process.addNode((Node)startNode);
        EventNode eventNode = new EventNode();
        EventTypeFilter eventFilter = new EventTypeFilter();
        eventFilter.setType("myEvent");
        eventNode.addEventFilter((EventFilter)eventFilter);
        eventNode.setId(3L);
        process.addNode((Node)eventNode);
        final ArrayList myList = new ArrayList();
        ActionNode actionNode = new ActionNode();
        actionNode.setName("Print");
        DroolsConsequenceAction action = new DroolsConsequenceAction("java", null);
        action.setMetaData("Action", (Object)new Action(){

            public void execute(ProcessContext context) throws Exception {
                myList.add("Executed action");
            }
        });
        actionNode.setAction((DroolsAction)action);
        actionNode.setId(4L);
        process.addNode((Node)actionNode);
        new ConnectionImpl((Node)eventNode, "DROOLS_DEFAULT", (Node)actionNode, "DROOLS_DEFAULT");
        EventNode eventNode2 = new EventNode();
        eventFilter = new EventTypeFilter();
        eventFilter.setType("myEvent");
        eventNode2.addEventFilter((EventFilter)eventFilter);
        eventNode2.setId(5L);
        process.addNode((Node)eventNode2);
        ActionNode actionNode2 = new ActionNode();
        actionNode2.setName("Print");
        action = new DroolsConsequenceAction("java", null);
        action.setMetaData("Action", (Object)new Action(){

            public void execute(ProcessContext context) throws Exception {
                myList.add("Executed action");
            }
        });
        actionNode2.setAction((DroolsAction)action);
        actionNode2.setId(6L);
        process.addNode((Node)actionNode2);
        new ConnectionImpl((Node)eventNode2, "DROOLS_DEFAULT", (Node)actionNode2, "DROOLS_DEFAULT");
        Join join = new Join();
        join.setName("AND Join");
        join.setType(1);
        join.setId(7L);
        process.addNode((Node)join);
        new ConnectionImpl((Node)startNode, "DROOLS_DEFAULT", (Node)join, "DROOLS_DEFAULT");
        new ConnectionImpl((Node)actionNode, "DROOLS_DEFAULT", (Node)join, "DROOLS_DEFAULT");
        new ConnectionImpl((Node)actionNode2, "DROOLS_DEFAULT", (Node)join, "DROOLS_DEFAULT");
        EndNode endNode = new EndNode();
        endNode.setName("EndNode");
        endNode.setId(8L);
        process.addNode((Node)endNode);
        new ConnectionImpl((Node)join, "DROOLS_DEFAULT", (Node)endNode, "DROOLS_DEFAULT");
        KieSession ksession = this.createKieSession(new Process[]{process});
        TestProcessEventListener procEventListener = new TestProcessEventListener();
        ksession.addEventListener((ProcessEventListener)procEventListener);
        ProcessInstance processInstance = ksession.startProcess("org.drools.core.process.event");
        Assert.assertEquals((long)0L, (long)myList.size());
        processInstance.signalEvent("myEvent", null);
        Assert.assertEquals((long)2L, (long)myList.size());
        Assert.assertEquals((long)2L, (long)processInstance.getState());
        this.verifyEventHistory(this.test4EventOrder, procEventListener.getEventHistory());
    }

    @Test
    public void testEvent5() {
        RuleFlowProcess process = new RuleFlowProcess();
        process.setId("org.drools.core.process.event");
        process.setName("Event Process");
        ArrayList<Variable> variables = new ArrayList<Variable>();
        Variable variable = new Variable();
        variable.setName("event");
        ObjectDataType personDataType = new ObjectDataType();
        personDataType.setClassName("org.drools.Person");
        variable.setType((DataType)personDataType);
        variables.add(variable);
        process.getVariableScope().setVariables(variables);
        StartNode startNode = new StartNode();
        startNode.setName("Start");
        startNode.setId(1L);
        process.addNode((Node)startNode);
        CompositeNode compositeNode = new CompositeNode();
        compositeNode.setName("CompositeNode");
        compositeNode.setId(2L);
        process.addNode((Node)compositeNode);
        new ConnectionImpl((Node)startNode, "DROOLS_DEFAULT", (Node)compositeNode, "DROOLS_DEFAULT");
        MilestoneNode milestoneNode = new MilestoneNode();
        milestoneNode.setName("Milestone");
        milestoneNode.setConstraint("eval(false)");
        compositeNode.addNode((Node)milestoneNode);
        compositeNode.linkIncomingConnections("DROOLS_DEFAULT", milestoneNode.getId(), "DROOLS_DEFAULT");
        EventNode eventNode = new EventNode();
        EventTypeFilter eventFilter = new EventTypeFilter();
        eventFilter.setType("myEvent");
        eventNode.addEventFilter((EventFilter)eventFilter);
        eventNode.setVariableName("event");
        compositeNode.addNode((Node)eventNode);
        final ArrayList myList = new ArrayList();
        ActionNode actionNode = new ActionNode();
        actionNode.setName("Print");
        DroolsConsequenceAction action = new DroolsConsequenceAction("java", null);
        action.setMetaData("Action", (Object)new Action(){

            public void execute(ProcessContext context) throws Exception {
                EventTest.this.logger.info("Detected event for person {}", (Object)((Person)context.getVariable("event")).getName());
                myList.add("Executed action");
            }
        });
        actionNode.setAction((DroolsAction)action);
        compositeNode.addNode((Node)actionNode);
        new ConnectionImpl((Node)eventNode, "DROOLS_DEFAULT", (Node)actionNode, "DROOLS_DEFAULT");
        Join join = new Join();
        join.setName("XOR Join");
        join.setType(2);
        compositeNode.addNode((Node)join);
        new ConnectionImpl((Node)milestoneNode, "DROOLS_DEFAULT", (Node)join, "DROOLS_DEFAULT");
        new ConnectionImpl((Node)actionNode, "DROOLS_DEFAULT", (Node)join, "DROOLS_DEFAULT");
        compositeNode.linkOutgoingConnections(join.getId(), "DROOLS_DEFAULT", "DROOLS_DEFAULT");
        EndNode endNode = new EndNode();
        endNode.setName("EndNode");
        endNode.setId(3L);
        process.addNode((Node)endNode);
        new ConnectionImpl((Node)compositeNode, "DROOLS_DEFAULT", (Node)endNode, "DROOLS_DEFAULT");
        KieSession ksession = this.createKieSession(new Process[]{process});
        TestProcessEventListener procEventListener = new TestProcessEventListener();
        ksession.addEventListener((ProcessEventListener)procEventListener);
        ProcessInstance processInstance = ksession.startProcess("org.drools.core.process.event");
        Assert.assertEquals((long)0L, (long)myList.size());
        Person jack = new Person();
        jack.setName("Jack");
        processInstance.signalEvent("myEvent", (Object)jack);
        Assert.assertEquals((long)1L, (long)myList.size());
        Assert.assertEquals((long)2L, (long)processInstance.getState());
        this.verifyEventHistory(this.test5EventOrder, procEventListener.getEventHistory());
    }
}

