/*
 * Decompiled with CFR 0.152.
 */
package org.jbpm.process;

import java.util.ArrayList;
import org.drools.core.process.core.Work;
import org.drools.core.process.core.datatype.DataType;
import org.drools.core.process.core.datatype.impl.type.ObjectDataType;
import org.drools.core.process.core.impl.WorkImpl;
import org.jbpm.process.core.context.variable.Variable;
import org.jbpm.process.core.event.EventTypeFilter;
import org.jbpm.process.instance.impl.Action;
import org.jbpm.process.test.NodeCreator;
import org.jbpm.process.test.TestProcessEventListener;
import org.jbpm.process.test.TestWorkItemHandler;
import org.jbpm.ruleflow.core.RuleFlowProcess;
import org.jbpm.test.util.AbstractBaseTest;
import org.jbpm.workflow.core.DroolsAction;
import org.jbpm.workflow.core.Node;
import org.jbpm.workflow.core.NodeContainer;
import org.jbpm.workflow.core.impl.DroolsConsequenceAction;
import org.jbpm.workflow.core.node.ActionNode;
import org.jbpm.workflow.core.node.CompositeNode;
import org.jbpm.workflow.core.node.EndNode;
import org.jbpm.workflow.core.node.EventSubProcessNode;
import org.jbpm.workflow.core.node.StartNode;
import org.jbpm.workflow.core.node.WorkItemNode;
import org.junit.Assert;
import org.junit.Test;
import org.kie.api.definition.process.Process;
import org.kie.api.event.process.ProcessEventListener;
import org.kie.api.runtime.KieSession;
import org.kie.api.runtime.process.ProcessContext;
import org.kie.api.runtime.process.ProcessInstance;
import org.kie.api.runtime.process.WorkItemHandler;
import org.slf4j.LoggerFactory;

public class EventSubProcessTest
extends AbstractBaseTest {
    String[] nestedEventOrder = new String[]{"bps", "bnt-0", "bnl-0", "bnt-1", "bnt-1:3", "bnl-1:3", "bnt-1:4", "bnt-1:4:5", "bnl-1:4:5", "bnt-1:4:6", "ant-1:4:6", "anl-1:4:5", "ant-1:4:5", "ant-1:4", "anl-1:3", "ant-1:3", "ant-1", "anl-0", "ant-0", "aps", "bnl-1:4:7:8", "bnt-1:4:7:9", "bnl-1:4:7:9", "bnt-1:4:7:10", "bnl-1:4:7:10", "bnl-1:4:7", "anl-1:4:7", "anl-1:4:7:10", "ant-1:4:7:10", "anl-1:4:7:9", "ant-1:4:7:9", "anl-1:4:7:8", "bnl-1:4:6", "bnt-1:4:11", "bnl-1:4:11", "bnl-1:4", "bnt-1:12", "bnl-1:12", "bnl-1", "bnt-12", "bnl-12", "bpc", "apc", "anl-12", "ant-12", "anl-1", "anl-1:12", "ant-1:12", "anl-1:4", "anl-1:4:11", "ant-1:4:11", "anl-1:4:6"};

    @Override
    public void addLogger() {
        this.logger = LoggerFactory.getLogger(this.getClass());
    }

    @Test
    public void testNestedEventSubProcess() throws Exception {
        RuleFlowProcess process = new RuleFlowProcess();
        process.setAutoComplete(true);
        String processId = "org.jbpm.process.event.subprocess";
        process.setId(processId);
        process.setName("Event SubProcess Process");
        ArrayList<Variable> variables = new ArrayList<Variable>();
        Variable variable = new Variable();
        variable.setName("event");
        ObjectDataType personDataType = new ObjectDataType();
        personDataType.setClassName("org.drools.Person");
        variable.setType((DataType)personDataType);
        variables.add(variable);
        process.getVariableScope().setVariables(variables);
        NodeCreator<StartNode> startNodeCreator = new NodeCreator<StartNode>((NodeContainer)process, StartNode.class);
        NodeCreator<EndNode> endNodeCreator = new NodeCreator<EndNode>((NodeContainer)process, EndNode.class);
        NodeCreator<CompositeNode> compNodeCreator = new NodeCreator<CompositeNode>((NodeContainer)process, CompositeNode.class);
        StartNode startNode = startNodeCreator.createNode("start0");
        CompositeNode compositeNode = compNodeCreator.createNode("comp0");
        NodeCreator.connect((Node)startNode, (Node)compositeNode);
        EndNode endNode = endNodeCreator.createNode("end0");
        NodeCreator.connect((Node)compositeNode, (Node)endNode);
        startNodeCreator.setNodeContainer((NodeContainer)compositeNode);
        endNodeCreator.setNodeContainer((NodeContainer)compositeNode);
        compNodeCreator.setNodeContainer((NodeContainer)compositeNode);
        startNode = startNodeCreator.createNode("start1");
        compositeNode = compNodeCreator.createNode("comp1");
        NodeCreator.connect((Node)startNode, (Node)compositeNode);
        endNode = endNodeCreator.createNode("end1");
        NodeCreator.connect((Node)compositeNode, (Node)endNode);
        startNodeCreator.setNodeContainer((NodeContainer)compositeNode);
        endNodeCreator.setNodeContainer((NodeContainer)compositeNode);
        NodeCreator<WorkItemNode> workItemNodeCreator = new NodeCreator<WorkItemNode>((NodeContainer)compositeNode, WorkItemNode.class);
        startNode = startNodeCreator.createNode("start2");
        WorkItemNode workItemNode = workItemNodeCreator.createNode("workItem2");
        WorkImpl work = new WorkImpl();
        String workItemName = "play";
        work.setName(workItemName);
        workItemNode.setWork((Work)work);
        NodeCreator.connect((Node)startNode, (Node)workItemNode);
        endNode = endNodeCreator.createNode("end2");
        NodeCreator.connect((Node)workItemNode, (Node)endNode);
        NodeCreator<EventSubProcessNode> espNodeCreator = new NodeCreator<EventSubProcessNode>((NodeContainer)compositeNode, EventSubProcessNode.class);
        EventSubProcessNode espNode = espNodeCreator.createNode("eventSub2");
        EventTypeFilter eventFilter = new EventTypeFilter();
        String EVENT_NAME = "subEvent";
        eventFilter.setType(EVENT_NAME);
        espNode.addEvent(eventFilter);
        startNodeCreator.setNodeContainer((NodeContainer)espNode);
        endNodeCreator.setNodeContainer((NodeContainer)espNode);
        NodeCreator<ActionNode> actionNodeCreator = new NodeCreator<ActionNode>((NodeContainer)espNode, ActionNode.class);
        startNode = startNodeCreator.createNode("start3*");
        ActionNode actionNode = actionNodeCreator.createNode("print3*");
        actionNode.setName("Print");
        final ArrayList eventList = new ArrayList();
        DroolsConsequenceAction action = new DroolsConsequenceAction("java", null);
        action.setMetaData("Action", (Object)new Action(){

            public void execute(ProcessContext context) throws Exception {
                eventList.add("Executed action");
            }
        });
        actionNode.setAction((DroolsAction)action);
        NodeCreator.connect((Node)startNode, (Node)actionNode);
        endNode = endNodeCreator.createNode("end3*");
        NodeCreator.connect((Node)actionNode, (Node)endNode);
        KieSession ksession = this.createKieSession(new Process[]{process});
        TestProcessEventListener procEventListener = new TestProcessEventListener();
        ksession.addEventListener((ProcessEventListener)procEventListener);
        TestWorkItemHandler workItemHandler = new TestWorkItemHandler();
        ksession.getWorkItemManager().registerWorkItemHandler(workItemName, (WorkItemHandler)workItemHandler);
        ProcessInstance processInstance = ksession.startProcess(processId);
        processInstance.signalEvent(EVENT_NAME, null);
        Assert.assertEquals((String)("Event " + EVENT_NAME + " did not fire!"), (long)1L, (long)eventList.size());
        ksession.getWorkItemManager().completeWorkItem(workItemHandler.getWorkItems().removeLast().getId(), null);
        Assert.assertEquals((long)2L, (long)processInstance.getState());
        this.verifyEventHistory(this.nestedEventOrder, procEventListener.getEventHistory());
    }
}

