/*
 * Decompiled with CFR 0.152.
 */
package org.jbpm.test.util;

import java.util.List;
import java.util.concurrent.atomic.AtomicInteger;
import org.drools.core.impl.InternalKnowledgeBase;
import org.drools.core.impl.KnowledgeBaseFactory;
import org.drools.core.impl.KnowledgeBaseImpl;
import org.jbpm.process.instance.impl.util.LoggingPrintStream;
import org.jbpm.process.test.TestProcessEventListener;
import org.junit.AfterClass;
import org.junit.Assert;
import org.junit.Before;
import org.junit.BeforeClass;
import org.junit.Rule;
import org.junit.rules.TestName;
import org.kie.api.definition.process.Process;
import org.kie.api.runtime.KieSession;
import org.slf4j.Logger;

public abstract class AbstractBaseTest {
    protected Logger logger;
    @Rule
    public TestName name = new TestName();
    protected static AtomicInteger uniqueIdGen = new AtomicInteger(0);

    @Before
    public void before() {
        this.addLogger();
        this.logger.debug("> " + this.name.getMethodName());
    }

    public abstract void addLogger();

    public KieSession createKieSession(Process ... process) {
        InternalKnowledgeBase kbase = KnowledgeBaseFactory.newKnowledgeBase();
        for (Process processToAdd : process) {
            ((KnowledgeBaseImpl)kbase).addProcess(processToAdd);
        }
        return kbase.newKieSession();
    }

    public void showEventHistory(KieSession ksession) {
        TestProcessEventListener procEventListener = (TestProcessEventListener)ksession.getProcessEventListeners().iterator().next();
        for (String event : procEventListener.getEventHistory()) {
            System.out.println("\"" + event + "\",");
        }
    }

    public void verifyEventHistory(String[] eventOrder, List<String> eventHistory) {
        int max = eventOrder.length > eventHistory.size() ? eventOrder.length : eventHistory.size();
        this.logger.debug("{} | {}", (Object)"EXPECTED", (Object)"TEST");
        for (int i = 0; i < max; ++i) {
            String expected = "";
            String real = "";
            if (i < eventOrder.length) {
                expected = eventOrder[i];
            }
            if (i < eventHistory.size()) {
                real = eventHistory.get(i);
            }
            this.logger.debug("{} | {}", (Object)expected, (Object)real);
            Assert.assertEquals((String)"Mismatch in expected event", (Object)expected, (Object)real);
        }
        Assert.assertEquals((String)"Mismatch in number of events expected.", (long)eventOrder.length, (long)eventHistory.size());
    }

    @BeforeClass
    public static void configure() {
        LoggingPrintStream.interceptSysOutSysErr();
    }

    @AfterClass
    public static void reset() {
        LoggingPrintStream.resetInterceptSysOutSysErr();
    }
}

