/*
 * Decompiled with CFR 0.152.
 */
package org.jbpm.process.core.async;

import java.util.Arrays;
import java.util.Map;
import org.drools.core.process.instance.impl.WorkItemImpl;
import org.kie.api.executor.Command;
import org.kie.api.executor.CommandContext;
import org.kie.api.executor.ExecutionResults;
import org.kie.api.runtime.manager.Context;
import org.kie.api.runtime.manager.RuntimeEngine;
import org.kie.api.runtime.manager.RuntimeManager;
import org.kie.api.runtime.process.WorkItem;
import org.kie.internal.KieInternalServices;
import org.kie.internal.process.CorrelationAwareProcessRuntime;
import org.kie.internal.process.CorrelationKey;
import org.kie.internal.process.CorrelationKeyFactory;
import org.kie.internal.runtime.manager.RuntimeManagerRegistry;
import org.kie.internal.runtime.manager.context.ProcessInstanceIdContext;

public class AsyncStartProcessCommand
implements Command {
    private static CorrelationKeyFactory correlationKeyFactory = KieInternalServices.Factory.get().newCorrelationKeyFactory();

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public ExecutionResults execute(CommandContext ctx) throws Exception {
        String deploymentId = this.getDeploymentId(ctx);
        String processId = (String)this.getData("ProcessId", ctx);
        String correlationKey = (String)this.getData("CorrelationKey", ctx);
        Map variables = (Map)this.getData("Variables", ctx);
        if (deploymentId == null || processId == null) {
            throw new IllegalArgumentException("Deployment id and process id is required");
        }
        RuntimeManager runtimeManager = RuntimeManagerRegistry.get().getManager(deploymentId);
        if (runtimeManager == null) {
            throw new IllegalArgumentException("No runtime manager found for deployment id " + deploymentId);
        }
        RuntimeEngine engine = runtimeManager.getRuntimeEngine((Context)ProcessInstanceIdContext.get());
        try {
            if (correlationKey == null || correlationKey.isEmpty()) {
                engine.getKieSession().startProcess(processId, variables);
            } else {
                String[] correlationKeyProperties = correlationKey.split(",");
                CorrelationKey ck = correlationKeyFactory.newCorrelationKey(Arrays.asList(correlationKeyProperties));
                ((CorrelationAwareProcessRuntime)engine.getKieSession()).startProcess(processId, ck, variables);
            }
            ExecutionResults executionResults = new ExecutionResults();
            return executionResults;
        }
        finally {
            runtimeManager.disposeRuntimeEngine(engine);
        }
    }

    protected Object getData(String name, CommandContext ctx) {
        if (ctx.getData(name) != null) {
            return ctx.getData(name);
        }
        WorkItem workItem = (WorkItem)ctx.getData("workItem");
        if (workItem != null) {
            return workItem.getParameter(name);
        }
        return null;
    }

    protected String getDeploymentId(CommandContext ctx) {
        String deploymentId = (String)ctx.getData("DeploymentId");
        if (deploymentId != null) {
            return deploymentId;
        }
        WorkItem workItem = (WorkItem)ctx.getData("workItem");
        if (workItem != null && (deploymentId = (String)workItem.getParameter("DeploymentId")) == null) {
            deploymentId = ((WorkItemImpl)workItem).getDeploymentId();
        }
        return deploymentId;
    }
}

